/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.context.DefaultContext;
import org.apache.flink.table.client.gateway.context.ExecutionContext;
import org.apache.flink.table.client.gateway.context.SessionContext;
import org.apache.flink.table.client.gateway.local.LocalContextUtils;
import org.apache.flink.table.client.gateway.local.ResultStore;
import org.apache.flink.table.client.gateway.local.result.ChangelogResult;
import org.apache.flink.table.client.gateway.local.result.DynamicResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedResult;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalExecutor
implements Executor {
    private static final Logger LOG = LoggerFactory.getLogger(LocalExecutor.class);
    private final ConcurrentHashMap<String, SessionContext> contextMap = new ConcurrentHashMap();
    private final ResultStore resultStore = new ResultStore();
    private final DefaultContext defaultContext;

    public LocalExecutor(DefaultContext defaultContext) {
        this.defaultContext = defaultContext;
    }

    @Override
    public void start() {
    }

    @Override
    public String openSession(@Nullable String sessionId) throws SqlExecutionException {
        SessionContext sessionContext = LocalContextUtils.buildSessionContext(sessionId, this.defaultContext);
        if (this.contextMap.containsKey(sessionId = sessionContext.getSessionId())) {
            throw new SqlExecutionException("Found another session with the same session identifier: " + sessionId);
        }
        this.contextMap.put(sessionId, sessionContext);
        return sessionId;
    }

    @Override
    public void closeSession(String sessionId) throws SqlExecutionException {
        this.resultStore.getResults().forEach(resultId -> {
            try {
                this.cancelQuery(sessionId, (String)resultId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        SessionContext context = this.contextMap.remove(sessionId);
        if (context != null) {
            context.close();
        }
    }

    private SessionContext getSessionContext(String sessionId) {
        SessionContext context = this.contextMap.get(sessionId);
        if (context == null) {
            throw new SqlExecutionException("Invalid session identifier: " + sessionId);
        }
        return context;
    }

    @VisibleForTesting
    protected ExecutionContext getExecutionContext(String sessionId) throws SqlExecutionException {
        return this.getSessionContext(sessionId).getExecutionContext();
    }

    @Override
    public Map<String, String> getSessionConfigMap(String sessionId) throws SqlExecutionException {
        return this.getSessionContext(sessionId).getConfigMap();
    }

    @Override
    public ReadableConfig getSessionConfig(String sessionId) throws SqlExecutionException {
        return this.getSessionContext(sessionId).getReadableConfig();
    }

    @Override
    public void resetSessionProperties(String sessionId) throws SqlExecutionException {
        SessionContext context = this.getSessionContext(sessionId);
        context.reset();
    }

    @Override
    public void resetSessionProperty(String sessionId, String key) throws SqlExecutionException {
        SessionContext context = this.getSessionContext(sessionId);
        context.reset(key);
    }

    @Override
    public void setSessionProperty(String sessionId, String key, String value) throws SqlExecutionException {
        SessionContext context = this.getSessionContext(sessionId);
        context.set(key, value);
    }

    @Override
    public Operation parseStatement(String sessionId, String statement) throws SqlExecutionException {
        List operations;
        ExecutionContext context = this.getExecutionContext(sessionId);
        StreamTableEnvironment tableEnv = context.getTableEnvironment();
        Parser parser = ((TableEnvironmentInternal)tableEnv).getParser();
        try {
            operations = context.wrapClassLoader(() -> parser.parse(statement));
        }
        catch (Exception e) {
            throw new SqlExecutionException("Failed to parse statement: " + statement, e);
        }
        if (operations.isEmpty()) {
            throw new SqlExecutionException("Failed to parse statement: " + statement);
        }
        return (Operation)operations.get(0);
    }

    @Override
    public List<String> completeStatement(String sessionId, String statement, int position) {
        ExecutionContext context = this.getExecutionContext(sessionId);
        TableEnvironmentInternal tableEnv = (TableEnvironmentInternal)context.getTableEnvironment();
        try {
            return context.wrapClassLoader(() -> Arrays.asList(tableEnv.getParser().getCompletionHints(statement, position)));
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not complete statement at " + position + ":" + statement, t);
            }
            return Collections.emptyList();
        }
    }

    @Override
    public TableResultInternal executeOperation(String sessionId, Operation operation) throws SqlExecutionException {
        ExecutionContext context = this.getExecutionContext(sessionId);
        TableEnvironmentInternal tEnv = (TableEnvironmentInternal)context.getTableEnvironment();
        try {
            return context.wrapClassLoader(() -> tEnv.executeInternal(operation));
        }
        catch (Exception e) {
            throw new SqlExecutionException("Could not execute SQL statement.", e);
        }
    }

    @Override
    public TableResultInternal executeModifyOperations(String sessionId, List<ModifyOperation> operations) throws SqlExecutionException {
        ExecutionContext context = this.getExecutionContext(sessionId);
        TableEnvironmentInternal tEnv = (TableEnvironmentInternal)context.getTableEnvironment();
        try {
            return context.wrapClassLoader(() -> tEnv.executeInternal(operations));
        }
        catch (Exception e) {
            throw new SqlExecutionException("Could not execute SQL statement.", e);
        }
    }

    @Override
    public ResultDescriptor executeQuery(String sessionId, QueryOperation query) throws SqlExecutionException {
        TableResultInternal tableResult = this.executeOperation(sessionId, (Operation)query);
        SessionContext context = this.getSessionContext(sessionId);
        ReadableConfig config = context.getReadableConfig();
        DynamicResult result = this.resultStore.createResult(config, tableResult);
        Preconditions.checkArgument((boolean)tableResult.getJobClient().isPresent());
        String jobId = ((JobClient)tableResult.getJobClient().get()).getJobID().toString();
        this.resultStore.storeResult(jobId, result);
        return new ResultDescriptor(jobId, tableResult.getResolvedSchema(), result.isMaterialized(), config, tableResult.getRowDataToStringConverter());
    }

    @Override
    public TypedResult<List<RowData>> retrieveResultChanges(String sessionId, String resultId) throws SqlExecutionException {
        DynamicResult result = this.resultStore.getResult(resultId);
        if (result == null) {
            throw new SqlExecutionException("Could not find a result with result identifier '" + resultId + "'.");
        }
        if (result.isMaterialized()) {
            throw new SqlExecutionException("Invalid result retrieval mode.");
        }
        return ((ChangelogResult)result).retrieveChanges();
    }

    @Override
    public TypedResult<Integer> snapshotResult(String sessionId, String resultId, int pageSize) throws SqlExecutionException {
        DynamicResult result = this.resultStore.getResult(resultId);
        if (result == null) {
            throw new SqlExecutionException("Could not find a result with result identifier '" + resultId + "'.");
        }
        if (!result.isMaterialized()) {
            throw new SqlExecutionException("Invalid result retrieval mode.");
        }
        return ((MaterializedResult)result).snapshot(pageSize);
    }

    @Override
    public List<RowData> retrieveResultPage(String resultId, int page) throws SqlExecutionException {
        DynamicResult result = this.resultStore.getResult(resultId);
        if (result == null) {
            throw new SqlExecutionException("Could not find a result with result identifier '" + resultId + "'.");
        }
        if (!result.isMaterialized()) {
            throw new SqlExecutionException("Invalid result retrieval mode.");
        }
        return ((MaterializedResult)result).retrievePage(page);
    }

    @Override
    public void cancelQuery(String sessionId, String resultId) throws SqlExecutionException {
        DynamicResult result = this.resultStore.getResult(resultId);
        if (result == null) {
            throw new SqlExecutionException("Could not find a result with result identifier '" + resultId + "'.");
        }
        LOG.info("Cancelling job {} and result retrieval.", (Object)resultId);
        try {
            result.close();
        }
        catch (Exception e) {
            throw new SqlExecutionException("Could not cancel the query execution", e);
        }
        this.resultStore.removeResult(resultId);
    }

    @Override
    public void addJar(String sessionId, String jarUrl) {
        SessionContext context = this.getSessionContext(sessionId);
        context.addJar(jarUrl);
    }

    @Override
    public void removeJar(String sessionId, String jarUrl) {
        SessionContext context = this.getSessionContext(sessionId);
        context.removeJar(jarUrl);
    }

    @Override
    public List<String> listJars(String sessionId) {
        SessionContext context = this.getSessionContext(sessionId);
        return context.listJars();
    }
}

