/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.shaded.com.ibm.icu.impl;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.Format;
import org.apache.flink.table.shaded.com.ibm.icu.impl.FormattedStringBuilder;
import org.apache.flink.table.shaded.com.ibm.icu.impl.StaticUnicodeSets;
import org.apache.flink.table.shaded.com.ibm.icu.text.ConstrainedFieldPosition;
import org.apache.flink.table.shaded.com.ibm.icu.text.ListFormatter;
import org.apache.flink.table.shaded.com.ibm.icu.text.NumberFormat;
import org.apache.flink.table.shaded.com.ibm.icu.text.UFormat;
import org.apache.flink.table.shaded.com.ibm.icu.text.UnicodeSet;

public class FormattedValueStringBuilderImpl {
    public static int findSpan(FormattedStringBuilder self, Object value2) {
        for (int i = self.zero; i < self.zero + self.length; ++i) {
            if (!(self.fields[i] instanceof SpanFieldPlaceholder) || !((SpanFieldPlaceholder)self.fields[i]).value.equals(value2)) continue;
            return i - self.zero;
        }
        return -1;
    }

    public static boolean nextFieldPosition(FormattedStringBuilder self, FieldPosition fp) {
        Format.Field rawField = fp.getFieldAttribute();
        if (rawField == null) {
            if (fp.getField() == 0) {
                rawField = NumberFormat.Field.INTEGER;
            } else if (fp.getField() == 1) {
                rawField = NumberFormat.Field.FRACTION;
            } else {
                return false;
            }
        }
        if (!(rawField instanceof NumberFormat.Field)) {
            throw new IllegalArgumentException("You must pass an instance of com.ibm.icu.text.NumberFormat.Field as your FieldPosition attribute.  You passed: " + rawField.getClass().toString());
        }
        ConstrainedFieldPosition cfpos = new ConstrainedFieldPosition();
        cfpos.constrainField(rawField);
        cfpos.setState(rawField, null, fp.getBeginIndex(), fp.getEndIndex());
        if (FormattedValueStringBuilderImpl.nextPosition(self, cfpos, null)) {
            fp.setBeginIndex(cfpos.getStart());
            fp.setEndIndex(cfpos.getLimit());
            return true;
        }
        if (rawField == NumberFormat.Field.FRACTION && fp.getEndIndex() == 0) {
            int i;
            boolean inside = false;
            for (i = self.zero; i < self.zero + self.length; ++i) {
                if (FormattedValueStringBuilderImpl.isIntOrGroup(self.fields[i]) || self.fields[i] == NumberFormat.Field.DECIMAL_SEPARATOR) {
                    inside = true;
                    continue;
                }
                if (inside) break;
            }
            fp.setBeginIndex(i - self.zero);
            fp.setEndIndex(i - self.zero);
        }
        return false;
    }

    public static AttributedCharacterIterator toCharacterIterator(FormattedStringBuilder self, Format.Field numericField) {
        ConstrainedFieldPosition cfpos = new ConstrainedFieldPosition();
        AttributedString as2 = new AttributedString(self.toString());
        while (FormattedValueStringBuilderImpl.nextPosition(self, cfpos, numericField)) {
            Object value2 = cfpos.getFieldValue();
            if (value2 == null) {
                value2 = cfpos.getField();
            }
            as2.addAttribute(cfpos.getField(), value2, cfpos.getStart(), cfpos.getLimit());
        }
        return as2.getIterator();
    }

    public static boolean nextPosition(FormattedStringBuilder self, ConstrainedFieldPosition cfpos, Format.Field numericField) {
        int fieldStart = -1;
        NullField currField = null;
        for (int i = self.zero + cfpos.getLimit(); i <= self.zero + self.length; ++i) {
            NullField _field;
            NullField nullField = _field = i < self.zero + self.length ? self.fields[i] : NullField.END;
            if (currField != null) {
                if (currField == _field) continue;
                int end = i - self.zero;
                if (currField instanceof SpanFieldPlaceholder) {
                    assert (FormattedValueStringBuilderImpl.handleSpan(currField, cfpos, fieldStart, end));
                    return true;
                }
                if (FormattedValueStringBuilderImpl.isTrimmable(currField)) {
                    end = FormattedValueStringBuilderImpl.trimBack(self, end);
                }
                if (end <= fieldStart) {
                    fieldStart = -1;
                    currField = null;
                    --i;
                    continue;
                }
                int start = fieldStart;
                if (FormattedValueStringBuilderImpl.isTrimmable(currField)) {
                    start = FormattedValueStringBuilderImpl.trimFront(self, start);
                }
                cfpos.setState(currField, null, start, end);
                return true;
            }
            if (cfpos.matchesField(NumberFormat.Field.INTEGER, null) && i > self.zero && i - self.zero > cfpos.getLimit() && FormattedValueStringBuilderImpl.isIntOrGroup(self.fields[i - 1]) && !FormattedValueStringBuilderImpl.isIntOrGroup(_field)) {
                int j2;
                for (j2 = i - 1; j2 >= self.zero && FormattedValueStringBuilderImpl.isIntOrGroup(self.fields[j2]); --j2) {
                }
                cfpos.setState(NumberFormat.Field.INTEGER, null, j2 - self.zero + 1, i - self.zero);
                return true;
            }
            if (numericField != null && cfpos.matchesField(numericField, null) && i > self.zero && (i - self.zero > cfpos.getLimit() || cfpos.getField() != numericField) && FormattedValueStringBuilderImpl.isNumericField(self.fields[i - 1]) && !FormattedValueStringBuilderImpl.isNumericField(_field)) {
                int j3;
                for (j3 = i - 1; j3 >= self.zero && FormattedValueStringBuilderImpl.isNumericField(self.fields[j3]); --j3) {
                }
                cfpos.setState(numericField, null, j3 - self.zero + 1, i - self.zero);
                return true;
            }
            if (i > self.zero && self.fields[i - 1] instanceof SpanFieldPlaceholder) {
                int j4;
                for (j4 = i - 1; j4 >= self.zero && self.fields[j4] == self.fields[i - 1]; --j4) {
                }
                if (FormattedValueStringBuilderImpl.handleSpan(self.fields[i - 1], cfpos, j4 - self.zero + 1, i - self.zero)) {
                    return true;
                }
            }
            if (_field == NumberFormat.Field.INTEGER) {
                _field = null;
            }
            if (_field == null || _field == NullField.END) continue;
            if (_field instanceof SpanFieldPlaceholder) {
                SpanFieldPlaceholder ph = (SpanFieldPlaceholder)((Object)_field);
                if (!cfpos.matchesField(ph.normalField, null) && !cfpos.matchesField(ph.spanField, ph.value)) continue;
                fieldStart = i - self.zero;
                currField = _field;
                continue;
            }
            if (!cfpos.matchesField(_field, null)) continue;
            fieldStart = i - self.zero;
            currField = _field;
        }
        assert (currField == null);
        return false;
    }

    private static boolean isIntOrGroup(Object field) {
        return field == NumberFormat.Field.INTEGER || field == NumberFormat.Field.GROUPING_SEPARATOR;
    }

    private static boolean isNumericField(Object field) {
        return field == null || NumberFormat.Field.class.isAssignableFrom(field.getClass());
    }

    private static boolean isTrimmable(Object field) {
        return field != NumberFormat.Field.GROUPING_SEPARATOR && !(field instanceof ListFormatter.Field);
    }

    private static int trimBack(FormattedStringBuilder self, int limit) {
        return StaticUnicodeSets.get(StaticUnicodeSets.Key.DEFAULT_IGNORABLES).spanBack(self, limit, UnicodeSet.SpanCondition.CONTAINED);
    }

    private static int trimFront(FormattedStringBuilder self, int start) {
        return StaticUnicodeSets.get(StaticUnicodeSets.Key.DEFAULT_IGNORABLES).span(self, start, UnicodeSet.SpanCondition.CONTAINED);
    }

    private static boolean handleSpan(Object field, ConstrainedFieldPosition cfpos, int start, int limit) {
        SpanFieldPlaceholder ph = (SpanFieldPlaceholder)field;
        if (cfpos.matchesField(ph.spanField, ph.value) && cfpos.getLimit() < limit) {
            cfpos.setState(ph.spanField, ph.value, start, limit);
            return true;
        }
        if (cfpos.matchesField(ph.normalField, null) && (cfpos.getLimit() < limit || cfpos.getField() != ph.normalField)) {
            cfpos.setState(ph.normalField, null, start, limit);
            return true;
        }
        return false;
    }

    static class NullField
    extends Format.Field {
        private static final long serialVersionUID = 1L;
        static final NullField END = new NullField("end");

        private NullField(String name) {
            super(name);
        }
    }

    public static class SpanFieldPlaceholder {
        public UFormat.SpanField spanField;
        public Format.Field normalField;
        public Object value;
    }
}

