/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections.binary;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.util.KeyValueIterator;
import org.apache.flink.table.runtime.util.collections.binary.AbstractBytesHashMap;
import org.apache.flink.table.runtime.util.collections.binary.BytesMap;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBytesHashMap<K>
extends BytesMap<K, BinaryRowData> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBytesHashMap.class);
    private final boolean hashSetMode;
    protected final PagedTypeSerializer<K> keySerializer;
    private final BinaryRowDataSerializer valueSerializer;
    private volatile EntryIterator destructiveIterator = null;

    public AbstractBytesHashMap(Object owner, MemoryManager memoryManager, long memorySize, PagedTypeSerializer<K> keySerializer, LogicalType[] valueTypes) {
        this(owner, memoryManager, memorySize, keySerializer, valueTypes.length);
    }

    public AbstractBytesHashMap(Object owner, MemoryManager memoryManager, long memorySize, PagedTypeSerializer<K> keySerializer, int valueArity) {
        super(owner, memoryManager, memorySize, keySerializer);
        this.recordArea = new RecordArea();
        this.keySerializer = keySerializer;
        this.valueSerializer = new BinaryRowDataSerializer(valueArity);
        if (valueArity == 0) {
            this.hashSetMode = true;
            this.reusedValue = new BinaryRowData(0);
            ((BinaryRowData)this.reusedValue).pointTo(MemorySegmentFactory.wrap((byte[])new byte[8]), 0, 8);
            LOG.info("BytesHashMap with hashSetMode = true.");
        } else {
            this.hashSetMode = false;
            this.reusedValue = this.valueSerializer.createInstance();
        }
        Preconditions.checkArgument((memorySize > 0x100000L ? 1 : 0) != 0, (Object)"The minBucketMemorySize is not valid!");
        int initBucketSegmentNum = MathUtils.roundDownToPowerOf2((int)((int)(0x100000L / (long)this.segmentSize)));
        this.initBucketSegments(initBucketSegmentNum);
        LOG.info("BytesHashMap with initial memory segments {}, {} in bytes, init allocating {} for bucket area.", new Object[]{this.reservedNumBuffers, this.reservedNumBuffers * this.segmentSize, initBucketSegmentNum});
    }

    @Override
    public long getNumKeys() {
        return this.numElements;
    }

    public BinaryRowData append(BytesMap.LookupInfo<K, BinaryRowData> lookupInfo, BinaryRowData value2) throws IOException {
        try {
            if (this.numElements >= (long)this.growthThreshold) {
                this.growAndRehash();
                this.lookup(lookupInfo.key);
            }
            BinaryRowData toAppend = this.hashSetMode ? (BinaryRowData)this.reusedValue : value2;
            int pointerToAppended = this.recordArea.appendRecord(lookupInfo, toAppend);
            ((MemorySegment)this.bucketSegments.get(lookupInfo.bucketSegmentIndex)).putInt(lookupInfo.bucketOffset, pointerToAppended);
            ((MemorySegment)this.bucketSegments.get(lookupInfo.bucketSegmentIndex)).putInt(lookupInfo.bucketOffset + 4, lookupInfo.keyHashCode);
            ++this.numElements;
            this.recordArea.setReadPosition(pointerToAppended);
            ((RecordArea)this.recordArea).skipKey();
            return (BinaryRowData)this.recordArea.readValue(this.reusedValue);
        }
        catch (EOFException e) {
            ++this.numSpillFiles;
            this.spillInBytes += this.recordArea.getSegmentsSize();
            throw e;
        }
    }

    @Override
    public long getNumSpillFiles() {
        return this.numSpillFiles;
    }

    public long getUsedMemoryInBytes() {
        return (long)this.bucketSegments.size() * (long)this.segmentSize + this.recordArea.getSegmentsSize();
    }

    @Override
    public long getSpillInBytes() {
        return this.spillInBytes;
    }

    @Override
    public long getNumElements() {
        return this.numElements;
    }

    public KeyValueIterator<K, BinaryRowData> getEntryIterator(boolean requiresCopy) {
        if (this.destructiveIterator != null) {
            throw new IllegalArgumentException("DestructiveIterator is not null, so this method can't be invoke!");
        }
        return ((RecordArea)this.recordArea).entryIterator(requiresCopy);
    }

    public ArrayList<MemorySegment> getRecordAreaMemorySegments() {
        return ((RecordArea)this.recordArea).segments;
    }

    public List<MemorySegment> getBucketAreaMemorySegments() {
        return this.bucketSegments;
    }

    public void free() {
        this.free(false);
    }

    @Override
    public void free(boolean reservedRecordMemory) {
        this.recordArea.release();
        this.destructiveIterator = null;
        super.free(reservedRecordMemory);
    }

    @Override
    public void reset() {
        this.recordArea.reset();
        this.destructiveIterator = null;
        super.reset();
    }

    @VisibleForTesting
    boolean isHashSetMode() {
        return this.hashSetMode;
    }

    static int getVariableLength(LogicalType[] types) {
        int length = 0;
        for (LogicalType type : types) {
            if (BinaryRowData.isInFixedLengthPart(type)) continue;
            length += 16;
        }
        return length;
    }

    private final class RecordArea
    implements BytesMap.RecordArea<K, BinaryRowData> {
        private final ArrayList<MemorySegment> segments = new ArrayList();
        private final RandomAccessInputView inView;
        private final SimpleCollectingOutputView outView;

        RecordArea() {
            this.outView = new SimpleCollectingOutputView(this.segments, (MemorySegmentSource)AbstractBytesHashMap.this.memoryPool, AbstractBytesHashMap.this.segmentSize);
            this.inView = new RandomAccessInputView(this.segments, AbstractBytesHashMap.this.segmentSize);
        }

        @Override
        public void release() {
            AbstractBytesHashMap.this.returnSegments(this.segments);
            this.segments.clear();
        }

        @Override
        public void reset() {
            this.release();
            this.outView.reset();
            this.inView.setReadPosition(0L);
        }

        @Override
        public int appendRecord(BytesMap.LookupInfo<K, BinaryRowData> lookupInfo, BinaryRowData value2) throws IOException {
            long oldLastPosition = this.outView.getCurrentOffset();
            int skip = AbstractBytesHashMap.this.keySerializer.serializeToPages(lookupInfo.getKey(), (AbstractPagedOutputView)this.outView);
            long offset = oldLastPosition + (long)skip;
            AbstractBytesHashMap.this.valueSerializer.serializeToPages(value2, (AbstractPagedOutputView)this.outView);
            if (offset > Integer.MAX_VALUE) {
                LOG.warn("We can't handle key area with more than Integer.MAX_VALUE bytes, because the pointer is a integer.");
                throw new EOFException();
            }
            return (int)offset;
        }

        @Override
        public long getSegmentsSize() {
            return (long)this.segments.size() * (long)AbstractBytesHashMap.this.segmentSize;
        }

        @Override
        public void setReadPosition(int position) {
            this.inView.setReadPosition((long)position);
        }

        @Override
        public boolean readKeyAndEquals(K lookupKey) throws IOException {
            AbstractBytesHashMap.this.reusedKey = AbstractBytesHashMap.this.keySerializer.mapFromPages(AbstractBytesHashMap.this.reusedKey, (AbstractPagedInputView)this.inView);
            return lookupKey.equals(AbstractBytesHashMap.this.reusedKey);
        }

        void skipKey() throws IOException {
            AbstractBytesHashMap.this.keySerializer.skipRecordFromPages((AbstractPagedInputView)this.inView);
        }

        @Override
        public BinaryRowData readValue(BinaryRowData reuse) throws IOException {
            return AbstractBytesHashMap.this.valueSerializer.mapFromPages(reuse, (AbstractPagedInputView)this.inView);
        }

        private KeyValueIterator<K, BinaryRowData> entryIterator(boolean requiresCopy) {
            return new EntryIterator(requiresCopy);
        }

        private final class EntryIterator
        extends AbstractPagedInputView
        implements KeyValueIterator<K, BinaryRowData> {
            private int count;
            private int currentSegmentIndex;
            private final boolean requiresCopy;

            private EntryIterator(boolean requiresCopy) {
                super((MemorySegment)RecordArea.this.segments.get(0), AbstractBytesHashMap.this.segmentSize, 0);
                this.count = 0;
                this.currentSegmentIndex = 0;
                AbstractBytesHashMap.this.destructiveIterator = this;
                this.requiresCopy = requiresCopy;
            }

            @Override
            public boolean advanceNext() throws IOException {
                if ((long)this.count < AbstractBytesHashMap.this.numElements) {
                    ++this.count;
                    AbstractBytesHashMap.this.keySerializer.mapFromPages(AbstractBytesHashMap.this.reusedKey, this);
                    AbstractBytesHashMap.this.valueSerializer.mapFromPages((BinaryRowData)AbstractBytesHashMap.this.reusedValue, (AbstractPagedInputView)this);
                    return true;
                }
                return false;
            }

            @Override
            public K getKey() {
                return this.requiresCopy ? AbstractBytesHashMap.this.keySerializer.copy(AbstractBytesHashMap.this.reusedKey) : AbstractBytesHashMap.this.reusedKey;
            }

            @Override
            public BinaryRowData getValue() {
                return this.requiresCopy ? ((BinaryRowData)AbstractBytesHashMap.this.reusedValue).copy() : (BinaryRowData)AbstractBytesHashMap.this.reusedValue;
            }

            public boolean hasNext() {
                return (long)this.count < AbstractBytesHashMap.this.numElements;
            }

            protected int getLimitForSegment(MemorySegment segment) {
                return AbstractBytesHashMap.this.segmentSize;
            }

            protected MemorySegment nextSegment(MemorySegment current) {
                return (MemorySegment)RecordArea.this.segments.get(++this.currentSegmentIndex);
            }
        }
    }
}

