/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.util.MathUtils;

public class CountWindow
extends Window {
    private final long id;

    public CountWindow(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public long maxTimestamp() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountWindow window = (CountWindow)o;
        return this.id == window.id;
    }

    @Override
    public int hashCode() {
        return MathUtils.longToIntWithBitMixing((long)this.id);
    }

    public String toString() {
        return "CountWindow{id=" + this.id + '}';
    }

    @Override
    public int compareTo(Window o) {
        CountWindow that = (CountWindow)o;
        return Long.compare(this.id, that.id);
    }

    public static class Serializer
    extends TypeSerializerSingleton<CountWindow> {
        private static final long serialVersionUID = 1L;

        public boolean isImmutableType() {
            return true;
        }

        public CountWindow createInstance() {
            return null;
        }

        public CountWindow copy(CountWindow from) {
            return from;
        }

        public CountWindow copy(CountWindow from, CountWindow reuse) {
            return from;
        }

        public int getLength() {
            return 0;
        }

        public void serialize(CountWindow record, DataOutputView target) throws IOException {
            target.writeLong(record.id);
        }

        public CountWindow deserialize(DataInputView source) throws IOException {
            return new CountWindow(source.readLong());
        }

        public CountWindow deserialize(CountWindow reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            target.writeLong(source.readLong());
        }

        public TypeSerializerSnapshot<CountWindow> snapshotConfiguration() {
            return new CountWindowSerializerSnapshot();
        }

        public static final class CountWindowSerializerSnapshot
        extends SimpleTypeSerializerSnapshot<CountWindow> {
            public CountWindowSerializerSnapshot() {
                super(Serializer::new);
            }
        }
    }
}

