/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.util.StreamRecordCollector;

public class RankOperator
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData> {
    private GeneratedRecordComparator partitionByGenComp;
    private GeneratedRecordComparator orderByGenComp;
    private final long rankStart;
    private final long rankEnd;
    private final boolean outputRankFunColumn;
    private transient RecordComparator partitionByComp;
    private transient RecordComparator orderByComp;
    private transient long rowNum;
    private transient long rank;
    private transient GenericRowData rankValueRow;
    private transient JoinedRowData joinedRow;
    private transient RowData lastInput;
    private transient StreamRecordCollector<RowData> collector;
    private transient AbstractRowDataSerializer<RowData> inputSer;

    public RankOperator(GeneratedRecordComparator partitionByGenComp, GeneratedRecordComparator orderByGenComp, long rankStart, long rankEnd, boolean outputRankFunColumn) {
        this.partitionByGenComp = partitionByGenComp;
        this.orderByGenComp = orderByGenComp;
        this.rankStart = rankStart;
        this.rankEnd = rankEnd;
        this.outputRankFunColumn = outputRankFunColumn;
    }

    @Override
    public void open() throws Exception {
        super.open();
        ClassLoader cl = this.getUserCodeClassloader();
        this.inputSer = (AbstractRowDataSerializer)this.getOperatorConfig().getTypeSerializerIn1(cl);
        this.partitionByComp = (RecordComparator)this.partitionByGenComp.newInstance(cl);
        this.partitionByGenComp = null;
        this.orderByComp = (RecordComparator)this.orderByGenComp.newInstance(cl);
        this.orderByGenComp = null;
        if (this.outputRankFunColumn) {
            this.joinedRow = new JoinedRowData();
            this.rankValueRow = new GenericRowData(1);
        }
        this.collector = new StreamRecordCollector(this.output);
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        RowData input = (RowData)element.getValue();
        ++this.rowNum;
        if (this.lastInput == null || this.partitionByComp.compare(this.lastInput, input) != 0) {
            this.rank = 1L;
            this.rowNum = 1L;
        } else if (this.orderByComp.compare(this.lastInput, input) != 0) {
            this.rank = this.rowNum;
        }
        this.emitInternal(input);
        this.lastInput = (RowData)this.inputSer.copy(input);
    }

    private void emitInternal(RowData element) {
        if (this.rank >= this.rankStart && this.rank <= this.rankEnd) {
            if (this.outputRankFunColumn) {
                this.rankValueRow.setField(0, this.rank);
                this.collector.collect(this.joinedRow.replace(element, this.rankValueRow));
            } else {
                this.collector.collect(element);
            }
        }
    }
}

