/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.triggers.ElementTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.EventTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.ProcessingTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.Trigger;
import org.apache.flink.table.runtime.operators.window.triggers.WindowTrigger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001E\u0011!cV5oI><X)\\5u'R\u0014\u0018\r^3hs*\u00111\u0001B\u0001\u0006kRLGn\u001d\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011!I\u0002A!A!\u0002\u0013Q\u0012aC5t\u000bZ,g\u000e\u001e+j[\u0016\u0004\"aG\u0016\u000f\u0005qIcBA\u000f)\u001d\tqrE\u0004\u0002 M9\u0011\u0001%\n\b\u0003C\u0011j\u0011A\t\u0006\u0003GA\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011!FB\u0001\ba\u0006\u001c7.Y4f\u0013\taSF\u0001\u0005K\u0005>|G.Z1o\u0015\tQc\u0001\u0003\u00050\u0001\t\u0005\t\u0015!\u0003\u001b\u0003=I7oU3tg&|gnV5oI><\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u001d\u0015\f'\u000f\\=GSJ,G)\u001a7bsB\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0005i&lWMC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u0011m\u0002!\u0011!Q\u0001\ni\tQ#Z1sYf4\u0015N]3EK2\f\u00170\u00128bE2,G\r\u0003\u0005>\u0001\t\u0005\t\u0015!\u00033\u00035a\u0017\r^3GSJ,G)\u001a7bs\"Aq\b\u0001B\u0001B\u0003%!$\u0001\u000bmCR,g)\u001b:f\t\u0016d\u0017-_#oC\ndW\r\u001a\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\u0006i\u0011\r\u001c7po2\u000bG/\u001a8fgN\u0004\"aG\"\n\u0005\u0011k#!\u0002&M_:<\u0007\"\u0002$\u0001\t\u00039\u0015A\u0002\u001fj]&$h\b\u0006\u0005I\u0015.cUJT(Q!\tI\u0005!D\u0001\u0003\u0011\u0015IR\t1\u0001\u001b\u0011\u0015yS\t1\u0001\u001b\u0011\u0015\tT\t1\u00013\u0011\u0015YT\t1\u0001\u001b\u0011\u0015iT\t1\u00013\u0011\u0015yT\t1\u0001\u001b\u0011\u0015\tU\t1\u0001C\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003A9W\r^!mY><H*\u0019;f]\u0016\u001c8/F\u0001C\u0011\u0015)\u0006\u0001\"\u0003W\u0003=\u0019\u0007.Z2l-\u0006d\u0017\u000eZ1uS>tG#A,\u0011\u0005MA\u0016BA-\u0015\u0005\u0011)f.\u001b;\t\u000bm\u0003A\u0011\u0001/\u0002\u001dA\u0014x\u000eZ;dKV\u0003H-\u0019;fgV\t!\u0004C\u0003_\u0001\u0011\u0005q,\u0001\u0006hKR$&/[4hKJ,\u0012\u0001\u0019\t\u0004C*dW\"\u00012\u000b\u0005\r$\u0017\u0001\u0003;sS\u001e<WM]:\u000b\u0005\u00154\u0017AB<j]\u0012|wO\u0003\u0002hQ\u0006Iq\u000e]3sCR|'o\u001d\u0006\u0003S\"\tqA];oi&lW-\u0003\u0002lE\n9AK]5hO\u0016\u0014\bCA7o\u001b\u0005!\u0017BA8e\u0005)!\u0016.\\3XS:$wn\u001e\u0005\u0006c\u0002!\tE]\u0001\ti>\u001cFO]5oOR\t1\u000f\u0005\u0002uo:\u00111#^\u0005\u0003mR\ta\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011a\u000f\u0006\u0005\u0006w\u0002!I\u0001`\u0001\u001bGJ,\u0017\r^3Ue&<w-\u001a:Ge>lg)\u001b:f\t\u0016d\u0017-\u001f\u000b\u0006{\u0006\u0005\u0011Q\u0001\t\u0004'y\u0004\u0017BA@\u0015\u0005\u0019y\u0005\u000f^5p]\"1\u00111\u0001>A\u0002i\tq\"\u001a8bE2,G)\u001a7bs\u0016k\u0017\u000e\u001e\u0005\u0007\u0003\u000fQ\b\u0019\u0001\u001a\u0002\u0013\u0019L'/\u001a#fY\u0006L\bbBA\u0006\u0001\u0011%\u0011QB\u0001\u0012M&\u0014X\rR3mCf$vn\u0015;sS:<G#B:\u0002\u0010\u0005E\u0001bBA\u0002\u0003\u0013\u0001\rA\u0007\u0005\b\u0003\u000f\tI\u00011\u00013\u000f\u001d\t)B\u0001E\u0001\u0003/\t!cV5oI><X)\\5u'R\u0014\u0018\r^3hsB\u0019\u0011*!\u0007\u0007\r\u0005\u0011\u0001\u0012AA\u000e'\r\tIB\u0005\u0005\b\r\u0006eA\u0011AA\u0010)\t\t9\u0002\u0003\u0005\u0002$\u0005eA\u0011AA\u0013\u0003\u0015\t\u0007\u000f\u001d7z)\u0015A\u0015qEA\u001c\u0011!\tI#!\tA\u0002\u0005-\u0012a\u0003;bE2,7i\u001c8gS\u001e\u0004B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cA\u0011aA1qS&!\u0011QGA\u0018\u0005-!\u0016M\u00197f\u0007>tg-[4\t\u000f\u0015\f\t\u00031\u0001\u0002:A!\u00111HA!\u001b\t\tiDC\u0002\u0002@\u0011\tq\u0001\\8hS\u000e\fG.\u0003\u0003\u0002D\u0005u\"!\u0004'pO&\u001c\u0017\r\\,j]\u0012|w\u000f\u0003\u0005\u0002H\u0005eA\u0011BA%\u0003I\u0001\u0018M]:f\u00032dwn\u001e'bi\u0016tWm]:\u0015\r\u0005-\u0013\u0011KA-!\r\u0019\u0012QJ\u0005\u0004\u0003\u001f\"\"\u0001\u0002'p]\u001eDqaLA#\u0001\u0004\t\u0019\u0006E\u0002\u0014\u0003+J1!a\u0016\u0015\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u000b\u0002F\u0001\u0007\u00111\u0006\u0005\u000b\u0003;\nIB1A\u0005\u0002\u0005}\u0013A\t+B\u00052+u,\u0012-F\u0007~+U*\u0013+`\u000b\u0006\u0013F*W0G\u0013J+u,\u0012(B\u00052+E)\u0006\u0002\u0002bA)\u00111MA555\u0011\u0011Q\r\u0006\u0004\u0003OR\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002l\u0005\u0015$\u0001D\"p]\u001aLwm\u00149uS>t\u0007\"CA8\u00033\u0001\u000b\u0011BA1\u0003\r\"\u0016I\u0011'F?\u0016CViQ0F\u001b&#v,R!S\u0019f{f)\u0013*F?\u0016s\u0015I\u0011'F\t\u0002BC!!\u001c\u0002tA!\u0011QOA>\u001b\t\t9HC\u0002\u0002z)\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti(a\u001e\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\t\u0015\u0005\u0005\u0015\u0011\u0004b\u0001\n\u0003\t\u0019)\u0001\u0011U\u0003\ncUiX#Y\u000b\u000e{V)T%U?\u0016\u000b%\u000bT-`\r&\u0013Vi\u0018#F\u0019\u0006KVCAAC!\u0015\t\u0019'!\u001b3\u0011%\tI)!\u0007!\u0002\u0013\t))A\u0011U\u0003\ncUiX#Y\u000b\u000e{V)T%U?\u0016\u000b%\u000bT-`\r&\u0013Vi\u0018#F\u0019\u0006K\u0006\u0005\u000b\u0003\u0002\b\u0006M\u0004BCAH\u00033\u0011\r\u0011\"\u0001\u0002`\u0005\tC+\u0011\"M\u000b~+\u0005,R\"`\u000b6KEk\u0018'B)\u0016{f)\u0013*F?\u0016s\u0015I\u0011'F\t\"I\u00111SA\rA\u0003%\u0011\u0011M\u0001#)\u0006\u0013E*R0F1\u0016\u001bu,R'J)~c\u0015\tV#`\r&\u0013ViX#O\u0003\ncU\t\u0012\u0011)\t\u0005E\u00151\u000f\u0005\u000b\u00033\u000bIB1A\u0005\u0002\u0005\r\u0015a\b+B\u00052+u,\u0012-F\u0007~+U*\u0013+`\u0019\u0006#Vi\u0018$J%\u0016{F)\u0012'B3\"I\u0011QTA\rA\u0003%\u0011QQ\u0001!)\u0006\u0013E*R0F1\u0016\u001bu,R'J)~c\u0015\tV#`\r&\u0013Vi\u0018#F\u0019\u0006K\u0006\u0005\u000b\u0003\u0002\u001c\u0006M\u0004BCAR\u00033\u0011\r\u0011\"\u0001\u0002\u0004\u0006qB+\u0011\"M\u000b~+\u0005,R\"`\u000b6KEkX!M\u0019>;v\fT!U\u000b:+5k\u0015\u0005\n\u0003O\u000bI\u0002)A\u0005\u0003\u000b\u000bq\u0004V!C\u0019\u0016{V\tW#D?\u0016k\u0015\nV0B\u00192{uk\u0018'B)\u0016sUiU*!Q\u0011\t)+a\u001d")
public class WindowEmitStrategy {
    private final Boolean isEventTime;
    private final Boolean isSessionWindow;
    private final Duration earlyFireDelay;
    private final Boolean earlyFireDelayEnabled;
    private final Duration lateFireDelay;
    private final Boolean lateFireDelayEnabled;
    private final Long allowLateness;

    public static ConfigOption<Duration> TABLE_EXEC_EMIT_ALLOW_LATENESS() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_ALLOW_LATENESS();
    }

    public static ConfigOption<Duration> TABLE_EXEC_EMIT_LATE_FIRE_DELAY() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY();
    }

    public static ConfigOption<Boolean> TABLE_EXEC_EMIT_LATE_FIRE_ENABLED() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED();
    }

    public static ConfigOption<Duration> TABLE_EXEC_EMIT_EARLY_FIRE_DELAY() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY();
    }

    public static ConfigOption<Boolean> TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED();
    }

    public static WindowEmitStrategy apply(TableConfig tableConfig, LogicalWindow logicalWindow) {
        return WindowEmitStrategy$.MODULE$.apply(tableConfig, logicalWindow);
    }

    public Long getAllowLateness() {
        return this.allowLateness;
    }

    private void checkValidation() {
        if (Predef$.MODULE$.Boolean2boolean(this.isSessionWindow) && (Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) || Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled))) {
            throw new TableException("Session window doesn't support EMIT strategy currently.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.isEventTime) && Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled) && Predef$.MODULE$.Long2long(this.allowLateness) <= 0L) {
            throw new TableException("The 'AFTER WATERMARK' emit strategy requires set 'allow-lateness' or 'minIdleStateRetentionTime' in table config.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) && (this.earlyFireDelay == null || this.earlyFireDelay.toMillis() < 0L)) {
            throw new TableException("Early-fire delay should not be null or negative value whenenable early-fire emit strategy.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled) && (this.lateFireDelay == null || this.lateFireDelay.toMillis() < 0L)) {
            throw new TableException("Late-fire delay should not be null or negative value whenenable late-fire emit strategy.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled) && this.lateFireDelay.toMillis() > Predef$.MODULE$.Long2long(this.allowLateness)) {
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Allow-lateness [", "ms] should not be smaller than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.allowLateness}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Late-fire delay [", "ms] when enable late-fire emit strategy."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lateFireDelay.toMillis())}))).toString());
        }
    }

    public Boolean produceUpdates() {
        return Predef$.MODULE$.Boolean2boolean(this.isEventTime) ? Predef$.MODULE$.boolean2Boolean(Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) || Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled)) : this.earlyFireDelayEnabled;
    }

    public Trigger<TimeWindow> getTrigger() {
        Option<Trigger<TimeWindow>> option;
        block11: {
            WindowTrigger windowTrigger;
            block8: {
                WindowTrigger windowTrigger2;
                block10: {
                    ProcessingTimeTriggers.AfterEndOfWindow<TimeWindow> trigger;
                    block9: {
                        Option<Trigger<TimeWindow>> earlyTrigger;
                        block2: {
                            Tuple2 tuple2;
                            block7: {
                                Trigger trigger2;
                                block4: {
                                    EventTimeTriggers.AfterEndOfWindow trigger3;
                                    block6: {
                                        block5: {
                                            block3: {
                                                earlyTrigger = this.createTriggerFromFireDelay(this.earlyFireDelayEnabled, this.earlyFireDelay);
                                                Option<Trigger<TimeWindow>> lateTrigger = this.createTriggerFromFireDelay(this.lateFireDelayEnabled, this.lateFireDelay);
                                                if (!Predef$.MODULE$.Boolean2boolean(this.isEventTime)) break block2;
                                                trigger3 = EventTimeTriggers.afterEndOfWindow();
                                                tuple2 = new Tuple2(earlyTrigger, lateTrigger);
                                                if (tuple2 == null) break block3;
                                                Option option2 = (Option)tuple2._1();
                                                Option option3 = (Option)tuple2._2();
                                                if (!(option2 instanceof Some)) break block3;
                                                Some some = (Some)option2;
                                                Trigger early = (Trigger)some.x();
                                                if (!(option3 instanceof Some)) break block3;
                                                Some some2 = (Some)option3;
                                                Trigger late = (Trigger)some2.x();
                                                trigger2 = trigger3.withEarlyFirings(early).withLateFirings(late);
                                                break block4;
                                            }
                                            if (tuple2 == null) break block5;
                                            Option option4 = (Option)tuple2._1();
                                            Option option5 = (Option)tuple2._2();
                                            if (!(option4 instanceof Some)) break block5;
                                            Some some = (Some)option4;
                                            Trigger early = (Trigger)some.x();
                                            if (!None$.MODULE$.equals(option5)) break block5;
                                            trigger2 = trigger3.withEarlyFirings(early);
                                            break block4;
                                        }
                                        if (tuple2 == null) break block6;
                                        Option option6 = (Option)tuple2._1();
                                        Option option7 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option6) || !(option7 instanceof Some)) break block6;
                                        Some some = (Some)option7;
                                        Trigger late = (Trigger)some.x();
                                        trigger2 = trigger3.withLateFirings(late);
                                        break block4;
                                    }
                                    if (tuple2 == null) break block7;
                                    Option option8 = (Option)tuple2._1();
                                    Option option9 = (Option)tuple2._2();
                                    if (!None$.MODULE$.equals(option8) || !None$.MODULE$.equals(option9)) break block7;
                                    trigger2 = trigger3;
                                }
                                windowTrigger = trigger2;
                                break block8;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        trigger = ProcessingTimeTriggers.afterEndOfWindow();
                        option = earlyTrigger;
                        if (!(option instanceof Some)) break block9;
                        Some some = (Some)option;
                        Trigger early = (Trigger)some.x();
                        windowTrigger2 = trigger.withEarlyFirings(early);
                        break block10;
                    }
                    if (!None$.MODULE$.equals(option)) break block11;
                    windowTrigger2 = trigger;
                }
                windowTrigger = windowTrigger2;
            }
            return windowTrigger;
        }
        throw new MatchError(option);
    }

    public String toString() {
        BoxedUnit boxedUnit;
        StringBuilder builder = new StringBuilder();
        String earlyString = this.fireDelayToString(this.earlyFireDelayEnabled, this.earlyFireDelay);
        String lateString = this.fireDelayToString(this.lateFireDelayEnabled, this.lateFireDelay);
        Object object = earlyString == null ? BoxedUnit.UNIT : builder.append("early ").append(earlyString);
        if (lateString == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Object object2 = earlyString == null ? BoxedUnit.UNIT : builder.append(", ");
            boxedUnit = builder.append("late ").append(lateString);
        }
        return builder.toString();
    }

    private Option<Trigger<TimeWindow>> createTriggerFromFireDelay(Boolean enableDelayEmit, Duration fireDelay) {
        return Predef$.MODULE$.Boolean2boolean(enableDelayEmit) ? (fireDelay.toMillis() > 0L ? new Some(ProcessingTimeTriggers.every(fireDelay)) : new Some(ElementTriggers.every())) : None$.MODULE$;
    }

    private String fireDelayToString(Boolean enableDelayEmit, Duration fireDelay) {
        return Predef$.MODULE$.Boolean2boolean(enableDelayEmit) ? (fireDelay.toMillis() > 0L ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delay ", " millisecond"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)fireDelay.toMillis())})) : "no delay") : null;
    }

    public WindowEmitStrategy(Boolean isEventTime, Boolean isSessionWindow, Duration earlyFireDelay, Boolean earlyFireDelayEnabled, Duration lateFireDelay, Boolean lateFireDelayEnabled, Long allowLateness) {
        this.isEventTime = isEventTime;
        this.isSessionWindow = isSessionWindow;
        this.earlyFireDelay = earlyFireDelay;
        this.earlyFireDelayEnabled = earlyFireDelayEnabled;
        this.lateFireDelay = lateFireDelay;
        this.lateFireDelayEnabled = lateFireDelayEnabled;
        this.allowLateness = allowLateness;
        this.checkValidation();
    }
}

