/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableList;

public class RelDescriptionWriterImpl
implements RelWriter {
    private static final String[] REL_TYPE_NAME_PREFIXES = new String[]{"StreamExec", "BatchExec", "BatchPhysical", "StreamPhysical", "FlinkLogical"};
    private final PrintWriter pw;
    private final List<Pair<String, Object>> values = new ArrayList<Pair<String, Object>>();

    public RelDescriptionWriterImpl(PrintWriter pw) {
        this.pw = pw;
    }

    @Override
    public void explain(RelNode rel, List<Pair<String, Object>> valueList) {
        StringBuilder s = new StringBuilder();
        s.append(this.getNodeTypeName(rel));
        int j2 = 0;
        for (Pair<String, Object> value2 : valueList) {
            if (j2++ == 0) {
                s.append("(");
            } else {
                s.append(", ");
            }
            s.append(value2.getKey()).append("=[").append(value2.getValue()).append("]");
        }
        if (j2 > 0) {
            s.append(")");
        }
        this.pw.print(s.toString());
    }

    @Override
    public SqlExplainLevel getDetailLevel() {
        return SqlExplainLevel.EXPPLAN_ATTRIBUTES;
    }

    @Override
    public RelWriter input(String term2, RelNode input) {
        return this;
    }

    @Override
    public RelWriter item(String term2, Object value2) {
        this.values.add(Pair.of(term2, value2));
        return this;
    }

    @Override
    public RelWriter done(RelNode node) {
        ImmutableList valuesCopy = ImmutableList.copyOf(this.values);
        this.values.clear();
        this.explain(node, (List<Pair<String, Object>>)valuesCopy);
        this.pw.flush();
        return this;
    }

    private String getNodeTypeName(RelNode rel) {
        String typeName = rel.getRelTypeName();
        for (String prefix : REL_TYPE_NAME_PREFIXES) {
            if (!typeName.startsWith(prefix)) continue;
            return typeName.substring(prefix.length());
        }
        throw new IllegalStateException("Unsupported RelNode class name '" + typeName + "'");
    }
}

