/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.plan.abilities.source.ProjectPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.ReadingMetadataSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.NestedColumn;
import org.apache.flink.table.planner.plan.utils.NestedProjectionUtil;
import org.apache.flink.table.planner.plan.utils.NestedSchema;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class PushProjectIntoTableSourceScanRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.EMPTY.as(Config.class).onProjectedScan().toRule();

    public PushProjectIntoTableSourceScanRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable sourceTable = scan.getTable().unwrap(TableSourceTable.class);
        if (sourceTable == null) {
            return false;
        }
        DynamicTableSource source = sourceTable.tableSource();
        if (this.supportsProjectionPushDown(source)) {
            return Arrays.stream(sourceTable.abilitySpecs()).noneMatch(spec -> spec instanceof ProjectPushDownSpec);
        }
        if (this.supportsMetadata(source)) {
            if (Arrays.stream(sourceTable.abilitySpecs()).anyMatch(spec -> spec instanceof ReadingMetadataSpec)) {
                return false;
            }
            return ((SupportsReadingMetadata)((Object)source)).supportsMetadataProjection();
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable sourceTable = scan.getTable().unwrap(TableSourceTable.class);
        boolean supportsNestedProjection = this.supportsNestedProjection(sourceTable.tableSource());
        int[] refFields = RexNodeExtractor.extractRefInputFields(project.getProjects());
        if (!supportsNestedProjection && refFields.length == scan.getRowType().getFieldCount()) {
            return;
        }
        FlinkTypeFactory typeFactory = ShortcutUtils.unwrapTypeFactory(scan);
        ResolvedSchema schema = sourceTable.catalogTable().getResolvedSchema();
        RowType producedType = DynamicSourceUtils.createProducedType(schema, sourceTable.tableSource());
        NestedSchema projectedSchema = NestedProjectionUtil.build(this.getProjections(project, scan), typeFactory.buildRelNodeRowType(producedType));
        if (!supportsNestedProjection) {
            for (NestedColumn column : projectedSchema.columns().values()) {
                column.markLeaf();
            }
        }
        ArrayList<SourceAbilitySpec> abilitySpecs = new ArrayList<SourceAbilitySpec>();
        RowType newProducedType = this.performPushDown(sourceTable, projectedSchema, producedType, abilitySpecs);
        DynamicTableSource newTableSource = sourceTable.tableSource().copy();
        SourceAbilityContext context = SourceAbilityContext.from(scan);
        abilitySpecs.forEach(spec -> spec.apply(newTableSource, context));
        RelDataType newRowType = typeFactory.buildRelNodeRowType(newProducedType);
        TableSourceTable newSource = sourceTable.copy(newTableSource, newRowType, PushProjectIntoTableSourceScanRule.getExtraDigests(abilitySpecs), abilitySpecs.toArray(new SourceAbilitySpec[0]));
        LogicalTableScan newScan = new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), scan.getHints(), newSource);
        Project newProject = project.copy(project.getTraitSet(), (RelNode)newScan, (List)this.rewriteProjections(call, newSource, projectedSchema), project.getRowType());
        if (ProjectRemoveRule.isTrivial(newProject)) {
            call.transformTo(newScan);
        } else {
            call.transformTo(newProject);
        }
    }

    private boolean supportsProjectionPushDown(DynamicTableSource tableSource) {
        return tableSource instanceof SupportsProjectionPushDown;
    }

    private boolean supportsMetadata(DynamicTableSource tableSource) {
        return tableSource instanceof SupportsReadingMetadata;
    }

    private boolean supportsNestedProjection(DynamicTableSource tableSource) {
        return this.supportsProjectionPushDown(tableSource) && ((SupportsProjectionPushDown)((Object)tableSource)).supportsNestedProjection();
    }

    private List<RexNode> getProjections(LogicalProject project, LogicalTableScan scan) {
        TableSourceTable source = scan.getTable().unwrap(TableSourceTable.class);
        TableConfig tableConfig = ShortcutUtils.unwrapContext(scan).getTableConfig();
        ArrayList<RexNode> projections = new ArrayList<RexNode>(project.getProjects());
        if (this.supportsProjectionPushDown(source.tableSource()) && PushProjectIntoTableSourceScanRule.requiresPrimaryKey(source, tableConfig)) {
            projections.addAll(this.getPrimaryKeyProjections(scan));
        }
        return projections;
    }

    private static boolean requiresPrimaryKey(TableSourceTable table, TableConfig config) {
        return DynamicSourceUtils.isUpsertSource(table.catalogTable(), table.tableSource()) || DynamicSourceUtils.isSourceChangeEventsDuplicate(table.catalogTable(), table.tableSource(), config);
    }

    private List<RexNode> getPrimaryKeyProjections(LogicalTableScan scan) {
        TableSourceTable source = scan.getTable().unwrap(TableSourceTable.class);
        ResolvedSchema schema = source.catalogTable().getResolvedSchema();
        if (!schema.getPrimaryKey().isPresent()) {
            return Collections.emptyList();
        }
        FlinkTypeFactory typeFactory = ShortcutUtils.unwrapTypeFactory(scan);
        UniqueConstraint primaryKey = schema.getPrimaryKey().get();
        return primaryKey.getColumns().stream().map(columnName -> {
            int idx = scan.getRowType().getFieldNames().indexOf(columnName);
            Column column = schema.getColumn(idx).orElseThrow(() -> new TableException(String.format("Column at index %d not found.", idx)));
            return new RexInputRef(idx, typeFactory.createFieldTypeFromLogicalType(column.getDataType().getLogicalType()));
        }).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private RowType performPushDown(TableSourceTable source, NestedSchema projectedSchema, RowType producedType, List<SourceAbilitySpec> abilitySpecs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<RexNode> rewriteProjections(RelOptRuleCall call, TableSourceTable source, NestedSchema projectedSchema) {
        LogicalProject project = (LogicalProject)call.rel(0);
        if (this.supportsProjectionPushDown(source.tableSource())) {
            return NestedProjectionUtil.rewrite(project.getProjects(), projectedSchema, call.builder().getRexBuilder());
        }
        return project.getProjects();
    }

    private static String[] getExtraDigests(List<SourceAbilitySpec> abilitySpecs) {
        ArrayList<String> digests = new ArrayList<String>();
        for (SourceAbilitySpec abilitySpec : abilitySpecs) {
            if (abilitySpec instanceof ProjectPushDownSpec) {
                digests.add(PushProjectIntoTableSourceScanRule.formatPushDownDigest((ProjectPushDownSpec)abilitySpec));
                continue;
            }
            if (!(abilitySpec instanceof ReadingMetadataSpec)) continue;
            digests.add(PushProjectIntoTableSourceScanRule.formatMetadataDigest((ReadingMetadataSpec)abilitySpec));
        }
        return digests.toArray(new String[0]);
    }

    private static String formatPushDownDigest(ProjectPushDownSpec pushDownSpec) {
        List<String> fieldNames = pushDownSpec.getProducedType().orElseThrow(() -> new TableException("Produced data type is not present.")).getFieldNames();
        return String.format("project=[%s]", String.join((CharSequence)", ", fieldNames));
    }

    private static String formatMetadataDigest(ReadingMetadataSpec metadataSpec) {
        return String.format("metadata=[%s]", String.join((CharSequence)", ", metadataSpec.getMetadataKeys()));
    }

    private static /* synthetic */ int[][] lambda$performPushDown$12(int x$0) {
        return new int[x$0][];
    }

    private static /* synthetic */ int[] lambda$performPushDown$11(Integer columnIndex) {
        return new int[]{columnIndex};
    }

    private static /* synthetic */ int[][] lambda$performPushDown$10(int x$0) {
        return new int[x$0][];
    }

    public static interface Config
    extends RelRule.Config {
        @Override
        default public RelOptRule toRule() {
            return new PushProjectIntoTableSourceScanRule(this);
        }

        default public Config onProjectedScan() {
            RelRule.OperandTransform scanTransform = operandBuilder -> operandBuilder.operand(LogicalTableScan.class).noInputs();
            RelRule.OperandTransform projectTransform = operandBuilder -> operandBuilder.operand(LogicalProject.class).oneInput(scanTransform);
            return this.withOperandSupplier(projectTransform).as(Config.class);
        }
    }
}

