/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.OverSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.OverAggregateUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.over.ProcTimeRangeBoundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.ProcTimeRowsBoundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.ProcTimeUnboundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRangeBoundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRangeUnboundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRowsBoundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRowsUnboundedPrecedingFunction;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamExecOverAggregate
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamExecOverAggregate.class);
    public static final String FIELD_NAME_OVER_SPEC = "overSpec";
    @JsonProperty(value="overSpec")
    private final OverSpec overSpec;

    public StreamExecOverAggregate(OverSpec overSpec, InputProperty inputProperty, RowType outputType, String description) {
        this(overSpec, StreamExecOverAggregate.getNewNodeId(), Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecOverAggregate(@JsonProperty(value="overSpec") OverSpec overSpec, @JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, inputProperties, outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.overSpec = (OverSpec)Preconditions.checkNotNull((Object)overSpec);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        KeyedProcessFunction<RowData, RowData, RowData> overProcessFunction;
        int rowTimeIdx;
        if (this.overSpec.getGroups().size() > 1) {
            throw new TableException("All aggregates must be computed on the same window.");
        }
        OverSpec.GroupSpec group = this.overSpec.getGroups().get(0);
        int[] orderKeys = group.getSort().getFieldIndices();
        boolean[] isAscendingOrders = group.getSort().getAscendingOrders();
        if (orderKeys.length != 1 || isAscendingOrders.length != 1) {
            throw new TableException("The window can only be ordered by a single time column.");
        }
        if (!isAscendingOrders[0]) {
            throw new TableException("The window can only be ordered in ASCENDING mode.");
        }
        int[] partitionKeys = this.overSpec.getPartition().getFieldIndices();
        TableConfig tableConfig = planner.getTableConfig();
        if (partitionKeys.length > 0 && tableConfig.getMinIdleStateRetentionTime() < 0L) {
            LOG.warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        int orderKey = orderKeys[0];
        LogicalType orderKeyType = inputRowType.getFields().get(orderKey).getType();
        if (LogicalTypeChecks.isRowtimeAttribute(orderKeyType)) {
            rowTimeIdx = orderKey;
        } else if (LogicalTypeChecks.isProctimeAttribute(orderKeyType)) {
            rowTimeIdx = -1;
        } else {
            throw new TableException("OVER windows' ordering in stream mode must be defined on a time attribute.");
        }
        List<RexLiteral> constants2 = this.overSpec.getConstants();
        ArrayList<String> fieldNames = new ArrayList<String>(inputRowType.getFieldNames());
        ArrayList<LogicalType> fieldTypes = new ArrayList<LogicalType>(inputRowType.getChildren());
        IntStream.range(0, constants2.size()).forEach(i -> fieldNames.add("TMP" + i));
        for (int i2 = 0; i2 < constants2.size(); ++i2) {
            fieldNames.add("TMP" + i2);
            fieldTypes.add(FlinkTypeFactory.toLogicalType(constants2.get(i2).getType()));
        }
        RowType aggInputRowType = RowType.of(fieldTypes.toArray(new LogicalType[0]), fieldNames.toArray(new String[0]));
        CodeGeneratorContext ctx = new CodeGeneratorContext(tableConfig);
        if (group.getLowerBound().isPreceding() && group.getLowerBound().isUnbounded() && group.getUpperBound().isCurrentRow()) {
            overProcessFunction = this.createUnboundedOverProcessFunction(ctx, group.getAggCalls(), constants2, aggInputRowType, inputRowType, rowTimeIdx, group.isRows(), tableConfig, planner.getRelBuilder());
        } else if (group.getLowerBound().isPreceding() && !group.getLowerBound().isUnbounded() && group.getUpperBound().isCurrentRow()) {
            Object boundValue = OverAggregateUtil.getBoundary(this.overSpec, group.getLowerBound());
            if (boundValue instanceof BigDecimal) {
                throw new TableException("the specific value is decimal which haven not supported yet.");
            }
            long precedingOffset = -1L * (Long)boundValue + (long)(group.isRows() ? 1 : 0);
            overProcessFunction = this.createBoundedOverProcessFunction(ctx, group.getAggCalls(), constants2, aggInputRowType, inputRowType, rowTimeIdx, group.isRows(), precedingOffset, tableConfig, planner.getRelBuilder());
        } else {
            throw new TableException("OVER RANGE FOLLOWING windows are not supported yet.");
        }
        KeyedProcessOperator operator = new KeyedProcessOperator(overProcessFunction);
        OneInputTransformation transform2 = new OneInputTransformation(inputTransform, this.getDescription(), (OneInputStreamOperator)operator, InternalTypeInfo.of(this.getOutputType()), inputTransform.getParallelism());
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(partitionKeys, InternalTypeInfo.of(inputRowType));
        transform2.setStateKeySelector((KeySelector)selector);
        transform2.setStateKeyType(selector.getProducedType());
        return transform2;
    }

    private KeyedProcessFunction<RowData, RowData, RowData> createUnboundedOverProcessFunction(CodeGeneratorContext ctx, List<AggregateCall> aggCalls, List<RexLiteral> constants2, RowType aggInputRowType, RowType inputRowType, int rowTimeIdx, boolean isRowsClause, TableConfig tableConfig, RelBuilder relBuilder) {
        AggregateInfoList aggInfoList = AggregateUtil.transformToStreamAggregateInfoList(aggInputRowType, JavaScalaConversionUtil.toScala(aggCalls), new boolean[aggCalls.size()], false, true, true);
        LogicalType[] fieldTypes = inputRowType.getChildren().toArray(new LogicalType[0]);
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(ctx, relBuilder, JavaScalaConversionUtil.toScala(Arrays.asList(fieldTypes)), false);
        GeneratedAggsHandleFunction genAggsHandler = generator.needAccumulate().withConstants(JavaScalaConversionUtil.toScala(constants2)).generateAggsHandler("UnboundedOverAggregateHelper", aggInfoList);
        LogicalType[] flattenAccTypes = (LogicalType[])Arrays.stream(aggInfoList.getAccTypes()).map(LogicalTypeDataTypeConverter::fromDataTypeToLogicalType).toArray(LogicalType[]::new);
        if (rowTimeIdx >= 0) {
            if (isRowsClause) {
                return new RowTimeRowsUnboundedPrecedingFunction<RowData>(tableConfig.getMinIdleStateRetentionTime(), tableConfig.getMaxIdleStateRetentionTime(), genAggsHandler, flattenAccTypes, fieldTypes, rowTimeIdx);
            }
            return new RowTimeRangeUnboundedPrecedingFunction<RowData>(tableConfig.getMinIdleStateRetentionTime(), tableConfig.getMaxIdleStateRetentionTime(), genAggsHandler, flattenAccTypes, fieldTypes, rowTimeIdx);
        }
        return new ProcTimeUnboundedPrecedingFunction<RowData>(tableConfig.getMinIdleStateRetentionTime(), tableConfig.getMaxIdleStateRetentionTime(), genAggsHandler, flattenAccTypes);
    }

    private KeyedProcessFunction<RowData, RowData, RowData> createBoundedOverProcessFunction(CodeGeneratorContext ctx, List<AggregateCall> aggCalls, List<RexLiteral> constants2, RowType aggInputType, RowType inputType, int rowTimeIdx, boolean isRowsClause, long precedingOffset, TableConfig tableConfig, RelBuilder relBuilder) {
        boolean[] aggCallNeedRetractions = new boolean[aggCalls.size()];
        Arrays.fill(aggCallNeedRetractions, true);
        AggregateInfoList aggInfoList = AggregateUtil.transformToStreamAggregateInfoList(aggInputType, JavaScalaConversionUtil.toScala(aggCalls), aggCallNeedRetractions, true, true, true);
        LogicalType[] fieldTypes = inputType.getChildren().toArray(new LogicalType[0]);
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(ctx, relBuilder, JavaScalaConversionUtil.toScala(Arrays.asList(fieldTypes)), false);
        GeneratedAggsHandleFunction genAggsHandler = generator.needRetract().needAccumulate().withConstants(JavaScalaConversionUtil.toScala(constants2)).generateAggsHandler("BoundedOverAggregateHelper", aggInfoList);
        LogicalType[] flattenAccTypes = (LogicalType[])Arrays.stream(aggInfoList.getAccTypes()).map(LogicalTypeDataTypeConverter::fromDataTypeToLogicalType).toArray(LogicalType[]::new);
        if (rowTimeIdx >= 0) {
            if (isRowsClause) {
                return new RowTimeRowsBoundedPrecedingFunction<RowData>(tableConfig.getMinIdleStateRetentionTime(), tableConfig.getMaxIdleStateRetentionTime(), genAggsHandler, flattenAccTypes, fieldTypes, precedingOffset, rowTimeIdx);
            }
            return new RowTimeRangeBoundedPrecedingFunction<RowData>(genAggsHandler, flattenAccTypes, fieldTypes, precedingOffset, rowTimeIdx);
        }
        if (isRowsClause) {
            return new ProcTimeRowsBoundedPrecedingFunction<RowData>(tableConfig.getMinIdleStateRetentionTime(), tableConfig.getMaxIdleStateRetentionTime(), genAggsHandler, flattenAccTypes, fieldTypes, precedingOffset);
        }
        return new ProcTimeRangeBoundedPrecedingFunction<RowData>(genAggsHandler, flattenAccTypes, fieldTypes, precedingOffset);
    }
}

