/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.runtime.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecExchange;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamExecExchange
extends CommonExecExchange
implements StreamExecNode<RowData> {
    public StreamExecExchange(InputProperty inputProperty, RowType outputType, String description) {
        this(StreamExecExchange.getNewNodeId(), Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecExchange(@JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, inputProperties, outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        int parallelism;
        GlobalPartitioner partitioner;
        Transformation<?> inputTransform = this.getInputEdges().get(0).translateToPlan(planner);
        InputProperty inputProperty = this.getInputProperties().get(0);
        InputProperty.DistributionType distributionType = inputProperty.getRequiredDistribution().getType();
        switch (distributionType) {
            case SINGLETON: {
                partitioner = new GlobalPartitioner();
                parallelism = 1;
                break;
            }
            case HASH: {
                int[] keys = ((InputProperty.HashDistribution)inputProperty.getRequiredDistribution()).getKeys();
                InternalTypeInfo inputType = (InternalTypeInfo)inputTransform.getOutputType();
                RowDataKeySelector keySelector = KeySelectorUtil.getRowDataSelector(keys, inputType);
                partitioner = new KeyGroupStreamPartitioner((KeySelector)keySelector, 128);
                parallelism = -1;
                break;
            }
            default: {
                throw new TableException(String.format("%s is not supported now!", new Object[]{distributionType}));
            }
        }
        PartitionTransformation transformation = new PartitionTransformation(inputTransform, (StreamPartitioner)partitioner);
        transformation.setParallelism(parallelism);
        transformation.setOutputType(InternalTypeInfo.of(this.getOutputType()));
        return transformation;
    }
}

