/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.CatalogTableSpecBase;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DynamicTableSinkSpec
extends CatalogTableSpecBase {
    public static final String FIELD_NAME_SINK_ABILITY_SPECS = "sinkAbilitySpecs";
    @JsonIgnore
    private DynamicTableSink tableSink;
    @JsonProperty(value="sinkAbilitySpecs")
    @Nullable
    private final List<SinkAbilitySpec> sinkAbilitySpecs;

    @JsonCreator
    public DynamicTableSinkSpec(@JsonProperty(value="identifier") ObjectIdentifier objectIdentifier, @JsonProperty(value="catalogTable") ResolvedCatalogTable catalogTable, @Nullable @JsonProperty(value="sinkAbilitySpecs") List<SinkAbilitySpec> sinkAbilitySpecs) {
        super(objectIdentifier, catalogTable);
        this.sinkAbilitySpecs = sinkAbilitySpecs;
    }

    public DynamicTableSink getTableSink() {
        if (this.tableSink == null) {
            this.tableSink = FactoryUtil.createTableSink(null, this.objectIdentifier, this.catalogTable, this.configuration, this.classLoader, true);
            if (this.sinkAbilitySpecs != null) {
                this.sinkAbilitySpecs.forEach(spec -> spec.apply(this.tableSink));
            }
        }
        return this.tableSink;
    }

    public void setTableSink(DynamicTableSink tableSink) {
        this.tableSink = tableSink;
    }
}

