/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsPartitionPushDown;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.util.Preconditions;

@JsonTypeName(value="PartitionPushDown")
public class PartitionPushDownSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_PARTITIONS = "partitions";
    @JsonProperty(value="partitions")
    private final List<Map<String, String>> partitions;

    @JsonCreator
    public PartitionPushDownSpec(@JsonProperty(value="partitions") List<Map<String, String>> partitions) {
        this.partitions = new ArrayList<Map<String, String>>((Collection)Preconditions.checkNotNull(partitions));
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        if (!(tableSource instanceof SupportsPartitionPushDown)) {
            throw new TableException(String.format("%s does not support SupportsPartitionPushDown.", tableSource.getClass().getName()));
        }
        ((SupportsPartitionPushDown)((Object)tableSource)).applyPartitions(this.partitions);
    }
}

