/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class LastValueAggFunction<T>
extends BuiltInAggregateFunction<T, RowData> {
    private transient DataType valueDataType;

    public LastValueAggFunction(LogicalType valueType) {
        this.valueDataType = DataTypeUtils.toInternalDataType(valueType);
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return Collections.singletonList(this.valueDataType);
    }

    @Override
    public DataType getAccumulatorDataType() {
        return (DataType)DataTypes.ROW(DataTypes.FIELD("lastValue", (DataType)this.valueDataType.nullable()), DataTypes.FIELD("lastOrder", DataTypes.BIGINT())).bridgedTo(RowData.class);
    }

    @Override
    public DataType getOutputDataType() {
        return this.valueDataType;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public RowData createAccumulator() {
        GenericRowData acc = new GenericRowData(2);
        acc.setField(0, null);
        acc.setField(1, Long.MIN_VALUE);
        return acc;
    }

    public void accumulate(RowData rowData, Object value2) {
        GenericRowData acc = (GenericRowData)rowData;
        if (value2 != null) {
            acc.setField(0, value2);
        }
    }

    public void accumulate(RowData rowData, Object value2, Long order) {
        GenericRowData acc = (GenericRowData)rowData;
        if (value2 != null && acc.getLong(1) < order) {
            acc.setField(0, value2);
            acc.setField(1, order);
        }
    }

    public void accumulate(GenericRowData acc, StringData value2) {
        if (value2 != null) {
            this.accumulate((RowData)acc, (Object)((BinaryStringData)value2).copy());
        }
    }

    public void accumulate(GenericRowData acc, StringData value2, Long order) {
        if (value2 != null) {
            this.accumulate((RowData)acc, (Object)((BinaryStringData)value2).copy(), order);
        }
    }

    public void resetAccumulator(RowData rowData) {
        GenericRowData acc = (GenericRowData)rowData;
        acc.setField(0, null);
        acc.setField(1, Long.MIN_VALUE);
    }

    @Override
    public T getValue(RowData rowData) {
        GenericRowData acc = (GenericRowData)rowData;
        return (T)acc.getField(0);
    }
}

