/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.calls;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.data.util.MapDataUtil;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods$;
import org.apache.flink.table.planner.codegen.calls.ScalarOperatorGens$;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.runtime.functions.SqlDateTimeUtils;
import org.apache.flink.table.runtime.functions.SqlFunctionUtils;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ScalarOperatorGens$ {
    public static final ScalarOperatorGens$ MODULE$;

    static {
        new ScalarOperatorGens$();
    }

    public GeneratedExpression generateBinaryArithmeticOperator(CodeGeneratorContext ctx, String operator, LogicalType resultType2, GeneratedExpression left, GeneratedExpression right) {
        Function1<String, String> function1;
        LogicalType logicalType = resultType2;
        if (logicalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType;
            return this.generateDecimalBinaryArithmeticOperator(ctx, operator, decimalType, left, right);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        String string2 = operator;
        if ("%".equals(string2)) {
            Function1<String, String> function12;
            if (PlannerTypeUtils.isInteroperable(left.resultType(), right.resultType())) {
                function12 = this.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$numericCasting(left.resultType(), resultType2);
            } else {
                LogicalType castedType = TypeCheckUtils.isDecimal(left.resultType()) ? new BigIntType() : left.resultType();
                function12 = this.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$numericCasting(left.resultType(), castedType);
            }
            function1 = function12;
        } else {
            function1 = this.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$numericCasting(left.resultType(), resultType2);
        }
        Function1<String, String> leftCasting = function1;
        Function1<String, String> rightCasting = this.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$numericCasting(right.resultType(), resultType2);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType2);
        return this.generateOperatorIfNotNull(ctx, resultType2, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(operator, leftCasting, rightCasting, resultTypeTerm){
            public static final long serialVersionUID = 0L;
            private final String operator$1;
            private final Function1 leftCasting$1;
            private final Function1 rightCasting$1;
            private final String resultTypeTerm$1;

            public final String apply(String leftTerm, String rightTerm) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") (", " ", " ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.resultTypeTerm$1, this.leftCasting$1.apply((Object)leftTerm), this.operator$1, this.rightCasting$1.apply((Object)rightTerm)}));
            }
            {
                this.operator$1 = operator$1;
                this.leftCasting$1 = leftCasting$1;
                this.rightCasting$1 = rightCasting$1;
                this.resultTypeTerm$1 = resultTypeTerm$1;
            }
        });
    }

    private GeneratedExpression generateDecimalBinaryArithmeticOperator(CodeGeneratorContext ctx, String operator, DecimalType resultType2, GeneratedExpression left, GeneratedExpression right) {
        scala.collection.immutable.Map methods = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"+"), (Object)"add"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-"), (Object)"subtract"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)"multiply"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/"), (Object)"divide"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"%"), (Object)"mod")}));
        return this.generateOperatorIfNotNull(ctx, resultType2, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(operator, resultType2, left, right, methods){
            public static final long serialVersionUID = 0L;
            private final String operator$4;
            private final DecimalType resultType$2;
            private final GeneratedExpression left$2;
            private final GeneratedExpression right$2;
            private final scala.collection.immutable.Map methods$1;

            public final String apply(String leftTerm, String rightTerm) {
                String method = (String)this.methods$1.apply((Object)this.operator$4);
                String leftCasted = (String)ScalarOperatorGens$.MODULE$.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$castToDec$1(this.left$2.resultType(), this.resultType$2).apply((Object)leftTerm);
                String rightCasted = (String)ScalarOperatorGens$.MODULE$.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$castToDec$1(this.right$2.resultType(), this.resultType$2).apply((Object)rightTerm);
                int precision = this.resultType$2.getPrecision();
                int scale = this.resultType$2.getScale();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "(", ", ", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.DECIMAL_UTIL(), method, leftCasted, rightCasted, BoxesRunTime.boxToInteger((int)precision), BoxesRunTime.boxToInteger((int)scale)}));
            }
            {
                this.operator$4 = operator$4;
                this.resultType$2 = resultType$2;
                this.left$2 = left$2;
                this.right$2 = right$2;
                this.methods$1 = methods$1;
            }
        });
    }

    public GeneratedExpression generateUnaryArithmeticOperator(CodeGeneratorContext ctx, String operator, LogicalType resultType2, GeneratedExpression operand) {
        return this.generateUnaryOperatorIfNotNull(ctx, resultType2, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(operator, resultType2, operand){
            public static final long serialVersionUID = 0L;
            private final String operator$2;
            private final LogicalType resultType$1;
            private final GeneratedExpression operand$1;

            /*
             * Enabled aggressive block sorting
             */
            public final String apply(String operandTerm) {
                String string2;
                if (TypeCheckUtils.isDecimal(this.operand$1.resultType())) {
                    String string3 = this.operator$2;
                    String string4 = "-";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".negate(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.DECIMAL_UTIL(), operandTerm}));
                        return string2;
                    }
                }
                if (TypeCheckUtils.isDecimal(this.operand$1.resultType())) {
                    String string5 = this.operator$2;
                    String string6 = "+";
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                        return string2;
                    }
                }
                String typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(this.resultType$1);
                string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") ", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeTerm, this.operator$2, operandTerm}));
                return string2;
            }
            {
                this.operator$2 = operator$2;
                this.resultType$1 = resultType$1;
                this.operand$1 = operand$1;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateTemporalPlusMinus(CodeGeneratorContext ctx, boolean plus, LogicalType resultType, GeneratedExpression left, GeneratedExpression right) {
        block23: {
            block8: {
                block22: {
                    block18: {
                        block21: {
                            block20: {
                                block19: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block9: {
                                                            block12: {
                                                                block11: {
                                                                    block10: {
                                                                        block7: {
                                                                            block6: {
                                                                                block5: {
                                                                                    op = plus != false ? "+" : "-";
                                                                                    var7_7 = new Tuple2((Object)left.resultType().getTypeRoot(), (Object)right.resultType().getTypeRoot());
                                                                                    if (var7_7 == null) break block5;
                                                                                    var8_8 = (LogicalTypeRoot)var7_7._1();
                                                                                    var9_9 = (LogicalTypeRoot)var7_7._2();
                                                                                    if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var8_8) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var9_9)) break block5;
                                                                                    var10_10 = true;
                                                                                    break block6;
                                                                                }
                                                                                if (var7_7 == null) ** GOTO lbl-1000
                                                                                var11_11 = (LogicalTypeRoot)var7_7._1();
                                                                                var12_12 = (LogicalTypeRoot)var7_7._2();
                                                                                if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var11_11) && LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var12_12)) {
                                                                                    var10_10 = true;
                                                                                } else lbl-1000:
                                                                                // 2 sources

                                                                                {
                                                                                    var10_10 = false;
                                                                                }
                                                                            }
                                                                            if (!var10_10) break block7;
                                                                            var13_13 = this.generateBinaryArithmeticOperator(ctx, op, left.resultType(), left, right);
                                                                            break block8;
                                                                        }
                                                                        if (var7_7 == null) break block9;
                                                                        var14_14 = (LogicalTypeRoot)var7_7._1();
                                                                        var15_15 = (LogicalTypeRoot)var7_7._2();
                                                                        if (!LogicalTypeRoot.DATE.equals((Object)var14_14) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var15_15)) break block9;
                                                                        var16_16 = resultType.getTypeRoot();
                                                                        if (!LogicalTypeRoot.DATE.equals((Object)var16_16)) break block10;
                                                                        var17_17 = this.generateOperatorIfNotNull(ctx, new DateType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(op){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final String op$1;

                                                                            public final String apply(String l, String r) {
                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " (java.lang.Math.toIntExact(", " / ", "L))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l, this.op$1, r, BoxesRunTime.boxToLong((long)86400000L)}));
                                                                            }
                                                                            {
                                                                                this.op$1 = op$1;
                                                                            }
                                                                        });
                                                                        break block11;
                                                                    }
                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var16_16)) break block12;
                                                                    var17_17 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(op){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final String op$1;

                                                                        public final String apply(String l, String r) {
                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".fromEpochMillis((", " * ", "L) ", " ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.TIMESTAMP_DATA(), l, BoxesRunTime.boxToLong((long)86400000L), this.op$1, r}));
                                                                        }
                                                                        {
                                                                            this.op$1 = op$1;
                                                                        }
                                                                    });
                                                                }
                                                                var13_13 = var17_17;
                                                                break block8;
                                                            }
                                                            throw new MatchError((Object)var16_16);
                                                        }
                                                        if (var7_7 == null) break block13;
                                                        var18_18 = (LogicalTypeRoot)var7_7._1();
                                                        var19_19 = (LogicalTypeRoot)var7_7._2();
                                                        if (!LogicalTypeRoot.DATE.equals((Object)var18_18) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var19_19)) break block13;
                                                        var13_13 = this.generateOperatorIfNotNull(ctx, new DateType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(op){
                                                            public static final long serialVersionUID = 0L;
                                                            private final String op$1;

                                                            public final String apply(String l, String r) {
                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", "(", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.ADD_MONTHS()), l, this.op$1, r}));
                                                            }
                                                            {
                                                                this.op$1 = op$1;
                                                            }
                                                        });
                                                        break block8;
                                                    }
                                                    if (var7_7 == null) break block14;
                                                    var20_20 = (LogicalTypeRoot)var7_7._1();
                                                    var21_21 = (LogicalTypeRoot)var7_7._2();
                                                    if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var20_20) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var21_21)) break block14;
                                                    var13_13 = this.generateOperatorIfNotNull(ctx, new TimeType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(op){
                                                        public static final long serialVersionUID = 0L;
                                                        private final String op$1;

                                                        public final String apply(String l, String r) {
                                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"java.lang.Math.toIntExact(((", " + ", "L) ", " ("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l, BoxesRunTime.boxToLong((long)86400000L), this.op$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"java.lang.Math.toIntExact(", " % ", "L))) % ", "L)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r, BoxesRunTime.boxToLong((long)86400000L), BoxesRunTime.boxToLong((long)86400000L)}))).toString();
                                                        }
                                                        {
                                                            this.op$1 = op$1;
                                                        }
                                                    });
                                                    break block8;
                                                }
                                                if (var7_7 == null) break block15;
                                                var22_22 = (LogicalTypeRoot)var7_7._1();
                                                var23_23 = (LogicalTypeRoot)var7_7._2();
                                                if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var22_22) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var23_23)) break block15;
                                                var13_13 = this.generateOperatorIfNotNull(ctx, new TimeType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply(String l, String r) {
                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l}));
                                                    }
                                                });
                                                break block8;
                                            }
                                            if (var7_7 == null) break block16;
                                            var24_24 = (LogicalTypeRoot)var7_7._1();
                                            var25_25 = (LogicalTypeRoot)var7_7._2();
                                            var26_26 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var24_24) != false ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var24_24) != false;
                                            if (!var26_26 || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var25_25)) break block16;
                                            var13_13 = this.generateOperatorIfNotNull(ctx, left.resultType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(op){
                                                public static final long serialVersionUID = 0L;
                                                private final String op$1;

                                                public final String apply(String l, String r) {
                                                    String leftTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l}));
                                                    String nanoTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getNanoOfMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l}));
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".fromEpochMillis(", " ", " ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.TIMESTAMP_DATA(), leftTerm, this.op$1, r, nanoTerm}));
                                                }
                                                {
                                                    this.op$1 = op$1;
                                                }
                                            });
                                            break block8;
                                        }
                                        if (var7_7 == null) break block17;
                                        var27_27 = (LogicalTypeRoot)var7_7._1();
                                        var28_28 = (LogicalTypeRoot)var7_7._2();
                                        var29_29 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var27_27) != false ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var27_27) != false;
                                        if (!var29_29 || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var28_28)) break block17;
                                        var13_13 = this.generateOperatorIfNotNull(ctx, left.resultType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(op){
                                            public static final long serialVersionUID = 0L;
                                            private final String op$1;

                                            public final String apply(String l, String r) {
                                                String leftTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l}));
                                                String nanoTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getNanoOfMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l}));
                                                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", ".fromEpochMillis(\n               |  ", "(", ", ", "(", ")),\n               |  ", ")\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.TIMESTAMP_DATA(), CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.ADD_MONTHS()), leftTerm, this.op$1, r, nanoTerm})))).stripMargin();
                                            }
                                            {
                                                this.op$1 = op$1;
                                            }
                                        });
                                        break block8;
                                    }
                                    if (var7_7 == null) break block18;
                                    var30_30 = (LogicalTypeRoot)var7_7._1();
                                    var31_31 = (LogicalTypeRoot)var7_7._2();
                                    var32_32 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var30_30) != false ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var30_30) != false ? true : LogicalTypeRoot.DATE.equals((Object)var30_30) != false);
                                    if (!var32_32 || !(var33_33 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var31_31) != false ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var31_31) != false ? true : LogicalTypeRoot.DATE.equals((Object)var31_31) != false)) || plus) break block18;
                                    var34_34 = resultType.getTypeRoot();
                                    if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var34_34)) break block19;
                                    var35_35 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(left, right){
                                        public static final long serialVersionUID = 0L;
                                        private final GeneratedExpression left$1;
                                        private final GeneratedExpression right$1;

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final String apply(String ll, String rr) {
                                            Tuple2 tuple2 = new Tuple2((Object)((Object)this.left$1.resultType().getTypeRoot()), (Object)((Object)this.right$1.resultType().getTypeRoot()));
                                            if (tuple2 != null) {
                                                LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                                                LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)((Object)tuple2._2());
                                                if (((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot)) && ((Object)((Object)LogicalTypeRoot.DATE)).equals((Object)((Object)logicalTypeRoot2))) {
                                                    String leftTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll}));
                                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", " * ", "L)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rr, BoxesRunTime.boxToLong((long)86400000L)}))).toString();
                                                }
                                            }
                                            if (tuple2 != null) {
                                                LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                                                LogicalTypeRoot logicalTypeRoot3 = (LogicalTypeRoot)((Object)tuple2._2());
                                                if (((Object)((Object)LogicalTypeRoot.DATE)).equals((Object)((Object)logicalTypeRoot)) && ((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot3))) {
                                                    String rightTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rr}));
                                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " * ", "L, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll, BoxesRunTime.boxToLong((long)86400000L), rightTerm}))).toString();
                                                }
                                            }
                                            if (tuple2 != null) {
                                                LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                                                LogicalTypeRoot logicalTypeRoot4 = (LogicalTypeRoot)((Object)tuple2._2());
                                                if (((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot)) && ((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot4))) {
                                                    String leftTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll}));
                                                    String rightTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rr}));
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS()), leftTerm, rightTerm}));
                                                }
                                            }
                                            if (tuple2 != null) {
                                                LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                                                LogicalTypeRoot logicalTypeRoot5 = (LogicalTypeRoot)((Object)tuple2._2());
                                                if (((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot)) && ((Object)((Object)LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot5))) {
                                                    String leftTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll}));
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS()), leftTerm, rr}));
                                                }
                                            }
                                            if (tuple2 == null) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS()), ll, rr}));
                                            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                                            LogicalTypeRoot logicalTypeRoot6 = (LogicalTypeRoot)((Object)tuple2._2());
                                            if (!((Object)((Object)LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot)) || !((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot6))) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS()), ll, rr}));
                                            String rightTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rr}));
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS()), ll, rightTerm}));
                                        }
                                        {
                                            this.left$1 = left$1;
                                            this.right$1 = right$1;
                                        }
                                    });
                                    break block20;
                                }
                                if (!LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var34_34)) break block21;
                                var35_35 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(left, right, op){
                                    public static final long serialVersionUID = 0L;
                                    private final GeneratedExpression left$1;
                                    private final GeneratedExpression right$1;
                                    private final String op$1;

                                    public final String apply(String ll, String rr) {
                                        Tuple2 tuple2;
                                        block6: {
                                            String string2;
                                            block3: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            tuple2 = new Tuple2((Object)((Object)this.left$1.resultType().getTypeRoot()), (Object)((Object)this.right$1.resultType().getTypeRoot()));
                                                            if (tuple2 == null) break block2;
                                                            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                                                            LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)((Object)tuple2._2());
                                                            if (!((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot)) || !((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot2))) break block2;
                                                            String leftTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll}));
                                                            String rightTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rr}));
                                                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, this.op$1, rightTerm}));
                                                            break block3;
                                                        }
                                                        if (tuple2 == null) break block4;
                                                        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                                                        LogicalTypeRoot logicalTypeRoot3 = (LogicalTypeRoot)((Object)tuple2._2());
                                                        if (!((Object)((Object)LogicalTypeRoot.DATE)).equals((Object)((Object)logicalTypeRoot)) || !((Object)((Object)LogicalTypeRoot.DATE)).equals((Object)((Object)logicalTypeRoot3))) break block4;
                                                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " * ", "L) ", " (", " * ", "L)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll, BoxesRunTime.boxToLong((long)86400000L), this.op$1, rr, BoxesRunTime.boxToLong((long)86400000L)}));
                                                        break block3;
                                                    }
                                                    if (tuple2 == null) break block5;
                                                    LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                                                    LogicalTypeRoot logicalTypeRoot4 = (LogicalTypeRoot)((Object)tuple2._2());
                                                    if (!((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot)) || !((Object)((Object)LogicalTypeRoot.DATE)).equals((Object)((Object)logicalTypeRoot4))) break block5;
                                                    String leftTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll}));
                                                    string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " (", " * ", "L)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, this.op$1, rr, BoxesRunTime.boxToLong((long)86400000L)}));
                                                    break block3;
                                                }
                                                if (tuple2 == null) break block6;
                                                LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                                                LogicalTypeRoot logicalTypeRoot5 = (LogicalTypeRoot)((Object)tuple2._2());
                                                if (!((Object)((Object)LogicalTypeRoot.DATE)).equals((Object)((Object)logicalTypeRoot)) || !((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot5))) break block6;
                                                String rightTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rr}));
                                                string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " * ", "L) ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll, BoxesRunTime.boxToLong((long)86400000L), this.op$1, rightTerm}));
                                            }
                                            return string2;
                                        }
                                        throw new MatchError((Object)tuple2);
                                    }
                                    {
                                        this.left$1 = left$1;
                                        this.right$1 = right$1;
                                        this.op$1 = op$1;
                                    }
                                });
                            }
                            var13_13 = var35_35;
                            break block8;
                        }
                        throw new MatchError((Object)var34_34);
                    }
                    if (var7_7 == null) break block22;
                    var36_36 = (LogicalTypeRoot)var7_7._1();
                    t = (LogicalTypeRoot)var7_7._2();
                    if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var36_36) || !t.getFamilies().contains((Object)LogicalTypeFamily.DATETIME) || plus) break block22;
                    var13_13 = this.generateTimestampLtzMinus(ctx, resultType, left, right);
                    break block8;
                }
                if (var7_7 == null) break block23;
                t = (LogicalTypeRoot)var7_7._1();
                var39_39 = (LogicalTypeRoot)var7_7._2();
                if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var39_39) || !t.getFamilies().contains((Object)LogicalTypeFamily.DATETIME) || plus) break block23;
                var13_13 = this.generateTimestampLtzMinus(ctx, resultType, left, right);
            }
            return var13_13;
        }
        throw new CodeGenException("Unsupported temporal arithmetic.");
    }

    private GeneratedExpression generateTimestampLtzMinus(CodeGeneratorContext ctx, LogicalType resultType2, GeneratedExpression left, GeneratedExpression right) {
        block4: {
            GeneratedExpression generatedExpression;
            block3: {
                LogicalTypeRoot logicalTypeRoot;
                block2: {
                    logicalTypeRoot = resultType2.getTypeRoot();
                    if (!((Object)((Object)LogicalTypeRoot.INTERVAL_YEAR_MONTH)).equals((Object)logicalTypeRoot)) break block2;
                    generatedExpression = this.generateOperatorIfNotNull(ctx, resultType2, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(left, right){
                        public static final long serialVersionUID = 0L;
                        private final GeneratedExpression left$3;
                        private final GeneratedExpression right$3;

                        public final String apply(String ll, String rr) {
                            Tuple2 tuple2 = new Tuple2((Object)((Object)this.left$3.resultType().getTypeRoot()), (Object)((Object)this.right$3.resultType().getTypeRoot()));
                            if (tuple2 != null) {
                                LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                                LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)((Object)tuple2._2());
                                if (((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot)) && ((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot2))) {
                                    String leftTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll}));
                                    String rightTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rr}));
                                    String string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS()), leftTerm, rightTerm}));
                                    return string2;
                                }
                            }
                            throw new CodeGenException("TIMESTAMP_LTZ only supports diff between the same type.");
                        }
                        {
                            this.left$3 = left$3;
                            this.right$3 = right$3;
                        }
                    });
                    break block3;
                }
                if (!((Object)((Object)LogicalTypeRoot.INTERVAL_DAY_TIME)).equals((Object)logicalTypeRoot)) break block4;
                generatedExpression = this.generateOperatorIfNotNull(ctx, resultType2, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(left, right){
                    public static final long serialVersionUID = 0L;
                    private final GeneratedExpression left$3;
                    private final GeneratedExpression right$3;

                    public final String apply(String ll, String rr) {
                        Tuple2 tuple2 = new Tuple2((Object)((Object)this.left$3.resultType().getTypeRoot()), (Object)((Object)this.right$3.resultType().getTypeRoot()));
                        if (tuple2 != null) {
                            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)((Object)tuple2._1());
                            LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)((Object)tuple2._2());
                            if (((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot)) && ((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).equals((Object)((Object)logicalTypeRoot2))) {
                                String leftTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ll}));
                                String rightTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rr}));
                                String string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm}));
                                return string2;
                            }
                        }
                        throw new CodeGenException("TIMESTAMP_LTZ only supports diff between the same type.");
                    }
                    {
                        this.left$3 = left$3;
                        this.right$3 = right$3;
                    }
                });
            }
            return generatedExpression;
        }
        throw new CodeGenException("Unsupported temporal arithmetic.");
    }

    public GeneratedExpression generateUnaryIntervalPlusMinus(CodeGeneratorContext ctx, boolean plus2, GeneratedExpression operand) {
        String operator = plus2 ? "+" : "-";
        return this.generateUnaryArithmeticOperator(ctx, operator, operand.resultType(), operand);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneratedExpression generateIn(CodeGeneratorContext ctx, GeneratedExpression needle, Seq<GeneratedExpression> haystack) {
        GeneratedExpression generatedExpression;
        if (haystack.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(GeneratedExpression x$1) {
                return x$1.literal();
            }
        })) {
            Tuple2 tuple2;
            LogicalType logicalType;
            void var9_10;
            Option widerType = JavaScalaConversionUtil$.MODULE$.toScala(LogicalTypeMerging.findCommonType(Arrays.asList((Object[])new LogicalType[]{needle.resultType(), ((GeneratedExpression)haystack.head()).resultType()}))).orElse((Function0)new Serializable(needle, haystack){
                public static final long serialVersionUID = 0L;
                private final GeneratedExpression needle$1;
                private final Seq haystack$1;

                public final Nothing$ apply() {
                    throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find common type of ", " and ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.needle$1, this.haystack$1})));
                }
                {
                    this.needle$1 = needle$1;
                    this.haystack$1 = haystack$1;
                }
            });
            Option option = widerType;
            if (option instanceof Some) {
                Some some = (Some)option;
                LogicalType t = (LogicalType)some.x();
                Serializable serializable = new Serializable(t){
                    public static final long serialVersionUID = 0L;
                    private final LogicalType t$1;

                    public final String apply(GeneratedExpression value2) {
                        return (String)ScalarOperatorGens$.MODULE$.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$numericCasting(value2.resultType(), this.t$1).apply((Object)value2.resultTerm());
                    }
                    {
                        this.t$1 = t$1;
                    }
                };
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                Serializable serializable = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(GeneratedExpression value2) {
                        return value2.resultTerm();
                    }
                };
            }
            void castNumeric = var9_10;
            Option option2 = widerType;
            if (option2 instanceof Some) {
                LogicalType t;
                Some some = (Some)option2;
                logicalType = t = (LogicalType)some.x();
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                logicalType = needle.resultType();
            }
            LogicalType resultType2 = logicalType;
            Seq elements = (Seq)haystack.map((Function1)new Serializable((Function1)castNumeric, resultType2){
                public static final long serialVersionUID = 0L;
                private final Function1 castNumeric$1;
                private final LogicalType resultType$4;

                public final GeneratedExpression apply(GeneratedExpression element) {
                    return element.copy((String)this.castNumeric$1.apply((Object)element), element.nullTerm(), element.code(), this.resultType$4, element.copy$default$5());
                }
                {
                    this.castNumeric$1 = castNumeric$1;
                    this.resultType$4 = resultType$4;
                }
            }, Seq$.MODULE$.canBuildFrom());
            String setTerm = ctx.addReusableHashSet((Seq<GeneratedExpression>)elements, resultType2);
            GeneratedExpression castedNeedle = needle.copy((String)castNumeric.apply((Object)needle), needle.nullTerm(), needle.code(), resultType2, needle.copy$default$5());
            Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) throw new MatchError(seq);
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(new BooleanType());
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(new BooleanType());
            String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", " ", " = ", ";\n           |boolean ", " = true;\n           |if (!", ") {\n           |  ", " = ", ".contains(", ");\n           |  ", " = !", " && ", ".containsNull();\n           |}\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{castedNeedle.code(), resultTypeTerm, resultTerm2, defaultValue, nullTerm2, castedNeedle.nullTerm(), resultTerm2, setTerm, castedNeedle.resultTerm(), nullTerm2, resultTerm2, setTerm})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", " ", " = ", ".contains(", ");\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{castedNeedle.code(), resultTypeTerm, resultTerm2, setTerm, castedNeedle.resultTerm()})))).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
            return generatedExpression;
        } else {
            generatedExpression = (GeneratedExpression)((TraversableOnce)haystack.map((Function1)new Serializable(ctx, needle){
                public static final long serialVersionUID = 0L;
                private final CodeGeneratorContext ctx$1;
                private final GeneratedExpression needle$1;

                public final GeneratedExpression apply(GeneratedExpression x$3) {
                    return ScalarOperatorGens$.MODULE$.generateEquals(this.ctx$1, this.needle$1, x$3);
                }
                {
                    this.ctx$1 = ctx$1;
                    this.needle$1 = needle$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(ctx){
                public static final long serialVersionUID = 0L;
                private final CodeGeneratorContext ctx$1;

                public final GeneratedExpression apply(GeneratedExpression left, GeneratedExpression right) {
                    return ScalarOperatorGens$.MODULE$.generateOr(this.ctx$1, left, right);
                }
                {
                    this.ctx$1 = ctx$1;
                }
            });
        }
        return generatedExpression;
    }

    private void checkImplicitConversionValidity(GeneratedExpression left, GeneratedExpression right) {
        if (TypeCheckUtils.isNumeric(left.resultType()) && TypeCheckUtils.isCharacterString(right.resultType()) || TypeCheckUtils.isNumeric(right.resultType()) && TypeCheckUtils.isCharacterString(left.resultType())) {
            throw new ValidationException(new StringBuilder().append((Object)"implicit type conversion between ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.resultType().getTypeRoot()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" and "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{right.resultType().getTypeRoot()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" is not supported now"})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    public GeneratedExpression generateEquals(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        block19: {
            GeneratedExpression generatedExpression;
            block16: {
                Object object;
                boolean bl;
                BooleanType booleanType;
                block18: {
                    block17: {
                        while (true) {
                            this.checkImplicitConversionValidity(left, right);
                            boolean canEqual = PlannerTypeUtils.isInteroperable(left.resultType(), right.resultType());
                            if (TypeCheckUtils.isCharacterString(left.resultType()) && TypeCheckUtils.isCharacterString(right.resultType())) {
                                generatedExpression = this.generateOperatorIfNotNull(ctx, new BooleanType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String leftTerm, String rightTerm) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".equals(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm}));
                                    }
                                });
                                break block16;
                            }
                            if (TypeCheckUtils.isNumeric(left.resultType()) && TypeCheckUtils.isNumeric(right.resultType())) {
                                generatedExpression = this.generateComparison(ctx, "==", left, right);
                                break block16;
                            }
                            if (TypeCheckUtils.isArray(left.resultType()) && canEqual) {
                                generatedExpression = this.generateArrayComparison(ctx, left, right);
                                break block16;
                            }
                            if (TypeCheckUtils.isMap(left.resultType()) && canEqual) {
                                MapType mapType = (MapType)left.resultType();
                                generatedExpression = this.generateMapComparison(ctx, left, right, mapType.getKeyType(), mapType.getValueType());
                                break block16;
                            }
                            if (TypeCheckUtils.isMultiset(left.resultType()) && canEqual) {
                                MultisetType multisetType = (MultisetType)left.resultType();
                                generatedExpression = this.generateMapComparison(ctx, left, right, multisetType.getElementType(), new IntType(false));
                                break block16;
                            }
                            if (TypeCheckUtils.isComparable(left.resultType()) && canEqual) {
                                generatedExpression = this.generateComparison(ctx, "==", left, right);
                                break block16;
                            }
                            if (TypeCheckUtils.isRaw(left.resultType()) && canEqual) {
                                Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
                                Some some = Seq$.MODULE$.unapplySeq(seq);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                    Tuple2 tuple2;
                                    String resultTerm = (String)((SeqLike)some.get()).apply(0);
                                    String nullTerm = (String)((SeqLike)some.get()).apply(1);
                                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
                                    String resultTerm2 = (String)tuple22._1();
                                    String nullTerm2 = (String)tuple22._2();
                                    String genericSer = ctx.addReusableTypeSerializer(left.resultType());
                                    String ser = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getInnerSerializer()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{genericSer}));
                                    BooleanType resultType2 = new BooleanType();
                                    String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |boolean ", " = ", " || ", ";\n         |boolean ", " = ", ";\n         |if (!", ") {\n         |  ", ".ensureMaterialized(", ");\n         |  ", ".ensureMaterialized(", ");\n         |  ", " =\n         |    ", ".getBinarySection().equals(", ".getBinarySection());\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.code(), right.code(), nullTerm2, left.nullTerm(), right.nullTerm(), resultTerm2, CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType2), nullTerm2, left.resultTerm(), ser, right.resultTerm(), ser, resultTerm2, left.resultTerm(), right.resultTerm()})))).stripMargin();
                                    generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, code, resultType2, GeneratedExpression$.MODULE$.apply$default$5());
                                    break block16;
                                }
                                throw new MatchError(seq);
                            }
                            if (TypeCheckUtils.isTimePoint(left.resultType()) && TypeCheckUtils.isCharacterString(right.resultType())) {
                                if (right.literal()) {
                                    right = this.generateCastStringLiteralToDateTime(ctx, right, left.resultType());
                                    continue;
                                }
                                right = this.generateCast(ctx, right, left.resultType());
                                continue;
                            }
                            if (!TypeCheckUtils.isTimePoint(right.resultType()) || !TypeCheckUtils.isCharacterString(left.resultType())) break;
                            if (left.literal()) {
                                GeneratedExpression generatedExpression2 = this.generateCastStringLiteralToDateTime(ctx, left, right.resultType());
                                left = generatedExpression2;
                                continue;
                            }
                            GeneratedExpression generatedExpression3 = this.generateCast(ctx, left, right.resultType());
                            left = generatedExpression3;
                        }
                        booleanType = new BooleanType();
                        bl = this.generateOperatorIfNotNull$default$5();
                        if (!TypeCheckUtils.isReference(left.resultType())) break block17;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String leftTerm, String rightTerm) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".equals(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm}));
                            }
                        };
                        break block18;
                    }
                    if (!TypeCheckUtils.isReference(right.resultType())) break block19;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String leftTerm, String rightTerm) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".equals(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightTerm, leftTerm}));
                        }
                    };
                }
                generatedExpression = this.generateOperatorIfNotNull(ctx, booleanType, left, right, bl, (Function2<String, String, String>)object);
            }
            return generatedExpression;
        }
        throw new CodeGenException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incomparable types: ", " and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.resultType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{right.resultType()}))).toString());
    }

    public GeneratedExpression generateIsNotDistinctFrom(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        return this.generateOr(ctx, this.generateAnd(ctx, this.generateIsNull(ctx, left), this.generateIsNull(ctx, right)), this.generateEquals(ctx, left, right));
    }

    public GeneratedExpression generateNotEquals(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        block11: {
            GeneratedExpression generatedExpression;
            block3: {
                Object object;
                boolean bl;
                BooleanType booleanType;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                this.checkImplicitConversionValidity(left, right);
                                                if (!TypeCheckUtils.isCharacterString(left.resultType()) || !TypeCheckUtils.isCharacterString(right.resultType())) break block2;
                                                generatedExpression = this.generateOperatorIfNotNull(ctx, new BooleanType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply(String leftTerm, String rightTerm) {
                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"!", ".equals(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm}));
                                                    }
                                                });
                                                break block3;
                                            }
                                            if (!TypeCheckUtils.isNumeric(left.resultType()) || !TypeCheckUtils.isNumeric(right.resultType())) break block4;
                                            generatedExpression = this.generateComparison(ctx, "!=", left, right);
                                            break block3;
                                        }
                                        if (!TypeCheckUtils.isTemporal(left.resultType()) || !PlannerTypeUtils.isInteroperable(left.resultType(), right.resultType())) break block5;
                                        generatedExpression = this.generateComparison(ctx, "!=", left, right);
                                        break block3;
                                    }
                                    if (!TypeCheckUtils.isArray(left.resultType()) || !PlannerTypeUtils.isInteroperable(left.resultType(), right.resultType())) break block6;
                                    GeneratedExpression equalsExpr = this.generateEquals(ctx, left, right);
                                    generatedExpression = new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(!", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{equalsExpr.resultTerm()})), equalsExpr.nullTerm(), equalsExpr.code(), new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
                                    break block3;
                                }
                                if (!TypeCheckUtils.isMap(left.resultType()) || !PlannerTypeUtils.isInteroperable(left.resultType(), right.resultType())) break block7;
                                GeneratedExpression equalsExpr = this.generateEquals(ctx, left, right);
                                generatedExpression = new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(!", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{equalsExpr.resultTerm()})), equalsExpr.nullTerm(), equalsExpr.code(), new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
                                break block3;
                            }
                            if (!TypeCheckUtils.isComparable(left.resultType()) || !PlannerTypeUtils.isInteroperable(left.resultType(), right.resultType())) break block8;
                            generatedExpression = this.generateComparison(ctx, "!=", left, right);
                            break block3;
                        }
                        booleanType = new BooleanType();
                        bl = this.generateOperatorIfNotNull$default$5();
                        if (!TypeCheckUtils.isReference(left.resultType())) break block9;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String leftTerm, String rightTerm) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"!(", ".equals(", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm}));
                            }
                        };
                        break block10;
                    }
                    if (!TypeCheckUtils.isReference(right.resultType())) break block11;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String leftTerm, String rightTerm) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"!(", ".equals(", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightTerm, leftTerm}));
                        }
                    };
                }
                generatedExpression = this.generateOperatorIfNotNull(ctx, booleanType, left, right, bl, (Function2<String, String, String>)object);
            }
            return generatedExpression;
        }
        throw new CodeGenException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incomparable types: ", " and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.resultType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{right.resultType()}))).toString());
    }

    public GeneratedExpression generateComparison(CodeGeneratorContext ctx, String operator, GeneratedExpression left, GeneratedExpression right) {
        block13: {
            Object object;
            boolean bl;
            BooleanType booleanType;
            block3: {
                block12: {
                    block8: {
                        block11: {
                            Object object2;
                            block10: {
                                String string2;
                                block9: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block2: {
                                                        booleanType = new BooleanType();
                                                        bl = this.generateOperatorIfNotNull$default$5();
                                                        if (!TypeCheckUtils.isDecimal(left.resultType()) && !TypeCheckUtils.isDecimal(right.resultType())) break block2;
                                                        object = new Serializable(operator){
                                                            public static final long serialVersionUID = 0L;
                                                            private final String operator$3;

                                                            public final String apply(String leftTerm, String rightTerm) {
                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".compare(", ", ", ") ", " 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.DECIMAL_UTIL(), leftTerm, rightTerm, this.operator$3}));
                                                            }
                                                            {
                                                                this.operator$3 = operator$3;
                                                            }
                                                        };
                                                        break block3;
                                                    }
                                                    if (!TypeCheckUtils.isNumeric(left.resultType()) || !TypeCheckUtils.isNumeric(right.resultType())) break block4;
                                                    String string3 = operator;
                                                    Object object3 = "==".equals(string3) ? new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final String apply(String leftTerm, String rightTerm) {
                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".equals(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.NUMERIC_UTIL(), leftTerm, rightTerm}));
                                                        }
                                                    } : ("!=".equals(string3) ? new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final String apply(String leftTerm, String rightTerm) {
                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"!", ".equals(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.NUMERIC_UTIL(), leftTerm, rightTerm}));
                                                        }
                                                    } : new Serializable(operator){
                                                        public static final long serialVersionUID = 0L;
                                                        private final String operator$3;

                                                        public final String apply(String leftTerm, String rightTerm) {
                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, this.operator$3, rightTerm}));
                                                        }
                                                        {
                                                            this.operator$3 = operator$3;
                                                        }
                                                    });
                                                    object = object3;
                                                    break block3;
                                                }
                                                if (!TypeCheckUtils.isTimestamp(left.resultType()) || !TypeCheckUtils.isTimestamp(right.resultType())) break block5;
                                                object = new Serializable(operator){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String operator$3;

                                                    public final String apply(String leftTerm, String rightTerm) {
                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".compareTo(", ") ", " 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm, this.operator$3}));
                                                    }
                                                    {
                                                        this.operator$3 = operator$3;
                                                    }
                                                };
                                                break block3;
                                            }
                                            if (!TypeCheckUtils.isTimestampWithLocalZone(left.resultType()) || !TypeCheckUtils.isTimestampWithLocalZone(right.resultType())) break block6;
                                            object = new Serializable(operator){
                                                public static final long serialVersionUID = 0L;
                                                private final String operator$3;

                                                public final String apply(String leftTerm, String rightTerm) {
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".compareTo(", ") ", " 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm, this.operator$3}));
                                                }
                                                {
                                                    this.operator$3 = operator$3;
                                                }
                                            };
                                            break block3;
                                        }
                                        if (!TypeCheckUtils.isTemporal(left.resultType()) || !PlannerTypeUtils.isInteroperable(left.resultType(), right.resultType())) break block7;
                                        String string4 = operator;
                                        Object object4 = "==".equals(string4) ? new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(String leftTerm, String rightTerm) {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".equals(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.NUMERIC_UTIL(), leftTerm, rightTerm}));
                                            }
                                        } : ("!=".equals(string4) ? new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(String leftTerm, String rightTerm) {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"!", ".equals(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.NUMERIC_UTIL(), leftTerm, rightTerm}));
                                            }
                                        } : new Serializable(operator){
                                            public static final long serialVersionUID = 0L;
                                            private final String operator$3;

                                            public final String apply(String leftTerm, String rightTerm) {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, this.operator$3, rightTerm}));
                                            }
                                            {
                                                this.operator$3 = operator$3;
                                            }
                                        });
                                        object = object4;
                                        break block3;
                                    }
                                    if (!TypeCheckUtils.isBoolean(left.resultType()) || !PlannerTypeUtils.isInteroperable(left.resultType(), right.resultType())) break block8;
                                    string2 = operator;
                                    boolean bl2 = "==".equals(string2) ? true : "!=".equals(string2);
                                    if (!bl2) break block9;
                                    object2 = new Serializable(operator){
                                        public static final long serialVersionUID = 0L;
                                        private final String operator$3;

                                        public final String apply(String leftTerm, String rightTerm) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, this.operator$3, rightTerm}));
                                        }
                                        {
                                            this.operator$3 = operator$3;
                                        }
                                    };
                                    break block10;
                                }
                                boolean bl3 = ">".equals(string2) ? true : ("<".equals(string2) ? true : ("<=".equals(string2) ? true : ">=".equals(string2)));
                                if (!bl3) break block11;
                                object2 = new Serializable(operator){
                                    public static final long serialVersionUID = 0L;
                                    private final String operator$3;

                                    public final String apply(String leftTerm, String rightTerm) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"java.lang.Boolean.compare(", ", ", ") ", " 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm, this.operator$3}));
                                    }
                                    {
                                        this.operator$3 = operator$3;
                                    }
                                };
                            }
                            object = object2;
                            break block3;
                        }
                        throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported boolean comparison '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operator})));
                    }
                    if (!TypeCheckUtils.isBinaryString(left.resultType()) || !PlannerTypeUtils.isInteroperable(left.resultType(), right.resultType())) break block12;
                    String utilName = SqlFunctionUtils.class.getCanonicalName();
                    object = new Serializable(operator, utilName){
                        public static final long serialVersionUID = 0L;
                        private final String operator$3;
                        private final String utilName$1;

                        public final String apply(String leftTerm, String rightTerm) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".byteArrayCompare(", ", ", ") ", " 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.utilName$1, leftTerm, rightTerm, this.operator$3}));
                        }
                        {
                            this.operator$3 = operator$3;
                            this.utilName$1 = utilName$1;
                        }
                    };
                    break block3;
                }
                if (!TypeCheckUtils.isComparable(left.resultType()) || !PlannerTypeUtils.isInteroperable(left.resultType(), right.resultType())) break block13;
                object = new Serializable(operator){
                    public static final long serialVersionUID = 0L;
                    private final String operator$3;

                    public final String apply(String leftTerm, String rightTerm) {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((", " == null) ? ((", " == null) ? 0 : -1) : ((", " == null) ? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm, rightTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 : (", ".compareTo(", ")))) ", " 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTerm, rightTerm, this.operator$3}))).toString();
                    }
                    {
                        this.operator$3 = operator$3;
                    }
                };
            }
            return this.generateOperatorIfNotNull(ctx, booleanType, left, right, bl, (Function2<String, String, String>)object);
        }
        throw new CodeGenException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incomparable types: ", " and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.resultType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{right.resultType()}))).toString());
    }

    public GeneratedExpression generateIsNull(CodeGeneratorContext ctx, GeneratedExpression operand) {
        GeneratedExpression generatedExpression;
        if (ctx.nullCheck()) {
            generatedExpression = new GeneratedExpression(operand.nullTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        } else if (!ctx.nullCheck() && TypeCheckUtils.isReference(operand.resultType())) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("isNull");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = ", " == null;\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.code(), resultTerm, operand.resultTerm()})))).stripMargin();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = new GeneratedExpression("false", GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateIsNotNull(CodeGeneratorContext ctx, GeneratedExpression operand) {
        GeneratedExpression generatedExpression;
        if (ctx.nullCheck()) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("result");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = !", ";\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.code(), resultTerm, operand.nullTerm()})))).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        } else if (!ctx.nullCheck() && TypeCheckUtils.isReference(operand.resultType())) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("result");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = ", " != null;\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.code(), resultTerm, operand.resultTerm()})))).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = new GeneratedExpression("true", GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateAnd(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |\n         |boolean ", " = false;\n         |boolean ", " = false;\n         |if (!", " && !", ") {\n         |  // left expr is false, skip right expr\n         |} else {\n         |  ", "\n         |\n         |  if (!", " && !", ") {\n         |    ", " = ", " && ", ";\n         |    ", " = false;\n         |  }\n         |  else if (!", " && ", " && ", ") {\n         |    ", " = false;\n         |    ", " = true;\n         |  }\n         |  else if (!", " && !", " && ", ") {\n         |    ", " = false;\n         |    ", " = false;\n         |  }\n         |  else if (", " && !", " && ", ") {\n         |    ", " = false;\n         |    ", " = true;\n         |  }\n         |  else if (", " && !", " && !", ") {\n         |    ", " = false;\n         |    ", " = false;\n         |  }\n         |  else {\n         |    ", " = false;\n         |    ", " = true;\n         |  }\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.code(), resultTerm2, nullTerm2, left.nullTerm(), left.resultTerm(), right.code(), left.nullTerm(), right.nullTerm(), resultTerm2, left.resultTerm(), right.resultTerm(), nullTerm2, left.nullTerm(), left.resultTerm(), right.nullTerm(), resultTerm2, nullTerm2, left.nullTerm(), left.resultTerm(), right.nullTerm(), resultTerm2, nullTerm2, left.nullTerm(), right.nullTerm(), right.resultTerm(), resultTerm2, nullTerm2, left.nullTerm(), right.nullTerm(), right.resultTerm(), resultTerm2, nullTerm2, resultTerm2, nullTerm2})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = false;\n         |if (", ") {\n         |  ", "\n         |  ", " = ", ";\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.code(), resultTerm2, left.resultTerm(), right.code(), resultTerm2, right.resultTerm()})))).stripMargin().trim();
            return new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateOr(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |\n        |boolean ", " = true;\n         |boolean ", " = false;\n         |if (!", " && ", ") {\n         |  // left expr is true, skip right expr\n         |} else {\n         |  ", "\n         |\n        |  if (!", " && !", ") {\n         |    ", " = ", " || ", ";\n         |    ", " = false;\n         |  }\n         |  else if (!", " && ", " && ", ") {\n         |    ", " = true;\n         |    ", " = false;\n         |  }\n         |  else if (!", " && !", " && ", ") {\n         |    ", " = false;\n         |    ", " = true;\n         |  }\n         |  else if (", " && !", " && ", ") {\n         |    ", " = true;\n         |    ", " = false;\n         |  }\n         |  else if (", " && !", " && !", ") {\n         |    ", " = false;\n         |    ", " = true;\n         |  }\n         |  else {\n         |    ", " = false;\n         |    ", " = true;\n         |  }\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.code(), resultTerm2, nullTerm2, left.nullTerm(), left.resultTerm(), right.code(), left.nullTerm(), right.nullTerm(), resultTerm2, left.resultTerm(), right.resultTerm(), nullTerm2, left.nullTerm(), left.resultTerm(), right.nullTerm(), resultTerm2, nullTerm2, left.nullTerm(), left.resultTerm(), right.nullTerm(), resultTerm2, nullTerm2, left.nullTerm(), right.nullTerm(), right.resultTerm(), resultTerm2, nullTerm2, left.nullTerm(), right.nullTerm(), right.resultTerm(), resultTerm2, nullTerm2, resultTerm2, nullTerm2})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = true;\n         |if (!", ") {\n         |  ", "\n         |  ", " = ", ";\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.code(), resultTerm2, left.resultTerm(), right.code(), resultTerm2, right.resultTerm()})))).stripMargin().trim();
            return new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateNot(CodeGeneratorContext ctx, GeneratedExpression operand) {
        return this.generateUnaryOperatorIfNotNull(ctx, new BooleanType(), operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String operandTerm) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"!(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
            }
        });
    }

    public GeneratedExpression generateIsTrue(GeneratedExpression operand) {
        return new GeneratedExpression(operand.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsNotTrue(GeneratedExpression operand) {
        return new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(!", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.resultTerm()})), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsFalse(GeneratedExpression operand) {
        return new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(!", " && !", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.resultTerm(), operand.nullTerm()})), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsNotFalse(GeneratedExpression operand) {
        return new GeneratedExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " || ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.resultTerm(), operand.nullTerm()})), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateReinterpret(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType targetType) {
        block21: {
            block22: {
                block6: {
                    block20: {
                        block19: {
                            block18: {
                                block8: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            block11: {
                                                                block10: {
                                                                    block9: {
                                                                        block7: {
                                                                            block5: {
                                                                                var4_4 = new Tuple2((Object)operand.resultType().getTypeRoot(), (Object)targetType.getTypeRoot());
                                                                                if (var4_4 == null || !PlannerTypeUtils.isInteroperable(operand.resultType(), targetType)) break block5;
                                                                                x$18 = targetType;
                                                                                x$19 = operand.copy$default$1();
                                                                                x$20 = operand.copy$default$2();
                                                                                x$21 = operand.copy$default$3();
                                                                                x$22 = operand.copy$default$5();
                                                                                var5_10 = operand.copy(x$19, x$20, x$21, x$18, x$22);
                                                                                break block6;
                                                                            }
                                                                            if (var4_4 == null) break block7;
                                                                            var11_11 = (LogicalTypeRoot)var4_4._1();
                                                                            var12_12 = (LogicalTypeRoot)var4_4._2();
                                                                            if (!LogicalTypeRoot.DATE.equals((Object)var11_11) || !LogicalTypeRoot.INTEGER.equals((Object)var12_12)) break block7;
                                                                            var13_13 = true;
                                                                            break block8;
                                                                        }
                                                                        if (var4_4 == null) break block9;
                                                                        var14_14 = (LogicalTypeRoot)var4_4._1();
                                                                        var15_15 = (LogicalTypeRoot)var4_4._2();
                                                                        if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var14_14) || !LogicalTypeRoot.INTEGER.equals((Object)var15_15)) break block9;
                                                                        var13_13 = true;
                                                                        break block8;
                                                                    }
                                                                    if (var4_4 == null) break block10;
                                                                    var16_16 = (LogicalTypeRoot)var4_4._1();
                                                                    var17_17 = (LogicalTypeRoot)var4_4._2();
                                                                    if (!LogicalTypeRoot.INTEGER.equals((Object)var16_16) || !LogicalTypeRoot.DATE.equals((Object)var17_17)) break block10;
                                                                    var13_13 = true;
                                                                    break block8;
                                                                }
                                                                if (var4_4 == null) break block11;
                                                                var18_18 = (LogicalTypeRoot)var4_4._1();
                                                                var19_19 = (LogicalTypeRoot)var4_4._2();
                                                                if (!LogicalTypeRoot.INTEGER.equals((Object)var18_18) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var19_19)) break block11;
                                                                var13_13 = true;
                                                                break block8;
                                                            }
                                                            if (var4_4 == null) break block12;
                                                            var20_20 = (LogicalTypeRoot)var4_4._1();
                                                            var21_21 = (LogicalTypeRoot)var4_4._2();
                                                            if (!LogicalTypeRoot.INTEGER.equals((Object)var20_20) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var21_21)) break block12;
                                                            var13_13 = true;
                                                            break block8;
                                                        }
                                                        if (var4_4 == null) break block13;
                                                        var22_22 = (LogicalTypeRoot)var4_4._1();
                                                        var23_23 = (LogicalTypeRoot)var4_4._2();
                                                        if (!LogicalTypeRoot.BIGINT.equals((Object)var22_22) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var23_23)) break block13;
                                                        var13_13 = true;
                                                        break block8;
                                                    }
                                                    if (var4_4 == null) break block14;
                                                    var24_24 = (LogicalTypeRoot)var4_4._1();
                                                    var25_25 = (LogicalTypeRoot)var4_4._2();
                                                    if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var24_24) || !LogicalTypeRoot.INTEGER.equals((Object)var25_25)) break block14;
                                                    var13_13 = true;
                                                    break block8;
                                                }
                                                if (var4_4 == null) break block15;
                                                var26_26 = (LogicalTypeRoot)var4_4._1();
                                                var27_27 = (LogicalTypeRoot)var4_4._2();
                                                if (!LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var26_26) || !LogicalTypeRoot.BIGINT.equals((Object)var27_27)) break block15;
                                                var13_13 = true;
                                                break block8;
                                            }
                                            if (var4_4 == null) break block16;
                                            var28_28 = (LogicalTypeRoot)var4_4._1();
                                            var29_29 = (LogicalTypeRoot)var4_4._2();
                                            if (!LogicalTypeRoot.DATE.equals((Object)var28_28) || !LogicalTypeRoot.BIGINT.equals((Object)var29_29)) break block16;
                                            var13_13 = true;
                                            break block8;
                                        }
                                        if (var4_4 == null) break block17;
                                        var30_30 = (LogicalTypeRoot)var4_4._1();
                                        var31_31 = (LogicalTypeRoot)var4_4._2();
                                        if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var30_30) || !LogicalTypeRoot.BIGINT.equals((Object)var31_31)) break block17;
                                        var13_13 = true;
                                        break block8;
                                    }
                                    if (var4_4 == null) ** GOTO lbl-1000
                                    var32_32 = (LogicalTypeRoot)var4_4._1();
                                    var33_33 = (LogicalTypeRoot)var4_4._2();
                                    if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var32_32) && LogicalTypeRoot.BIGINT.equals((Object)var33_33)) {
                                        var13_13 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        var13_13 = false;
                                    }
                                }
                                if (!var13_13) break block18;
                                var5_10 = this.internalExprCasting(operand, targetType);
                                break block6;
                            }
                            if (var4_4 == null) break block19;
                            var34_34 = (LogicalTypeRoot)var4_4._1();
                            var35_35 = (LogicalTypeRoot)var4_4._2();
                            if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var34_34) || !LogicalTypeRoot.BIGINT.equals((Object)var35_35)) break block19;
                            var5_10 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String operandTerm) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                }
                            });
                            break block6;
                        }
                        if (var4_4 == null) break block20;
                        var36_36 = (LogicalTypeRoot)var4_4._1();
                        var37_37 = (LogicalTypeRoot)var4_4._2();
                        if (!LogicalTypeRoot.BIGINT.equals((Object)var36_36) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var37_37)) break block20;
                        var5_10 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String operandTerm) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".fromEpochMillis(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.TIMESTAMP_DATA(), operandTerm}));
                            }
                        });
                        break block6;
                    }
                    if (var4_4 == null) break block21;
                    from = (LogicalTypeRoot)var4_4._1();
                    to = (LogicalTypeRoot)var4_4._2();
                    v0 = from;
                    var40_40 = to;
                    if (v0 != null ? v0.equals((Object)var40_40) == false : var40_40 != null) break block22;
                    var5_10 = operand;
                }
                return var5_10;
            }
            throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported reinterpret from '", "' to '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from, to})));
        }
        throw new MatchError((Object)var4_4);
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateCast(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType targetType) {
        block104: {
            block28: {
                block103: {
                    block101: {
                        block102: {
                            block100: {
                                block99: {
                                    block92: {
                                        block98: {
                                            block97: {
                                                block96: {
                                                    block95: {
                                                        block94: {
                                                            block93: {
                                                                block91: {
                                                                    block78: {
                                                                        block90: {
                                                                            block89: {
                                                                                block88: {
                                                                                    block87: {
                                                                                        block86: {
                                                                                            block85: {
                                                                                                block84: {
                                                                                                    block83: {
                                                                                                        block82: {
                                                                                                            block81: {
                                                                                                                block80: {
                                                                                                                    block79: {
                                                                                                                        block77: {
                                                                                                                            block64: {
                                                                                                                                block76: {
                                                                                                                                    block75: {
                                                                                                                                        block74: {
                                                                                                                                            block73: {
                                                                                                                                                block72: {
                                                                                                                                                    block71: {
                                                                                                                                                        block70: {
                                                                                                                                                            block69: {
                                                                                                                                                                block68: {
                                                                                                                                                                    block67: {
                                                                                                                                                                        block66: {
                                                                                                                                                                            block65: {
                                                                                                                                                                                block63: {
                                                                                                                                                                                    block62: {
                                                                                                                                                                                        block61: {
                                                                                                                                                                                            block60: {
                                                                                                                                                                                                block59: {
                                                                                                                                                                                                    block58: {
                                                                                                                                                                                                        block57: {
                                                                                                                                                                                                            block56: {
                                                                                                                                                                                                                block55: {
                                                                                                                                                                                                                    block54: {
                                                                                                                                                                                                                        block53: {
                                                                                                                                                                                                                            block52: {
                                                                                                                                                                                                                                block51: {
                                                                                                                                                                                                                                    block50: {
                                                                                                                                                                                                                                        block49: {
                                                                                                                                                                                                                                            block48: {
                                                                                                                                                                                                                                                block47: {
                                                                                                                                                                                                                                                    block46: {
                                                                                                                                                                                                                                                        block45: {
                                                                                                                                                                                                                                                            block44: {
                                                                                                                                                                                                                                                                block43: {
                                                                                                                                                                                                                                                                    block42: {
                                                                                                                                                                                                                                                                        block41: {
                                                                                                                                                                                                                                                                            block40: {
                                                                                                                                                                                                                                                                                block39: {
                                                                                                                                                                                                                                                                                    block38: {
                                                                                                                                                                                                                                                                                        block37: {
                                                                                                                                                                                                                                                                                            block36: {
                                                                                                                                                                                                                                                                                                block35: {
                                                                                                                                                                                                                                                                                                    block34: {
                                                                                                                                                                                                                                                                                                        block33: {
                                                                                                                                                                                                                                                                                                            block32: {
                                                                                                                                                                                                                                                                                                                block31: {
                                                                                                                                                                                                                                                                                                                    block30: {
                                                                                                                                                                                                                                                                                                                        block29: {
                                                                                                                                                                                                                                                                                                                            block26: {
                                                                                                                                                                                                                                                                                                                                block27: {
                                                                                                                                                                                                                                                                                                                                    var4_4 = new Tuple2((Object)operand.resultType().getTypeRoot(), (Object)targetType.getTypeRoot());
                                                                                                                                                                                                                                                                                                                                    if (var4_4 == null) break block26;
                                                                                                                                                                                                                                                                                                                                    var5_5 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                                                                    var6_6 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var5_5) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var6_6)) break block26;
                                                                                                                                                                                                                                                                                                                                    v0 = ((TimestampType)operand.resultType()).getKind();
                                                                                                                                                                                                                                                                                                                                    var7_7 = TimestampKind.PROCTIME;
                                                                                                                                                                                                                                                                                                                                    if (!(v0 == null ? var7_7 != null : v0.equals((Object)var7_7) == false)) break block27;
                                                                                                                                                                                                                                                                                                                                    v1 = ((TimestampType)operand.resultType()).getKind();
                                                                                                                                                                                                                                                                                                                                    var8_8 = TimestampKind.ROWTIME;
                                                                                                                                                                                                                                                                                                                                    if (!(v1 == null ? var8_8 != null : v1.equals((Object)var8_8) == false)) break block27;
                                                                                                                                                                                                                                                                                                                                    v2 = ((TimestampType)targetType).getKind();
                                                                                                                                                                                                                                                                                                                                    var9_9 = TimestampKind.PROCTIME;
                                                                                                                                                                                                                                                                                                                                    if (!(v2 == null ? var9_9 != null : v2.equals((Object)var9_9) == false)) break block27;
                                                                                                                                                                                                                                                                                                                                    v3 = ((TimestampType)targetType).getKind();
                                                                                                                                                                                                                                                                                                                                    var10_10 = TimestampKind.ROWTIME;
                                                                                                                                                                                                                                                                                                                                    if (v3 != null ? v3.equals((Object)var10_10) == false : var10_10 != null) break block26;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                x$23 = new TimestampType(operand.resultType().isNullable(), 3);
                                                                                                                                                                                                                                                                                                                                x$24 = operand.copy$default$1();
                                                                                                                                                                                                                                                                                                                                x$25 = operand.copy$default$2();
                                                                                                                                                                                                                                                                                                                                x$26 = operand.copy$default$3();
                                                                                                                                                                                                                                                                                                                                x$27 = operand.copy$default$5();
                                                                                                                                                                                                                                                                                                                                var11_16 = operand.copy(x$24, x$25, x$26, x$23, x$27);
                                                                                                                                                                                                                                                                                                                                break block28;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (var4_4 == null) break block29;
                                                                                                                                                                                                                                                                                                                            var17_17 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                                                            var18_18 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var17_17) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var18_18)) break block29;
                                                                                                                                                                                                                                                                                                                            fromType = (TimestampType)operand.resultType();
                                                                                                                                                                                                                                                                                                                            toType = (TimestampType)targetType;
                                                                                                                                                                                                                                                                                                                            if (fromType.getPrecision() <= toType.getPrecision()) {
                                                                                                                                                                                                                                                                                                                                x$28 = targetType;
                                                                                                                                                                                                                                                                                                                                x$29 = operand.copy$default$1();
                                                                                                                                                                                                                                                                                                                                x$30 = operand.copy$default$2();
                                                                                                                                                                                                                                                                                                                                x$31 = operand.copy$default$3();
                                                                                                                                                                                                                                                                                                                                x$32 = operand.copy$default$5();
                                                                                                                                                                                                                                                                                                                                v4 = operand.copy(x$29, x$30, x$31, x$28, x$32);
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                                                                                v4 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(toType, method){
                                                                                                                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                    private final TimestampType toType$1;
                                                                                                                                                                                                                                                                                                                                    private final String method$1;

                                                                                                                                                                                                                                                                                                                                    public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                                                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$1, operandTerm, BoxesRunTime.boxToInteger((int)this.toType$1.getPrecision())}));
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                                                                        this.toType$1 = toType$1;
                                                                                                                                                                                                                                                                                                                                        this.method$1 = method$1;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                });
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            var11_16 = v4;
                                                                                                                                                                                                                                                                                                                            break block28;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (var4_4 == null) break block30;
                                                                                                                                                                                                                                                                                                                        var27_27 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                                                        var28_28 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var27_27) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var28_28)) break block30;
                                                                                                                                                                                                                                                                                                                        fromType = (TimestampType)operand.resultType();
                                                                                                                                                                                                                                                                                                                        toType = (LocalZonedTimestampType)targetType;
                                                                                                                                                                                                                                                                                                                        method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_TO_TIMESTAMP_WITH_LOCAL_ZONE());
                                                                                                                                                                                                                                                                                                                        if (fromType.getPrecision() < toType.getPrecision()) {
                                                                                                                                                                                                                                                                                                                            v5 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(ctx, method){
                                                                                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                private final CodeGeneratorContext ctx$2;
                                                                                                                                                                                                                                                                                                                                private final String method$2;

                                                                                                                                                                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                                                                                    String timeZone = this.ctx$2.addReusableSessionTimeZone();
                                                                                                                                                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$2, operandTerm, timeZone}));
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                                                                    this.ctx$2 = ctx$2;
                                                                                                                                                                                                                                                                                                                                    this.method$2 = method$2;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            });
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            truncate_method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                                                                            v5 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(ctx, toType, method, truncate_method){
                                                                                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                private final CodeGeneratorContext ctx$2;
                                                                                                                                                                                                                                                                                                                                private final LocalZonedTimestampType toType$2;
                                                                                                                                                                                                                                                                                                                                private final String method$2;
                                                                                                                                                                                                                                                                                                                                private final String truncate_method$1;

                                                                                                                                                                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                                                                                    String timeZone = this.ctx$2.addReusableSessionTimeZone();
                                                                                                                                                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", "(", ", ", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.truncate_method$1, this.method$2, operandTerm, timeZone, BoxesRunTime.boxToInteger((int)this.toType$2.getPrecision())}));
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                                                                    this.ctx$2 = ctx$2;
                                                                                                                                                                                                                                                                                                                                    this.toType$2 = toType$2;
                                                                                                                                                                                                                                                                                                                                    this.method$2 = method$2;
                                                                                                                                                                                                                                                                                                                                    this.truncate_method$1 = truncate_method$1;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            });
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        var11_16 = v5;
                                                                                                                                                                                                                                                                                                                        break block28;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (var4_4 == null) break block31;
                                                                                                                                                                                                                                                                                                                    var33_33 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                                                    var34_34 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var33_33) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var34_34)) break block31;
                                                                                                                                                                                                                                                                                                                    fromType = (LocalZonedTimestampType)operand.resultType();
                                                                                                                                                                                                                                                                                                                    toType = (TimestampType)targetType;
                                                                                                                                                                                                                                                                                                                    method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_WITH_LOCAL_ZONE_TO_TIMESTAMP());
                                                                                                                                                                                                                                                                                                                    if (fromType.getPrecision() < toType.getPrecision()) {
                                                                                                                                                                                                                                                                                                                        v6 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(ctx, method){
                                                                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                            private final CodeGeneratorContext ctx$2;
                                                                                                                                                                                                                                                                                                                            private final String method$3;

                                                                                                                                                                                                                                                                                                                            public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                                                                                String zone = this.ctx$2.addReusableSessionTimeZone();
                                                                                                                                                                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$3, operandTerm, zone}));
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                                                                this.ctx$2 = ctx$2;
                                                                                                                                                                                                                                                                                                                                this.method$3 = method$3;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        });
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        truncate_method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                                                                        v6 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(ctx, toType, method, truncate_method){
                                                                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                            private final CodeGeneratorContext ctx$2;
                                                                                                                                                                                                                                                                                                                            private final TimestampType toType$3;
                                                                                                                                                                                                                                                                                                                            private final String method$3;
                                                                                                                                                                                                                                                                                                                            private final String truncate_method$2;

                                                                                                                                                                                                                                                                                                                            public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                                                                                String zone = this.ctx$2.addReusableSessionTimeZone();
                                                                                                                                                                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", "(", ", ", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.truncate_method$2, this.method$3, operandTerm, zone, BoxesRunTime.boxToInteger((int)this.toType$3.getPrecision())}));
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                                                                this.ctx$2 = ctx$2;
                                                                                                                                                                                                                                                                                                                                this.toType$3 = toType$3;
                                                                                                                                                                                                                                                                                                                                this.method$3 = method$3;
                                                                                                                                                                                                                                                                                                                                this.truncate_method$2 = truncate_method$2;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        });
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    var11_16 = v6;
                                                                                                                                                                                                                                                                                                                    break block28;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (var4_4 == null) break block32;
                                                                                                                                                                                                                                                                                                                var39_39 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                                                var40_40 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var39_39) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var40_40)) break block32;
                                                                                                                                                                                                                                                                                                                fromType = (LocalZonedTimestampType)operand.resultType();
                                                                                                                                                                                                                                                                                                                toType = (LocalZonedTimestampType)targetType;
                                                                                                                                                                                                                                                                                                                if (fromType.getPrecision() <= toType.getPrecision()) {
                                                                                                                                                                                                                                                                                                                    x$33 = targetType;
                                                                                                                                                                                                                                                                                                                    x$34 = operand.copy$default$1();
                                                                                                                                                                                                                                                                                                                    x$35 = operand.copy$default$2();
                                                                                                                                                                                                                                                                                                                    x$36 = operand.copy$default$3();
                                                                                                                                                                                                                                                                                                                    x$37 = operand.copy$default$5();
                                                                                                                                                                                                                                                                                                                    v7 = operand.copy(x$34, x$35, x$36, x$33, x$37);
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                                                                    v7 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(toType, method){
                                                                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                        private final LocalZonedTimestampType toType$4;
                                                                                                                                                                                                                                                                                                                        private final String method$4;

                                                                                                                                                                                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$4, operandTerm, BoxesRunTime.boxToInteger((int)this.toType$4.getPrecision())}));
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                                                            this.toType$4 = toType$4;
                                                                                                                                                                                                                                                                                                                            this.method$4 = method$4;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    });
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                var11_16 = v7;
                                                                                                                                                                                                                                                                                                                break block28;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (var4_4 == null || !PlannerTypeUtils.isInteroperable(operand.resultType(), targetType)) break block33;
                                                                                                                                                                                                                                                                                                            x$38 = targetType;
                                                                                                                                                                                                                                                                                                            x$39 = operand.copy$default$1();
                                                                                                                                                                                                                                                                                                            x$40 = operand.copy$default$2();
                                                                                                                                                                                                                                                                                                            x$41 = operand.copy$default$3();
                                                                                                                                                                                                                                                                                                            x$42 = operand.copy$default$5();
                                                                                                                                                                                                                                                                                                            var11_16 = operand.copy(x$39, x$40, x$41, x$38, x$42);
                                                                                                                                                                                                                                                                                                            break block28;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (var4_4 == null || !(var55_55 = LogicalTypeRoot.VARCHAR.equals((Object)(var54_54 = (LogicalTypeRoot)var4_4._2())) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var54_54) != false) || !TypeCheckUtils.isTimePoint(operand.resultType())) break block34;
                                                                                                                                                                                                                                                                                                        var11_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)new Serializable(ctx, operand){
                                                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                            private final CodeGeneratorContext ctx$2;
                                                                                                                                                                                                                                                                                                            private final GeneratedExpression operand$2;

                                                                                                                                                                                                                                                                                                            public final String apply(Seq<String> operandTerm) {
                                                                                                                                                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ScalarOperatorGens$.MODULE$.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$localTimeToStringCode(this.ctx$2, this.operand$2.resultType(), (String)operandTerm.head())}));
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                                                this.ctx$2 = ctx$2;
                                                                                                                                                                                                                                                                                                                this.operand$2 = operand$2;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        });
                                                                                                                                                                                                                                                                                                        break block28;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (var4_4 == null) break block35;
                                                                                                                                                                                                                                                                                                    var56_56 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                                    var57_57 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                                    if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var56_56) || !(var58_58 = LogicalTypeRoot.VARCHAR.equals((Object)var57_57) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var57_57) != false)) break block35;
                                                                                                                                                                                                                                                                                                    method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.INTERVAL_YEAR_MONTH_TO_STRING.method);
                                                                                                                                                                                                                                                                                                    timeUnitRange = CodeGenUtils$.MODULE$.qualifyEnum(TimeUnitRange.YEAR_TO_MONTH);
                                                                                                                                                                                                                                                                                                    var11_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)new Serializable(method, timeUnitRange){
                                                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                        private final String method$5;
                                                                                                                                                                                                                                                                                                        private final String timeUnitRange$1;

                                                                                                                                                                                                                                                                                                        public final String apply(Seq<String> terms) {
                                                                                                                                                                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$5, terms.head(), this.timeUnitRange$1}));
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                                            this.method$5 = method$5;
                                                                                                                                                                                                                                                                                                            this.timeUnitRange$1 = timeUnitRange$1;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    });
                                                                                                                                                                                                                                                                                                    break block28;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (var4_4 == null) break block36;
                                                                                                                                                                                                                                                                                                var61_61 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                                var62_62 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                                if (!LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var61_61) || !(var63_63 = LogicalTypeRoot.VARCHAR.equals((Object)var62_62) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var62_62) != false)) break block36;
                                                                                                                                                                                                                                                                                                method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.INTERVAL_DAY_TIME_TO_STRING.method);
                                                                                                                                                                                                                                                                                                timeUnitRange = CodeGenUtils$.MODULE$.qualifyEnum(TimeUnitRange.DAY_TO_SECOND);
                                                                                                                                                                                                                                                                                                var11_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)new Serializable(method, timeUnitRange){
                                                                                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                    private final String method$6;
                                                                                                                                                                                                                                                                                                    private final String timeUnitRange$2;

                                                                                                                                                                                                                                                                                                    public final String apply(Seq<String> terms) {
                                                                                                                                                                                                                                                                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ", 3)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$6, terms.head(), this.timeUnitRange$2}));
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                                        this.method$6 = method$6;
                                                                                                                                                                                                                                                                                                        this.timeUnitRange$2 = timeUnitRange$2;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                });
                                                                                                                                                                                                                                                                                                break block28;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (var4_4 == null) break block37;
                                                                                                                                                                                                                                                                                            var66_66 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                            var67_67 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                            if (!LogicalTypeRoot.ARRAY.equals((Object)var66_66) || !(var68_68 = LogicalTypeRoot.VARCHAR.equals((Object)var67_67) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var67_67) != false)) break block37;
                                                                                                                                                                                                                                                                                            var11_16 = this.generateCastArrayToString(ctx, operand, (ArrayType)operand.resultType(), targetType);
                                                                                                                                                                                                                                                                                            break block28;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (var4_4 == null) break block38;
                                                                                                                                                                                                                                                                                        var69_69 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                        var70_70 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                        var71_71 = LogicalTypeRoot.BINARY.equals((Object)var69_69) != false ? true : LogicalTypeRoot.VARBINARY.equals((Object)var69_69) != false;
                                                                                                                                                                                                                                                                                        if (!var71_71 || !(var72_72 = LogicalTypeRoot.VARCHAR.equals((Object)var70_70) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var70_70) != false)) break block38;
                                                                                                                                                                                                                                                                                        charset = StandardCharsets.class.getCanonicalName();
                                                                                                                                                                                                                                                                                        var11_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)new Serializable(charset){
                                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                            private final String charset$1;

                                                                                                                                                                                                                                                                                            public final String apply(Seq<String> terms) {
                                                                                                                                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(new String(", ", ", ".UTF_8))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{terms.head(), this.charset$1}));
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                                this.charset$1 = charset$1;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        });
                                                                                                                                                                                                                                                                                        break block28;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (var4_4 == null) break block39;
                                                                                                                                                                                                                                                                                    var74_74 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                    var75_75 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                    if (!LogicalTypeRoot.MAP.equals((Object)var74_74) || !(var76_76 = LogicalTypeRoot.VARCHAR.equals((Object)var75_75) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var75_75) != false)) break block39;
                                                                                                                                                                                                                                                                                    var11_16 = this.generateCastMapToString(ctx, operand, (MapType)operand.resultType(), targetType);
                                                                                                                                                                                                                                                                                    break block28;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (var4_4 == null) break block40;
                                                                                                                                                                                                                                                                                var77_77 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                                var78_78 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                                if (!LogicalTypeRoot.ROW.equals((Object)var77_77) || !(var79_79 = LogicalTypeRoot.VARCHAR.equals((Object)var78_78) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var78_78) != false)) break block40;
                                                                                                                                                                                                                                                                                var11_16 = this.generateCastRowDataToString(ctx, operand, (RowType)operand.resultType(), targetType);
                                                                                                                                                                                                                                                                                break block28;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (var4_4 == null) break block41;
                                                                                                                                                                                                                                                                            var80_80 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                            var81_81 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                            if (!LogicalTypeRoot.RAW.equals((Object)var80_80) || !(var82_82 = LogicalTypeRoot.VARCHAR.equals((Object)var81_81) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var81_81) != false)) break block41;
                                                                                                                                                                                                                                                                            var11_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)new Serializable(ctx, operand){
                                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                private final CodeGeneratorContext ctx$2;
                                                                                                                                                                                                                                                                                private final GeneratedExpression operand$2;

                                                                                                                                                                                                                                                                                public final String apply(Seq<String> terms) {
                                                                                                                                                                                                                                                                                    DataFormatConverters.DataFormatConverter converter = DataFormatConverters.getConverterForDataType(LogicalTypeDataTypeConverter.fromLogicalTypeToDataType(this.operand$2.resultType()));
                                                                                                                                                                                                                                                                                    String converterTerm = this.ctx$2.addReusableObject(converter, "converter", this.ctx$2.addReusableObject$default$3());
                                                                                                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" \"\" + ", ".toExternal(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{converterTerm, terms.head()}));
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                    this.ctx$2 = ctx$2;
                                                                                                                                                                                                                                                                                    this.operand$2 = operand$2;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            });
                                                                                                                                                                                                                                                                            break block28;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (var4_4 == null || !(var84_84 = LogicalTypeRoot.VARCHAR.equals((Object)(var83_83 = (LogicalTypeRoot)var4_4._2())) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var83_83) != false)) break block42;
                                                                                                                                                                                                                                                                        var11_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)new Serializable(){
                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                                                                            public final String apply(Seq<String> terms) {
                                                                                                                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" \"\" + ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{terms.head()}));
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        });
                                                                                                                                                                                                                                                                        break block28;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (var4_4 == null) break block43;
                                                                                                                                                                                                                                                                    var85_85 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                                    var86_86 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                                    var87_87 = LogicalTypeRoot.VARCHAR.equals((Object)var85_85) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var85_85) != false;
                                                                                                                                                                                                                                                                    if (!var87_87 || !LogicalTypeRoot.BOOLEAN.equals((Object)var86_86)) break block43;
                                                                                                                                                                                                                                                                    castedExpression = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)new Serializable(){
                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toBooleanSQL(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.BINARY_STRING_UTIL(), operandTerm}));
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    });
                                                                                                                                                                                                                                                                    x$43 = resultTerm = CodeGenUtils$.MODULE$.newName("primitiveCastResult");
                                                                                                                                                                                                                                                                    x$44 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |boolean ", " = Boolean.TRUE.equals(", ");\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{castedExpression.code(), resultTerm, castedExpression.resultTerm()})))).stripMargin();
                                                                                                                                                                                                                                                                    x$45 = castedExpression.copy$default$2();
                                                                                                                                                                                                                                                                    x$46 = castedExpression.copy$default$4();
                                                                                                                                                                                                                                                                    x$47 = castedExpression.copy$default$5();
                                                                                                                                                                                                                                                                    var11_16 = castedExpression.copy(x$43, x$45, x$44, x$46, x$47);
                                                                                                                                                                                                                                                                    break block28;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (var4_4 == null || !(var96_96 = LogicalTypeRoot.VARCHAR.equals((Object)(var95_95 = (LogicalTypeRoot)var4_4._1())) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var95_95) != false) || !TypeCheckUtils.isNumeric(targetType)) break block44;
                                                                                                                                                                                                                                                                var97_97 = targetType;
                                                                                                                                                                                                                                                                if (var97_97 instanceof DecimalType) {
                                                                                                                                                                                                                                                                    var98_98 = (DecimalType)var97_97;
                                                                                                                                                                                                                                                                    var99_99 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(var98_98){
                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                        private final DecimalType x2$1;

                                                                                                                                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toDecimal(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.BINARY_STRING_UTIL(), operandTerm, BoxesRunTime.boxToInteger((int)this.x2$1.getPrecision()), BoxesRunTime.boxToInteger((int)this.x2$1.getScale())}));
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                            this.x2$1 = x2$1;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    });
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    var101_100 = targetType.getTypeRoot();
                                                                                                                                                                                                                                                                    var102_101 = LogicalTypeRoot.TINYINT.equals((Object)var101_100) != false ? "toByte" : (LogicalTypeRoot.SMALLINT.equals((Object)var101_100) != false ? "toShort" : (LogicalTypeRoot.INTEGER.equals((Object)var101_100) != false ? "toInt" : (LogicalTypeRoot.BIGINT.equals((Object)var101_100) != false ? "toLong" : (LogicalTypeRoot.DOUBLE.equals((Object)var101_100) != false ? "toDouble" : (LogicalTypeRoot.FLOAT.equals((Object)var101_100) != false ? "toFloat" : null)))));
                                                                                                                                                                                                                                                                    methodName = var102_101;
                                                                                                                                                                                                                                                                    Predef$.MODULE$.assert(methodName != null, (Function0)new Serializable(){
                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                                                                        public final String apply() {
                                                                                                                                                                                                                                                                            return "Unexpected data type.";
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    });
                                                                                                                                                                                                                                                                    var99_99 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)new Serializable(methodName){
                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                        private final String methodName$1;

                                                                                                                                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ".", "(", ".trim()))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.BINARY_STRING_UTIL(), this.methodName$1, operandTerm}));
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                            this.methodName$1 = methodName$1;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    });
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                var11_16 = var99_99;
                                                                                                                                                                                                                                                                break block28;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (var4_4 == null) break block45;
                                                                                                                                                                                                                                                            var103_103 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                            var104_104 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                            var105_105 = LogicalTypeRoot.VARCHAR.equals((Object)var103_103) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var103_103) != false;
                                                                                                                                                                                                                                                            if (!var105_105 || !LogicalTypeRoot.DATE.equals((Object)var104_104)) break block45;
                                                                                                                                                                                                                                                            var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)new Serializable(){
                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ".toString())"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_DATE()), operandTerm}));
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            });
                                                                                                                                                                                                                                                            break block28;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (var4_4 == null) break block46;
                                                                                                                                                                                                                                                        var106_106 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                        var107_107 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                        var108_108 = LogicalTypeRoot.VARCHAR.equals((Object)var106_106) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var106_106) != false;
                                                                                                                                                                                                                                                        if (!var108_108 || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var107_107)) break block46;
                                                                                                                                                                                                                                                        var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)new Serializable(){
                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                                                            public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ".toString())"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIME()), operandTerm}));
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        });
                                                                                                                                                                                                                                                        break block28;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (var4_4 == null) break block47;
                                                                                                                                                                                                                                                    var109_109 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                    var110_110 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                    var111_111 = LogicalTypeRoot.VARCHAR.equals((Object)var109_109) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var109_109) != false;
                                                                                                                                                                                                                                                    if (!var111_111 || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var110_110)) break block47;
                                                                                                                                                                                                                                                    var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)new Serializable(){
                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "(", ".toString())\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIMESTAMP()), operandTerm})))).stripMargin();
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    });
                                                                                                                                                                                                                                                    break block28;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (var4_4 == null) break block48;
                                                                                                                                                                                                                                                var112_112 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                                var113_113 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                                var114_114 = LogicalTypeRoot.VARCHAR.equals((Object)var112_112) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var112_112) != false;
                                                                                                                                                                                                                                                if (!var114_114 || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var113_113)) break block48;
                                                                                                                                                                                                                                                var11_16 = GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, targetType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), true, (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx){
                                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                    private final CodeGeneratorContext ctx$2;

                                                                                                                                                                                                                                                    public final Tuple2<String, String> apply(Seq<String> operands) {
                                                                                                                                                                                                                                                        String zone = this.ctx$2.addReusableSessionTimeZone();
                                                                                                                                                                                                                                                        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIMESTAMP_TIME_ZONE());
                                                                                                                                                                                                                                                        String toTimestampResultName = CodeGenUtils$.MODULE$.newName("toTimestampResult");
                                                                                                                                                                                                                                                        String stmt = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Long ", " = ", "(", ".toString(), ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{toTimestampResultName, method, operands.head(), zone}));
                                                                                                                                                                                                                                                        String result = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |(", " == null ?\n             |  null :\n             |  ", ".fromEpochMillis(", "))\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{toTimestampResultName, CodeGenUtils$.MODULE$.TIMESTAMP_DATA(), toTimestampResultName})))).stripMargin();
                                                                                                                                                                                                                                                        return new Tuple2((Object)stmt, (Object)result);
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                        this.ctx$2 = ctx$2;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                });
                                                                                                                                                                                                                                                break block28;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (var4_4 == null) break block49;
                                                                                                                                                                                                                                            var115_115 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                            var116_116 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                            var117_117 = LogicalTypeRoot.VARCHAR.equals((Object)var115_115) != false ? true : LogicalTypeRoot.CHAR.equals((Object)var115_115) != false;
                                                                                                                                                                                                                                            if (!var117_117 || !(var118_118 = LogicalTypeRoot.VARBINARY.equals((Object)var116_116) != false ? true : LogicalTypeRoot.BINARY.equals((Object)var116_116) != false)) break block49;
                                                                                                                                                                                                                                            var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(){
                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toBytes()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            });
                                                                                                                                                                                                                                            break block28;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (var4_4 == null) break block50;
                                                                                                                                                                                                                                        var119_119 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                        var120_120 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                        if (!LogicalTypeRoot.BOOLEAN.equals((Object)var119_119) || !LogicalTypeRoot.DECIMAL.equals((Object)var120_120)) break block50;
                                                                                                                                                                                                                                        dt = (DecimalType)targetType;
                                                                                                                                                                                                                                        var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(dt){
                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                            private final DecimalType dt$1;

                                                                                                                                                                                                                                            public final String apply(String operandTerm) {
                                                                                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".castFrom(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.DECIMAL_UTIL(), operandTerm, BoxesRunTime.boxToInteger((int)this.dt$1.getPrecision()), BoxesRunTime.boxToInteger((int)this.dt$1.getScale())}));
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                this.dt$1 = dt$1;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        });
                                                                                                                                                                                                                                        break block28;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (var4_4 == null || !LogicalTypeRoot.BOOLEAN.equals((Object)(var122_122 = (LogicalTypeRoot)var4_4._1())) || !TypeCheckUtils.isNumeric(targetType)) break block51;
                                                                                                                                                                                                                                    targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                                                                                                                    var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(targetTypeTerm){
                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                        private final String targetTypeTerm$1;

                                                                                                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") (", " ? 1 : 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTypeTerm$1, operandTerm}));
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                            this.targetTypeTerm$1 = targetTypeTerm$1;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    });
                                                                                                                                                                                                                                    break block28;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (var4_4 == null) break block52;
                                                                                                                                                                                                                                var124_124 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                                var125_125 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                                if (!LogicalTypeRoot.DECIMAL.equals((Object)var124_124) || !LogicalTypeRoot.BOOLEAN.equals((Object)var125_125)) break block52;
                                                                                                                                                                                                                                var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(){
                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                                    public final String apply(String operandTerm) {
                                                                                                                                                                                                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".castToBoolean(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.DECIMAL_UTIL(), operandTerm}));
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                });
                                                                                                                                                                                                                                break block28;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (var4_4 == null || !LogicalTypeRoot.BOOLEAN.equals((Object)(var126_126 = (LogicalTypeRoot)var4_4._2())) || !TypeCheckUtils.isNumeric(operand.resultType())) break block53;
                                                                                                                                                                                                                            var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(){
                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " != 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            });
                                                                                                                                                                                                                            break block28;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (var4_4 == null || !TypeCheckUtils.isNumeric(operand.resultType()) || !TypeCheckUtils.isNumeric(targetType)) break block54;
                                                                                                                                                                                                                        operandCasting = this.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$numericCasting(operand.resultType(), targetType);
                                                                                                                                                                                                                        var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(operandCasting){
                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                            private final Function1 operandCasting$1;

                                                                                                                                                                                                                            public final String apply(String operandTerm) {
                                                                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.operandCasting$1.apply((Object)operandTerm)}));
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                this.operandCasting$1 = operandCasting$1;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        });
                                                                                                                                                                                                                        break block28;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (var4_4 == null) break block55;
                                                                                                                                                                                                                    var128_128 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                    var129_129 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                    if (!LogicalTypeRoot.DATE.equals((Object)var128_128) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var129_129)) break block55;
                                                                                                                                                                                                                    var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(){
                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                                                                                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", ".fromEpochMillis(\n             |  ", " * ", ".MILLIS_PER_DAY)\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.TIMESTAMP_DATA(), operandTerm, DateTimeUtils.class.getCanonicalName()})))).stripMargin();
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    });
                                                                                                                                                                                                                    break block28;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (var4_4 == null) break block56;
                                                                                                                                                                                                                var130_130 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                                var131_131 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var130_130) || !LogicalTypeRoot.DATE.equals((Object)var131_131)) break block56;
                                                                                                                                                                                                                targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                                                                                                var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(targetTypeTerm){
                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                    private final String targetTypeTerm$2;

                                                                                                                                                                                                                    public final String apply(String operandTerm) {
                                                                                                                                                                                                                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |(", ") (", ".getMillisecond() /\n             |  ", ".MILLIS_PER_DAY)\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTypeTerm$2, operandTerm, DateTimeUtils.class.getCanonicalName()})))).stripMargin();
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    {
                                                                                                                                                                                                                        this.targetTypeTerm$2 = targetTypeTerm$2;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                });
                                                                                                                                                                                                                break block28;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (var4_4 == null) break block57;
                                                                                                                                                                                                            var133_133 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                            var134_134 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                            if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var133_133) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var134_134)) break block57;
                                                                                                                                                                                                            var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(){
                                                                                                                                                                                                                public static final long serialVersionUID = 0L;

                                                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".fromEpochMillis(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.TIMESTAMP_DATA(), operandTerm}));
                                                                                                                                                                                                                }
                                                                                                                                                                                                            });
                                                                                                                                                                                                            break block28;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (var4_4 == null) break block58;
                                                                                                                                                                                                        var135_135 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                        var136_136 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var135_135) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var136_136)) break block58;
                                                                                                                                                                                                        targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                                                                                        var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(targetTypeTerm){
                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                            private final String targetTypeTerm$3;

                                                                                                                                                                                                            public final String apply(String operandTerm) {
                                                                                                                                                                                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") (", ".getMillisecond() % "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTypeTerm$3, operandTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".MILLIS_PER_DAY)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeUtils.class.getCanonicalName()}))).toString();
                                                                                                                                                                                                            }
                                                                                                                                                                                                            {
                                                                                                                                                                                                                this.targetTypeTerm$3 = targetTypeTerm$3;
                                                                                                                                                                                                            }
                                                                                                                                                                                                        });
                                                                                                                                                                                                        break block28;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (var4_4 == null) break block59;
                                                                                                                                                                                                    var138_138 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                    var139_139 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                    if (!LogicalTypeRoot.DATE.equals((Object)var138_138) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var139_139)) break block59;
                                                                                                                                                                                                    var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(ctx){
                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                        private final CodeGeneratorContext ctx$2;

                                                                                                                                                                                                        public final String apply(String operandTerm) {
                                                                                                                                                                                                            String zone = this.ctx$2.addReusableSessionTimeZone();
                                                                                                                                                                                                            String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.DATE_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE());
                                                                                                                                                                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".fromEpochMillis(", "(", ", ", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.TIMESTAMP_DATA(), method, operandTerm, zone}));
                                                                                                                                                                                                        }
                                                                                                                                                                                                        {
                                                                                                                                                                                                            this.ctx$2 = ctx$2;
                                                                                                                                                                                                        }
                                                                                                                                                                                                    });
                                                                                                                                                                                                    break block28;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (var4_4 == null) break block60;
                                                                                                                                                                                                var140_140 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                                var141_141 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var140_140) || !LogicalTypeRoot.DATE.equals((Object)var141_141)) break block60;
                                                                                                                                                                                                var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(ctx){
                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                    private final CodeGeneratorContext ctx$2;

                                                                                                                                                                                                    public final String apply(String operandTerm) {
                                                                                                                                                                                                        String zone = this.ctx$2.addReusableSessionTimeZone();
                                                                                                                                                                                                        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_DATE());
                                                                                                                                                                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ".getMillisecond(), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{method, operandTerm, zone}));
                                                                                                                                                                                                    }
                                                                                                                                                                                                    {
                                                                                                                                                                                                        this.ctx$2 = ctx$2;
                                                                                                                                                                                                    }
                                                                                                                                                                                                });
                                                                                                                                                                                                break block28;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (var4_4 == null) break block61;
                                                                                                                                                                                            var142_142 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                            var143_143 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                            if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var142_142) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var143_143)) break block61;
                                                                                                                                                                                            var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(ctx){
                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                private final CodeGeneratorContext ctx$2;

                                                                                                                                                                                                public final String apply(String operandTerm) {
                                                                                                                                                                                                    String zone = this.ctx$2.addReusableSessionTimeZone();
                                                                                                                                                                                                    String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIME_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE());
                                                                                                                                                                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".fromEpochMillis(", "(", ", ", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.TIMESTAMP_DATA(), method, operandTerm, zone}));
                                                                                                                                                                                                }
                                                                                                                                                                                                {
                                                                                                                                                                                                    this.ctx$2 = ctx$2;
                                                                                                                                                                                                }
                                                                                                                                                                                            });
                                                                                                                                                                                            break block28;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (var4_4 == null) break block62;
                                                                                                                                                                                        var144_144 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                        var145_145 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var144_144) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var145_145)) break block62;
                                                                                                                                                                                        var11_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(ctx){
                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                            private final CodeGeneratorContext ctx$2;

                                                                                                                                                                                            public final String apply(String operandTerm) {
                                                                                                                                                                                                String zone = this.ctx$2.addReusableSessionTimeZone();
                                                                                                                                                                                                String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME());
                                                                                                                                                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ".getMillisecond(), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{method, operandTerm, zone}));
                                                                                                                                                                                            }
                                                                                                                                                                                            {
                                                                                                                                                                                                this.ctx$2 = ctx$2;
                                                                                                                                                                                            }
                                                                                                                                                                                        });
                                                                                                                                                                                        break block28;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (var4_4 == null) break block63;
                                                                                                                                                                                    var146_146 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                    var147_147 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                    if (!LogicalTypeRoot.TINYINT.equals((Object)var146_146) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var147_147)) break block63;
                                                                                                                                                                                    var148_148 = true;
                                                                                                                                                                                    break block64;
                                                                                                                                                                                }
                                                                                                                                                                                if (var4_4 == null) break block65;
                                                                                                                                                                                var149_149 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                                var150_150 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                                if (!LogicalTypeRoot.SMALLINT.equals((Object)var149_149) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var150_150)) break block65;
                                                                                                                                                                                var148_148 = true;
                                                                                                                                                                                break block64;
                                                                                                                                                                            }
                                                                                                                                                                            if (var4_4 == null) break block66;
                                                                                                                                                                            var151_151 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                            var152_152 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                            if (!LogicalTypeRoot.INTEGER.equals((Object)var151_151) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var152_152)) break block66;
                                                                                                                                                                            var148_148 = true;
                                                                                                                                                                            break block64;
                                                                                                                                                                        }
                                                                                                                                                                        if (var4_4 == null) break block67;
                                                                                                                                                                        var153_153 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                        var154_154 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                        if (!LogicalTypeRoot.BIGINT.equals((Object)var153_153) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var154_154)) break block67;
                                                                                                                                                                        var148_148 = true;
                                                                                                                                                                        break block64;
                                                                                                                                                                    }
                                                                                                                                                                    if (var4_4 == null) break block68;
                                                                                                                                                                    var155_155 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                    var156_156 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                    if (!LogicalTypeRoot.FLOAT.equals((Object)var155_155) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var156_156)) break block68;
                                                                                                                                                                    var148_148 = true;
                                                                                                                                                                    break block64;
                                                                                                                                                                }
                                                                                                                                                                if (var4_4 == null) break block69;
                                                                                                                                                                var157_157 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                                var158_158 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                                if (!LogicalTypeRoot.DOUBLE.equals((Object)var157_157) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var158_158)) break block69;
                                                                                                                                                                var148_148 = true;
                                                                                                                                                                break block64;
                                                                                                                                                            }
                                                                                                                                                            if (var4_4 == null) break block70;
                                                                                                                                                            var159_159 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                            var160_160 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                            if (!LogicalTypeRoot.DECIMAL.equals((Object)var159_159) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var160_160)) break block70;
                                                                                                                                                            var148_148 = true;
                                                                                                                                                            break block64;
                                                                                                                                                        }
                                                                                                                                                        if (var4_4 == null) break block71;
                                                                                                                                                        var161_161 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                        var162_162 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var161_161) || !LogicalTypeRoot.TINYINT.equals((Object)var162_162)) break block71;
                                                                                                                                                        var148_148 = true;
                                                                                                                                                        break block64;
                                                                                                                                                    }
                                                                                                                                                    if (var4_4 == null) break block72;
                                                                                                                                                    var163_163 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                    var164_164 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var163_163) || !LogicalTypeRoot.SMALLINT.equals((Object)var164_164)) break block72;
                                                                                                                                                    var148_148 = true;
                                                                                                                                                    break block64;
                                                                                                                                                }
                                                                                                                                                if (var4_4 == null) break block73;
                                                                                                                                                var165_165 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                                var166_166 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var165_165) || !LogicalTypeRoot.INTEGER.equals((Object)var166_166)) break block73;
                                                                                                                                                var148_148 = true;
                                                                                                                                                break block64;
                                                                                                                                            }
                                                                                                                                            if (var4_4 == null) break block74;
                                                                                                                                            var167_167 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                            var168_168 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var167_167) || !LogicalTypeRoot.BIGINT.equals((Object)var168_168)) break block74;
                                                                                                                                            var148_148 = true;
                                                                                                                                            break block64;
                                                                                                                                        }
                                                                                                                                        if (var4_4 == null) break block75;
                                                                                                                                        var169_169 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                        var170_170 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var169_169) || !LogicalTypeRoot.FLOAT.equals((Object)var170_170)) break block75;
                                                                                                                                        var148_148 = true;
                                                                                                                                        break block64;
                                                                                                                                    }
                                                                                                                                    if (var4_4 == null) break block76;
                                                                                                                                    var171_171 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                    var172_172 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var171_171) || !LogicalTypeRoot.DOUBLE.equals((Object)var172_172)) break block76;
                                                                                                                                    var148_148 = true;
                                                                                                                                    break block64;
                                                                                                                                }
                                                                                                                                if (var4_4 == null) ** GOTO lbl-1000
                                                                                                                                var173_173 = (LogicalTypeRoot)var4_4._1();
                                                                                                                                var174_174 = (LogicalTypeRoot)var4_4._2();
                                                                                                                                if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)var173_173) && LogicalTypeRoot.DECIMAL.equals((Object)var174_174)) {
                                                                                                                                    var148_148 = true;
                                                                                                                                } else lbl-1000:
                                                                                                                                // 2 sources

                                                                                                                                {
                                                                                                                                    var148_148 = false;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            if (var148_148) {
                                                                                                                                if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)targetType.getTypeRoot())) {
                                                                                                                                    throw new ValidationException("The cast conversion from NUMERIC type to TIMESTAMP type is not allowed, it's recommended to use TO_TIMESTAMP(FROM_UNIXTIME(numeric_col)) instead, note the numeric is in seconds.");
                                                                                                                                }
                                                                                                                                throw new ValidationException("The cast conversion from TIMESTAMP type to NUMERIC type is not allowed, it's recommended to use UNIX_TIMESTAMP(CAST(timestamp_col AS STRING)) instead.");
                                                                                                                            }
                                                                                                                            if (var4_4 == null) break block77;
                                                                                                                            var175_175 = (LogicalTypeRoot)var4_4._1();
                                                                                                                            var176_176 = (LogicalTypeRoot)var4_4._2();
                                                                                                                            if (!LogicalTypeRoot.TINYINT.equals((Object)var175_175) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var176_176)) break block77;
                                                                                                                            var177_177 = true;
                                                                                                                            break block78;
                                                                                                                        }
                                                                                                                        if (var4_4 == null) break block79;
                                                                                                                        var178_178 = (LogicalTypeRoot)var4_4._1();
                                                                                                                        var179_179 = (LogicalTypeRoot)var4_4._2();
                                                                                                                        if (!LogicalTypeRoot.SMALLINT.equals((Object)var178_178) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var179_179)) break block79;
                                                                                                                        var177_177 = true;
                                                                                                                        break block78;
                                                                                                                    }
                                                                                                                    if (var4_4 == null) break block80;
                                                                                                                    var180_180 = (LogicalTypeRoot)var4_4._1();
                                                                                                                    var181_181 = (LogicalTypeRoot)var4_4._2();
                                                                                                                    if (!LogicalTypeRoot.INTEGER.equals((Object)var180_180) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var181_181)) break block80;
                                                                                                                    var177_177 = true;
                                                                                                                    break block78;
                                                                                                                }
                                                                                                                if (var4_4 == null) break block81;
                                                                                                                var182_182 = (LogicalTypeRoot)var4_4._1();
                                                                                                                var183_183 = (LogicalTypeRoot)var4_4._2();
                                                                                                                if (!LogicalTypeRoot.BIGINT.equals((Object)var182_182) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var183_183)) break block81;
                                                                                                                var177_177 = true;
                                                                                                                break block78;
                                                                                                            }
                                                                                                            if (var4_4 == null) break block82;
                                                                                                            var184_184 = (LogicalTypeRoot)var4_4._1();
                                                                                                            var185_185 = (LogicalTypeRoot)var4_4._2();
                                                                                                            if (!LogicalTypeRoot.FLOAT.equals((Object)var184_184) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var185_185)) break block82;
                                                                                                            var177_177 = true;
                                                                                                            break block78;
                                                                                                        }
                                                                                                        if (var4_4 == null) break block83;
                                                                                                        var186_186 = (LogicalTypeRoot)var4_4._1();
                                                                                                        var187_187 = (LogicalTypeRoot)var4_4._2();
                                                                                                        if (!LogicalTypeRoot.DOUBLE.equals((Object)var186_186) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var187_187)) break block83;
                                                                                                        var177_177 = true;
                                                                                                        break block78;
                                                                                                    }
                                                                                                    if (var4_4 == null) break block84;
                                                                                                    var188_188 = (LogicalTypeRoot)var4_4._1();
                                                                                                    var189_189 = (LogicalTypeRoot)var4_4._2();
                                                                                                    if (!LogicalTypeRoot.DECIMAL.equals((Object)var188_188) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var189_189)) break block84;
                                                                                                    var177_177 = true;
                                                                                                    break block78;
                                                                                                }
                                                                                                if (var4_4 == null) break block85;
                                                                                                var190_190 = (LogicalTypeRoot)var4_4._1();
                                                                                                var191_191 = (LogicalTypeRoot)var4_4._2();
                                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var190_190) || !LogicalTypeRoot.TINYINT.equals((Object)var191_191)) break block85;
                                                                                                var177_177 = true;
                                                                                                break block78;
                                                                                            }
                                                                                            if (var4_4 == null) break block86;
                                                                                            var192_192 = (LogicalTypeRoot)var4_4._1();
                                                                                            var193_193 = (LogicalTypeRoot)var4_4._2();
                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var192_192) || !LogicalTypeRoot.SMALLINT.equals((Object)var193_193)) break block86;
                                                                                            var177_177 = true;
                                                                                            break block78;
                                                                                        }
                                                                                        if (var4_4 == null) break block87;
                                                                                        var194_194 = (LogicalTypeRoot)var4_4._1();
                                                                                        var195_195 = (LogicalTypeRoot)var4_4._2();
                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var194_194) || !LogicalTypeRoot.INTEGER.equals((Object)var195_195)) break block87;
                                                                                        var177_177 = true;
                                                                                        break block78;
                                                                                    }
                                                                                    if (var4_4 == null) break block88;
                                                                                    var196_196 = (LogicalTypeRoot)var4_4._1();
                                                                                    var197_197 = (LogicalTypeRoot)var4_4._2();
                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var196_196) || !LogicalTypeRoot.BIGINT.equals((Object)var197_197)) break block88;
                                                                                    var177_177 = true;
                                                                                    break block78;
                                                                                }
                                                                                if (var4_4 == null) break block89;
                                                                                var198_198 = (LogicalTypeRoot)var4_4._1();
                                                                                var199_199 = (LogicalTypeRoot)var4_4._2();
                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var198_198) || !LogicalTypeRoot.FLOAT.equals((Object)var199_199)) break block89;
                                                                                var177_177 = true;
                                                                                break block78;
                                                                            }
                                                                            if (var4_4 == null) break block90;
                                                                            var200_200 = (LogicalTypeRoot)var4_4._1();
                                                                            var201_201 = (LogicalTypeRoot)var4_4._2();
                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var200_200) || !LogicalTypeRoot.DOUBLE.equals((Object)var201_201)) break block90;
                                                                            var177_177 = true;
                                                                            break block78;
                                                                        }
                                                                        if (var4_4 == null) ** GOTO lbl-1000
                                                                        var202_202 = (LogicalTypeRoot)var4_4._1();
                                                                        var203_203 = (LogicalTypeRoot)var4_4._2();
                                                                        if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var202_202) && LogicalTypeRoot.DECIMAL.equals((Object)var203_203)) {
                                                                            var177_177 = true;
                                                                        } else lbl-1000:
                                                                        // 2 sources

                                                                        {
                                                                            var177_177 = false;
                                                                        }
                                                                    }
                                                                    if (var177_177) {
                                                                        if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)targetType.getTypeRoot())) {
                                                                            throw new ValidationException("The cast conversion from NUMERIC type to TIMESTAMP_LTZ type is not allowed, it's recommended to use TO_TIMESTAMP_LTZ(numeric_col, precision) instead.");
                                                                        }
                                                                        throw new ValidationException("The cast conversion from TIMESTAMP_LTZ type to NUMERIC type is not allowed.");
                                                                    }
                                                                    if (var4_4 == null) break block91;
                                                                    var204_204 = (LogicalTypeRoot)var4_4._1();
                                                                    var205_205 = (LogicalTypeRoot)var4_4._2();
                                                                    if (!LogicalTypeRoot.DATE.equals((Object)var204_204) || !LogicalTypeRoot.INTEGER.equals((Object)var205_205)) break block91;
                                                                    var206_206 = true;
                                                                    break block92;
                                                                }
                                                                if (var4_4 == null) break block93;
                                                                var207_207 = (LogicalTypeRoot)var4_4._1();
                                                                var208_208 = (LogicalTypeRoot)var4_4._2();
                                                                if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var207_207) || !LogicalTypeRoot.INTEGER.equals((Object)var208_208)) break block93;
                                                                var206_206 = true;
                                                                break block92;
                                                            }
                                                            if (var4_4 == null) break block94;
                                                            var209_209 = (LogicalTypeRoot)var4_4._1();
                                                            var210_210 = (LogicalTypeRoot)var4_4._2();
                                                            if (!LogicalTypeRoot.INTEGER.equals((Object)var209_209) || !LogicalTypeRoot.DATE.equals((Object)var210_210)) break block94;
                                                            var206_206 = true;
                                                            break block92;
                                                        }
                                                        if (var4_4 == null) break block95;
                                                        var211_211 = (LogicalTypeRoot)var4_4._1();
                                                        var212_212 = (LogicalTypeRoot)var4_4._2();
                                                        if (!LogicalTypeRoot.INTEGER.equals((Object)var211_211) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var212_212)) break block95;
                                                        var206_206 = true;
                                                        break block92;
                                                    }
                                                    if (var4_4 == null) break block96;
                                                    var213_213 = (LogicalTypeRoot)var4_4._1();
                                                    var214_214 = (LogicalTypeRoot)var4_4._2();
                                                    if (!LogicalTypeRoot.INTEGER.equals((Object)var213_213) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var214_214)) break block96;
                                                    var206_206 = true;
                                                    break block92;
                                                }
                                                if (var4_4 == null) break block97;
                                                var215_215 = (LogicalTypeRoot)var4_4._1();
                                                var216_216 = (LogicalTypeRoot)var4_4._2();
                                                if (!LogicalTypeRoot.BIGINT.equals((Object)var215_215) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var216_216)) break block97;
                                                var206_206 = true;
                                                break block92;
                                            }
                                            if (var4_4 == null) break block98;
                                            var217_217 = (LogicalTypeRoot)var4_4._1();
                                            var218_218 = (LogicalTypeRoot)var4_4._2();
                                            if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var217_217) || !LogicalTypeRoot.INTEGER.equals((Object)var218_218)) break block98;
                                            var206_206 = true;
                                            break block92;
                                        }
                                        if (var4_4 == null) ** GOTO lbl-1000
                                        var219_219 = (LogicalTypeRoot)var4_4._1();
                                        var220_220 = (LogicalTypeRoot)var4_4._2();
                                        if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals((Object)var219_219) && LogicalTypeRoot.BIGINT.equals((Object)var220_220)) {
                                            var206_206 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            var206_206 = false;
                                        }
                                    }
                                    if (!var206_206) break block99;
                                    var11_16 = this.internalExprCasting(operand, targetType);
                                    break block28;
                                }
                                if (var4_4 == null) break block100;
                                var221_221 = (LogicalTypeRoot)var4_4._1();
                                var222_222 = (LogicalTypeRoot)var4_4._2();
                                if (!LogicalTypeRoot.DATE.equals((Object)var221_221) || !LogicalTypeRoot.BIGINT.equals((Object)var222_222)) break block100;
                                var223_223 = true;
                                break block101;
                            }
                            if (var4_4 == null) break block102;
                            var224_224 = (LogicalTypeRoot)var4_4._1();
                            var225_225 = (LogicalTypeRoot)var4_4._2();
                            if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals((Object)var224_224) || !LogicalTypeRoot.BIGINT.equals((Object)var225_225)) break block102;
                            var223_223 = true;
                            break block101;
                        }
                        if (var4_4 == null) ** GOTO lbl-1000
                        var226_226 = (LogicalTypeRoot)var4_4._1();
                        var227_227 = (LogicalTypeRoot)var4_4._2();
                        if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals((Object)var226_226) && LogicalTypeRoot.BIGINT.equals((Object)var227_227)) {
                            var223_223 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var223_223 = false;
                        }
                    }
                    if (!var223_223) break block103;
                    var11_16 = this.internalExprCasting(operand, targetType);
                    break block28;
                }
                if (var4_4 == null) break block104;
                var228_228 = (LogicalTypeRoot)var4_4._1();
                var229_229 = (LogicalTypeRoot)var4_4._2();
                var230_230 = LogicalTypeRoot.ROW.equals((Object)var228_228) != false ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals((Object)var228_228) != false;
                if (!var230_230 || !(var231_231 = LogicalTypeRoot.ROW.equals((Object)var229_229) != false ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals((Object)var229_229) != false) || !LogicalTypeCasts.supportsExplicitCast(operand.resultType(), targetType)) break block104;
                var11_16 = this.generateCastRowToRow(ctx, operand, targetType);
            }
            return var11_16;
        }
        if (var4_4 != null) {
            throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported cast from '", "' to '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand.resultType(), targetType})));
        }
        throw new MatchError((Object)var4_4);
    }

    public GeneratedExpression generateIfElse(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType resultType2, int i) {
        Seq<String> seq;
        block4: {
            GeneratedExpression generatedExpression;
            block3: {
                Tuple2 tuple2;
                block2: {
                    if (i != operands.size() - 1) break block2;
                    generatedExpression = this.generateCast(ctx, (GeneratedExpression)operands.apply(i), resultType2);
                    break block3;
                }
                CodeGenUtils$.MODULE$.requireBoolean((GeneratedExpression)operands.apply(i));
                GeneratedExpression condition = (GeneratedExpression)operands.apply(i);
                GeneratedExpression trueAction = this.generateCast(ctx, (GeneratedExpression)operands.apply(i + 1), resultType2);
                GeneratedExpression falseAction = this.generateIfElse(ctx, operands, resultType2, i + 2);
                seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block4;
                String resultTerm = (String)((SeqLike)some.get()).apply(0);
                String nullTerm = (String)((SeqLike)some.get()).apply(1);
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
                String resultTerm2 = (String)tuple22._1();
                String nullTerm2 = (String)tuple22._2();
                String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType2);
                String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType2);
                String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", " ", " = ", ";\n           |boolean ", ";\n           |if (", ") {\n           |  ", "\n           |  ", " = ", ";\n           |  if (!", ") {\n           |    ", " = ", ";\n           |  }\n           |}\n           |else {\n           |  ", "\n           |  ", " = ", ";\n           |  if (!", ") {\n           |    ", " = ", ";\n           |  }\n           |}\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condition.code(), resultTypeTerm, resultTerm2, defaultValue, nullTerm2, condition.resultTerm(), trueAction.code(), nullTerm2, trueAction.nullTerm(), nullTerm2, resultTerm2, trueAction.resultTerm(), falseAction.code(), nullTerm2, falseAction.nullTerm(), nullTerm2, resultTerm2, falseAction.resultTerm()})))).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", " ", ";\n           |if (", ") {\n           |  ", "\n           |  ", " = ", ";\n           |}\n           |else {\n           |  ", "\n           |  ", " = ", ";\n           |}\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condition.code(), resultTypeTerm, resultTerm2, condition.resultTerm(), trueAction.code(), resultTerm2, trueAction.resultTerm(), falseAction.code(), resultTerm2, falseAction.resultTerm()})))).stripMargin().trim();
                generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, resultType2, GeneratedExpression$.MODULE$.apply$default$5());
            }
            return generatedExpression;
        }
        throw new MatchError(seq);
    }

    public int generateIfElse$default$4() {
        return 0;
    }

    public GeneratedExpression generateDot(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands) {
        if (operands.size() > 2) {
            throw new CodeGenException("A DOT operator with more than 2 operands is not supported yet.");
        }
        Preconditions.checkArgument((boolean)((GeneratedExpression)operands.apply(1)).literal());
        Preconditions.checkArgument((boolean)TypeCheckUtils.isCharacterString(((GeneratedExpression)operands.apply(1)).resultType()));
        Preconditions.checkArgument((boolean)(((GeneratedExpression)operands.head()).resultType() instanceof RowType));
        String fieldName = ((GeneratedExpression)operands.apply(1)).literalValue().get().toString();
        int fieldIdx = ((RowType)((GeneratedExpression)operands.head()).resultType()).getFieldIndex(fieldName);
        GeneratedExpression access = GenerateUtils$.MODULE$.generateFieldAccess(ctx, ((GeneratedExpression)operands.head()).resultType(), ((GeneratedExpression)operands.head()).resultTerm(), fieldIdx);
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(access.resultType());
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(access.resultType());
            String resultCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", " ", ";\n         |boolean ", ";\n         |if (", ") {\n         |  ", " = ", ";\n         |  ", " = true;\n         |}\n         |else {\n         |  ", "\n         |  ", " = ", ";\n         |  ", " = ", ";\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)operands.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(GeneratedExpression x$9) {
                    return x$9.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n"), resultTypeTerm, resultTerm2, nullTerm2, ((TraversableOnce)operands.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(GeneratedExpression x$10) {
                    return x$10.nullTerm();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(" || "), resultTerm2, defaultValue, nullTerm2, access.code(), resultTerm2, access.resultTerm(), nullTerm2, access.nullTerm()})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |", " ", " = ", ";\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)operands.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(GeneratedExpression x$11) {
                    return x$11.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n"), access.code(), resultTypeTerm, resultTerm2, access.resultTerm()})))).stripMargin();
            return new GeneratedExpression(resultTerm2, nullTerm2, resultCode, access.resultType(), GeneratedExpression$.MODULE$.apply$default$5());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateRow(CodeGeneratorContext ctx, LogicalType rowType, Seq<GeneratedExpression> elements) {
        GeneratedExpression generatedExpression;
        List<LogicalType> fieldTypes = LogicalTypeChecks.getFieldTypes(rowType);
        boolean isLiteral = elements.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(GeneratedExpression e) {
                return e.literal();
            }
        });
        boolean isPrimitive = JavaConversions$.MODULE$.asScalaBuffer(fieldTypes).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogicalType x$1) {
                return PlannerTypeUtils.isPrimitive(x$1);
            }
        });
        if (isLiteral) {
            generatedExpression = this.generateLiteralRow(ctx, rowType, elements);
        } else if (isPrimitive) {
            Seq mapped = (Seq)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(fieldTypes){
                public static final long serialVersionUID = 0L;
                private final List fieldTypes$1;

                public final GeneratedExpression apply(Tuple2<GeneratedExpression, Object> x0$1) {
                    Tuple2<GeneratedExpression, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        GeneratedExpression generatedExpression;
                        GeneratedExpression element = (GeneratedExpression)tuple2._1();
                        int idx = tuple2._2$mcI$sp();
                        if (element.literal()) {
                            generatedExpression = element;
                        } else {
                            LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.asScalaBuffer(this.fieldTypes$1).apply(idx);
                            String resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(tpe);
                            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.ALWAYS_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), tpe, (Option<Object>)new Some(null));
                        }
                        GeneratedExpression generatedExpression2 = generatedExpression;
                        return generatedExpression2;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.fieldTypes$1 = fieldTypes$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            GeneratedExpression row = this.generateLiteralRow(ctx, rowType, (Seq<GeneratedExpression>)mapped);
            String code = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(ctx, fieldTypes, row){
                public static final long serialVersionUID = 0L;
                private final CodeGeneratorContext ctx$3;
                private final List fieldTypes$1;
                private final GeneratedExpression row$1;

                public final String apply(Tuple2<GeneratedExpression, Object> x0$2) {
                    Tuple2<GeneratedExpression, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        GeneratedExpression element = (GeneratedExpression)tuple2._1();
                        int idx = tuple2._2$mcI$sp();
                        LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.asScalaBuffer(this.fieldTypes$1).apply(idx);
                        String string2 = element.literal() ? "" : (this.ctx$3.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n               |if (", ") {\n               |  ", ";\n               |} else {\n               |  ", ";\n               |}\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), element.nullTerm(), CodeGenUtils$.MODULE$.binaryRowSetNull(idx, this.row$1.resultTerm(), tpe), CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, this.row$1.resultTerm(), tpe, element.resultTerm())})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n               |", ";\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, this.row$1.resultTerm(), tpe, element.resultTerm())})))).stripMargin());
                        return string2;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.ctx$3 = ctx$3;
                    this.fieldTypes$1 = fieldTypes$1;
                    this.row$1 = row$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
            generatedExpression = new GeneratedExpression(row.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), code, rowType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = this.generateNonLiteralRow(ctx, rowType, elements);
        }
        return generatedExpression;
    }

    private GeneratedExpression generateLiteralRow(CodeGeneratorContext ctx, LogicalType rowType, Seq<GeneratedExpression> elements) {
        Preconditions.checkArgument((boolean)elements.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(GeneratedExpression e) {
                return e.literal();
            }
        }));
        GeneratedExpression expr = this.generateNonLiteralRow(ctx, rowType, elements);
        ctx.addReusableInitStatement(expr.code());
        return new GeneratedExpression(expr.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), rowType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateNonLiteralRow(CodeGeneratorContext ctx, LogicalType rowType, Seq<GeneratedExpression> elements) {
        List<LogicalType> fieldTypes = LogicalTypeChecks.getFieldTypes(rowType);
        String rowTerm = CodeGenUtils$.MODULE$.newName("row");
        String writerTerm = CodeGenUtils$.MODULE$.newName("writer");
        String writerCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryRowWriter.class));
        String writeCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(ctx, fieldTypes, writerTerm){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$10;
            private final List fieldTypes$2;
            private final String writerTerm$1;

            public final String apply(Tuple2<GeneratedExpression, Object> x0$3) {
                Tuple2<GeneratedExpression, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    GeneratedExpression element = (GeneratedExpression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.asScalaBuffer(this.fieldTypes$2).apply(idx);
                    String string2 = this.ctx$10.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |if (", ") {\n             |  ", ";\n             |} else {\n             |  ", ";\n             |}\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), element.nullTerm(), CodeGenUtils$.MODULE$.binaryWriterWriteNull(idx, this.writerTerm$1, tpe), CodeGenUtils$.MODULE$.binaryWriterWriteField(this.ctx$10, idx, element.resultTerm(), this.writerTerm$1, tpe)})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |", ";\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), CodeGenUtils$.MODULE$.binaryWriterWriteField(this.ctx$10, idx, element.resultTerm(), this.writerTerm$1, tpe)})))).stripMargin();
                    return string2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$10 = ctx$10;
                this.fieldTypes$2 = fieldTypes$2;
                this.writerTerm$1 = writerTerm$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", ".reset();\n         |", "\n         |", ".complete();\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, writeCode, writerTerm})))).stripMargin();
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.BINARY_ROW(), rowTerm, CodeGenUtils$.MODULE$.BINARY_ROW(), BoxesRunTime.boxToInteger((int)JavaConversions$.MODULE$.asScalaBuffer(fieldTypes).length())})));
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerCls, writerTerm, writerCls, rowTerm})));
        return new GeneratedExpression(rowTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, rowType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArray(CodeGeneratorContext ctx, LogicalType resultType2, Seq<GeneratedExpression> elements) {
        GeneratedExpression generatedExpression;
        Preconditions.checkArgument((boolean)(resultType2 instanceof ArrayType));
        ArrayType arrayType = (ArrayType)resultType2;
        LogicalType elementType = arrayType.getElementType();
        boolean isLiteral = elements.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(GeneratedExpression e) {
                return e.literal();
            }
        });
        boolean isPrimitive = PlannerTypeUtils.isPrimitive(elementType);
        if (isLiteral) {
            generatedExpression = this.generateLiteralArray(ctx, arrayType, elements);
        } else if (isPrimitive) {
            Seq mapped = (Seq)elements.map((Function1)new Serializable(elementType){
                public static final long serialVersionUID = 0L;
                private final LogicalType elementType$1;

                public final GeneratedExpression apply(GeneratedExpression element) {
                    GeneratedExpression generatedExpression;
                    if (element.literal()) {
                        generatedExpression = element;
                    } else {
                        String resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(this.elementType$1);
                        generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.ALWAYS_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), this.elementType$1, (Option<Object>)new Some(null));
                    }
                    return generatedExpression;
                }
                {
                    this.elementType$1 = elementType$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            GeneratedExpression array = this.generateLiteralArray(ctx, arrayType, (Seq<GeneratedExpression>)mapped);
            String code = this.generatePrimitiveArrayUpdateCode(ctx, array.resultTerm(), elementType, elements);
            generatedExpression = new GeneratedExpression(array.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), code, arrayType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = this.generateNonLiteralArray(ctx, arrayType, elements);
        }
        return generatedExpression;
    }

    private String generatePrimitiveArrayUpdateCode(CodeGeneratorContext ctx, String arrayTerm, LogicalType elementType, Seq<GeneratedExpression> elements) {
        return ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(ctx, arrayTerm, elementType){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$11;
            private final String arrayTerm$1;
            private final LogicalType elementType$2;

            public final String apply(Tuple2<GeneratedExpression, Object> x0$4) {
                Tuple2<GeneratedExpression, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    GeneratedExpression element = (GeneratedExpression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    String string2 = element.literal() ? "" : (this.ctx$11.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |if (", ") {\n           |  ", ";\n           |} else {\n           |  ", ";\n           |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), element.nullTerm(), CodeGenUtils$.MODULE$.binaryArraySetNull(idx, this.arrayTerm$1, this.elementType$2), CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, this.arrayTerm$1, this.elementType$2, element.resultTerm())})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", ";\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, this.arrayTerm$1, this.elementType$2, element.resultTerm())})))).stripMargin());
                    return string2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$11 = ctx$11;
                this.arrayTerm$1 = arrayTerm$1;
                this.elementType$2 = elementType$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private GeneratedExpression generateLiteralArray(CodeGeneratorContext ctx, ArrayType arrayType, Seq<GeneratedExpression> elements) {
        Preconditions.checkArgument((boolean)elements.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(GeneratedExpression e) {
                return e.literal();
            }
        }));
        GeneratedExpression expr = this.generateNonLiteralArray(ctx, arrayType, elements);
        ctx.addReusableInitStatement(expr.code());
        return new GeneratedExpression(expr.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), arrayType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateNonLiteralArray(CodeGeneratorContext ctx, ArrayType arrayType, Seq<GeneratedExpression> elements) {
        LogicalType elementType = arrayType.getElementType();
        String arrayTerm = CodeGenUtils$.MODULE$.newName("array");
        String writerTerm = CodeGenUtils$.MODULE$.newName("writer");
        String writerCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryArrayWriter.class));
        int elementSize = BinaryArrayData.calculateFixLengthPartSize(elementType);
        String writeCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(ctx, elementType, writerTerm){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$12;
            private final LogicalType elementType$3;
            private final String writerTerm$2;

            public final String apply(Tuple2<GeneratedExpression, Object> x0$5) {
                Tuple2<GeneratedExpression, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    GeneratedExpression element = (GeneratedExpression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    String string2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |if (", ") {\n           |  ", ";\n           |} else {\n           |  ", ";\n           |}\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), element.nullTerm(), CodeGenUtils$.MODULE$.binaryArraySetNull(idx, this.writerTerm$2, this.elementType$3), CodeGenUtils$.MODULE$.binaryWriterWriteField(this.ctx$12, idx, element.resultTerm(), this.writerTerm$2, this.elementType$3)})))).stripMargin();
                    return string2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$12 = ctx$12;
                this.elementType$3 = elementType$3;
                this.writerTerm$2 = writerTerm$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", ".reset();\n         |", "\n         |", ".complete();\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writerTerm, writeCode, writerTerm})))).stripMargin();
        String memberStmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = new ", "();\n         |", " ", " = new ", "(", ", ", ", ", ");\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.BINARY_ARRAY(), arrayTerm, CodeGenUtils$.MODULE$.BINARY_ARRAY(), writerCls, writerTerm, writerCls, arrayTerm, BoxesRunTime.boxToInteger((int)elements.length()), BoxesRunTime.boxToInteger((int)elementSize)})))).stripMargin();
        ctx.addReusableMember(memberStmt);
        return new GeneratedExpression(arrayTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, arrayType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArrayElementAt(CodeGeneratorContext ctx, GeneratedExpression array, GeneratedExpression index) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            int n;
            Some some2;
            Object v;
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            LogicalType componentInfo = ((ArrayType)array.resultType()).getElementType();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(componentInfo);
            String defaultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(componentInfo);
            Option<Object> option = index.literalValue();
            if (option instanceof Some && (v = (some2 = (Some)option).x()) instanceof Integer && (n = BoxesRunTime.unboxToInt((Object)v)) < 1) {
                throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Array element access needs an index starting at 1 but was ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            String idxStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{index.resultTerm()}));
            String arrayIsNull = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".isNullAt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array.resultTerm(), idxStr}));
            String arrayGet = CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, idxStr, array.resultTerm(), componentInfo);
            String arrayAccessCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |", "\n        |boolean ", " = ", " || ", " ||\n        |   ", " < 0 || ", " >= ", ".size() || ", ";\n        |", " ", " = ", " ? ", " : ", ";\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array.code(), index.code(), nullTerm2, array.nullTerm(), index.nullTerm(), idxStr, idxStr, array.resultTerm(), arrayIsNull, resultTypeTerm, resultTerm2, nullTerm2, defaultTerm, arrayGet})))).stripMargin();
            return new GeneratedExpression(resultTerm2, nullTerm2, arrayAccessCode, componentInfo, GeneratedExpression$.MODULE$.apply$default$5());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateArrayElement(CodeGeneratorContext ctx, GeneratedExpression array) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            LogicalType resultType2 = ((ArrayType)array.resultType()).getElementType();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType2);
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType2);
            String arrayLengthCode = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ? 0 : ", ".size()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array.nullTerm(), array.resultTerm()}));
            String arrayGet = CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, 0, array.resultTerm(), resultType2);
            String arrayAccessCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", ";\n         |", " ", ";\n         |switch (", ") {\n         |  case 0:\n         |    ", " = true;\n         |    ", " = ", ";\n         |    break;\n         |  case 1:\n         |    ", " = ", ".isNullAt(0);\n         |    ", " = ", " ? ", " : ", ";\n         |    break;\n         |  default:\n         |    throw new RuntimeException(\"Array has more than one element.\");\n         |}\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array.code(), nullTerm2, resultTypeTerm, resultTerm2, arrayLengthCode, nullTerm2, resultTerm2, defaultValue, nullTerm2, array.resultTerm(), resultTerm2, nullTerm2, defaultValue, arrayGet})))).stripMargin();
            return new GeneratedExpression(resultTerm2, nullTerm2, arrayAccessCode, resultType2, GeneratedExpression$.MODULE$.apply$default$5());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateArrayCardinality(CodeGeneratorContext ctx, GeneratedExpression array) {
        return this.generateUnaryOperatorIfNotNull(ctx, new IntType(), array, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(array){
            public static final long serialVersionUID = 0L;
            private final GeneratedExpression array$1;

            public final String apply(String x$14) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".size()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.array$1.resultTerm()}));
            }
            {
                this.array$1 = array$1;
            }
        });
    }

    public GeneratedExpression generateGreatestLeast(LogicalType resultType2, Seq<GeneratedExpression> elements, boolean greatest) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "cur", "nullTerm"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
            Tuple3 tuple3;
            String result = (String)((SeqLike)some.get()).apply(0);
            String cur = (String)((SeqLike)some.get()).apply(1);
            String nullTerm = (String)((SeqLike)some.get()).apply(2);
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)result, (Object)cur, (Object)nullTerm);
            String result2 = (String)tuple32._1();
            String cur2 = (String)tuple32._2();
            String nullTerm2 = (String)tuple32._3();
            Option widerType = JavaScalaConversionUtil$.MODULE$.toScala(LogicalTypeMerging.findCommonType(JavaConversions$.MODULE$.seqAsJavaList((Seq)elements.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final LogicalType apply(GeneratedExpression element) {
                    return element.resultType();
                }
            }, Seq$.MODULE$.canBuildFrom())))).orElse((Function0)new Serializable(elements){
                public static final long serialVersionUID = 0L;
                private final Seq elements$1;

                public final Nothing$ apply() {
                    throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find common type for ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.elements$1})));
                }
                {
                    this.elements$1 = elements$1;
                }
            });
            String resultTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType((LogicalType)widerType.get());
            String elementsCode = ((TraversableOnce)elements.map((Function1)new Serializable(greatest, result2, cur2, nullTerm2, widerType, resultTypeTerm){
                public static final long serialVersionUID = 0L;
                private final boolean greatest$1;
                private final String result$1;
                private final String cur$1;
                private final String nullTerm$1;
                private final Option widerType$1;
                private final String resultTypeTerm$2;

                public final String apply(GeneratedExpression element) {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | ", "\n         | if (!", ") {\n         |   ", " ", " = ", ";\n         |   if (", ") {\n         |     ", " = true;\n         |   } else {\n         |     int compareResult = ", ".compareTo(", ");\n         |     if ((", " && compareResult < 0) || (compareResult > 0 && !", ")) {\n         |       ", " = ", ";\n         |     }\n         |   }\n         | }\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.code(), this.nullTerm$1, this.resultTypeTerm$2, this.cur$1, ScalarOperatorGens$.MODULE$.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$castIfNumeric$1(element, this.widerType$1), element.nullTerm(), this.nullTerm$1, this.result$1, this.cur$1, BoxesRunTime.boxToBoolean((boolean)this.greatest$1), BoxesRunTime.boxToBoolean((boolean)this.greatest$1), this.result$1, this.cur$1})))).stripMargin();
                }
                {
                    this.greatest$1 = greatest$1;
                    this.result$1 = result$1;
                    this.cur$1 = cur$1;
                    this.nullTerm$1 = nullTerm$1;
                    this.widerType$1 = widerType$1;
                    this.resultTypeTerm$2 = resultTypeTerm$2;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
            String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | ", " ", " = ", ";\n         | boolean ", " = false;\n         | ", "\n         | if (", ") {\n         |   ", " = null;\n         | }\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTypeTerm, result2, this.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$castIfNumeric$1((GeneratedExpression)elements.head(), widerType), nullTerm2, elementsCode, nullTerm2, result2})))).stripMargin();
            return new GeneratedExpression(result2, nullTerm2, code, resultType2, GeneratedExpression$.MODULE$.apply$default$5());
        }
        throw new MatchError(seq);
    }

    public boolean generateGreatestLeast$default$3() {
        return true;
    }

    public GeneratedExpression generateMap(CodeGeneratorContext ctx, LogicalType resultType2, Seq<GeneratedExpression> elements) {
        String string2;
        Preconditions.checkArgument((boolean)(resultType2 instanceof MapType));
        MapType mapType = (MapType)resultType2;
        String baseMap = CodeGenUtils$.MODULE$.newName("map");
        Seq keyElements = elements.grouped(2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GeneratedExpression apply(Seq<GeneratedExpression> x0$6) {
                Seq<GeneratedExpression> seq = x0$6;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    GeneratedExpression key;
                    GeneratedExpression generatedExpression = key = (GeneratedExpression)((SeqLike)some.get()).apply(0);
                    return generatedExpression;
                }
                throw new MatchError(seq);
            }
        }).toSeq();
        LogicalType keyType = mapType.getKeyType();
        GeneratedExpression keyExpr = this.generateArray(ctx, new ArrayType(keyType), (Seq<GeneratedExpression>)keyElements);
        boolean isKeyFixLength = PlannerTypeUtils.isPrimitive(keyType);
        Seq valueElements = elements.grouped(2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GeneratedExpression apply(Seq<GeneratedExpression> x0$7) {
                Seq<GeneratedExpression> seq = x0$7;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    GeneratedExpression value2;
                    GeneratedExpression generatedExpression = value2 = (GeneratedExpression)((SeqLike)some.get()).apply(1);
                    return generatedExpression;
                }
                throw new MatchError(seq);
            }
        }).toSeq();
        LogicalType valueType = mapType.getValueType();
        GeneratedExpression valueExpr = this.generateArray(ctx, new ArrayType(valueType), (Seq<GeneratedExpression>)valueElements);
        boolean isValueFixLength = PlannerTypeUtils.isPrimitive(valueType);
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = null;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.MAP_DATA(), baseMap})));
        if (isKeyFixLength && isValueFixLength) {
            String binaryMap = CodeGenUtils$.MODULE$.newName("binaryMap");
            ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = null;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.BINARY_MAP(), binaryMap})));
            String init = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".valueOf(", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryMap, CodeGenUtils$.MODULE$.BINARY_MAP(), keyExpr.resultTerm(), valueExpr.resultTerm()}));
            ctx.addReusableInitStatement(init);
            String keyArrayTerm = CodeGenUtils$.MODULE$.newName("keyArray");
            String valueArrayTerm = CodeGenUtils$.MODULE$.newName("valueArray");
            String keyUpdate = this.generatePrimitiveArrayUpdateCode(ctx, keyArrayTerm, keyType, (Seq<GeneratedExpression>)keyElements);
            String valueUpdate = this.generatePrimitiveArrayUpdateCode(ctx, valueArrayTerm, valueType, (Seq<GeneratedExpression>)valueElements);
            string2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ".keyArray();\n         |", "\n         |", " ", " = ", ".valueArray();\n         |", "\n         |", " = ", ";\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.BINARY_ARRAY(), keyArrayTerm, binaryMap, keyUpdate, CodeGenUtils$.MODULE$.BINARY_ARRAY(), valueArrayTerm, binaryMap, valueUpdate, baseMap, binaryMap})))).stripMargin();
        } else {
            string2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |", " = ", ".valueOf(", ", ", ");\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyExpr.code(), valueExpr.code(), baseMap, CodeGenUtils$.MODULE$.BINARY_MAP(), keyExpr.resultTerm(), valueExpr.resultTerm()})))).stripMargin();
        }
        String code = string2;
        return new GeneratedExpression(baseMap, GeneratedExpression$.MODULE$.NEVER_NULL(), code, resultType2, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateMapGet(CodeGeneratorContext ctx, GeneratedExpression map2, GeneratedExpression key) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String tmpKey = CodeGenUtils$.MODULE$.newName("key");
            String length = CodeGenUtils$.MODULE$.newName("length");
            String keys = CodeGenUtils$.MODULE$.newName("keys");
            String values = CodeGenUtils$.MODULE$.newName("values");
            String index = CodeGenUtils$.MODULE$.newName("index");
            String found = CodeGenUtils$.MODULE$.newName("found");
            String tmpValue = CodeGenUtils$.MODULE$.newName("value");
            MapType mapType = (MapType)map2.resultType();
            LogicalType keyType = mapType.getKeyType();
            LogicalType valueType = mapType.getValueType();
            String keyTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(keyType);
            String valueTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(valueType);
            String valueDefault = CodeGenUtils$.MODULE$.primitiveDefaultValue(valueType);
            String binaryMapTerm = CodeGenUtils$.MODULE$.newName("binaryMap");
            String genericMapTerm = CodeGenUtils$.MODULE$.newName("genericMap");
            String boxedValueTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(valueType);
            String mapTerm = map2.resultTerm();
            GeneratedExpression equal = this.generateEquals(ctx, new GeneratedExpression(key.resultTerm(), key.nullTerm(), GeneratedExpression$.MODULE$.NO_CODE(), key.resultType(), key.literalValue()), new GeneratedExpression(tmpKey, GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), keyType, GeneratedExpression$.MODULE$.apply$default$5()));
            String code = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |if (", " instanceof ", ") {\n         |  ", " ", " = (", ") ", ";\n         |  final int ", " = ", ".size();\n         |  final ", " ", " = ", ".keyArray();\n         |  final ", " ", " = ", ".valueArray();\n         |\n         |  int ", " = 0;\n         |  boolean ", " = false;\n         |  if (", ") {\n         |    while (", " < ", " && !", ") {\n         |      if (", ".isNullAt(", ")) {\n         |        ", " = true;\n         |      } else {\n         |        ", "++;\n         |      }\n         |    }\n         |  } else {\n         |    while (", " < ", " && !", ") {\n         |      final ", " ", " = ", ";\n         |      ", "\n         |      if (", ") {\n         |        ", " = true;\n         |      } else {\n         |        ", "++;\n         |      }\n         |    }\n         |  }\n         |\n         |  if (!", " || ", ".isNullAt(", ")) {\n         |    ", " = true;\n         |  } else {\n         |    ", " = ", ";\n         |  }\n         |} else {\n         |  ", " ", " = (", ") ", ";\n         |  ", " ", " =\n         |    (", ") ", ".get((", ") ", ");\n         |  if (", " == null) {\n         |    ", " = true;\n         |  } else {\n         |    ", " = ", ";\n         |  }\n         |}\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapTerm, CodeGenUtils$.MODULE$.BINARY_MAP(), CodeGenUtils$.MODULE$.BINARY_MAP(), binaryMapTerm, CodeGenUtils$.MODULE$.BINARY_MAP(), mapTerm, length, binaryMapTerm, CodeGenUtils$.MODULE$.BINARY_ARRAY(), keys, binaryMapTerm, CodeGenUtils$.MODULE$.BINARY_ARRAY(), values, binaryMapTerm, index, found, key.nullTerm(), index, length, found, keys, index, found, index, index, length, found, keyTypeTerm, tmpKey, CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, index, keys, keyType), equal.code(), equal.resultTerm(), found, index, found, values, index, nullTerm2, resultTerm2, CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, index, values, valueType), CodeGenUtils$.MODULE$.GENERIC_MAP(), genericMapTerm, CodeGenUtils$.MODULE$.GENERIC_MAP(), mapTerm, boxedValueTypeTerm, tmpValue, boxedValueTypeTerm, genericMapTerm, keyTypeTerm, key.resultTerm(), tmpValue, nullTerm2, resultTerm2, tmpValue})))).stripMargin();
            String accessCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |boolean ", " = (", " || ", ");\n         |", " ", " = ", ";\n         |if (!", ") {\n         | ", "\n         |}\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{map2.code(), key.code(), nullTerm2, map2.nullTerm(), key.nullTerm(), valueTypeTerm, resultTerm2, valueDefault, nullTerm2, code})))).stripMargin();
            return new GeneratedExpression(resultTerm2, nullTerm2, accessCode, valueType, GeneratedExpression$.MODULE$.apply$default$5());
        }
        throw new MatchError(seq);
    }

    public GeneratedExpression generateMapCardinality(CodeGeneratorContext ctx, GeneratedExpression map2) {
        return this.generateUnaryOperatorIfNotNull(ctx, new IntType(), map2, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)new Serializable(map2){
            public static final long serialVersionUID = 0L;
            private final GeneratedExpression map$1;

            public final String apply(String x$17) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".size()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.map$1.resultTerm()}));
            }
            {
                this.map$1 = map$1;
            }
        });
    }

    private GeneratedExpression generateCastRowToRow(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType targetRowType) {
        return GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, targetRowType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$4(), (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, operand, targetRowType){
            public static final long serialVersionUID = 0L;
            public final CodeGeneratorContext ctx$9;
            private final GeneratedExpression operand$3;
            private final LogicalType targetRowType$1;

            public final Tuple2<String, String> apply(Seq<String> x0$8) {
                Seq<String> seq = x0$8;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                    String rowTerm = (String)((SeqLike)some.get()).apply(0);
                    Buffer fieldExprs = (Buffer)((TraversableLike)((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(this.operand$3.resultType().getChildren()).zip((GenIterable)JavaConversions$.MODULE$.asScalaBuffer(this.targetRowType$1.getChildren()), Buffer$.MODULE$.canBuildFrom())).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, rowTerm){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.generateCastRowToRow.1 $outer;
                        private final String rowTerm$1;

                        public final GeneratedExpression apply(Tuple2<Tuple2<LogicalType, LogicalType>, Object> x0$9) {
                            Tuple2<Tuple2<LogicalType, LogicalType>, Object> tuple2 = x0$9;
                            if (tuple2 != null) {
                                Tuple2 tuple22 = (Tuple2)tuple2._1();
                                int idx = tuple2._2$mcI$sp();
                                if (tuple22 != null) {
                                    LogicalType sourceType = (LogicalType)tuple22._1();
                                    LogicalType targetType = (LogicalType)tuple22._2();
                                    String sourceTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(sourceType);
                                    String sourceTerm = CodeGenUtils$.MODULE$.newName("field");
                                    String sourceAccessCode = CodeGenUtils$.MODULE$.rowFieldReadAccess(this.$outer.ctx$9, idx, this.rowTerm$1, sourceType);
                                    GeneratedExpression sourceExpr = new GeneratedExpression(sourceTerm, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".isNullAt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rowTerm$1, BoxesRunTime.boxToInteger((int)idx)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = (", ") ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceTypeTerm, sourceTerm, sourceTypeTerm, sourceAccessCode})), sourceType, GeneratedExpression$.MODULE$.apply$default$5());
                                    GeneratedExpression generatedExpression = ScalarOperatorGens$.MODULE$.generateCast(this.$outer.ctx$9, sourceExpr, targetType);
                                    return generatedExpression;
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rowTerm$1 = rowTerm$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    GeneratedExpression generateRowExpr = ScalarOperatorGens$.MODULE$.generateRow(this.ctx$9, this.targetRowType$1, (Seq<GeneratedExpression>)fieldExprs);
                    Tuple2 tuple2 = new Tuple2((Object)generateRowExpr.code(), (Object)generateRowExpr.resultTerm());
                    return tuple2;
                }
                throw new MatchError(seq);
            }
            {
                this.ctx$9 = ctx$9;
                this.operand$3 = operand$3;
                this.targetRowType$1 = targetRowType$1;
            }
        });
    }

    private GeneratedExpression generateCastStringLiteralToDateTime(CodeGeneratorContext ctx, GeneratedExpression stringLiteral, LogicalType expectType) {
        block10: {
            Object object;
            block8: {
                LogicalTypeRoot logicalTypeRoot;
                String stringValue;
                block9: {
                    block7: {
                        Preconditions.checkArgument((boolean)stringLiteral.literal());
                        if (Predef$.MODULE$.Boolean2boolean(Boolean.valueOf(stringLiteral.nullTerm()))) {
                            return GenerateUtils$.MODULE$.generateNullLiteral(expectType, true);
                        }
                        stringValue = stringLiteral.literalValue().get().toString();
                        logicalTypeRoot = expectType.getTypeRoot();
                        if (!((Object)((Object)LogicalTypeRoot.DATE)).equals((Object)logicalTypeRoot)) break block7;
                        Integer n = SqlDateTimeUtils.dateStringToUnixDate(stringValue);
                        if (n == null) {
                            throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"String '", "' is not a valid date"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stringValue})));
                        }
                        Integer n2 = n;
                        object = n2;
                        break block8;
                    }
                    if (!((Object)((Object)LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE)).equals((Object)logicalTypeRoot)) break block9;
                    Integer n = SqlDateTimeUtils.timeStringToUnixDate(stringValue);
                    if (n == null) {
                        throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"String '", "' is not a valid time"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stringValue})));
                    }
                    Integer n3 = n;
                    object = n3;
                    break block8;
                }
                if (!((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)logicalTypeRoot)) break block10;
                TimestampData timestampData = SqlDateTimeUtils.toTimestampData(stringValue);
                if (timestampData == null) {
                    throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"String '", "' is not a valid timestamp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stringValue})));
                }
                String string2 = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".fromEpochMillis("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.TIMESTAMP_DATA()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "L, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestampData.getMillisecond()), BoxesRunTime.boxToInteger((int)timestampData.getNanoOfMillisecond())}))).toString();
                object = string2;
            }
            Integer literalCode = object;
            String typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(expectType);
            String resultTerm = CodeGenUtils$.MODULE$.newName("stringToTime");
            String stmt = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeTerm, resultTerm, literalCode}));
            ctx.addReusableMember(stmt);
            return new GeneratedExpression(resultTerm, "false", "", expectType, GeneratedExpression$.MODULE$.apply$default$5());
        }
        throw new UnsupportedOperationException();
    }

    private GeneratedExpression generateCastArrayToString(CodeGeneratorContext ctx, GeneratedExpression operand, ArrayType at, LogicalType targetType) {
        return GenerateUtils$.MODULE$.generateStringResultCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, at, targetType){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$6;
            private final ArrayType at$1;
            private final LogicalType targetType$1;

            public final Tuple2<String, String> apply(Seq<String> terms) {
                String builderCls = java.lang.StringBuilder.class.getCanonicalName();
                String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
                this.ctx$6.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderCls, builderTerm, builderCls})));
                String arrayTerm = (String)terms.head();
                String indexTerm = CodeGenUtils$.MODULE$.newName("i");
                String numTerm = CodeGenUtils$.MODULE$.newName("num");
                LogicalType elementType = this.at$1.getElementType();
                String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
                String elementTerm = CodeGenUtils$.MODULE$.newName("element");
                String elementNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
                String elementCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " = ", ";\n             |boolean ", " = ", ".isNullAt(", ");\n             |if (!", ") {\n             |  ", " = (", ") ", ";\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elementCls, elementTerm, CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType), elementNullTerm, arrayTerm, indexTerm, elementNullTerm, elementTerm, elementCls, CodeGenUtils$.MODULE$.rowFieldReadAccess(this.ctx$6, indexTerm, arrayTerm, elementType)})))).stripMargin();
                GeneratedExpression elementExpr = new GeneratedExpression(elementTerm, elementNullTerm, elementCode, elementType, GeneratedExpression$.MODULE$.apply$default$5());
                GeneratedExpression castExpr = ScalarOperatorGens$.MODULE$.generateCast(this.ctx$6, elementExpr, this.targetType$1);
                String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", ".setLength(0);\n             |", ".append(\"[\");\n             |int ", " = ", ".size();\n             |for (int ", " = 0; ", " < ", "; ", "++) {\n             |  if (", " != 0) {\n             |    ", ".append(\", \");\n             |  }\n             |\n             |  ", "\n             |  if (", ") {\n             |    ", ".append(\"null\");\n             |  } else {\n             |    ", ".append(", ");\n             |  }\n             |}\n             |", ".append(\"]\");\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderTerm, builderTerm, numTerm, arrayTerm, indexTerm, indexTerm, numTerm, indexTerm, indexTerm, builderTerm, castExpr.code(), castExpr.nullTerm(), builderTerm, builderTerm, castExpr.resultTerm(), builderTerm})))).stripMargin();
                return new Tuple2((Object)stmt, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toString()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderTerm})));
            }
            {
                this.ctx$6 = ctx$6;
                this.at$1 = at$1;
                this.targetType$1 = targetType$1;
            }
        });
    }

    private GeneratedExpression generateCastMapToString(CodeGeneratorContext ctx, GeneratedExpression operand, MapType mt, LogicalType targetType) {
        return GenerateUtils$.MODULE$.generateStringResultCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, mt, targetType){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$7;
            private final MapType mt$1;
            private final LogicalType targetType$2;

            public final Tuple2<String, String> apply(Seq<String> terms) {
                String resultTerm = CodeGenUtils$.MODULE$.newName("toStringResult");
                String builderCls = java.lang.StringBuilder.class.getCanonicalName();
                String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
                this.ctx$7.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderCls, builderTerm, builderCls})));
                String mapTerm = (String)terms.head();
                String genericMapTerm = CodeGenUtils$.MODULE$.newName("genericMap");
                String binaryMapTerm = CodeGenUtils$.MODULE$.newName("binaryMap");
                String keyArrayTerm = CodeGenUtils$.MODULE$.newName("keyArray");
                String valueArrayTerm = CodeGenUtils$.MODULE$.newName("valueArray");
                String indexTerm = CodeGenUtils$.MODULE$.newName("i");
                String numTerm = CodeGenUtils$.MODULE$.newName("num");
                LogicalType keyType = this.mt$1.getKeyType();
                String keyCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(keyType);
                String keyTerm = CodeGenUtils$.MODULE$.newName("key");
                String keyNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
                String keyCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " = ", ";\n             |boolean ", " = ", ".isNullAt(", ");\n             |if (!", ") {\n             |  ", " = (", ") ", ";\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyCls, keyTerm, CodeGenUtils$.MODULE$.primitiveDefaultValue(keyType), keyNullTerm, keyArrayTerm, indexTerm, keyNullTerm, keyTerm, keyCls, CodeGenUtils$.MODULE$.rowFieldReadAccess(this.ctx$7, indexTerm, keyArrayTerm, keyType)})))).stripMargin();
                GeneratedExpression keyExpr = new GeneratedExpression(keyTerm, keyNullTerm, keyCode, keyType, GeneratedExpression$.MODULE$.apply$default$5());
                GeneratedExpression keyCastExpr = ScalarOperatorGens$.MODULE$.generateCast(this.ctx$7, keyExpr, this.targetType$2);
                LogicalType valueType = this.mt$1.getValueType();
                String valueCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(valueType);
                String valueTerm = CodeGenUtils$.MODULE$.newName("value");
                String valueNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
                String valueCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " = ", ";\n             |boolean ", " = ", ".isNullAt(", ");\n             |if (!", ") {\n             |  ", " = (", ") ", ";\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{valueCls, valueTerm, CodeGenUtils$.MODULE$.primitiveDefaultValue(valueType), valueNullTerm, valueArrayTerm, indexTerm, valueNullTerm, valueTerm, valueCls, CodeGenUtils$.MODULE$.rowFieldReadAccess(this.ctx$7, indexTerm, valueArrayTerm, valueType)})))).stripMargin();
                GeneratedExpression valueExpr = new GeneratedExpression(valueTerm, valueNullTerm, valueCode, valueType, GeneratedExpression$.MODULE$.apply$default$5());
                GeneratedExpression valueCastExpr = ScalarOperatorGens$.MODULE$.generateCast(this.ctx$7, valueExpr, this.targetType$2);
                String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |String ", ";\n             |if (", " instanceof ", ") {\n             |  ", " ", " = (", ") ", ";\n             |  ", " ", " = ", ".keyArray();\n             |  ", " ", " = ", ".valueArray();\n             |\n             |  ", ".setLength(0);\n             |  ", ".append(\"{\");\n             |\n             |  int ", " = ", ".size();\n             |  for (int ", " = 0; ", " < ", "; ", "++) {\n             |    if (", " != 0) {\n             |      ", ".append(\", \");\n             |    }\n             |\n             |    ", "\n             |    if (", ") {\n             |      ", ".append(\"null\");\n             |    } else {\n             |      ", ".append(", ");\n             |    }\n             |    ", ".append(\"=\");\n             |\n             |    ", "\n             |    if (", ") {\n             |      ", ".append(\"null\");\n             |    } else {\n             |      ", ".append(", ");\n             |    }\n             |  }\n             |  ", ".append(\"}\");\n             |\n             |  ", " = ", ".toString();\n             |} else {\n             |  ", " ", " = (", ") ", ";\n             |  ", " = ", ".toString();\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTerm, mapTerm, CodeGenUtils$.MODULE$.BINARY_MAP(), CodeGenUtils$.MODULE$.BINARY_MAP(), binaryMapTerm, CodeGenUtils$.MODULE$.BINARY_MAP(), mapTerm, CodeGenUtils$.MODULE$.ARRAY_DATA(), keyArrayTerm, binaryMapTerm, CodeGenUtils$.MODULE$.ARRAY_DATA(), valueArrayTerm, binaryMapTerm, builderTerm, builderTerm, numTerm, binaryMapTerm, indexTerm, indexTerm, numTerm, indexTerm, indexTerm, builderTerm, keyCastExpr.code(), keyCastExpr.nullTerm(), builderTerm, builderTerm, keyCastExpr.resultTerm(), builderTerm, valueCastExpr.code(), valueCastExpr.nullTerm(), builderTerm, builderTerm, valueCastExpr.resultTerm(), builderTerm, resultTerm, builderTerm, CodeGenUtils$.MODULE$.GENERIC_MAP(), genericMapTerm, CodeGenUtils$.MODULE$.GENERIC_MAP(), mapTerm, resultTerm, genericMapTerm})))).stripMargin();
                return new Tuple2((Object)stmt, (Object)resultTerm);
            }
            {
                this.ctx$7 = ctx$7;
                this.mt$1 = mt$1;
                this.targetType$2 = targetType$2;
            }
        });
    }

    private GeneratedExpression generateCastRowDataToString(CodeGeneratorContext ctx, GeneratedExpression operand, RowType brt, LogicalType targetType) {
        return GenerateUtils$.MODULE$.generateStringResultCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, brt, targetType){
            public static final long serialVersionUID = 0L;
            public final CodeGeneratorContext ctx$8;
            private final RowType brt$1;
            public final LogicalType targetType$3;

            public final Tuple2<String, String> apply(Seq<String> terms) {
                String builderCls = java.lang.StringBuilder.class.getCanonicalName();
                String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
                this.ctx$8.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderCls, builderTerm, builderCls})));
                String rowTerm = (String)terms.head();
                String appendCode = ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(this.brt$1.getChildren()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, builderTerm, rowTerm){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.generateCastRowDataToString.1 $outer;
                    private final String builderTerm$1;
                    private final String rowTerm$2;

                    public final String apply(Tuple2<LogicalType, Object> x0$10) {
                        Tuple2<LogicalType, Object> tuple2 = x0$10;
                        if (tuple2 != null) {
                            LogicalType elementType = (LogicalType)tuple2._1();
                            int idx = tuple2._2$mcI$sp();
                            String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
                            String elementTerm = CodeGenUtils$.MODULE$.newName("element");
                            GeneratedExpression elementExpr = new GeneratedExpression(elementTerm, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".isNullAt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rowTerm$2, BoxesRunTime.boxToInteger((int)idx)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = (", ") ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elementCls, elementTerm, elementCls, CodeGenUtils$.MODULE$.rowFieldReadAccess(this.$outer.ctx$8, idx, this.rowTerm$2, elementType)})), elementType, GeneratedExpression$.MODULE$.apply$default$5());
                            GeneratedExpression castExpr = ScalarOperatorGens$.MODULE$.generateCast(this.$outer.ctx$8, elementExpr, this.$outer.targetType$3);
                            String string2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n               |", "\n               |if (", ") {\n               |  ", ".append(\"null\");\n               |} else {\n               |  ", ".append(", ");\n               |}\n               "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{idx != 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".append(\",\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.builderTerm$1})) : "", castExpr.code(), castExpr.nullTerm(), this.builderTerm$1, this.builderTerm$1, castExpr.resultTerm()})))).stripMargin();
                            return string2;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.builderTerm$1 = builderTerm$1;
                        this.rowTerm$2 = rowTerm$2;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).mkString("\n");
                String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", ".setLength(0);\n             |", ".append(\"(\");\n             |", "\n             |", ".append(\")\");\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderTerm, builderTerm, appendCode, builderTerm})))).stripMargin();
                return new Tuple2((Object)stmt, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toString()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builderTerm})));
            }
            {
                this.ctx$8 = ctx$8;
                this.brt$1 = brt$1;
                this.targetType$3 = targetType$3;
            }
        });
    }

    private GeneratedExpression generateArrayComparison(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        return GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, new BooleanType(), (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$4(), (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, left){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$4;
            private final GeneratedExpression left$4;

            public final Tuple2<String, String> apply(Seq<String> args) {
                String leftTerm = (String)args.head();
                String rightTerm = (String)args.apply(1);
                String resultTerm = CodeGenUtils$.MODULE$.newName("compareResult");
                LogicalType elementType = ((ArrayType)this.left$4.resultType()).getElementType();
                String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
                String elementDefault = CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType);
                String leftElementTerm = CodeGenUtils$.MODULE$.newName("leftElement");
                String leftElementNullTerm = CodeGenUtils$.MODULE$.newName("leftElementIsNull");
                GeneratedExpression leftElementExpr = new GeneratedExpression(leftElementTerm, leftElementNullTerm, "", elementType, GeneratedExpression$.MODULE$.apply$default$5());
                String rightElementTerm = CodeGenUtils$.MODULE$.newName("rightElement");
                String rightElementNullTerm = CodeGenUtils$.MODULE$.newName("rightElementIsNull");
                GeneratedExpression rightElementExpr = new GeneratedExpression(rightElementTerm, rightElementNullTerm, "", elementType, GeneratedExpression$.MODULE$.apply$default$5());
                String indexTerm = CodeGenUtils$.MODULE$.newName("index");
                GeneratedExpression elementEqualsExpr = ScalarOperatorGens$.MODULE$.generateEquals(this.ctx$4, leftElementExpr, rightElementExpr);
                String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |boolean ", ";\n             |if (", " instanceof ", " && ", " instanceof ", ") {\n             |  ", " = ", ".equals(", ");\n             |} else {\n             |  if (", ".size() == ", ".size()) {\n             |    ", " = true;\n             |    for (int ", " = 0; ", " < ", ".size(); ", "++) {\n             |      ", " ", " = ", ";\n             |      boolean ", " = ", ".isNullAt(", ");\n             |      if (!", ") {\n             |        ", " =\n             |          ", ";\n             |      }\n             |\n             |      ", " ", " = ", ";\n             |      boolean ", " = ", ".isNullAt(", ");\n             |      if (!", ") {\n             |        ", " =\n             |          ", ";\n             |      }\n             |\n             |      ", "\n             |      if (!", ") {\n             |        ", " = false;\n             |        break;\n             |      }\n             |    }\n             |  } else {\n             |    ", " = false;\n             |  }\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTerm, leftTerm, CodeGenUtils$.MODULE$.BINARY_ARRAY(), rightTerm, CodeGenUtils$.MODULE$.BINARY_ARRAY(), resultTerm, leftTerm, rightTerm, leftTerm, rightTerm, resultTerm, indexTerm, indexTerm, leftTerm, indexTerm, elementCls, leftElementTerm, elementDefault, leftElementNullTerm, leftTerm, indexTerm, leftElementNullTerm, leftElementTerm, CodeGenUtils$.MODULE$.rowFieldReadAccess(this.ctx$4, indexTerm, leftTerm, elementType), elementCls, rightElementTerm, elementDefault, rightElementNullTerm, rightTerm, indexTerm, rightElementNullTerm, rightElementTerm, CodeGenUtils$.MODULE$.rowFieldReadAccess(this.ctx$4, indexTerm, rightTerm, elementType), elementEqualsExpr.code(), elementEqualsExpr.resultTerm(), resultTerm, resultTerm})))).stripMargin();
                return new Tuple2((Object)stmt, (Object)resultTerm);
            }
            {
                this.ctx$4 = ctx$4;
                this.left$4 = left$4;
            }
        });
    }

    private GeneratedExpression generateMapComparison(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, LogicalType keyType, LogicalType valueType) {
        return GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, new BooleanType(), (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$4(), (Function1<Seq<String>, Tuple2<String, String>>)new Serializable(ctx, keyType, valueType){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$5;
            private final LogicalType keyType$1;
            private final LogicalType valueType$1;

            public final Tuple2<String, String> apply(Seq<String> args) {
                String leftTerm = (String)args.head();
                String rightTerm = (String)args.apply(1);
                String resultTerm = CodeGenUtils$.MODULE$.newName("compareResult");
                String mapCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any())})));
                String keyCls = CodeGenUtils$.MODULE$.boxedTypeTermForType(this.keyType$1);
                String valueCls = CodeGenUtils$.MODULE$.boxedTypeTermForType(this.valueType$1);
                String leftMapTerm = CodeGenUtils$.MODULE$.newName("leftMap");
                String leftKeyTerm = CodeGenUtils$.MODULE$.newName("leftKey");
                String leftValueTerm = CodeGenUtils$.MODULE$.newName("leftValue");
                String leftValueNullTerm = CodeGenUtils$.MODULE$.newName("leftValueIsNull");
                GeneratedExpression leftValueExpr = new GeneratedExpression(leftValueTerm, leftValueNullTerm, "", this.valueType$1, GeneratedExpression$.MODULE$.apply$default$5());
                String rightMapTerm = CodeGenUtils$.MODULE$.newName("rightMap");
                String rightValueTerm = CodeGenUtils$.MODULE$.newName("rightValue");
                String rightValueNullTerm = CodeGenUtils$.MODULE$.newName("rightValueIsNull");
                GeneratedExpression rightValueExpr = new GeneratedExpression(rightValueTerm, rightValueNullTerm, "", this.valueType$1, GeneratedExpression$.MODULE$.apply$default$5());
                String entryTerm = CodeGenUtils$.MODULE$.newName("entry");
                String entryCls = Map.Entry.class.getCanonicalName();
                GeneratedExpression valueEqualsExpr = ScalarOperatorGens$.MODULE$.generateEquals(this.ctx$5, leftValueExpr, rightValueExpr);
                String internalTypeCls = LogicalType.class.getCanonicalName();
                String keyTypeTerm = this.ctx$5.addReusableObject(this.keyType$1, "keyType", internalTypeCls);
                String valueTypeTerm = this.ctx$5.addReusableObject(this.valueType$1, "valueType", internalTypeCls);
                String mapDataUtil = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(MapDataUtil.class));
                String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |boolean ", ";\n             |if (", ".size() == ", ".size()) {\n             |  ", " = true;\n             |  ", " ", " = ", "\n             |      .convertToJavaMap(", ", ", ", ", ");\n             |  ", " ", " = ", "\n             |      .convertToJavaMap(", ", ", ", ", ");\n             |\n             |  for (", " ", " : ", ".entrySet()) {\n             |    ", " ", " = (", ") ", ".getKey();\n             |    if (", ".containsKey(", ")) {\n             |      ", " ", " = (", ") ", ".getValue();\n             |      ", " ", " = (", ") ", ".get(", ");\n             |      boolean ", " = (", " == null);\n             |      boolean ", " = (", " == null);\n             |\n             |      ", "\n             |      if (!", ") {\n             |        ", " = false;\n             |        break;\n             |      }\n             |    } else {\n             |      ", " = false;\n             |      break;\n             |    }\n             |  }\n             |} else {\n             |  ", " = false;\n             |}\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultTerm, leftTerm, rightTerm, resultTerm, mapCls, leftMapTerm, mapDataUtil, leftTerm, keyTypeTerm, valueTypeTerm, mapCls, rightMapTerm, mapDataUtil, rightTerm, keyTypeTerm, valueTypeTerm, entryCls, entryTerm, leftMapTerm, keyCls, leftKeyTerm, keyCls, entryTerm, rightMapTerm, leftKeyTerm, valueCls, leftValueTerm, valueCls, entryTerm, valueCls, rightValueTerm, valueCls, rightMapTerm, leftKeyTerm, leftValueNullTerm, leftValueTerm, rightValueNullTerm, rightValueTerm, valueEqualsExpr.code(), valueEqualsExpr.resultTerm(), resultTerm, resultTerm, resultTerm})))).stripMargin();
                return new Tuple2((Object)stmt, (Object)resultTerm);
            }
            {
                this.ctx$5 = ctx$5;
                this.keyType$1 = keyType$1;
                this.valueType$1 = valueType$1;
            }
        });
    }

    private GeneratedExpression generateUnaryOperatorIfNotNull(CodeGeneratorContext ctx, LogicalType returnType, GeneratedExpression operand, boolean resultNullable, Function1<String, String> expr) {
        return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), resultNullable, (Function1<Seq<String>, String>)new Serializable(expr){
            public static final long serialVersionUID = 0L;
            private final Function1 expr$2;

            public final String apply(Seq<String> args) {
                return (String)this.expr$2.apply(args.head());
            }
            {
                this.expr$2 = expr$2;
            }
        });
    }

    private boolean generateUnaryOperatorIfNotNull$default$4() {
        return false;
    }

    private GeneratedExpression generateOperatorIfNotNull(CodeGeneratorContext ctx, LogicalType returnType, GeneratedExpression left, GeneratedExpression right, boolean resultNullable, Function2<String, String, String> expr) {
        return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), resultNullable, (Function1<Seq<String>, String>)new Serializable(expr){
            public static final long serialVersionUID = 0L;
            private final Function2 expr$1;

            public final String apply(Seq<String> args) {
                return (String)this.expr$1.apply(args.head(), args.apply(1));
            }
            {
                this.expr$1 = expr$1;
            }
        });
    }

    private boolean generateOperatorIfNotNull$default$5() {
        return false;
    }

    private GeneratedExpression internalExprCasting(GeneratedExpression expr, LogicalType targetType) {
        LogicalType x$48 = targetType;
        String x$49 = expr.copy$default$1();
        String x$50 = expr.copy$default$2();
        String x$51 = expr.copy$default$3();
        Option<Object> x$52 = expr.copy$default$5();
        return expr.copy(x$49, x$50, x$51, x$48, x$52);
    }

    public Function1<String, String> org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$numericCasting(LogicalType operandType, LogicalType resultType2) {
        block8: {
            Object object;
            block3: {
                String resultTypeTerm;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType2);
                                    if (!PlannerTypeUtils.isInteroperable(operandType, resultType2)) break block2;
                                    object = new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String operandTerm) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
                                        }
                                    };
                                    break block3;
                                }
                                if (!TypeCheckUtils.isDecimal(resultType2) || !TypeCheckUtils.isDecimal(operandType)) break block4;
                                DecimalType dt = (DecimalType)resultType2;
                                object = new Serializable(dt){
                                    public static final long serialVersionUID = 0L;
                                    private final DecimalType dt$2;

                                    public final String apply(String operandTerm) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".castToDecimal(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.DECIMAL_UTIL(), operandTerm, BoxesRunTime.boxToInteger((int)this.dt$2.getPrecision()), BoxesRunTime.boxToInteger((int)this.dt$2.getScale())}));
                                    }
                                    {
                                        this.dt$2 = dt$2;
                                    }
                                };
                                break block3;
                            }
                            if (!TypeCheckUtils.isDecimal(resultType2) || !TypeCheckUtils.isNumeric(operandType)) break block5;
                            DecimalType dt = (DecimalType)resultType2;
                            object = new Serializable(dt){
                                public static final long serialVersionUID = 0L;
                                private final DecimalType dt$3;

                                public final String apply(String operandTerm) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".castFrom(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.DECIMAL_UTIL(), operandTerm, BoxesRunTime.boxToInteger((int)this.dt$3.getPrecision()), BoxesRunTime.boxToInteger((int)this.dt$3.getScale())}));
                                }
                                {
                                    this.dt$3 = dt$3;
                                }
                            };
                            break block3;
                        }
                        if (!TypeCheckUtils.isNumeric(resultType2) || !TypeCheckUtils.isDecimal(operandType)) break block6;
                        object = new Serializable(resultType2){
                            public static final long serialVersionUID = 0L;
                            private final LogicalType resultType$3;

                            public final String apply(String operandTerm) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.DECIMAL_UTIL(), ScalarOperatorGens$.MODULE$.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$decToPrimMethod$1(this.resultType$3), operandTerm}));
                            }
                            {
                                this.resultType$3 = resultType$3;
                            }
                        };
                        break block3;
                    }
                    if (!TypeCheckUtils.isNumeric(operandType) || !TypeCheckUtils.isNumeric(resultType2)) break block7;
                    String resultTypeValue = new StringBuilder().append((Object)resultTypeTerm).append((Object)"Value()").toString();
                    String boxedTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(operandType);
                    object = new Serializable(resultTypeValue, boxedTypeTerm){
                        public static final long serialVersionUID = 0L;
                        private final String resultTypeValue$1;
                        private final String boxedTypeTerm$1;

                        public final String apply(String operandTerm) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(new ", "(", ")).", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.boxedTypeTerm$1, operandTerm, this.resultTypeValue$1}));
                        }
                        {
                            this.resultTypeValue$1 = resultTypeValue$1;
                            this.boxedTypeTerm$1 = boxedTypeTerm$1;
                        }
                    };
                    break block3;
                }
                if (!TypeCheckUtils.isTimeInterval(resultType2) || !TypeCheckUtils.isInteger(operandType)) break block8;
                object = new Serializable(resultTypeTerm){
                    public static final long serialVersionUID = 0L;
                    private final String resultTypeTerm$3;

                    public final String apply(String operandTerm) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((", ") ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.resultTypeTerm$3, operandTerm}));
                    }
                    {
                        this.resultTypeTerm$3 = resultTypeTerm$3;
                    }
                };
            }
            return object;
        }
        throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported casting from ", " to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandType, resultType2})));
    }

    public String org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$localTimeToStringCode(CodeGeneratorContext ctx, LogicalType fromType, String operandTerm) {
        LogicalTypeRoot logicalTypeRoot;
        block6: {
            String string2;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            logicalTypeRoot = fromType.getTypeRoot();
                            if (!((Object)((Object)LogicalTypeRoot.DATE)).equals((Object)logicalTypeRoot)) break block2;
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.UNIX_DATE_TO_STRING.method), operandTerm}));
                            break block3;
                        }
                        if (!((Object)((Object)LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE)).equals((Object)logicalTypeRoot)) break block4;
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.UNIX_TIME_TO_STRING()), operandTerm}));
                        break block3;
                    }
                    if (!((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)logicalTypeRoot)) break block5;
                    int precision = ((TimestampType)fromType).getPrecision();
                    string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_TO_STRING()), operandTerm, BoxesRunTime.boxToInteger((int)precision)}));
                    break block3;
                }
                if (!((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).equals((Object)logicalTypeRoot)) break block6;
                String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_TO_STRING_TIME_ZONE());
                String zone = ctx.addReusableSessionTimeZone();
                int precision = ((LocalZonedTimestampType)fromType).getPrecision();
                string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{method, operandTerm, zone, BoxesRunTime.boxToInteger((int)precision)}));
            }
            return string2;
        }
        throw new MatchError((Object)logicalTypeRoot);
    }

    public final Function1 org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$castToDec$1(LogicalType t, DecimalType resultType$2) {
        LogicalType logicalType = t;
        Serializable serializable = logicalType instanceof DecimalType ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String operandTerm) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandTerm}));
            }
        } : this.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$numericCasting(t, resultType$2);
        return serializable;
    }

    public final String org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$castIfNumeric$1(GeneratedExpression t, Option widerType$1) {
        return TypeCheckUtils.isNumeric((LogicalType)widerType$1.get()) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$numericCasting(t.resultType(), (LogicalType)widerType$1.get()).apply((Object)t.resultTerm())})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.resultTerm()}));
    }

    public final String org$apache$flink$table$planner$codegen$calls$ScalarOperatorGens$$decToPrimMethod$1(LogicalType targetType) {
        block9: {
            String string2;
            block3: {
                LogicalTypeRoot logicalTypeRoot;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        logicalTypeRoot = targetType.getTypeRoot();
                                        if (!((Object)((Object)LogicalTypeRoot.TINYINT)).equals((Object)logicalTypeRoot)) break block2;
                                        string2 = "castToByte";
                                        break block3;
                                    }
                                    if (!((Object)((Object)LogicalTypeRoot.SMALLINT)).equals((Object)logicalTypeRoot)) break block4;
                                    string2 = "castToShort";
                                    break block3;
                                }
                                if (!((Object)((Object)LogicalTypeRoot.INTEGER)).equals((Object)logicalTypeRoot)) break block5;
                                string2 = "castToInt";
                                break block3;
                            }
                            if (!((Object)((Object)LogicalTypeRoot.BIGINT)).equals((Object)logicalTypeRoot)) break block6;
                            string2 = "castToLong";
                            break block3;
                        }
                        if (!((Object)((Object)LogicalTypeRoot.FLOAT)).equals((Object)logicalTypeRoot)) break block7;
                        string2 = "castToFloat";
                        break block3;
                    }
                    if (!((Object)((Object)LogicalTypeRoot.DOUBLE)).equals((Object)logicalTypeRoot)) break block8;
                    string2 = "castToDouble";
                    break block3;
                }
                if (!((Object)((Object)LogicalTypeRoot.BOOLEAN)).equals((Object)logicalTypeRoot)) break block9;
                string2 = "castToBoolean";
            }
            return string2;
        }
        throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported decimal casting type: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetType})));
    }

    private ScalarOperatorGens$() {
        MODULE$ = this;
    }
}

