/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.expressions.utils.ResolvedExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SortQueryOperation;

@Internal
final class SortOperationFactory {
    SortOperationFactory() {
    }

    QueryOperation createSort(List<ResolvedExpression> orders, QueryOperation child, ExpressionResolver.PostResolverFactory postResolverFactory) {
        OrderWrapper orderWrapper = new OrderWrapper(postResolverFactory);
        List<ResolvedExpression> convertedOrders = orders.stream().map(f -> f.accept(orderWrapper)).collect(Collectors.toList());
        return new SortQueryOperation(convertedOrders, child);
    }

    QueryOperation createLimitWithOffset(int offset, QueryOperation child, ExpressionResolver.PostResolverFactory postResolverFactory) {
        SortQueryOperation previousSort = this.validateAndGetChildSort(child, postResolverFactory);
        if (offset < 0) {
            throw new ValidationException("Offset should be greater or equal 0");
        }
        if (previousSort.getOffset() != -1) {
            throw new ValidationException("OFFSET already defined");
        }
        return new SortQueryOperation(previousSort.getOrder(), previousSort.getChild(), offset, -1);
    }

    QueryOperation createLimitWithFetch(int fetch, QueryOperation child, ExpressionResolver.PostResolverFactory postResolverFactory) {
        SortQueryOperation previousSort = this.validateAndGetChildSort(child, postResolverFactory);
        if (fetch < 0) {
            throw new ValidationException("Fetch should be greater or equal 0");
        }
        int offset = Math.max(previousSort.getOffset(), 0);
        return new SortQueryOperation(previousSort.getOrder(), previousSort.getChild(), offset, fetch);
    }

    private SortQueryOperation validateAndGetChildSort(QueryOperation child, ExpressionResolver.PostResolverFactory postResolverFactory) {
        SortQueryOperation previousSort = child instanceof SortQueryOperation ? (SortQueryOperation)child : (SortQueryOperation)this.createSort(Collections.emptyList(), child, postResolverFactory);
        if (previousSort.getFetch() != -1) {
            throw new ValidationException("FETCH is already defined.");
        }
        return previousSort;
    }

    private static class OrderWrapper
    extends ResolvedExpressionDefaultVisitor<ResolvedExpression> {
        private ExpressionResolver.PostResolverFactory postResolverFactory;

        OrderWrapper(ExpressionResolver.PostResolverFactory postResolverFactory) {
            this.postResolverFactory = postResolverFactory;
        }

        @Override
        public ResolvedExpression visit(CallExpression call) {
            if (BuiltInFunctionDefinitions.ORDERING.contains(call.getFunctionDefinition())) {
                return call;
            }
            return this.defaultMethod(call);
        }

        @Override
        protected ResolvedExpression defaultMethod(ResolvedExpression expression2) {
            return this.postResolverFactory.wrappingCall(BuiltInFunctionDefinitions.ORDER_ASC, expression2);
        }
    }
}

