/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.sql.Timestamp;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;

@Internal
public final class TemporalTableFunctionImpl
extends TemporalTableFunction {
    private final transient QueryOperation underlyingHistoryTable;
    private final transient Expression timeAttribute;
    private final transient Expression primaryKey;
    private final RowTypeInfo resultType;

    private TemporalTableFunctionImpl(QueryOperation underlyingHistoryTable, Expression timeAttribute, Expression primaryKey, RowTypeInfo resultType2) {
        this.underlyingHistoryTable = underlyingHistoryTable;
        this.timeAttribute = timeAttribute;
        this.primaryKey = primaryKey;
        this.resultType = resultType2;
    }

    public void eval(Timestamp t) {
        throw new IllegalStateException("This should never be called");
    }

    public Expression getTimeAttribute() {
        return this.timeAttribute;
    }

    public Expression getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        TableSchema tableSchema = TableSchema.fromResolvedSchema(this.underlyingHistoryTable.getResolvedSchema());
        return TypeInference.newBuilder().inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.explicit(DataTypes.TIMESTAMP(3))), InputTypeStrategies.sequence(InputTypeStrategies.explicit(DataTypes.TIMESTAMP_LTZ(3))))).outputTypeStrategy(TypeStrategies.explicit(tableSchema.toRowDataType())).build();
    }

    public RowTypeInfo getResultType() {
        return this.resultType;
    }

    public QueryOperation getUnderlyingHistoryTable() {
        if (this.underlyingHistoryTable == null) {
            throw new IllegalStateException("Accessing table field after planing/serialization");
        }
        return this.underlyingHistoryTable;
    }

    public static TemporalTableFunction create(QueryOperation operationTree, Expression timeAttribute, Expression primaryKey) {
        TableSchema tableSchema = TableSchema.fromResolvedSchema(operationTree.getResolvedSchema());
        return new TemporalTableFunctionImpl(operationTree, timeAttribute, primaryKey, new RowTypeInfo(tableSchema.getFieldTypes(), tableSchema.getFieldNames()));
    }
}

