/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.table.filesystem.RowPartitionComputer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.utils.PartitionPathUtils;

@FunctionalInterface
public interface PartitionFieldExtractor<T extends FileSourceSplit>
extends Serializable {
    public Object extract(T var1, String var2, LogicalType var3);

    public static PartitionFieldExtractor<FileSourceSplit> forFileSystem(String defaultPartValue) {
        return (split2, fieldName, fieldType) -> {
            LinkedHashMap<String, String> partitionSpec = PartitionPathUtils.extractPartitionSpecFromPath(split2.path());
            if (!partitionSpec.containsKey(fieldName)) {
                throw new RuntimeException("Cannot find the partition value from path for partition: " + fieldName);
            }
            String valueStr = partitionSpec.get(fieldName);
            valueStr = valueStr.equals(defaultPartValue) ? null : valueStr;
            return RowPartitionComputer.restorePartValueFromType(valueStr, fieldType);
        };
    }
}

