/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.filesystem.PartitionTimeExtractor;

public class DefaultPartTimeExtractor
implements PartitionTimeExtractor {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NORMAL).optionalStart().appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NORMAL).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.LENIENT);
    private static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NORMAL).toFormatter().withResolverStyle(ResolverStyle.LENIENT);
    @Nullable
    private final String pattern;

    public DefaultPartTimeExtractor(@Nullable String pattern) {
        this.pattern = pattern;
    }

    @Override
    public LocalDateTime extract(List<String> partitionKeys, List<String> partitionValues) {
        String timestampString;
        if (this.pattern == null) {
            timestampString = partitionValues.get(0);
        } else {
            timestampString = this.pattern;
            for (int i = 0; i < partitionKeys.size(); ++i) {
                timestampString = timestampString.replaceAll("\\$" + partitionKeys.get(i), partitionValues.get(i));
            }
        }
        return DefaultPartTimeExtractor.toLocalDateTime(timestampString);
    }

    public static LocalDateTime toLocalDateTime(String timestampString) {
        try {
            return LocalDateTime.parse(timestampString, TIMESTAMP_FORMATTER);
        }
        catch (DateTimeParseException e) {
            return LocalDateTime.of(LocalDate.parse(timestampString, DATE_FORMATTER), LocalTime.MIDNIGHT);
        }
    }

    public static long toMills(LocalDateTime dateTime) {
        return TimestampData.fromLocalDateTime(dateTime).getMillisecond();
    }

    public static long toMills(String timestampString) {
        return DefaultPartTimeExtractor.toMills(DefaultPartTimeExtractor.toLocalDateTime(timestampString));
    }
}

