/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.ValueDataTypeConverter;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public final class ValueLiteralExpression
implements ResolvedExpression {
    @Nullable
    private final Object value;
    private final DataType dataType;

    public ValueLiteralExpression(@Nonnull Object value2) {
        this(value2, ValueLiteralExpression.deriveDataTypeFromValue(value2));
    }

    public ValueLiteralExpression(@Nullable Object value2, DataType dataType2) {
        ValueLiteralExpression.validateValueDataType(value2, (DataType)Preconditions.checkNotNull((Object)dataType2, (String)"Data type must not be null."));
        this.value = value2;
        this.dataType = dataType2;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public <T> Optional<T> getValueAs(Class<T> clazz) {
        Preconditions.checkArgument((!clazz.isPrimitive() ? 1 : 0) != 0);
        if (this.value == null) {
            return Optional.empty();
        }
        Serializable convertedValue = null;
        if (clazz.isInstance(this.value)) {
            convertedValue = (Serializable)clazz.cast(this.value);
        } else {
            Class<?> valueClass = this.value.getClass();
            if (clazz == Period.class) {
                convertedValue = this.convertToPeriod(this.value, valueClass);
            } else if (clazz == Duration.class) {
                convertedValue = this.convertToDuration(this.value, valueClass);
            } else if (clazz == LocalDate.class) {
                convertedValue = this.convertToLocalDate(this.value, valueClass);
            } else if (clazz == LocalTime.class) {
                convertedValue = this.convertToLocalTime(this.value, valueClass);
            } else if (clazz == LocalDateTime.class) {
                convertedValue = this.convertToLocalDateTime(this.value, valueClass);
            } else if (clazz == OffsetDateTime.class) {
                convertedValue = this.convertToOffsetDateTime(this.value, valueClass);
            } else if (clazz == Instant.class) {
                convertedValue = this.convertToInstant(this.value, valueClass);
            } else if (clazz == BigDecimal.class) {
                convertedValue = this.convertToBigDecimal(this.value);
            }
        }
        return Optional.ofNullable(convertedValue);
    }

    @Nullable
    private LocalDate convertToLocalDate(Object value2, Class<?> valueClass) {
        if (valueClass == Date.class) {
            return ((Date)value2).toLocalDate();
        }
        if (valueClass == Integer.class) {
            return LocalDate.ofEpochDay(((Integer)value2).intValue());
        }
        return null;
    }

    @Nullable
    private LocalTime convertToLocalTime(Object value2, Class<?> valueClass) {
        if (valueClass == Time.class) {
            return ((Time)value2).toLocalTime();
        }
        if (valueClass == Integer.class) {
            return LocalTime.ofNanoOfDay((long)((Integer)value2).intValue() * 1000000L);
        }
        if (valueClass == Long.class) {
            return LocalTime.ofNanoOfDay((Long)value2);
        }
        return null;
    }

    @Nullable
    private LocalDateTime convertToLocalDateTime(Object value2, Class<?> valueClass) {
        if (valueClass == Timestamp.class) {
            return ((Timestamp)value2).toLocalDateTime();
        }
        return null;
    }

    @Nullable
    private OffsetDateTime convertToOffsetDateTime(Object value2, Class<?> valueClass) {
        if (valueClass == ZonedDateTime.class) {
            return ((ZonedDateTime)value2).toOffsetDateTime();
        }
        return null;
    }

    @Nullable
    private Instant convertToInstant(Object value2, Class<?> valueClass) {
        if (valueClass == Integer.class) {
            return Instant.ofEpochSecond(((Integer)value2).intValue());
        }
        if (valueClass == Long.class) {
            return Instant.ofEpochMilli((Long)value2);
        }
        return null;
    }

    @Nullable
    private Duration convertToDuration(Object value2, Class<?> valueClass) {
        if (valueClass == Long.class) {
            Long longValue = (Long)value2;
            return Duration.ofMillis(longValue);
        }
        return null;
    }

    @Nullable
    private Period convertToPeriod(Object value2, Class<?> valueClass) {
        if (valueClass == Integer.class) {
            Integer integer = (Integer)value2;
            return Period.ofMonths(integer);
        }
        return null;
    }

    @Nullable
    private BigDecimal convertToBigDecimal(Object value2) {
        if (Number.class.isAssignableFrom(value2.getClass())) {
            return new BigDecimal(String.valueOf(value2));
        }
        return null;
    }

    @Override
    public DataType getOutputDataType() {
        return this.dataType;
    }

    @Override
    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    @Override
    public String asSummaryString() {
        return ValueLiteralExpression.stringifyValue(this.value);
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueLiteralExpression that = (ValueLiteralExpression)o;
        return Objects.deepEquals(this.value, that.value) && this.dataType.equals(that.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.dataType);
    }

    public String toString() {
        return this.asSummaryString();
    }

    private static DataType deriveDataTypeFromValue(Object value2) {
        return ValueDataTypeConverter.extractDataType(value2).orElseThrow(() -> new ValidationException("Cannot derive a data type for value '" + value2 + "'. The data type must be specified explicitly."));
    }

    private static void validateValueDataType(Object value2, DataType dataType2) {
        LogicalType logicalType = dataType2.getLogicalType();
        if (value2 == null) {
            if (!logicalType.isNullable()) {
                throw new ValidationException(String.format("Data type '%s' does not support null values.", dataType2));
            }
            return;
        }
        if (logicalType.isNullable()) {
            throw new ValidationException("Literals that have a non-null value must not have a nullable data type.");
        }
        Class<?> candidate = value2.getClass();
        if (!dataType2.getConversionClass().isAssignableFrom(candidate)) {
            throw new ValidationException(String.format("Data type '%s' with conversion class '%s' does not support a value literal of class '%s'.", dataType2, dataType2.getConversionClass().getName(), value2.getClass().getName()));
        }
        if (!logicalType.supportsInputConversion(candidate)) {
            throw new ValidationException(String.format("Data type '%s' does not support a conversion from class '%s'.", dataType2, candidate.getName()));
        }
    }

    private static String stringifyValue(Object value2) {
        if (value2 instanceof String[]) {
            String[] array = (String[])value2;
            return Stream.of(array).map(ValueLiteralExpression::stringifyValue).collect(Collectors.joining(", ", "[", "]"));
        }
        if (value2 instanceof Object[]) {
            Object[] array = (Object[])value2;
            return Stream.of(array).map(ValueLiteralExpression::stringifyValue).collect(Collectors.joining(", ", "[", "]"));
        }
        if (value2 instanceof String) {
            return "'" + ((String)value2).replace("'", "''") + "'";
        }
        return StringUtils.arrayAwareToString((Object)value2);
    }
}

