/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.Rowtime;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.UnresolvedUserDefinedType;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.TypeStringUtils;

@Deprecated
@PublicEvolving
public class Schema
implements Descriptor {
    public static final String SCHEMA = "schema";
    public static final String SCHEMA_NAME = "name";
    @Deprecated
    public static final String SCHEMA_TYPE = "type";
    public static final String SCHEMA_DATA_TYPE = "data-type";
    public static final String SCHEMA_PROCTIME = "proctime";
    public static final String SCHEMA_FROM = "from";
    private final Map<String, LinkedHashMap<String, String>> tableSchema = new LinkedHashMap<String, LinkedHashMap<String, String>>();
    private String lastField;

    public Schema schema(TableSchema schema) {
        this.tableSchema.clear();
        this.lastField = null;
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            this.field(schema.getFieldName(i).get(), schema.getFieldDataType(i).get());
        }
        return this;
    }

    public Schema field(String fieldName, DataType fieldType) {
        this.addField(fieldName, fieldType.getLogicalType().asSerializableString());
        return this;
    }

    @Deprecated
    public Schema field(String fieldName, TypeInformation<?> fieldType) {
        this.field(fieldName, TypeConversions.fromLegacyInfoToDataType(fieldType));
        return this;
    }

    public Schema field(String fieldName, String fieldType) {
        if (Schema.isLegacyTypeString(fieldType)) {
            TypeInformation<?> typeInfo = TypeStringUtils.readTypeInfo(fieldType);
            return this.field(fieldName, TypeConversions.fromLegacyInfoToDataType(typeInfo));
        }
        return this.addField(fieldName, fieldType);
    }

    private Schema addField(String fieldName, String fieldType) {
        if (this.tableSchema.containsKey(fieldName)) {
            throw new ValidationException("Duplicate field name " + fieldName + ".");
        }
        LinkedHashMap<String, String> fieldProperties = new LinkedHashMap<String, String>();
        fieldProperties.put(SCHEMA_DATA_TYPE, fieldType);
        this.tableSchema.put(fieldName, fieldProperties);
        this.lastField = fieldName;
        return this;
    }

    private static boolean isLegacyTypeString(String fieldType) {
        try {
            LogicalType type = LogicalTypeParser.parse(fieldType);
            return type instanceof UnresolvedUserDefinedType;
        }
        catch (Exception e) {
            return true;
        }
    }

    public Schema from(String originFieldName) {
        if (this.lastField == null) {
            throw new ValidationException("No field previously defined. Use field() before.");
        }
        this.tableSchema.get(this.lastField).put(SCHEMA_FROM, originFieldName);
        this.lastField = null;
        return this;
    }

    public Schema proctime() {
        if (this.lastField == null) {
            throw new ValidationException("No field defined previously. Use field() before.");
        }
        this.tableSchema.get(this.lastField).put(SCHEMA_PROCTIME, "true");
        this.lastField = null;
        return this;
    }

    public Schema rowtime(Rowtime rowtime2) {
        if (this.lastField == null) {
            throw new ValidationException("No field defined previously. Use field() before.");
        }
        this.tableSchema.get(this.lastField).putAll(rowtime2.toProperties());
        this.lastField = null;
        return this;
    }

    @Override
    public Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        ArrayList<Map<String, String>> subKeyValues = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, LinkedHashMap<String, String>> entry : this.tableSchema.entrySet()) {
            String name = entry.getKey();
            LinkedHashMap<String, String> props = entry.getValue();
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put(SCHEMA_NAME, name);
            map2.putAll(props);
            subKeyValues.add(map2);
        }
        properties.putIndexedVariableProperties(SCHEMA, subKeyValues);
        return properties.asMap();
    }
}

