/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.vector.heap;

import java.util.Arrays;
import org.apache.flink.table.data.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.vector.writable.WritableLongVector;

public class HeapLongVector
extends AbstractHeapVector
implements WritableLongVector {
    private static final long serialVersionUID = 8534925169458006397L;
    public long[] vector;

    public HeapLongVector(int len) {
        super(len);
        this.vector = new long[len];
    }

    @Override
    public long getLong(int i) {
        if (this.dictionary == null) {
            return this.vector[i];
        }
        return this.dictionary.decodeToLong(this.dictionaryIds.vector[i]);
    }

    @Override
    public void setLong(int i, long value2) {
        this.vector[i] = value2;
    }

    @Override
    public void setLongsFromBinary(int rowId, int count, byte[] src, int srcIndex) {
        if (rowId + count > this.vector.length || (long)srcIndex + (long)count * 8L > (long)src.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds, row id is %s, count is %s, binary src index is %s, binary length is %s, long array src index is %s, long array length is %s.", rowId, count, srcIndex, src.length, rowId, this.vector.length));
        }
        if (LITTLE_ENDIAN) {
            UNSAFE.copyMemory(src, BYTE_ARRAY_OFFSET + srcIndex, this.vector, (long)LONG_ARRAY_OFFSET + (long)rowId * 8L, (long)count * 8L);
        } else {
            long srcOffset = srcIndex + BYTE_ARRAY_OFFSET;
            int i = 0;
            while (i < count) {
                this.vector[i + rowId] = Long.reverseBytes(UNSAFE.getLong(src, srcOffset));
                ++i;
                srcOffset += 8L;
            }
        }
    }

    @Override
    public void fill(long value2) {
        Arrays.fill(this.vector, value2);
    }
}

