/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.vector.heap;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.flink.table.data.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.vector.writable.WritableDoubleVector;

public class HeapDoubleVector
extends AbstractHeapVector
implements WritableDoubleVector {
    private static final long serialVersionUID = 6193940154117411328L;
    public double[] vector;

    public HeapDoubleVector(int len) {
        super(len);
        this.vector = new double[len];
    }

    @Override
    public double getDouble(int i) {
        if (this.dictionary == null) {
            return this.vector[i];
        }
        return this.dictionary.decodeToDouble(this.dictionaryIds.vector[i]);
    }

    @Override
    public void setDouble(int i, double value2) {
        this.vector[i] = value2;
    }

    @Override
    public void setDoublesFromBinary(int rowId, int count, byte[] src, int srcIndex) {
        if (rowId + count > this.vector.length || (long)srcIndex + (long)count * 8L > (long)src.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds, row id is %s, count is %s, binary src index is %s, binary length is %s, double array src index is %s, double array length is %s.", rowId, count, srcIndex, src.length, rowId, this.vector.length));
        }
        if (LITTLE_ENDIAN) {
            UNSAFE.copyMemory(src, BYTE_ARRAY_OFFSET + srcIndex, this.vector, (long)DOUBLE_ARRAY_OFFSET + (long)rowId * 8L, (long)count * 8L);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(src).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                this.vector[i + rowId] = bb.getDouble(srcIndex + 8 * i);
            }
        }
    }

    @Override
    public void fill(double value2) {
        Arrays.fill(this.vector, value2);
    }
}

