/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.compiler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.State;
import org.apache.flink.cep.nfa.StateTransition;
import org.apache.flink.cep.nfa.StateTransitionAction;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.compiler.NFAStateNameHandler;
import org.apache.flink.cep.pattern.GroupPattern;
import org.apache.flink.cep.pattern.MalformedPatternException;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.cep.pattern.conditions.BooleanConditions;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.RichAndCondition;
import org.apache.flink.cep.pattern.conditions.RichNotCondition;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.util.Preconditions;

public class NFACompiler {
    protected static final String ENDING_STATE_NAME = "$endState$";

    public static <T> NFAFactory<T> compileFactory(Pattern<T, ?> pattern, boolean timeoutHandling) {
        if (pattern == null) {
            return new NFAFactoryImpl(0L, Collections.emptyList(), timeoutHandling);
        }
        NFAFactoryCompiler<T> nfaFactoryCompiler = new NFAFactoryCompiler<T>(pattern);
        nfaFactoryCompiler.compileFactory();
        return new NFAFactoryImpl(nfaFactoryCompiler.getWindowTime(), nfaFactoryCompiler.getStates(), timeoutHandling);
    }

    public static boolean canProduceEmptyMatches(Pattern<?, ?> pattern) {
        NFAFactoryCompiler compiler = new NFAFactoryCompiler((Pattern)Preconditions.checkNotNull(pattern));
        compiler.compileFactory();
        State startState = compiler.getStates().stream().filter(State::isStart).findFirst().orElseThrow(() -> new IllegalStateException("Compiler produced no start state. It is a bug. File a jira."));
        HashSet<State> visitedStates = new HashSet<State>();
        Stack statesToCheck = new Stack();
        statesToCheck.push(startState);
        while (!statesToCheck.isEmpty()) {
            State currentState = (State)statesToCheck.pop();
            if (visitedStates.contains(currentState)) continue;
            visitedStates.add(currentState);
            for (StateTransition transition : currentState.getStateTransitions()) {
                if (transition.getAction() != StateTransitionAction.PROCEED) continue;
                if (transition.getTargetState().isFinal()) {
                    return true;
                }
                statesToCheck.push(transition.getTargetState());
            }
        }
        return false;
    }

    private static class NFAFactoryImpl<T>
    implements NFAFactory<T> {
        private static final long serialVersionUID = 8939783698296714379L;
        private final long windowTime;
        private final Collection<State<T>> states;
        private final boolean timeoutHandling;

        private NFAFactoryImpl(long windowTime, Collection<State<T>> states, boolean timeoutHandling) {
            this.windowTime = windowTime;
            this.states = states;
            this.timeoutHandling = timeoutHandling;
        }

        @Override
        public NFA<T> createNFA() {
            return new NFA<T>(this.states, this.windowTime, this.timeoutHandling);
        }
    }

    public static interface NFAFactory<T>
    extends Serializable {
        public NFA<T> createNFA();
    }

    static class NFAFactoryCompiler<T> {
        private final NFAStateNameHandler stateNameHandler = new NFAStateNameHandler();
        private final Map<String, State<T>> stopStates = new HashMap<String, State<T>>();
        private final List<State<T>> states = new ArrayList<State<T>>();
        private Optional<Long> windowTime;
        private GroupPattern<T, ?> currentGroupPattern;
        private Map<GroupPattern<T, ?>, Boolean> firstOfLoopMap = new HashMap();
        private Pattern<T, ?> currentPattern;
        private Pattern<T, ?> followingPattern;
        private final AfterMatchSkipStrategy afterMatchSkipStrategy;
        private Map<String, State<T>> originalStateMap = new HashMap<String, State<T>>();

        NFAFactoryCompiler(Pattern<T, ?> pattern) {
            this.currentPattern = pattern;
            this.afterMatchSkipStrategy = pattern.getAfterMatchSkipStrategy();
            this.windowTime = Optional.empty();
        }

        void compileFactory() {
            if (this.currentPattern.getQuantifier().getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_FOLLOW) {
                throw new MalformedPatternException("NotFollowedBy is not supported as a last part of a Pattern!");
            }
            this.checkPatternNameUniqueness();
            this.checkPatternSkipStrategy();
            State<T> sinkState = this.createEndingState();
            sinkState = this.createMiddleStates(sinkState);
            this.createStartState(sinkState);
        }

        AfterMatchSkipStrategy getAfterMatchSkipStrategy() {
            return this.afterMatchSkipStrategy;
        }

        List<State<T>> getStates() {
            return this.states;
        }

        long getWindowTime() {
            return this.windowTime.orElse(0L);
        }

        private void checkPatternSkipStrategy() {
            if (this.afterMatchSkipStrategy.getPatternName().isPresent()) {
                String patternName = this.afterMatchSkipStrategy.getPatternName().get();
                Pattern<T, Object> pattern = this.currentPattern;
                while (pattern.getPrevious() != null && !pattern.getName().equals(patternName)) {
                    pattern = pattern.getPrevious();
                }
                if (!pattern.getName().equals(patternName)) {
                    throw new MalformedPatternException("The pattern name specified in AfterMatchSkipStrategy can not be found in the given Pattern");
                }
            }
        }

        private void checkPatternNameUniqueness() {
            this.stateNameHandler.checkNameUniqueness(NFACompiler.ENDING_STATE_NAME);
            for (Pattern<T, Object> patternToCheck = this.currentPattern; patternToCheck != null; patternToCheck = patternToCheck.getPrevious()) {
                this.checkPatternNameUniqueness(patternToCheck);
            }
            this.stateNameHandler.clear();
        }

        private void checkPatternNameUniqueness(Pattern pattern) {
            if (pattern instanceof GroupPattern) {
                for (Pattern patternToCheck = ((GroupPattern)pattern).getRawPattern(); patternToCheck != null; patternToCheck = patternToCheck.getPrevious()) {
                    this.checkPatternNameUniqueness(patternToCheck);
                }
            } else {
                this.stateNameHandler.checkNameUniqueness(pattern.getName());
            }
        }

        private List<Tuple2<IterativeCondition<T>, String>> getCurrentNotCondition() {
            ArrayList<Tuple2<IterativeCondition<T>, String>> notConditions = new ArrayList<Tuple2<IterativeCondition<T>, String>>();
            Pattern<T, Object> previousPattern = this.currentPattern;
            while (previousPattern.getPrevious() != null && (previousPattern.getPrevious().getQuantifier().hasProperty(Quantifier.QuantifierProperty.OPTIONAL) || previousPattern.getPrevious().getQuantifier().getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_FOLLOW)) {
                if ((previousPattern = previousPattern.getPrevious()).getQuantifier().getConsumingStrategy() != Quantifier.ConsumingStrategy.NOT_FOLLOW) continue;
                IterativeCondition<T> notCondition = this.getTakeCondition(previousPattern);
                notConditions.add(Tuple2.of(notCondition, (Object)previousPattern.getName()));
            }
            return notConditions;
        }

        private State<T> createEndingState() {
            State<T> endState = this.createState(NFACompiler.ENDING_STATE_NAME, State.StateType.Final);
            this.windowTime = Optional.ofNullable(this.currentPattern.getWindowTime()).map(Time::toMilliseconds);
            return endState;
        }

        private State<T> createMiddleStates(State<T> sinkState) {
            State<T> lastSink = sinkState;
            while (this.currentPattern.getPrevious() != null) {
                if (this.currentPattern.getQuantifier().getConsumingStrategy() != Quantifier.ConsumingStrategy.NOT_FOLLOW) {
                    if (this.currentPattern.getQuantifier().getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_NEXT) {
                        State<T> notNext = this.createState(this.currentPattern.getName(), State.StateType.Normal);
                        IterativeCondition<T> notCondition = this.getTakeCondition(this.currentPattern);
                        State<T> stopState = this.createStopState(notCondition, this.currentPattern.getName());
                        if (lastSink.isFinal()) {
                            notNext.addIgnore(lastSink, new RichNotCondition<T>(notCondition));
                        } else {
                            notNext.addProceed(lastSink, new RichNotCondition<T>(notCondition));
                        }
                        notNext.addProceed(stopState, notCondition);
                        lastSink = notNext;
                    } else {
                        lastSink = this.convertPattern(lastSink);
                    }
                }
                this.followingPattern = this.currentPattern;
                this.currentPattern = this.currentPattern.getPrevious();
                Time currentWindowTime = this.currentPattern.getWindowTime();
                if (currentWindowTime == null || currentWindowTime.toMilliseconds() >= this.windowTime.orElse(Long.MAX_VALUE)) continue;
                this.windowTime = Optional.of(currentWindowTime.toMilliseconds());
            }
            return lastSink;
        }

        private State<T> createStartState(State<T> sinkState) {
            State<T> beginningState = this.convertPattern(sinkState);
            beginningState.makeStart();
            return beginningState;
        }

        private State<T> convertPattern(State<T> sinkState) {
            State<T> lastSink;
            Quantifier quantifier = this.currentPattern.getQuantifier();
            if (quantifier.hasProperty(Quantifier.QuantifierProperty.LOOPING)) {
                this.setCurrentGroupPatternFirstOfLoop(false);
                State<T> sink = this.copyWithoutTransitiveNots(sinkState);
                State<T> looping = this.createLooping(sink);
                this.setCurrentGroupPatternFirstOfLoop(true);
                lastSink = this.createTimesState(looping, sinkState, this.currentPattern.getTimes());
            } else {
                lastSink = quantifier.hasProperty(Quantifier.QuantifierProperty.TIMES) ? this.createTimesState(sinkState, sinkState, this.currentPattern.getTimes()) : this.createSingletonState(sinkState);
            }
            this.addStopStates(lastSink);
            return lastSink;
        }

        private State<T> createState(String name, State.StateType stateType) {
            String stateName = this.stateNameHandler.getUniqueInternalName(name);
            State state = new State(stateName, stateType);
            this.states.add(state);
            return state;
        }

        private State<T> createStopState(IterativeCondition<T> notCondition, String name) {
            State<T> stopState = this.stopStates.get(name);
            if (stopState == null) {
                stopState = this.createState(name, State.StateType.Stop);
                stopState.addTake(notCondition);
                this.stopStates.put(name, stopState);
            }
            return stopState;
        }

        private State<T> copyWithoutTransitiveNots(State<T> sinkState) {
            List<Tuple2<IterativeCondition<T>, String>> currentNotCondition = this.getCurrentNotCondition();
            if (currentNotCondition.isEmpty() || !this.currentPattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.OPTIONAL)) {
                return sinkState;
            }
            State<T> copyOfSink = this.createState(sinkState.getName(), sinkState.getStateType());
            for (StateTransition<T> tStateTransition : sinkState.getStateTransitions()) {
                if (tStateTransition.getAction() == StateTransitionAction.PROCEED) {
                    State<T> targetState = tStateTransition.getTargetState();
                    boolean remove2 = false;
                    if (targetState.isStop()) {
                        for (Tuple2<IterativeCondition<T>, String> notCondition : currentNotCondition) {
                            if (!targetState.getName().equals(notCondition.f1)) continue;
                            remove2 = true;
                        }
                    } else {
                        targetState = this.copyWithoutTransitiveNots(tStateTransition.getTargetState());
                    }
                    if (remove2) continue;
                    copyOfSink.addStateTransition(tStateTransition.getAction(), targetState, tStateTransition.getCondition());
                    continue;
                }
                copyOfSink.addStateTransition(tStateTransition.getAction(), tStateTransition.getTargetState().equals(tStateTransition.getSourceState()) ? copyOfSink : tStateTransition.getTargetState(), tStateTransition.getCondition());
            }
            return copyOfSink;
        }

        private State<T> copy(State<T> state) {
            State<T> copyOfState = this.createState(NFAStateNameHandler.getOriginalNameFromInternal(state.getName()), state.getStateType());
            for (StateTransition<T> tStateTransition : state.getStateTransitions()) {
                copyOfState.addStateTransition(tStateTransition.getAction(), tStateTransition.getTargetState().equals(tStateTransition.getSourceState()) ? copyOfState : tStateTransition.getTargetState(), tStateTransition.getCondition());
            }
            return copyOfState;
        }

        private void addStopStates(State<T> state) {
            for (Tuple2<IterativeCondition<T>, String> notCondition : this.getCurrentNotCondition()) {
                State<T> stopState = this.createStopState((IterativeCondition)notCondition.f0, (String)notCondition.f1);
                state.addProceed(stopState, (IterativeCondition)notCondition.f0);
            }
        }

        private void addStopStateToLooping(State<T> loopingState) {
            if (this.followingPattern != null && this.followingPattern.getQuantifier().getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_FOLLOW) {
                IterativeCondition<T> notCondition = this.getTakeCondition(this.followingPattern);
                State<T> stopState = this.createStopState(notCondition, this.followingPattern.getName());
                loopingState.addProceed(stopState, notCondition);
            }
        }

        private State<T> createTimesState(State<T> sinkState, State<T> proceedState, Quantifier.Times times2) {
            int i;
            State<T> lastSink = sinkState;
            this.setCurrentGroupPatternFirstOfLoop(false);
            IterativeCondition<?> untilCondition = this.currentPattern.getUntilCondition();
            IterativeCondition<T> innerIgnoreCondition = this.extendWithUntilCondition(this.getInnerIgnoreCondition(this.currentPattern), untilCondition, false);
            IterativeCondition<T> takeCondition = this.extendWithUntilCondition(this.getTakeCondition(this.currentPattern), untilCondition, true);
            if (this.currentPattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.GREEDY) && times2.getFrom() != times2.getTo()) {
                if (untilCondition != null) {
                    State<T> sinkStateCopy = this.copy(sinkState);
                    this.originalStateMap.put(sinkState.getName(), sinkStateCopy);
                }
                this.updateWithGreedyCondition(sinkState, takeCondition);
            }
            for (i = times2.getFrom(); i < times2.getTo(); ++i) {
                lastSink = this.createSingletonState(lastSink, proceedState, takeCondition, innerIgnoreCondition, true);
                this.addStopStateToLooping(lastSink);
            }
            for (i = 0; i < times2.getFrom() - 1; ++i) {
                lastSink = this.createSingletonState(lastSink, null, takeCondition, innerIgnoreCondition, false);
                this.addStopStateToLooping(lastSink);
            }
            this.setCurrentGroupPatternFirstOfLoop(true);
            return this.createSingletonState(lastSink, proceedState, takeCondition, this.getIgnoreCondition(this.currentPattern), this.currentPattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.OPTIONAL));
        }

        private void setCurrentGroupPatternFirstOfLoop(boolean isFirstOfLoop) {
            if (this.currentPattern instanceof GroupPattern) {
                this.firstOfLoopMap.put((GroupPattern)this.currentPattern, isFirstOfLoop);
            }
        }

        private boolean isCurrentGroupPatternFirstOfLoop() {
            if (this.firstOfLoopMap.containsKey(this.currentGroupPattern)) {
                return this.firstOfLoopMap.get(this.currentGroupPattern);
            }
            return true;
        }

        private boolean headOfGroup(Pattern<T, ?> pattern) {
            return this.currentGroupPattern != null && pattern.getPrevious() == null;
        }

        private boolean isPatternOptional(Pattern<T, ?> pattern) {
            if (this.headOfGroup(pattern)) {
                return this.isCurrentGroupPatternFirstOfLoop() && this.currentGroupPattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.OPTIONAL);
            }
            return pattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.OPTIONAL);
        }

        private State<T> createSingletonState(State<T> sinkState) {
            return this.createSingletonState(sinkState, sinkState, this.getTakeCondition(this.currentPattern), this.getIgnoreCondition(this.currentPattern), this.isPatternOptional(this.currentPattern));
        }

        private State<T> createSingletonState(State<T> sinkState, State<T> proceedState, IterativeCondition<T> takeCondition, IterativeCondition<T> ignoreCondition, boolean isOptional) {
            if (this.currentPattern instanceof GroupPattern) {
                return this.createGroupPatternState((GroupPattern)this.currentPattern, sinkState, proceedState, isOptional);
            }
            State<T> singletonState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
            State<T> sink = this.copyWithoutTransitiveNots(sinkState);
            singletonState.addTake(sink, takeCondition);
            RichAndCondition proceedCondition = this.getTrueFunction();
            if (isOptional && !this.headOfGroup(this.currentPattern)) {
                if (this.currentPattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.GREEDY)) {
                    IterativeCondition<?> untilCondition = this.currentPattern.getUntilCondition();
                    if (untilCondition != null) {
                        singletonState.addProceed(this.originalStateMap.get(proceedState.getName()), new RichAndCondition((IterativeCondition<?>)proceedCondition, untilCondition));
                    }
                    singletonState.addProceed(proceedState, untilCondition != null ? new RichAndCondition((IterativeCondition<?>)proceedCondition, (IterativeCondition<?>)new RichNotCondition(untilCondition)) : proceedCondition);
                } else {
                    singletonState.addProceed(proceedState, proceedCondition);
                }
            }
            if (ignoreCondition != null) {
                State<T> ignoreState;
                if (isOptional) {
                    ignoreState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
                    ignoreState.addTake(sink, takeCondition);
                    ignoreState.addIgnore(ignoreCondition);
                    this.addStopStates(ignoreState);
                } else {
                    ignoreState = singletonState;
                }
                singletonState.addIgnore(ignoreState, ignoreCondition);
            }
            return singletonState;
        }

        private State<T> createGroupPatternState(GroupPattern<T, ?> groupPattern, State<T> sinkState, State<T> proceedState, boolean isOptional) {
            IterativeCondition<T> proceedCondition = this.getTrueFunction();
            Pattern<T, ?> oldCurrentPattern = this.currentPattern;
            Pattern<T, ?> oldFollowingPattern = this.followingPattern;
            GroupPattern<T, ?> oldGroupPattern = this.currentGroupPattern;
            State<T> lastSink = sinkState;
            this.currentGroupPattern = groupPattern;
            this.currentPattern = groupPattern.getRawPattern();
            lastSink = this.createMiddleStates(lastSink);
            lastSink = this.convertPattern(lastSink);
            if (isOptional) {
                lastSink.addProceed(proceedState, proceedCondition);
            }
            this.currentPattern = oldCurrentPattern;
            this.followingPattern = oldFollowingPattern;
            this.currentGroupPattern = oldGroupPattern;
            return lastSink;
        }

        private State<T> createLoopingGroupPatternState(GroupPattern<T, ?> groupPattern, State<T> sinkState) {
            State<T> dummyState;
            IterativeCondition<T> proceedCondition = this.getTrueFunction();
            Pattern<T, ?> oldCurrentPattern = this.currentPattern;
            Pattern<T, ?> oldFollowingPattern = this.followingPattern;
            GroupPattern<T, ?> oldGroupPattern = this.currentGroupPattern;
            State<T> lastSink = dummyState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
            this.currentGroupPattern = groupPattern;
            this.currentPattern = groupPattern.getRawPattern();
            lastSink = this.createMiddleStates(lastSink);
            lastSink = this.convertPattern(lastSink);
            lastSink.addProceed(sinkState, proceedCondition);
            dummyState.addProceed(lastSink, proceedCondition);
            this.currentPattern = oldCurrentPattern;
            this.followingPattern = oldFollowingPattern;
            this.currentGroupPattern = oldGroupPattern;
            return lastSink;
        }

        private State<T> createLooping(State<T> sinkState) {
            if (this.currentPattern instanceof GroupPattern) {
                return this.createLoopingGroupPatternState((GroupPattern)this.currentPattern, sinkState);
            }
            IterativeCondition<?> untilCondition = this.currentPattern.getUntilCondition();
            IterativeCondition<T> ignoreCondition = this.extendWithUntilCondition(this.getInnerIgnoreCondition(this.currentPattern), untilCondition, false);
            IterativeCondition<T> takeCondition = this.extendWithUntilCondition(this.getTakeCondition(this.currentPattern), untilCondition, true);
            RichAndCondition proceedCondition = this.getTrueFunction();
            State<T> loopingState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
            if (this.currentPattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.GREEDY)) {
                if (untilCondition != null) {
                    State<T> sinkStateCopy = this.copy(sinkState);
                    loopingState.addProceed(sinkStateCopy, new RichAndCondition((IterativeCondition<?>)proceedCondition, untilCondition));
                    this.originalStateMap.put(sinkState.getName(), sinkStateCopy);
                }
                loopingState.addProceed(sinkState, untilCondition != null ? new RichAndCondition((IterativeCondition<?>)proceedCondition, (IterativeCondition<?>)new RichNotCondition(untilCondition)) : proceedCondition);
                this.updateWithGreedyCondition(sinkState, this.getTakeCondition(this.currentPattern));
            } else {
                loopingState.addProceed(sinkState, proceedCondition);
            }
            loopingState.addTake(takeCondition);
            this.addStopStateToLooping(loopingState);
            if (ignoreCondition != null) {
                State<T> ignoreState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
                ignoreState.addTake(loopingState, takeCondition);
                ignoreState.addIgnore(ignoreCondition);
                loopingState.addIgnore(ignoreState, ignoreCondition);
                this.addStopStateToLooping(ignoreState);
            }
            return loopingState;
        }

        private IterativeCondition<T> extendWithUntilCondition(IterativeCondition<T> condition, IterativeCondition<T> untilCondition, boolean isTakeCondition) {
            if (untilCondition != null && condition != null) {
                return new RichAndCondition<T>(new RichNotCondition<T>(untilCondition), condition);
            }
            if (untilCondition != null && isTakeCondition) {
                return new RichNotCondition<T>(untilCondition);
            }
            return condition;
        }

        private IterativeCondition<T> getInnerIgnoreCondition(Pattern<T, ?> pattern) {
            Quantifier.ConsumingStrategy consumingStrategy = pattern.getQuantifier().getInnerConsumingStrategy();
            if (this.headOfGroup(pattern)) {
                consumingStrategy = this.currentGroupPattern.getQuantifier().getInnerConsumingStrategy();
            }
            IterativeCondition innerIgnoreCondition = null;
            switch (consumingStrategy) {
                case STRICT: {
                    innerIgnoreCondition = null;
                    break;
                }
                case SKIP_TILL_NEXT: {
                    innerIgnoreCondition = new RichNotCondition(pattern.getCondition());
                    break;
                }
                case SKIP_TILL_ANY: {
                    innerIgnoreCondition = BooleanConditions.trueFunction();
                }
            }
            if (this.currentGroupPattern != null && this.currentGroupPattern.getUntilCondition() != null) {
                innerIgnoreCondition = this.extendWithUntilCondition(innerIgnoreCondition, this.currentGroupPattern.getUntilCondition(), false);
            }
            return innerIgnoreCondition;
        }

        private IterativeCondition<T> getIgnoreCondition(Pattern<T, ?> pattern) {
            Quantifier.ConsumingStrategy consumingStrategy = pattern.getQuantifier().getConsumingStrategy();
            if (this.headOfGroup(pattern)) {
                consumingStrategy = this.isCurrentGroupPatternFirstOfLoop() ? this.currentGroupPattern.getQuantifier().getConsumingStrategy() : this.currentGroupPattern.getQuantifier().getInnerConsumingStrategy();
            }
            IterativeCondition ignoreCondition = null;
            switch (consumingStrategy) {
                case STRICT: {
                    ignoreCondition = null;
                    break;
                }
                case SKIP_TILL_NEXT: {
                    ignoreCondition = new RichNotCondition(pattern.getCondition());
                    break;
                }
                case SKIP_TILL_ANY: {
                    ignoreCondition = BooleanConditions.trueFunction();
                }
            }
            if (this.currentGroupPattern != null && this.currentGroupPattern.getUntilCondition() != null) {
                ignoreCondition = this.extendWithUntilCondition(ignoreCondition, this.currentGroupPattern.getUntilCondition(), false);
            }
            return ignoreCondition;
        }

        private IterativeCondition<T> getTakeCondition(Pattern<T, ?> pattern) {
            IterativeCondition<?> takeCondition = pattern.getCondition();
            if (this.currentGroupPattern != null && this.currentGroupPattern.getUntilCondition() != null) {
                takeCondition = this.extendWithUntilCondition(takeCondition, this.currentGroupPattern.getUntilCondition(), true);
            }
            return takeCondition;
        }

        private IterativeCondition<T> getTrueFunction() {
            IterativeCondition trueCondition = BooleanConditions.trueFunction();
            if (this.currentGroupPattern != null && this.currentGroupPattern.getUntilCondition() != null) {
                trueCondition = this.extendWithUntilCondition(trueCondition, this.currentGroupPattern.getUntilCondition(), true);
            }
            return trueCondition;
        }

        private void updateWithGreedyCondition(State<T> state, IterativeCondition<T> takeCondition) {
            for (StateTransition<T> stateTransition : state.getStateTransitions()) {
                stateTransition.setCondition(new RichAndCondition<T>(stateTransition.getCondition(), new RichNotCondition<T>(takeCondition)));
            }
        }
    }
}

