/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.SizeOf;
import com.esri.core.geometry.VertexDescription;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class AttributeStreamOfInt32
extends AttributeStreamBase {
    private int[] m_buffer = null;
    private int m_size;

    public void reserve(int reserve) {
        if (reserve <= 0) {
            return;
        }
        if (this.m_buffer == null) {
            this.m_buffer = new int[reserve];
        } else {
            if (reserve <= this.m_buffer.length) {
                return;
            }
            int[] buf = new int[reserve];
            System.arraycopy(this.m_buffer, 0, buf, 0, this.m_buffer.length);
            this.m_buffer = buf;
        }
    }

    public int size() {
        return this.m_size;
    }

    public int capacity() {
        return this.m_buffer != null ? this.m_buffer.length : 0;
    }

    public AttributeStreamOfInt32(int size) {
        int sz = size;
        if (sz < 2) {
            sz = 2;
        }
        this.m_buffer = new int[sz];
        this.m_size = size;
    }

    public AttributeStreamOfInt32(int size, int defaultValue) {
        int sz = size;
        if (sz < 2) {
            sz = 2;
        }
        this.m_buffer = new int[sz];
        this.m_size = size;
        Arrays.fill(this.m_buffer, 0, size, defaultValue);
    }

    public AttributeStreamOfInt32(AttributeStreamOfInt32 other) {
        this.m_buffer = (int[])other.m_buffer.clone();
        this.m_size = other.m_size;
    }

    public AttributeStreamOfInt32(AttributeStreamOfInt32 other, int maxSize) {
        int sz;
        this.m_size = other.size();
        if (this.m_size > maxSize) {
            this.m_size = maxSize;
        }
        if ((sz = this.m_size) < 2) {
            sz = 2;
        }
        this.m_buffer = new int[sz];
        System.arraycopy(other.m_buffer, 0, this.m_buffer, 0, this.m_size);
    }

    public int read(int offset) {
        return this.m_buffer[offset];
    }

    public int get(int offset) {
        return this.m_buffer[offset];
    }

    public void write(int offset, int value2) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = value2;
    }

    public void set(int offset, int value2) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = value2;
    }

    public void add(int v) {
        this.resize(this.m_size + 1);
        this.m_buffer[this.m_size - 1] = v;
    }

    @Override
    public AttributeStreamBase restrictedClone(int maxsize) {
        int len = this.m_size;
        int newSize = maxsize < len ? maxsize : len;
        int[] newBuffer = new int[newSize];
        System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
        this.m_buffer = newBuffer;
        this.m_size = newSize;
        return this;
    }

    @Override
    public int virtualSize() {
        return this.size();
    }

    @Override
    public long estimateMemorySize() {
        return 24L + SizeOf.sizeOfIntArray(this.m_buffer.length);
    }

    @Override
    public int getPersistence() {
        return 2;
    }

    @Override
    public double readAsDbl(int offset) {
        return this.read(offset);
    }

    @Override
    public int readAsInt(int offset) {
        return this.read(offset);
    }

    @Override
    public long readAsInt64(int offset) {
        return this.read(offset);
    }

    @Override
    public void resize(int newSize) {
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        if (newSize <= this.m_size) {
            if (newSize * 5 / 4 < this.m_buffer.length) {
                int[] newBuffer = new int[newSize];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        } else {
            if (newSize > this.m_buffer.length) {
                int sz = newSize < 64 ? Math.max(newSize * 2, 4) : newSize * 5 / 4;
                int[] newBuffer = new int[sz];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_size);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        }
    }

    @Override
    public void resizePreserveCapacity(int newSize) {
        if (this.m_buffer == null || newSize > this.m_buffer.length) {
            this.resize(newSize);
        }
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        this.m_size = newSize;
    }

    @Override
    public void resize(int newSize, double defaultValue) {
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        if (newSize <= this.m_size) {
            if (newSize * 5 / 4 < this.m_buffer.length) {
                int[] newBuffer = new int[newSize];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        } else {
            if (newSize > this.m_buffer.length) {
                int sz = newSize < 64 ? Math.max(newSize * 2, 4) : newSize * 5 / 4;
                int[] newBuffer = new int[sz];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_size);
                this.m_buffer = newBuffer;
            }
            Arrays.fill(this.m_buffer, this.m_size, newSize, (int)defaultValue);
            this.m_size = newSize;
        }
    }

    @Override
    public void writeAsDbl(int offset, double d) {
        this.write(offset, (int)d);
    }

    @Override
    public void writeAsInt64(int offset, long d) {
        this.write(offset, (int)d);
    }

    @Override
    public void writeAsInt(int offset, int d) {
        this.write(offset, d);
    }

    @Override
    public int calculateHashImpl(int hashCode2, int start, int end) {
        int n = this.size();
        for (int i = start; i < n && i < end; ++i) {
            hashCode2 = NumberUtils.hash(hashCode2, this.read(i));
        }
        return hashCode2;
    }

    @Override
    public boolean equals(AttributeStreamBase other, int start, int end) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AttributeStreamOfInt32)) {
            return false;
        }
        AttributeStreamOfInt32 _other = (AttributeStreamOfInt32)other;
        int size = this.size();
        int sizeOther = _other.size();
        if (end > size || end > sizeOther && size != sizeOther) {
            return false;
        }
        if (end > size) {
            end = size;
        }
        for (int i = start; i < end; ++i) {
            if (this.read(i) == _other.read(i)) continue;
            return false;
        }
        return true;
    }

    public int getLast() {
        return this.m_buffer[this.m_size - 1];
    }

    public void setLast(int v) {
        this.m_buffer[this.m_size - 1] = v;
    }

    public void removeLast() {
        this.resize(this.m_size - 1);
    }

    int findElement(int value2) {
        int n = this.m_size;
        for (int i = 0; i < n; ++i) {
            if (this.m_buffer[i] != value2) continue;
            return i;
        }
        return -1;
    }

    boolean hasElement(int value2) {
        return this.findElement(value2) >= 0;
    }

    void popElement(int index) {
        assert (index >= 0 && index < this.m_size);
        if (index < this.m_size - 1) {
            this.m_buffer[index] = this.m_buffer[this.m_size - 1];
        }
        this.resize(this.m_size - 1);
    }

    @Override
    public void addRange(AttributeStreamBase src, int start, int count, boolean bForward, int stride) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (!(bForward || stride >= 1 && count % stride == 0)) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.m_size;
        int newSize = oldSize + count;
        this.resize(newSize);
        if (bForward) {
            System.arraycopy(((AttributeStreamOfInt32)src).m_buffer, start, this.m_buffer, oldSize, count);
        } else {
            int n = count;
            for (int i = 0; i < count; i += stride) {
                n -= stride;
                for (int s = 0; s < stride; ++s) {
                    this.m_buffer[oldSize + i + s] = ((AttributeStreamOfInt32)src).m_buffer[start + n + s];
                }
            }
        }
    }

    @Override
    public void insertRange(int start, AttributeStreamBase src, int srcStart, int count, boolean bForward, int stride, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (!(bForward || stride >= 1 && count % stride == 0)) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + count, validSize - start);
        if (this.m_buffer == ((AttributeStreamOfInt32)src).m_buffer && start < srcStart) {
            srcStart += count;
        }
        if (bForward) {
            System.arraycopy(((AttributeStreamOfInt32)src).m_buffer, srcStart, this.m_buffer, start, count);
        } else {
            int n = count;
            for (int i = 0; i < count; i += stride) {
                n -= stride;
                for (int s = 0; s < stride; ++s) {
                    this.m_buffer[start + i + s] = ((AttributeStreamOfInt32)src).m_buffer[srcStart + n + s];
                }
            }
        }
    }

    @Override
    public void insertRange(int start, double value2, int count, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + count, validSize - start);
        int v = (int)value2;
        Arrays.fill(this.m_buffer, start, start + count, v);
    }

    @Override
    public void insertAttributes(int start, Point pt, int semantics, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        int comp = VertexDescription.getComponentCount(semantics);
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + comp, validSize - start);
        for (int c = 0; c < comp; ++c) {
            this.m_buffer[start + c] = (int)pt.getAttributeAsDbl(semantics, c);
        }
    }

    @Override
    public void eraseRange(int index, int count, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (index + count > this.m_size) {
            throw new GeometryException("invalid_call");
        }
        System.arraycopy(this.m_buffer, index + count, this.m_buffer, index, validSize - (index + count));
        this.m_size -= count;
    }

    @Override
    public void readRange(int srcStart, int count, ByteBuffer dst, int dstOffset, boolean bForward) {
        if (srcStart < 0 || count < 0 || dstOffset < 0 || this.size() < count + srcStart) {
            throw new IllegalArgumentException();
        }
        int elmSize = NumberUtils.sizeOf(0.0);
        if (dst.capacity() < dstOffset + elmSize * count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        int j2 = srcStart;
        if (!bForward) {
            j2 += count - 1;
        }
        int dj = bForward ? 1 : -1;
        int offset = dstOffset;
        int i = 0;
        while (i < count) {
            dst.putInt(offset, this.m_buffer[j2]);
            j2 += dj;
            ++i;
            offset += elmSize;
        }
    }

    @Override
    public void reverseRange(int index, int count, int stride) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (stride < 1 || count % stride != 0) {
            throw new GeometryException("invalid_call");
        }
        int cIterations = count >> 1;
        int n = count;
        for (int i = 0; i < cIterations; i += stride) {
            n -= stride;
            for (int s = 0; s < stride; ++s) {
                int temp = this.m_buffer[index + i + s];
                this.m_buffer[index + i + s] = this.m_buffer[index + n + s];
                this.m_buffer[index + n + s] = temp;
            }
        }
    }

    @Override
    public void setRange(double value2, int start, int count) {
        if (start < 0 || count < 0 || start < 0 || count + start > this.size()) {
            throw new IllegalArgumentException();
        }
        int v = (int)value2;
        Arrays.fill(this.m_buffer, start, start + count, v);
    }

    @Override
    public void writeRange(int startElement, int count, AttributeStreamBase _src, int srcStart, boolean bForward, int stride) {
        if (startElement < 0 || count < 0 || srcStart < 0) {
            throw new IllegalArgumentException();
        }
        if (!(bForward || stride > 0 && count % stride == 0)) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfInt32 src = (AttributeStreamOfInt32)_src;
        if (src.size() < srcStart + count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        if (this.size() < count + startElement) {
            this.resize(count + startElement);
        }
        if (_src == this) {
            this._selfWriteRangeImpl(startElement, count, srcStart, bForward, stride);
            return;
        }
        if (bForward) {
            System.arraycopy(src.m_buffer, srcStart, this.m_buffer, startElement, count);
        } else {
            int j2 = startElement;
            int offset = srcStart + count - stride;
            if (stride == 1) {
                for (int i = 0; i < count; ++i) {
                    this.m_buffer[j2] = src.m_buffer[offset];
                    ++j2;
                    --offset;
                }
            } else {
                int n = count / stride;
                for (int i = 0; i < n; ++i) {
                    for (int k = 0; k < stride; ++k) {
                        this.m_buffer[j2 + k] = src.m_buffer[offset + k];
                    }
                    j2 += stride;
                    offset -= stride;
                }
            }
        }
    }

    private void _selfWriteRangeImpl(int toElement, int count, int fromElement, boolean bForward, int stride) {
        if (bForward && toElement == fromElement) {
            return;
        }
        System.arraycopy(this.m_buffer, fromElement, this.m_buffer, toElement, count);
        if (bForward) {
            return;
        }
        int j2 = toElement;
        int offset = toElement + count - stride;
        int dj = stride;
        int n = count / 2;
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < stride; ++k) {
                int v = this.m_buffer[j2 + k];
                this.m_buffer[j2 + k] = this.m_buffer[offset + k];
                this.m_buffer[offset + k] = v;
            }
            j2 += stride;
            offset -= stride;
        }
    }

    @Override
    public void writeRange(int startElement, int count, ByteBuffer src, int offsetBytes, boolean bForward) {
        if (startElement < 0 || count < 0 || offsetBytes < 0) {
            throw new IllegalArgumentException();
        }
        int elmSize = NumberUtils.sizeOf(0.0);
        if (src.capacity() < offsetBytes + elmSize * count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        if (this.size() < count + startElement) {
            this.resize(count + startElement);
        }
        int j2 = startElement;
        if (!bForward) {
            j2 += count - 1;
        }
        int dj = bForward ? 1 : -1;
        int offset = offsetBytes;
        int i = 0;
        while (i < count) {
            this.m_buffer[j2] = src.getInt(offset);
            j2 += dj;
            ++i;
            offset += elmSize;
        }
    }

    public void Sort(int start, int end, IntComparator compare) {
        if (end - start < 10) {
            this.insertionsort(start, end, compare);
        } else {
            this.quicksort(start, end - 1, compare, new RandomSeed());
        }
    }

    void insertionsort(int start, int end, IntComparator compare) {
        for (int j2 = start; j2 < end; ++j2) {
            int key = this.m_buffer[j2];
            for (int i = j2 - 1; i >= start && compare.compare(this.m_buffer[i], key) > 0; --i) {
                this.m_buffer[i + 1] = this.m_buffer[i];
            }
            this.m_buffer[i + 1] = key;
        }
    }

    void swap(int left, int right) {
        int tmp = this.m_buffer[right];
        this.m_buffer[right] = this.m_buffer[left];
        this.m_buffer[left] = tmp;
    }

    void quicksort(int leftIn, int rightIn, IntComparator compare, RandomSeed seed) {
        if (leftIn >= rightIn) {
            return;
        }
        int left = leftIn;
        int right = rightIn;
        while (true) {
            if (right - left < 9) {
                this.insertionsort(left, right + 1, compare);
                return;
            }
            seed.random = NumberUtils.nextRand(seed.random);
            long nom = (long)(right - left) * (long)seed.random;
            int pivotIndex = (int)(nom / (long)NumberUtils.intMax()) + left;
            int pivotValue = this.m_buffer[pivotIndex];
            this.swap(pivotIndex, right);
            int storeIndex = left;
            for (int i = left; i < right; ++i) {
                int elm = this.m_buffer[i];
                if (compare.compare(elm, pivotValue) > 0) continue;
                this.swap(storeIndex, i);
                ++storeIndex;
            }
            this.swap(storeIndex, right);
            if (storeIndex - left < right - storeIndex) {
                this.quicksort(left, storeIndex - 1, compare, seed);
                left = storeIndex + 1;
                continue;
            }
            this.quicksort(storeIndex + 1, right, compare, seed);
            right = storeIndex - 1;
        }
    }

    public void sort(int start, int end) {
        Arrays.sort(this.m_buffer, start, end);
    }

    static class RandomSeed {
        public int random = 1973;
    }

    public static abstract class IntComparator {
        public abstract int compare(int var1, int var2);
    }
}

