/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.client.config.ResultMode;
import org.apache.flink.table.client.config.SqlClientOptions;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.local.result.ChangelogCollectResult;
import org.apache.flink.table.client.gateway.local.result.DynamicResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedCollectBatchResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedCollectStreamResult;

public class ResultStore {
    private final Map<String, DynamicResult> results = new HashMap<String, DynamicResult>();

    public DynamicResult createResult(ReadableConfig config, TableResult tableResult) {
        if (((ResultMode)((Object)config.get(SqlClientOptions.EXECUTION_RESULT_MODE))).equals((Object)ResultMode.CHANGELOG) && ((RuntimeExecutionMode)config.get(ExecutionOptions.RUNTIME_MODE)).equals((Object)RuntimeExecutionMode.BATCH)) {
            throw new SqlExecutionException("Results of batch queries can only be served in table or tableau mode.");
        }
        switch ((ResultMode)((Object)config.get(SqlClientOptions.EXECUTION_RESULT_MODE))) {
            case CHANGELOG: 
            case TABLEAU: {
                return new ChangelogCollectResult(tableResult);
            }
            case TABLE: {
                Integer maxRows = (Integer)config.get(SqlClientOptions.EXECUTION_MAX_TABLE_RESULT_ROWS);
                if (((RuntimeExecutionMode)config.get(ExecutionOptions.RUNTIME_MODE)).equals((Object)RuntimeExecutionMode.STREAMING)) {
                    return new MaterializedCollectStreamResult(tableResult, maxRows);
                }
                return new MaterializedCollectBatchResult(tableResult, maxRows);
            }
        }
        throw new SqlExecutionException(String.format("Unknown value '%s' for option '%s'.", config.get(SqlClientOptions.EXECUTION_RESULT_MODE), SqlClientOptions.EXECUTION_RESULT_MODE.key()));
    }

    public void storeResult(String resultId, DynamicResult result) {
        this.results.put(resultId, result);
    }

    public DynamicResult getResult(String resultId) {
        return this.results.get(resultId);
    }

    public void removeResult(String resultId) {
        this.results.remove(resultId);
    }

    public List<String> getResults() {
        return new ArrayList<String>(this.results.keySet());
    }
}

