/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.List;
import org.apache.flink.table.client.cli.CliStatementSplitter;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;

public class SqlMultiLineParser
extends DefaultParser {
    private static final String NEW_LINE_PROMPT = "";

    public SqlMultiLineParser() {
        this.setEscapeChars(null);
        this.setQuoteChars(null);
    }

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        if (!CliStatementSplitter.isStatementComplete(line) && context != Parser.ParseContext.COMPLETE) {
            throw new EOFError(-1, -1, "New line without EOF character.", NEW_LINE_PROMPT);
        }
        DefaultParser.ArgumentList parsedLine = (DefaultParser.ArgumentList)super.parse(line, cursor, context);
        return new SqlArgumentList(parsedLine.line(), parsedLine.words(), parsedLine.wordIndex(), parsedLine.wordCursor(), parsedLine.cursor(), null, parsedLine.rawWordCursor(), parsedLine.rawWordLength());
    }

    private class SqlArgumentList
    extends DefaultParser.ArgumentList {
        public SqlArgumentList(String line, List<String> words, int wordIndex, int wordCursor, int cursor, String openingQuote, int rawWordCursor, int rawWordLength) {
            super(SqlMultiLineParser.this, line, words, wordIndex, wordCursor, cursor, openingQuote, rawWordCursor, rawWordLength);
        }

        @Override
        public CharSequence escape(CharSequence candidate, boolean complete) {
            return candidate;
        }
    }
}

