/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;

@Internal
public abstract class ThreadLocalCache<K, V> {
    private static final int DEFAULT_CACHE_SIZE = 64;
    private final ThreadLocal<BoundedMap<K, V>> cache = new ThreadLocal();
    private final int maxSizePerThread;

    protected ThreadLocalCache() {
        this(64);
    }

    protected ThreadLocalCache(int maxSizePerThread) {
        this.maxSizePerThread = maxSizePerThread;
    }

    public V get(K key) {
        Object value2;
        BoundedMap map2 = this.cache.get();
        if (map2 == null) {
            map2 = new BoundedMap(this.maxSizePerThread);
            this.cache.set(map2);
        }
        if ((value2 = map2.get(key)) == null) {
            value2 = this.getNewInstance(key);
            map2.put(key, value2);
        }
        return value2;
    }

    public abstract V getNewInstance(K var1);

    private static class BoundedMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -211630219014422361L;
        private final int maxSize;

        private BoundedMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

