/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.CastInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.CommonInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.CurrentWatermarkInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.MapInputTypeStrategy;
import org.apache.flink.table.types.logical.StructuredType;

@Internal
public final class SpecificInputTypeStrategies {
    public static final InputTypeStrategy CAST = new CastInputTypeStrategy();
    public static final InputTypeStrategy MAP = new MapInputTypeStrategy();
    public static final InputTypeStrategy CURRENT_WATERMARK = new CurrentWatermarkInputTypeStrategy();
    public static final InputTypeStrategy ARRAY = new CommonInputTypeStrategy(ConstantArgumentCount.from(1));
    public static final InputTypeStrategy TWO_FULLY_COMPARABLE = InputTypeStrategies.comparable(ConstantArgumentCount.of(2), StructuredType.StructuredComparison.FULL);
    public static final InputTypeStrategy TWO_EQUALS_COMPARABLE = InputTypeStrategies.comparable(ConstantArgumentCount.of(2), StructuredType.StructuredComparison.EQUALS);

    private SpecificInputTypeStrategies() {
    }
}

