/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.wmstrategies;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.table.sources.wmstrategies.PeriodicWatermarkAssigner;

@PublicEvolving
public final class BoundedOutOfOrderTimestamps
extends PeriodicWatermarkAssigner {
    private static final long serialVersionUID = 1L;
    private final long delay;
    private long maxTimestamp;

    public BoundedOutOfOrderTimestamps(long delay) {
        this.delay = delay;
        this.maxTimestamp = Long.MIN_VALUE + delay;
    }

    @Override
    public void nextTimestamp(long timestamp) {
        if (timestamp > this.maxTimestamp) {
            this.maxTimestamp = timestamp;
        }
    }

    @Override
    public Watermark getWatermark() {
        return new Watermark(this.maxTimestamp - this.delay);
    }

    @Override
    public Map<String, String> toProperties() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("rowtime.watermarks.type", "periodic-bounded");
        map2.put("rowtime.watermarks.delay", String.valueOf(this.delay));
        return map2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundedOutOfOrderTimestamps that = (BoundedOutOfOrderTimestamps)o;
        return this.delay == that.delay;
    }

    public int hashCode() {
        return Long.hashCode(this.delay);
    }
}

