/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class BinPacking {
    private BinPacking() {
    }

    public static <T> List<List<T>> pack(Iterable<T> items, Function<T, Long> weightFunc, long targetWeight) {
        ArrayList packed = new ArrayList();
        LinkedList<Bin<Bin>> bins = new LinkedList<Bin<Bin>>();
        for (T item : items) {
            long weight = weightFunc.apply(item);
            Bin<T> bin2 = BinPacking.findBin(bins, weight);
            if (bin2 != null) {
                bin2.add(item, weight);
                continue;
            }
            bin2 = new Bin(targetWeight);
            bin2.add(item, weight);
            bins.addLast(bin2);
            if (bins.size() <= 10) continue;
            packed.add(((Bin)bins.removeFirst()).items());
        }
        bins.forEach(bin -> packed.add(((Bin)bin).items));
        return packed;
    }

    private static <T> Bin<T> findBin(Iterable<Bin<T>> bins, long weight) {
        for (Bin<T> bin : bins) {
            if (!bin.canAdd(weight)) continue;
            return bin;
        }
        return null;
    }

    private static class Bin<T> {
        private final long targetWeight;
        private final List<T> items = new ArrayList<T>();
        private long binWeight = 0L;

        Bin(long targetWeight) {
            this.targetWeight = targetWeight;
        }

        List<T> items() {
            return this.items;
        }

        boolean canAdd(long weight) {
            return this.binWeight + weight <= this.targetWeight;
        }

        void add(T item, long weight) {
            this.binWeight += weight;
            this.items.add(item);
        }
    }
}

