/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

abstract class AbstractMapSerializer<K, V, M extends Map<K, V>>
extends TypeSerializer<M> {
    private static final long serialVersionUID = 1L;
    final TypeSerializer<K> keySerializer;
    final TypeSerializer<V> valueSerializer;

    AbstractMapSerializer(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        Preconditions.checkNotNull(keySerializer, (String)"The key serializer must not be null");
        Preconditions.checkNotNull(valueSerializer, (String)"The value serializer must not be null.");
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public M copy(M from) {
        Map newMap = (Map)this.createInstance();
        for (Map.Entry entry : from.entrySet()) {
            Object newKey = entry.getKey() == null ? null : this.keySerializer.copy(entry.getKey());
            Object newValue = entry.getValue() == null ? null : this.valueSerializer.copy(entry.getValue());
            newMap.put(newKey, newValue);
        }
        return (M)newMap;
    }

    public M copy(M from, M reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(M map2, DataOutputView target) throws IOException {
        int size = map2.size();
        target.writeInt(size);
        for (Map.Entry entry : map2.entrySet()) {
            this.keySerializer.serialize(entry.getKey(), target);
            if (entry.getValue() == null) {
                target.writeBoolean(true);
                continue;
            }
            target.writeBoolean(false);
            this.valueSerializer.serialize(entry.getValue(), target);
        }
    }

    public M deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        Map map2 = (Map)this.createInstance();
        for (int i = 0; i < size; ++i) {
            Object key = this.keySerializer.deserialize(source);
            boolean isNull = source.readBoolean();
            Object value2 = isNull ? null : this.valueSerializer.deserialize(source);
            map2.put(key, value2);
        }
        return (M)map2;
    }

    public M deserialize(M reuse, DataInputView source) throws IOException {
        return (M)this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int size = source.readInt();
        target.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.keySerializer.copy(source, target);
            boolean isNull = source.readBoolean();
            target.writeBoolean(isNull);
            if (isNull) continue;
            this.valueSerializer.copy(source, target);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractMapSerializer that = (AbstractMapSerializer)((Object)o);
        return this.keySerializer.equals(that.keySerializer) && this.valueSerializer.equals(that.valueSerializer);
    }

    public int hashCode() {
        int result = this.keySerializer.hashCode();
        result = 31 * result + this.valueSerializer.hashCode();
        return result;
    }
}

