/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.TableStreamOperator;

@Internal
public class StreamRecordTimestampInserter
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData> {
    private final int rowtimeIndex;
    private final int precision;

    public StreamRecordTimestampInserter(int rowtimeIndex, int precision) {
        this.rowtimeIndex = rowtimeIndex;
        this.precision = precision;
    }

    public StreamRecordTimestampInserter(int rowtimeIndex) {
        this(rowtimeIndex, 3);
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        RowData rowData = (RowData)element.getValue();
        long rowtime2 = rowData.getTimestamp(this.rowtimeIndex, this.precision).getMillisecond();
        element.setTimestamp(rowtime2);
        this.output.collect(element);
    }
}

