/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode$class;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecSort;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel$class;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRel;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil$;
import org.apache.flink.table.planner.plan.utils.SortUtil$;
import scala.Enumeration;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001U\u0011\u0011CQ1uG\"\u0004\u0006._:jG\u0006d7k\u001c:u\u0015\t\u0019A!A\u0003cCR\u001c\u0007N\u0003\u0002\u0006\r\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\b\u0011\u0005)an\u001c3fg*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0004\u0001Y\u0001\u0003CA\f\u001f\u001b\u0005A\"BA\r\u001b\u0003\u0011\u0019wN]3\u000b\u0005ma\u0012a\u0001:fY*\u0011Q\u0004E\u0001\bG\u0006d7-\u001b;f\u0013\ty\u0002D\u0001\u0003T_J$\bCA\u0011#\u001b\u0005\u0011\u0011BA\u0012\u0003\u0005A\u0011\u0015\r^2i!\"L8/[2bYJ+G\u000e\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003\u001d\u0019G.^:uKJ\u0004\"aJ\u0015\u000e\u0003!R!!\u0003\u000f\n\u0005)B#!\u0004*fY>\u0003Ho\u00117vgR,'\u000f\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003!!(/Y5u'\u0016$\bCA\u0014/\u0013\ty\u0003FA\u0006SK2$&/Y5u'\u0016$\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0011%t\u0007/\u001e;SK2\u0004\"a\r\u001b\u000e\u0003iI!!\u000e\u000e\u0003\u000fI+GNT8eK\"Aq\u0007\u0001B\u0001B\u0003%\u0001(A\u0007t_J$8i\u001c7mCRLwN\u001c\t\u0003geJ!A\u000f\u000e\u0003\u0019I+GnQ8mY\u0006$\u0018n\u001c8\t\u000bq\u0002A\u0011A\u001f\u0002\rqJg.\u001b;?)\u0015qt\bQ!C!\t\t\u0003\u0001C\u0003&w\u0001\u0007a\u0005C\u0003-w\u0001\u0007Q\u0006C\u00032w\u0001\u0007!\u0007C\u00038w\u0001\u0007\u0001\bC\u0003E\u0001\u0011\u0005S)\u0001\u0003d_BLHC\u0002\fG\u000f&[5\u000bC\u0003-\u0007\u0002\u0007Q\u0006C\u0003I\u0007\u0002\u0007!'\u0001\u0005oK^Le\u000e];u\u0011\u0015Q5\t1\u00019\u00031qWm^\"pY2\fG/[8o\u0011\u0015a5\t1\u0001N\u0003\u0019ygMZ:fiB\u0011a*U\u0007\u0002\u001f*\u0011\u0001\u000bH\u0001\u0004e\u0016D\u0018B\u0001*P\u0005\u001d\u0011V\r\u001f(pI\u0016DQ\u0001V\"A\u00025\u000bQAZ3uG\"DQA\u0016\u0001\u0005B]\u000bA\"\u001a=qY\u0006Lg\u000eV3s[N$\"\u0001W.\u0011\u0005MJ\u0016B\u0001.\u001b\u0005%\u0011V\r\\,sSR,'\u000fC\u0003]+\u0002\u0007\u0001,\u0001\u0002qo\")a\f\u0001C!?\u0006\u0001Rm\u001d;j[\u0006$XMU8x\u0007>,h\u000e\u001e\u000b\u0003A\u001a\u0004\"!\u00193\u000e\u0003\tT\u0011aY\u0001\u0006g\u000e\fG.Y\u0005\u0003K\n\u0014a\u0001R8vE2,\u0007\"B4^\u0001\u0004A\u0017AA7r!\tIG.D\u0001k\u0015\tY'$\u0001\u0005nKR\fG-\u0019;b\u0013\ti'N\u0001\tSK2lU\r^1eCR\f\u0017+^3ss\")q\u000e\u0001C!a\u0006y1m\\7qkR,7+\u001a7g\u0007>\u001cH\u000fF\u0002rib\u0004\"a\n:\n\u0005MD#A\u0003*fY>\u0003HoQ8ti\")1B\u001ca\u0001kB\u0011qE^\u0005\u0003o\"\u0012QBU3m\u001fB$\b\u000b\\1o]\u0016\u0014\b\"B4o\u0001\u0004A\u0007\"\u0002>\u0001\t\u0003Z\u0018a\u0005;sC:\u001cH.\u0019;f)>,\u00050Z2O_\u0012,G#\u0001?1\u0007u\fY\u0001E\u0003\u007f\u0003\u0007\t9!D\u0001\u0000\u0015\r\t\tAB\u0001\u0005Kb,7-C\u0002\u0002\u0006}\u0014\u0001\"\u0012=fG:{G-\u001a\t\u0005\u0003\u0013\tY\u0001\u0004\u0001\u0005\u0017\u00055\u00110!A\u0001\u0002\u000b\u0005\u0011q\u0002\u0002\u0004?\u0012\n\u0014\u0003BA\t\u0003/\u00012!YA\n\u0013\r\t)B\u0019\u0002\b\u001d>$\b.\u001b8h!\r\t\u0017\u0011D\u0005\u0004\u00037\u0011'aA!os\"\u001a\u00110a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005!A.\u00198h\u0015\t\tI#\u0001\u0003kCZ\f\u0017\u0002BA\u0017\u0003G\u0011\u0001b\u0014<feJLG-\u001a")
public class BatchPhysicalSort
extends Sort
implements BatchPhysicalRel {
    private final RelOptCluster cluster;
    private final RelCollation sortCollation;

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel$class.satisfyTraits(this, requiredTraitSet);
    }

    @Override
    public String getRelDetailedDescription() {
        return FlinkRelNode$class.getRelDetailedDescription(this);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable, expressionFormat);
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new BatchPhysicalSort(this.cluster, traitSet, newInput, newCollation);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.input("input", this.getInput()).item("orderBy", RelExplainUtil$.MODULE$.collationToString(this.sortCollation, this.getRowType()));
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return Predef$.MODULE$.Double2double(mq.getRowCount(this.getInput()));
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double rowCount = mq.getRowCount(this.getInput());
        if (rowCount == null) {
            return null;
        }
        int numOfSortKeys = this.sortCollation.getFieldCollations().size();
        double cpuCost = (double)(FlinkCost$.MODULE$.COMPARE_CPU_COST() * numOfSortKeys) * Predef$.MODULE$.Double2double(rowCount) * Math.max(Math.log(Predef$.MODULE$.Double2double(rowCount)), 1.0);
        Double memCost = FlinkRelMdUtil$.MODULE$.computeSortMemory(mq, this.getInput());
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        return costFactory.makeCost(Predef$.MODULE$.Double2double(rowCount), cpuCost, 0.0, 0.0, Predef$.MODULE$.Double2double(memCost));
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        return new BatchExecSort(SortUtil$.MODULE$.getSortSpec((Seq<RelFieldCollation>)JavaConversions$.MODULE$.asScalaBuffer(this.sortCollation.getFieldCollations())), InputProperty.builder().damBehavior(InputProperty.DamBehavior.END_INPUT).build(), FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    public BatchPhysicalSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RelCollation sortCollation) {
        this.cluster = cluster;
        this.sortCollation = sortCollation;
        super(cluster, traitSet, inputRel, sortCollation);
        FlinkRelNode$class.$init$(this);
        FlinkPhysicalRel$class.$init$(this);
        Predef$.MODULE$.require(sortCollation.getFieldCollations().size() > 0);
    }
}

