/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.expressions.PlannerNamedWindowProperty;
import org.apache.flink.table.planner.expressions.PlannerWindowProperty;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowAggregateBase;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.aggregate.window.SlicingWindowAggOperatorBuilder;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceSharedAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SlicingWindowOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class StreamExecWindowAggregate
extends StreamExecWindowAggregateBase {
    private static final long WINDOW_AGG_MEMORY_RATIO = 100L;
    public static final String FIELD_NAME_WINDOWING = "windowing";
    public static final String FIELD_NAME_NAMED_WINDOW_PROPERTIES = "namedWindowProperties";
    @JsonProperty(value="grouping")
    private final int[] grouping;
    @JsonProperty(value="aggCalls")
    private final AggregateCall[] aggCalls;
    @JsonProperty(value="windowing")
    private final WindowingStrategy windowing;
    @JsonProperty(value="namedWindowProperties")
    private final PlannerNamedWindowProperty[] namedWindowProperties;

    public StreamExecWindowAggregate(int[] grouping, AggregateCall[] aggCalls, WindowingStrategy windowing, PlannerNamedWindowProperty[] namedWindowProperties, InputProperty inputProperty, RowType outputType, String description) {
        this(grouping, aggCalls, windowing, namedWindowProperties, StreamExecWindowAggregate.getNewNodeId(), Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecWindowAggregate(@JsonProperty(value="grouping") int[] grouping, @JsonProperty(value="aggCalls") AggregateCall[] aggCalls, @JsonProperty(value="windowing") WindowingStrategy windowing, @JsonProperty(value="namedWindowProperties") PlannerNamedWindowProperty[] namedWindowProperties, @JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, inputProperties, outputType, description);
        this.grouping = (int[])Preconditions.checkNotNull((Object)grouping);
        this.aggCalls = (AggregateCall[])Preconditions.checkNotNull((Object)aggCalls);
        this.windowing = (WindowingStrategy)Preconditions.checkNotNull((Object)windowing);
        this.namedWindowProperties = (PlannerNamedWindowProperty[])Preconditions.checkNotNull((Object)namedWindowProperties);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        TableConfig config = planner.getTableConfig();
        ZoneId shiftTimeZone = TimeWindowUtil.getShiftTimeZone(this.windowing.getTimeAttributeType(), config);
        SliceAssigner sliceAssigner = this.createSliceAssigner(this.windowing, shiftTimeZone);
        AggregateInfoList aggInfoList = AggregateUtil.deriveStreamWindowAggregateInfoList(inputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), this.windowing.getWindow(), true);
        GeneratedNamespaceAggsHandleFunction<Long> generatedAggsHandler = this.createAggsHandler(sliceAssigner, aggInfoList, config, planner.getRelBuilder(), inputRowType.getChildren(), shiftTimeZone);
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(this.grouping, InternalTypeInfo.of(inputRowType));
        LogicalType[] accTypes = this.convertToLogicalTypes(aggInfoList.getAccTypes());
        SlicingWindowOperator<RowData, ?> windowOperator = SlicingWindowAggOperatorBuilder.builder().inputSerializer(new RowDataSerializer(inputRowType)).shiftTimeZone(shiftTimeZone).keySerializer((PagedTypeSerializer)selector.getProducedType().toSerializer()).assigner(sliceAssigner).countStarIndex(aggInfoList.getIndexOfCountStar()).aggregate(generatedAggsHandler, new RowDataSerializer(accTypes)).build();
        OneInputTransformation<?, ?> transform2 = ExecNodeUtil.createOneInputTransformation(inputTransform, this.getDescription(), SimpleOperatorFactory.of(windowOperator), InternalTypeInfo.of(this.getOutputType()), inputTransform.getParallelism(), 100L);
        transform2.setStateKeySelector((KeySelector)selector);
        transform2.setStateKeyType(selector.getProducedType());
        return transform2;
    }

    private GeneratedNamespaceAggsHandleFunction<Long> createAggsHandler(SliceAssigner sliceAssigner, AggregateInfoList aggInfoList, TableConfig config, RelBuilder relBuilder, List<LogicalType> fieldTypes, ZoneId shiftTimeZone) {
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(new CodeGeneratorContext(config), relBuilder, JavaScalaConversionUtil.toScala(fieldTypes), false).needAccumulate();
        if (sliceAssigner instanceof SliceSharedAssigner) {
            generator.needMerge(0, false, null);
        }
        List windowProperties = Arrays.asList(Arrays.stream(this.namedWindowProperties).map(PlannerNamedWindowProperty::getProperty).toArray(PlannerWindowProperty[]::new));
        return generator.generateNamespaceAggsHandler("WindowAggsHandler", aggInfoList, JavaScalaConversionUtil.toScala(windowProperties), sliceAssigner, shiftTimeZone);
    }
}

