/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.expressions.converter.converters.ArrayConverter;
import org.apache.flink.table.planner.expressions.converter.converters.AsConverter;
import org.apache.flink.table.planner.expressions.converter.converters.BetweenConverter;
import org.apache.flink.table.planner.expressions.converter.converters.CastConverter;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.expressions.converter.converters.GetConverter;
import org.apache.flink.table.planner.expressions.converter.converters.InConverter;
import org.apache.flink.table.planner.expressions.converter.converters.JsonExistsConverter;
import org.apache.flink.table.planner.expressions.converter.converters.JsonValueConverter;
import org.apache.flink.table.planner.expressions.converter.converters.MapConverter;
import org.apache.flink.table.planner.expressions.converter.converters.NotBetweenConverter;
import org.apache.flink.table.planner.expressions.converter.converters.OrderAscConverter;
import org.apache.flink.table.planner.expressions.converter.converters.PlusConverter;
import org.apache.flink.table.planner.expressions.converter.converters.ReinterpretCastConverter;
import org.apache.flink.table.planner.expressions.converter.converters.ReplaceConverter;
import org.apache.flink.table.planner.expressions.converter.converters.RowConverter;
import org.apache.flink.table.planner.expressions.converter.converters.SqrtConverter;
import org.apache.flink.table.planner.expressions.converter.converters.TemporalOverlapsConverter;
import org.apache.flink.table.planner.expressions.converter.converters.ThrowExceptionConverter;
import org.apache.flink.table.planner.expressions.converter.converters.TimestampDiffConverter;
import org.apache.flink.table.planner.expressions.converter.converters.TrimConverter;
import org.apache.flink.table.planner.functions.InternalFunctionDefinitions;

@Internal
public class CustomizedConverters {
    private static final Map<FunctionDefinition, CustomizedConverter> CONVERTERS = new HashMap<FunctionDefinition, CustomizedConverter>();

    public Optional<CustomizedConverter> getConverter(FunctionDefinition functionDefinition) {
        return Optional.ofNullable(CONVERTERS.get(functionDefinition));
    }

    static {
        CONVERTERS.put(BuiltInFunctionDefinitions.CAST, new CastConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.REINTERPRET_CAST, new ReinterpretCastConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.IN, new InConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.GET, new GetConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.TRIM, new TrimConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.AS, new AsConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.BETWEEN, new BetweenConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.NOT_BETWEEN, new NotBetweenConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.REPLACE, new ReplaceConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.PLUS, new PlusConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.TEMPORAL_OVERLAPS, new TemporalOverlapsConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.TIMESTAMP_DIFF, new TimestampDiffConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.ARRAY, new ArrayConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.MAP, new MapConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.ROW, new RowConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.ORDER_ASC, new OrderAscConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.SQRT, new SqrtConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.JSON_EXISTS, new JsonExistsConverter());
        CONVERTERS.put(BuiltInFunctionDefinitions.JSON_VALUE, new JsonValueConverter());
        CONVERTERS.put(InternalFunctionDefinitions.THROW_EXCEPTION, new ThrowExceptionConverter());
    }
}

