/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@Internal
public final class RexNodeExpression
implements ResolvedExpression {
    private final RexNode rexNode;
    private final DataType outputDataType;
    @Nullable
    private final String summaryString;
    @Nullable
    private final String serializableString;

    public RexNodeExpression(RexNode rexNode, DataType outputDataType, @Nullable String summaryString, @Nullable String serializableString) {
        this.rexNode = (RexNode)Preconditions.checkNotNull((Object)rexNode, (String)"RexNode must not be null.");
        this.outputDataType = (DataType)Preconditions.checkNotNull((Object)outputDataType, (String)"Output data type must not be null.");
        this.summaryString = summaryString;
        this.serializableString = serializableString;
    }

    public RexNode getRexNode() {
        return this.rexNode;
    }

    @Override
    public String asSummaryString() {
        if (this.summaryString != null) {
            return this.summaryString;
        }
        return this.rexNode.toString();
    }

    @Override
    public String asSerializableString() {
        if (this.serializableString != null) {
            return this.serializableString;
        }
        throw new TableException(String.format("Expression '%s' is not string serializable. Currently, only expressions that originated from a SQL expression have a well-defined string representation.", this.asSummaryString()));
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public DataType getOutputDataType() {
        return this.outputDataType;
    }

    @Override
    public List<ResolvedExpression> getResolvedChildren() {
        return new ArrayList<ResolvedExpression>();
    }

    public String toString() {
        return this.asSummaryString();
    }
}

