/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.PlannerNamedWindowProperty;
import org.apache.flink.table.planner.expressions.PlannerRowtimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerWindowReference;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalAggregate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCorrelate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalDistribution;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalExpand;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalIntersect;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacySink;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalMatch;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalMinus;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalOverAggregate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRank;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSink;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSort;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableAggregate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalUnion;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalValues;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalWatermarkAssigner;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalWindowTableAggregate;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.MatchUtil;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil;
import org.apache.flink.table.planner.plan.utils.WindowUtil;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public final class RelTimeIndicatorConverter
extends RelHomogeneousShuttle {
    private final RexBuilder rexBuilder;

    private RelTimeIndicatorConverter(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
    }

    public static RelNode convert(RelNode rootRel, RexBuilder rexBuilder, boolean needFinalTimeIndicatorConversion) {
        RelTimeIndicatorConverter converter = new RelTimeIndicatorConverter(rexBuilder);
        RelNode convertedRoot = rootRel.accept(converter);
        if (rootRel instanceof FlinkLogicalLegacySink || rootRel instanceof FlinkLogicalSink || !needFinalTimeIndicatorConversion) {
            return convertedRoot;
        }
        return converter.materializeProcTime(convertedRoot);
    }

    @Override
    public RelNode visit(RelNode node) {
        if (node instanceof FlinkLogicalValues || node instanceof TableScan) {
            return node;
        }
        if (node instanceof FlinkLogicalIntersect || node instanceof FlinkLogicalUnion || node instanceof FlinkLogicalMinus) {
            return this.visitSetOp((SetOp)node);
        }
        if (node instanceof FlinkLogicalTableFunctionScan || node instanceof FlinkLogicalSnapshot || node instanceof FlinkLogicalRank || node instanceof FlinkLogicalDistribution || node instanceof FlinkLogicalWatermarkAssigner || node instanceof FlinkLogicalSort || node instanceof FlinkLogicalOverAggregate || node instanceof FlinkLogicalExpand) {
            return this.visitSimpleRel(node);
        }
        if (node instanceof FlinkLogicalWindowAggregate) {
            return this.visitWindowAggregate((FlinkLogicalWindowAggregate)node);
        }
        if (node instanceof FlinkLogicalWindowTableAggregate) {
            return this.visitWindowTableAggregate((FlinkLogicalWindowTableAggregate)node);
        }
        if (node instanceof FlinkLogicalAggregate) {
            return this.visitAggregate((FlinkLogicalAggregate)node);
        }
        if (node instanceof FlinkLogicalTableAggregate) {
            return this.visitTableAggregate((FlinkLogicalTableAggregate)node);
        }
        if (node instanceof FlinkLogicalMatch) {
            return this.visitMatch((FlinkLogicalMatch)node);
        }
        if (node instanceof FlinkLogicalCalc) {
            return this.visitCalc((FlinkLogicalCalc)node);
        }
        if (node instanceof FlinkLogicalCorrelate) {
            return this.visitCorrelate((FlinkLogicalCorrelate)node);
        }
        if (node instanceof FlinkLogicalJoin) {
            return this.visitJoin((FlinkLogicalJoin)node);
        }
        if (node instanceof FlinkLogicalSink) {
            return this.visitSink((FlinkLogicalSink)node);
        }
        if (node instanceof FlinkLogicalLegacySink) {
            return this.visitSink((FlinkLogicalLegacySink)node);
        }
        return this.visitInvalidRel(node);
    }

    @Override
    public RelNode visit(LogicalCalc calc) {
        return this.visitInvalidRel(calc);
    }

    @Override
    public RelNode visit(LogicalTableModify modify) {
        return this.visitInvalidRel(modify);
    }

    private RelNode visitMatch(FlinkLogicalMatch match) {
        RelNode newInput = match.getInput().accept(this);
        RexTimeIndicatorMaterializer materializer = new RexTimeIndicatorMaterializer(newInput);
        Function<Map, Map> materializeExprs = rexNodesMap -> rexNodesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RexNode)e.getValue()).accept(materializer), (e1, e2) -> e1, LinkedHashMap::new));
        Map newPatternDefs = materializeExprs.apply(match.getPatternDefinitions());
        Map newMeasures = materializeExprs.apply(match.getMeasures());
        RexNode newInterval = null;
        if (match.getInterval() != null) {
            newInterval = match.getInterval().accept(materializer);
        }
        Predicate<String> isNoLongerTimeIndicator = fieldName -> {
            RexNode newMeasure = (RexNode)newMeasures.get(fieldName);
            if (newMeasure == null) {
                return false;
            }
            return !FlinkTypeFactory.isTimeIndicatorType(newMeasure.getType());
        };
        boolean isTimestampLtz = newMeasures.values().stream().anyMatch(node -> this.isTimestampLtzType(node.getType()));
        RelDataType newOutputType = this.getRowTypeWithoutTimeIndicator(match.getRowType(), isTimestampLtz, isNoLongerTimeIndicator);
        return new FlinkLogicalMatch(match.getCluster(), match.getTraitSet(), newInput, newOutputType, match.getPattern(), match.isStrictStart(), match.isStrictEnd(), newPatternDefs, newMeasures, match.getAfter(), match.getSubsets(), match.isAllRows(), match.getPartitionKeys(), match.getOrderKeys(), newInterval);
    }

    private RelNode visitCalc(FlinkLogicalCalc calc) {
        RelNode newInput = calc.getInput().accept(this);
        RexProgram program = calc.getProgram();
        RexTimeIndicatorMaterializer materializer = new RexTimeIndicatorMaterializer(newInput);
        List newProjects = program.getProjectList().stream().map(project -> program.expandLocalRef((RexLocalRef)project).accept(materializer)).collect(Collectors.toList());
        RexNode newCondition = null;
        if (program.getCondition() != null) {
            newCondition = program.expandLocalRef(program.getCondition()).accept(materializer);
        }
        RexProgram newProgram = RexProgram.create(newInput.getRowType(), newProjects, newCondition, program.getOutputRowType().getFieldNames(), this.rexBuilder);
        return calc.copy(calc.getTraitSet(), newInput, newProgram);
    }

    private RelNode visitJoin(FlinkLogicalJoin join) {
        RelNode newLeft = join.getLeft().accept(this);
        RelNode newRight = join.getRight().accept(this);
        int leftFieldCount = newLeft.getRowType().getFieldCount();
        if (TemporalJoinUtil.satisfyTemporalJoin(join, newLeft, newRight)) {
            Join rewrittenTemporalJoin = join.copy(join.getTraitSet(), join.getCondition(), newLeft, newRight, join.getJoinType(), join.isSemiJoinDone());
            Set<Integer> rightIndices = IntStream.range(0, newRight.getRowType().getFieldCount()).mapToObj(startIdx -> leftFieldCount + startIdx).collect(Collectors.toSet());
            return this.createCalcToMaterializeTimeIndicators(rewrittenTemporalJoin, rightIndices);
        }
        if (JoinUtil.satisfyRegularJoin(join, newLeft, newRight)) {
            newLeft = this.materializeTimeIndicators(newLeft);
            newRight = this.materializeTimeIndicators(newRight);
        }
        final ArrayList<RelDataTypeField> leftRightFields = new ArrayList<RelDataTypeField>();
        leftRightFields.addAll(newLeft.getRowType().getFieldList());
        leftRightFields.addAll(newRight.getRowType().getFieldList());
        RexNode newCondition = join.getCondition().accept(new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef inputRef) {
                if (FlinkTypeFactory.isTimeIndicatorType(inputRef.getType())) {
                    return RexInputRef.of(inputRef.getIndex(), leftRightFields);
                }
                return super.visitInputRef(inputRef);
            }
        });
        return FlinkLogicalJoin.create(newLeft, newRight, newCondition, join.getJoinType());
    }

    private RelNode visitCorrelate(FlinkLogicalCorrelate correlate) {
        RelNode newLeft = correlate.getLeft().accept(this);
        RelNode newRight = correlate.getRight().accept(this);
        if (newRight instanceof FlinkLogicalTableFunctionScan) {
            FlinkLogicalTableFunctionScan newScan = (FlinkLogicalTableFunctionScan)newRight;
            List<RelNode> newScanInputs = newScan.getInputs().stream().map(input -> input.accept(this)).collect(Collectors.toList());
            RexTimeIndicatorMaterializer materializer = new RexTimeIndicatorMaterializer(newLeft);
            RexNode newScanCall = newScan.getCall().accept(materializer);
            newRight = newScan.copy(newScan.getTraitSet(), newScanInputs, newScanCall, newScan.getElementType(), newScan.getRowType(), newScan.getColumnMappings());
        }
        return FlinkLogicalCorrelate.create(newLeft, newRight, correlate.getCorrelationId(), correlate.getRequiredColumns(), correlate.getJoinType());
    }

    private RelNode visitSimpleRel(RelNode node) {
        List<RelNode> newInputs = node.getInputs().stream().map(input -> input.accept(this)).collect(Collectors.toList());
        return node.copy(node.getTraitSet(), newInputs);
    }

    private RelNode visitSetOp(SetOp setOp) {
        RelNode convertedSetOp = this.visitSimpleRel(setOp);
        List<RelDataTypeField> headInputFields = convertedSetOp.getInputs().get(0).getRowType().getFieldList();
        int fieldCnt = headInputFields.size();
        for (int inputIdx = 1; inputIdx < convertedSetOp.getInputs().size(); ++inputIdx) {
            List<RelDataTypeField> currentInputFields = convertedSetOp.getInputs().get(inputIdx).getRowType().getFieldList();
            for (int fieldIdx = 0; fieldIdx < fieldCnt; ++fieldIdx) {
                RelDataType headFieldType = headInputFields.get(fieldIdx).getType();
                RelDataType currentInputFieldType = currentInputFields.get(fieldIdx).getType();
                this.validateType(currentInputFieldType, headFieldType);
            }
        }
        return convertedSetOp;
    }

    private RelNode visitSink(SingleRel sink) {
        Preconditions.checkArgument((sink instanceof FlinkLogicalLegacySink || sink instanceof FlinkLogicalSink ? 1 : 0) != 0);
        RelNode newInput = sink.getInput().accept(this);
        newInput = this.materializeProcTime(newInput);
        return sink.copy(sink.getTraitSet(), Collections.singletonList(newInput));
    }

    private FlinkLogicalAggregate visitAggregate(FlinkLogicalAggregate agg) {
        RelNode newInput = this.convertAggInput(agg);
        List<AggregateCall> updatedAggCalls = this.convertAggregateCalls(agg);
        return (FlinkLogicalAggregate)agg.copy(agg.getTraitSet(), newInput, agg.getGroupSet(), agg.getGroupSets(), updatedAggCalls);
    }

    private RelNode convertAggInput(Aggregate agg) {
        RelNode newInput = agg.getInput().accept(this);
        Set<Integer> timeIndicatorIndices = this.gatherIndicesToMaterialize(agg, newInput);
        return this.materializeTimeIndicators(newInput, timeIndicatorIndices);
    }

    private Set<Integer> gatherIndicesToMaterialize(Aggregate agg, RelNode newInput) {
        List<RelDataType> inputFieldTypes = RelOptUtil.getFieldTypeList(newInput.getRowType());
        Predicate<Integer> isTimeIndicator = idx -> FlinkTypeFactory.isTimeIndicatorType((RelDataType)inputFieldTypes.get((int)idx));
        Set aggCallArgs = agg.getAggCallList().stream().map(AggregateCall::getArgList).flatMap(Collection::stream).filter(isTimeIndicator).collect(Collectors.toSet());
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(agg.getCluster().getMetadataQuery());
        RelWindowProperties windowProps = fmq.getRelWindowProperties(newInput);
        Set groupSets = agg.getGroupSets().stream().map(grouping -> {
            if (windowProps != null && WindowUtil.groupingContainsWindowStartEnd(grouping, windowProps)) {
                return grouping.except(windowProps.getWindowTimeColumns());
            }
            return grouping;
        }).flatMap(set -> set.asList().stream()).filter(isTimeIndicator).collect(Collectors.toSet());
        HashSet<Integer> timeIndicatorIndices = new HashSet<Integer>(aggCallArgs);
        timeIndicatorIndices.addAll(groupSets);
        return timeIndicatorIndices;
    }

    private List<AggregateCall> convertAggregateCalls(Aggregate agg) {
        return agg.getAggCallList().stream().map(call -> {
            if (FlinkTypeFactory.isTimeIndicatorType(call.getType())) {
                RelDataType callType = this.timestamp(call.getType().isNullable(), this.isTimestampLtzType(call.getType()));
                return AggregateCall.create(call.getAggregation(), call.isDistinct(), false, false, call.getArgList(), call.filterArg, RelCollations.EMPTY, callType, call.name);
            }
            return call;
        }).collect(Collectors.toList());
    }

    private RelNode visitTableAggregate(FlinkLogicalTableAggregate node) {
        FlinkLogicalTableAggregate tableAgg = node;
        FlinkLogicalAggregate correspondingAgg = FlinkLogicalAggregate.create(tableAgg.getInput(), tableAgg.getGroupSet(), tableAgg.getGroupSets(), tableAgg.getAggCallList());
        FlinkLogicalAggregate convertedAgg = this.visitAggregate(correspondingAgg);
        return new FlinkLogicalTableAggregate(tableAgg.getCluster(), tableAgg.getTraitSet(), convertedAgg.getInput(), convertedAgg.getGroupSet(), convertedAgg.getGroupSets(), convertedAgg.getAggCallList());
    }

    private FlinkLogicalWindowAggregate visitWindowAggregate(FlinkLogicalWindowAggregate agg) {
        Seq newNamedProperties;
        LogicalWindow newWindow;
        boolean convertedToRowtimeTimestampLtz;
        RelNode newInput = this.convertAggInput(agg);
        List<AggregateCall> updatedAggCalls = this.convertAggregateCalls(agg);
        LogicalWindow oldWindow = agg.getWindow();
        Seq oldNamedProperties = agg.getNamedProperties();
        FieldReferenceExpression oldTimeAttribute = agg.getWindow().timeAttribute();
        LogicalType oldTimeAttributeType = oldTimeAttribute.getOutputDataType().getLogicalType();
        boolean isRowtimeIndicator = LogicalTypeChecks.isRowtimeAttribute(oldTimeAttributeType);
        if (!isRowtimeIndicator) {
            convertedToRowtimeTimestampLtz = false;
        } else {
            int timeIndicatorIdx = oldTimeAttribute.getFieldIndex();
            RelDataType oldType = agg.getInput().getRowType().getFieldList().get(timeIndicatorIdx).getType();
            RelDataType newType = newInput.getRowType().getFieldList().get(timeIndicatorIdx).getType();
            boolean bl = convertedToRowtimeTimestampLtz = this.isTimestampLtzType(newType) && !this.isTimestampLtzType(oldType);
        }
        if (convertedToRowtimeTimestampLtz) {
            LogicalWindow window;
            LocalZonedTimestampType newTimestampLtzType = new LocalZonedTimestampType(oldTimeAttributeType.isNullable(), TimestampKind.ROWTIME, 3);
            FieldReferenceExpression newFieldRef = new FieldReferenceExpression(oldTimeAttribute.getName(), LogicalTypeDataTypeConverter.fromLogicalTypeToDataType(newTimestampLtzType), oldTimeAttribute.getInputIndex(), oldTimeAttribute.getFieldIndex());
            PlannerWindowReference newAlias = new PlannerWindowReference(oldWindow.aliasAttribute().getName(), newTimestampLtzType);
            if (oldWindow instanceof TumblingGroupWindow) {
                window = (TumblingGroupWindow)oldWindow;
                newWindow = new TumblingGroupWindow(newAlias, newFieldRef, ((TumblingGroupWindow)window).size());
            } else if (oldWindow instanceof SlidingGroupWindow) {
                window = (SlidingGroupWindow)oldWindow;
                newWindow = new SlidingGroupWindow(newAlias, newFieldRef, ((SlidingGroupWindow)window).size(), ((SlidingGroupWindow)window).slide());
            } else if (oldWindow instanceof SessionGroupWindow) {
                window = (SessionGroupWindow)oldWindow;
                newWindow = new SessionGroupWindow(newAlias, newFieldRef, ((SessionGroupWindow)window).gap());
            } else {
                throw new TableException(String.format("This is a bug and should not happen. Please file an issue. Invalid window %s.", oldWindow.getClass().getSimpleName()));
            }
            List newNamedPropertiesList = ((List)JavaConverters.seqAsJavaListConverter(oldNamedProperties).asJava()).stream().map(namedProperty -> {
                if (namedProperty.getProperty() instanceof PlannerRowtimeAttribute) {
                    return new PlannerNamedWindowProperty(namedProperty.getName(), new PlannerRowtimeAttribute(newAlias));
                }
                return namedProperty;
            }).collect(Collectors.toList());
            newNamedProperties = ((Iterable)JavaConverters.iterableAsScalaIterableConverter(newNamedPropertiesList).asScala()).toSeq();
        } else {
            newWindow = oldWindow;
            newNamedProperties = oldNamedProperties;
        }
        return new FlinkLogicalWindowAggregate(agg.getCluster(), agg.getTraitSet(), newInput, agg.getGroupSet(), updatedAggCalls, newWindow, newNamedProperties);
    }

    private RelNode visitWindowTableAggregate(FlinkLogicalWindowTableAggregate node) {
        FlinkLogicalWindowTableAggregate tableAgg = node;
        FlinkLogicalWindowAggregate correspondingAgg = new FlinkLogicalWindowAggregate(tableAgg.getCluster(), tableAgg.getTraitSet(), tableAgg.getInput(), tableAgg.getGroupSet(), tableAgg.getAggCallList(), tableAgg.getWindow(), tableAgg.getNamedProperties());
        FlinkLogicalWindowAggregate convertedWindowAgg = this.visitWindowAggregate(correspondingAgg);
        return new FlinkLogicalWindowTableAggregate(tableAgg.getCluster(), tableAgg.getTraitSet(), convertedWindowAgg.getInput(), tableAgg.getGroupSet(), tableAgg.getGroupSets(), convertedWindowAgg.getAggCallList(), tableAgg.getWindow(), tableAgg.getNamedProperties());
    }

    private RelNode visitInvalidRel(RelNode node) {
        throw new TableException(String.format("This is a bug and should not happen. Please file an issue. Unknown node %s.", node.getRelTypeName()));
    }

    private RelNode materializeProcTime(RelNode node) {
        if (node instanceof FlinkLogicalValues && FlinkLogicalValues.isEmpty((FlinkLogicalValues)node)) {
            return node;
        }
        Set<Integer> procTimeFieldIndices = this.gatherProcTimeIndices(node);
        return this.materializeTimeIndicators(node, procTimeFieldIndices);
    }

    private RelNode materializeTimeIndicators(RelNode node) {
        Set<Integer> timeFieldIndices = this.gatherTimeAttributeIndices(node);
        return this.materializeTimeIndicators(node, timeFieldIndices);
    }

    private RelNode materializeTimeIndicators(RelNode node, Set<Integer> timeIndicatorIndices) {
        if (timeIndicatorIndices.isEmpty()) {
            return node;
        }
        if (node instanceof FlinkLogicalCalc) {
            return this.mergeCalcToMaterializeTimeIndicators((FlinkLogicalCalc)node, timeIndicatorIndices);
        }
        return this.createCalcToMaterializeTimeIndicators(node, timeIndicatorIndices);
    }

    private RelNode mergeCalcToMaterializeTimeIndicators(FlinkLogicalCalc calc, Set<Integer> refIndices) {
        RexProgram program = calc.getProgram();
        RexProgramBuilder newProgramBuilder = new RexProgramBuilder(program.getInputRowType(), this.rexBuilder);
        for (int idx = 0; idx < program.getNamedProjects().size(); ++idx) {
            Pair<RexLocalRef, String> pair = program.getNamedProjects().get(idx);
            RexNode project = program.expandLocalRef((RexLocalRef)pair.left);
            if (refIndices.contains(idx)) {
                project = this.materializeTimeIndicators(project);
            }
            newProgramBuilder.addProject(project, (String)pair.right);
        }
        if (program.getCondition() != null) {
            newProgramBuilder.addCondition(program.expandLocalRef(program.getCondition()));
        }
        RexProgram newProgram = newProgramBuilder.getProgram();
        return FlinkLogicalCalc.create(calc.getInput(), newProgram);
    }

    private RelNode createCalcToMaterializeTimeIndicators(RelNode input, Set<Integer> refIndices) {
        List projects = input.getRowType().getFieldList().stream().map(field -> {
            RexNode project = new RexInputRef(field.getIndex(), field.getType());
            if (refIndices.contains(field.getIndex())) {
                project = this.materializeTimeIndicators(project);
            }
            return project;
        }).collect(Collectors.toList());
        RexProgram newProgram = RexProgram.create(input.getRowType(), projects, null, input.getRowType().getFieldNames(), this.rexBuilder);
        return FlinkLogicalCalc.create(input, newProgram);
    }

    private RexNode materializeTimeIndicators(RexNode expr) {
        if (FlinkTypeFactory.isRowtimeIndicatorType(expr.getType())) {
            return this.rexBuilder.makeAbstractCast(this.timestamp(expr.getType().isNullable(), this.isTimestampLtzType(expr.getType())), expr);
        }
        if (FlinkTypeFactory.isProctimeIndicatorType(expr.getType())) {
            return this.rexBuilder.makeCall((SqlOperator)FlinkSqlOperatorTable.PROCTIME_MATERIALIZE, expr);
        }
        return expr;
    }

    private void validateType(RelDataType l, RelDataType r) {
        boolean isValid2;
        if (FlinkTypeFactory.isTimeIndicatorType(l) && FlinkTypeFactory.isTimeIndicatorType(r)) {
            boolean leftIsEventTime = ((TimeIndicatorRelDataType)l).isEventTime();
            boolean rightIsEventTime = ((TimeIndicatorRelDataType)r).isEventTime();
            isValid2 = leftIsEventTime && rightIsEventTime ? this.isTimestampLtzType(l) == this.isTimestampLtzType(r) : leftIsEventTime == rightIsEventTime;
        } else {
            boolean bl = isValid2 = !FlinkTypeFactory.isTimeIndicatorType(l) && !FlinkTypeFactory.isTimeIndicatorType(r);
        }
        if (!isValid2) {
            throw new ValidationException(String.format("Union fields with time attributes requires same types, but the types are %s and %s.", l, r));
        }
    }

    private RelDataType getRowTypeWithoutTimeIndicator(RelDataType relType, boolean isTimestampLtzType, Predicate<String> shouldMaterialize) {
        Map convertedFields = relType.getFieldList().stream().map(field -> {
            RelDataType fieldType = field.getType();
            if (FlinkTypeFactory.isTimeIndicatorType(fieldType)) {
                if (isTimestampLtzType) {
                    fieldType = ((FlinkTypeFactory)this.rexBuilder.getTypeFactory()).createFieldTypeFromLogicalType(new LocalZonedTimestampType(fieldType.isNullable(), TimestampKind.ROWTIME, 3));
                }
                if (shouldMaterialize.test(field.getName())) {
                    fieldType = this.timestamp(fieldType.isNullable(), this.isTimestampLtzType(fieldType));
                }
            }
            return Tuple2.of((Object)field.getName(), (Object)fieldType);
        }).collect(Collectors.toMap(t -> (String)t.f0, t -> (RelDataType)t.f1, (e1, e2) -> e1, LinkedHashMap::new));
        return this.rexBuilder.getTypeFactory().builder().addAll((java.lang.Iterable)convertedFields.entrySet()).build();
    }

    private Set<Integer> gatherProcTimeIndices(RelNode node) {
        return this.gatherTimeAttributeIndices(node, f -> FlinkTypeFactory.isProctimeIndicatorType(f.getType()));
    }

    private Set<Integer> gatherTimeAttributeIndices(RelNode node) {
        return this.gatherTimeAttributeIndices(node, f -> FlinkTypeFactory.isTimeIndicatorType(f.getType()));
    }

    private Set<Integer> gatherTimeAttributeIndices(RelNode node, Predicate<RelDataTypeField> predicate) {
        return node.getRowType().getFieldList().stream().filter(predicate).map(RelDataTypeField::getIndex).collect(Collectors.toSet());
    }

    private RelDataType timestamp(boolean isNullable, boolean isTimestampLtzIndicator) {
        LogicalType logicalType = isTimestampLtzIndicator ? new LocalZonedTimestampType(isNullable, 3) : new TimestampType(isNullable, 3);
        return ((FlinkTypeFactory)this.rexBuilder.getTypeFactory()).createFieldTypeFromLogicalType(logicalType);
    }

    private boolean isTimestampLtzType(RelDataType type) {
        return type.getSqlTypeName().equals((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
    }

    private class RexTimeIndicatorMaterializer
    extends RexShuttle {
        private final List<RelDataType> inputFieldTypes;

        private RexTimeIndicatorMaterializer(RelNode node) {
            this(RelOptUtil.getFieldTypeList(node.getRowType()));
        }

        private RexTimeIndicatorMaterializer(List<RelDataType> inputFieldTypes) {
            this.inputFieldTypes = inputFieldTypes;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexCall updatedCall = (RexCall)super.visitCall(call);
            SqlOperator updatedCallOp = updatedCall.getOperator();
            List<RexNode> materializedOperands = updatedCallOp == FlinkSqlOperatorTable.SESSION_OLD || updatedCallOp == FlinkSqlOperatorTable.HOP_OLD || updatedCallOp == FlinkSqlOperatorTable.TUMBLE_OLD ? updatedCall.getOperands() : updatedCall.getOperands().stream().map(x$0 -> RelTimeIndicatorConverter.this.materializeTimeIndicators(x$0)).collect(Collectors.toList());
            if (MatchUtil.isFinalOnRowTimeIndicator(call)) {
                RelDataType rowTimeType = updatedCall.getOperands().get(0).getType();
                return RelTimeIndicatorConverter.this.rexBuilder.makeCall(rowTimeType, updatedCall.getOperator(), updatedCall.getOperands());
            }
            if (MatchUtil.isMatchRowTimeIndicator(updatedCall)) {
                RelDataType firstRowTypeType = this.inputFieldTypes.stream().filter(FlinkTypeFactory::isTimeIndicatorType).findFirst().get();
                return RelTimeIndicatorConverter.this.rexBuilder.makeCall(((FlinkTypeFactory)RelTimeIndicatorConverter.this.rexBuilder.getTypeFactory()).createRowtimeIndicatorType(updatedCall.getType().isNullable(), RelTimeIndicatorConverter.this.isTimestampLtzType(firstRowTypeType)), updatedCall.getOperator(), materializedOperands);
            }
            if (FlinkTypeFactory.isTimeIndicatorType(updatedCall.getType())) {
                if (updatedCallOp == FlinkSqlOperatorTable.TUMBLE_ROWTIME || updatedCallOp == FlinkSqlOperatorTable.TUMBLE_PROCTIME || updatedCallOp == FlinkSqlOperatorTable.HOP_ROWTIME || updatedCallOp == FlinkSqlOperatorTable.HOP_PROCTIME || updatedCallOp == FlinkSqlOperatorTable.SESSION_ROWTIME || updatedCallOp == FlinkSqlOperatorTable.SESSION_PROCTIME || updatedCallOp == FlinkSqlOperatorTable.MATCH_PROCTIME || updatedCallOp == FlinkSqlOperatorTable.PROCTIME || updatedCallOp == SqlStdOperatorTable.AS || updatedCallOp == SqlStdOperatorTable.CAST || updatedCallOp == FlinkSqlOperatorTable.REINTERPRET) {
                    return updatedCall;
                }
                return updatedCall.clone(RelTimeIndicatorConverter.this.timestamp(updatedCall.getType().isNullable(), RelTimeIndicatorConverter.this.isTimestampLtzType(updatedCall.getType())), materializedOperands);
            }
            return updatedCall.clone(updatedCall.getType(), materializedOperands);
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            RelDataType oldType = inputRef.getType();
            if (FlinkTypeFactory.isTimeIndicatorType(oldType)) {
                RelDataType resolvedRefType = this.inputFieldTypes.get(inputRef.getIndex());
                if (RelTimeIndicatorConverter.this.isTimestampLtzType(resolvedRefType) && !RelTimeIndicatorConverter.this.isTimestampLtzType(oldType)) {
                    return RelTimeIndicatorConverter.this.rexBuilder.makeInputRef(resolvedRefType, inputRef.getIndex());
                }
                if (!FlinkTypeFactory.isTimeIndicatorType(resolvedRefType)) {
                    return new RexInputRef(inputRef.getIndex(), resolvedRefType);
                }
            }
            return super.visitInputRef(inputRef);
        }

        @Override
        public RexNode visitPatternFieldRef(RexPatternFieldRef fieldRef) {
            RelDataType oldType = fieldRef.getType();
            if (FlinkTypeFactory.isTimeIndicatorType(oldType)) {
                RelDataType resolvedRefType = this.inputFieldTypes.get(fieldRef.getIndex());
                if (RelTimeIndicatorConverter.this.isTimestampLtzType(resolvedRefType) && !RelTimeIndicatorConverter.this.isTimestampLtzType(oldType)) {
                    return RelTimeIndicatorConverter.this.rexBuilder.makePatternFieldRef(fieldRef.getAlpha(), resolvedRefType, fieldRef.getIndex());
                }
                if (!FlinkTypeFactory.isTimeIndicatorType(resolvedRefType)) {
                    return new RexPatternFieldRef(fieldRef.getAlpha(), fieldRef.getIndex(), resolvedRefType);
                }
            }
            return super.visitPatternFieldRef(fieldRef);
        }
    }
}

