/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.util.StringUtils;

@Internal
public class OperationUtils {
    private static final String OPERATION_INDENT = "    ";

    static String indent(String item) {
        return "\n    " + item.replace("\n    ", "\n        ");
    }

    public static <T extends Operation> String formatWithChildren(String operationName, Map<String, Object> parameters, List<T> children, Function<T, String> childToString) {
        String description = parameters.entrySet().stream().map(entry -> OperationUtils.formatParameter((String)entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(operationName).append(":");
        if (!StringUtils.isNullOrWhitespaceOnly((String)description)) {
            stringBuilder.append(" (").append(description).append(")");
        }
        String childrenDescription = children.stream().map(child -> OperationUtils.indent((String)childToString.apply(child))).collect(Collectors.joining());
        return stringBuilder.append(childrenDescription).toString();
    }

    public static String formatParameter(String name, Object value2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(name);
        stringBuilder.append(": ");
        if (value2.getClass().isArray()) {
            stringBuilder.append(Arrays.toString((Object[])value2));
        } else if (value2 instanceof Collection) {
            stringBuilder.append(value2);
        } else {
            stringBuilder.append("[").append(value2).append("]");
        }
        return stringBuilder.toString();
    }

    public static String formatProperties(Map<String, String> properties) {
        return properties.entrySet().stream().map(entry -> OperationUtils.formatParameter((String)entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
    }

    public static String formatPartitionSpec(CatalogPartitionSpec spec) {
        return spec.getPartitionSpec().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", "));
    }

    private OperationUtils() {
    }
}

