/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.writer;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.MapDataSerializer;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public interface BinaryWriter {
    public void reset();

    public void setNullAt(int var1);

    public void writeBoolean(int var1, boolean var2);

    public void writeByte(int var1, byte var2);

    public void writeShort(int var1, short var2);

    public void writeInt(int var1, int var2);

    public void writeLong(int var1, long var2);

    public void writeFloat(int var1, float var2);

    public void writeDouble(int var1, double var2);

    public void writeString(int var1, StringData var2);

    public void writeBinary(int var1, byte[] var2);

    public void writeDecimal(int var1, DecimalData var2, int var3);

    public void writeTimestamp(int var1, TimestampData var2, int var3);

    public void writeArray(int var1, ArrayData var2, ArrayDataSerializer var3);

    public void writeMap(int var1, MapData var2, MapDataSerializer var3);

    public void writeRow(int var1, RowData var2, RowDataSerializer var3);

    public void writeRawValue(int var1, RawValueData<?> var2, RawValueDataSerializer<?> var3);

    public void complete();

    @Deprecated
    public static void write(BinaryWriter writer, int pos, Object o, LogicalType type, TypeSerializer<?> serializer) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                writer.writeBoolean(pos, (Boolean)o);
                break;
            }
            case TINYINT: {
                writer.writeByte(pos, (Byte)o);
                break;
            }
            case SMALLINT: {
                writer.writeShort(pos, (Short)o);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                writer.writeInt(pos, (Integer)o);
                break;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                writer.writeLong(pos, (Long)o);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                writer.writeTimestamp(pos, (TimestampData)o, timestampType.getPrecision());
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)type;
                writer.writeTimestamp(pos, (TimestampData)o, lzTs.getPrecision());
                break;
            }
            case FLOAT: {
                writer.writeFloat(pos, ((Float)o).floatValue());
                break;
            }
            case DOUBLE: {
                writer.writeDouble(pos, (Double)o);
                break;
            }
            case CHAR: 
            case VARCHAR: {
                writer.writeString(pos, (StringData)o);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                writer.writeDecimal(pos, (DecimalData)o, decimalType.getPrecision());
                break;
            }
            case ARRAY: {
                writer.writeArray(pos, (ArrayData)o, (ArrayDataSerializer)serializer);
                break;
            }
            case MAP: 
            case MULTISET: {
                writer.writeMap(pos, (MapData)o, (MapDataSerializer)serializer);
                break;
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                writer.writeRow(pos, (RowData)o, (RowDataSerializer)serializer);
                break;
            }
            case RAW: {
                writer.writeRawValue(pos, (RawValueData)o, (RawValueDataSerializer)serializer);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                writer.writeBinary(pos, (byte[])o);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not support type: " + type);
            }
        }
    }

    public static ValueSetter createValueSetter(LogicalType elementType) {
        switch (elementType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return (writer, pos, value2) -> writer.writeString(pos, (StringData)value2);
            }
            case BOOLEAN: {
                return (writer, pos, value2) -> writer.writeBoolean(pos, (Boolean)value2);
            }
            case BINARY: 
            case VARBINARY: {
                return (writer, pos, value2) -> writer.writeBinary(pos, (byte[])value2);
            }
            case DECIMAL: {
                int decimalPrecision = LogicalTypeChecks.getPrecision(elementType);
                return (writer, pos, value2) -> writer.writeDecimal(pos, (DecimalData)value2, decimalPrecision);
            }
            case TINYINT: {
                return (writer, pos, value2) -> writer.writeByte(pos, (Byte)value2);
            }
            case SMALLINT: {
                return (writer, pos, value2) -> writer.writeShort(pos, (Short)value2);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return (writer, pos, value2) -> writer.writeInt(pos, (Integer)value2);
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return (writer, pos, value2) -> writer.writeLong(pos, (Long)value2);
            }
            case FLOAT: {
                return (writer, pos, value2) -> writer.writeFloat(pos, ((Float)value2).floatValue());
            }
            case DOUBLE: {
                return (writer, pos, value2) -> writer.writeDouble(pos, (Double)value2);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = LogicalTypeChecks.getPrecision(elementType);
                return (writer, pos, value2) -> writer.writeTimestamp(pos, (TimestampData)value2, timestampPrecision);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new UnsupportedOperationException();
            }
            case ARRAY: {
                TypeSerializer arraySerializer = InternalSerializers.create(elementType);
                return (writer, pos, value2) -> writer.writeArray(pos, (ArrayData)value2, (ArrayDataSerializer)arraySerializer);
            }
            case MAP: 
            case MULTISET: {
                TypeSerializer mapSerializer = InternalSerializers.create(elementType);
                return (writer, pos, value2) -> writer.writeMap(pos, (MapData)value2, (MapDataSerializer)mapSerializer);
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                TypeSerializer rowSerializer = InternalSerializers.create(elementType);
                return (writer, pos, value2) -> writer.writeRow(pos, (RowData)value2, (RowDataSerializer)rowSerializer);
            }
            case DISTINCT_TYPE: {
                return BinaryWriter.createValueSetter(((DistinctType)elementType).getSourceType());
            }
            case RAW: {
                TypeSerializer rawSerializer = InternalSerializers.create(elementType);
                return (writer, pos, value2) -> writer.writeRawValue(pos, (RawValueData)value2, (RawValueDataSerializer)rawSerializer);
            }
        }
        throw new IllegalArgumentException();
    }

    public static interface ValueSetter
    extends Serializable {
        public void setValue(BinaryArrayWriter var1, int var2, Object var3);
    }
}

