/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.vector.heap;

import java.util.Arrays;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.vector.writable.WritableTimestampVector;

public class HeapTimestampVector
extends AbstractHeapVector
implements WritableTimestampVector {
    private static final long serialVersionUID = 1L;
    private final long[] milliseconds;
    private final int[] nanoOfMilliseconds;

    public HeapTimestampVector(int len) {
        super(len);
        this.milliseconds = new long[len];
        this.nanoOfMilliseconds = new int[len];
    }

    @Override
    public TimestampData getTimestamp(int i, int precision) {
        if (this.dictionary == null) {
            return TimestampData.fromEpochMillis(this.milliseconds[i], this.nanoOfMilliseconds[i]);
        }
        return this.dictionary.decodeToTimestamp(this.dictionaryIds.vector[i]);
    }

    @Override
    public void setTimestamp(int i, TimestampData timestamp) {
        this.milliseconds[i] = timestamp.getMillisecond();
        this.nanoOfMilliseconds[i] = timestamp.getNanoOfMillisecond();
    }

    @Override
    public void fill(TimestampData value2) {
        Arrays.fill(this.milliseconds, value2.getMillisecond());
        Arrays.fill(this.nanoOfMilliseconds, value2.getNanoOfMillisecond());
    }
}

