/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.conversion.ArrayBooleanArrayConverter;
import org.apache.flink.table.data.conversion.ArrayByteArrayConverter;
import org.apache.flink.table.data.conversion.ArrayDoubleArrayConverter;
import org.apache.flink.table.data.conversion.ArrayFloatArrayConverter;
import org.apache.flink.table.data.conversion.ArrayIntArrayConverter;
import org.apache.flink.table.data.conversion.ArrayListConverter;
import org.apache.flink.table.data.conversion.ArrayLongArrayConverter;
import org.apache.flink.table.data.conversion.ArrayObjectArrayConverter;
import org.apache.flink.table.data.conversion.ArrayShortArrayConverter;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DateDateConverter;
import org.apache.flink.table.data.conversion.DateLocalDateConverter;
import org.apache.flink.table.data.conversion.DayTimeIntervalDurationConverter;
import org.apache.flink.table.data.conversion.DecimalBigDecimalConverter;
import org.apache.flink.table.data.conversion.IdentityConverter;
import org.apache.flink.table.data.conversion.LocalZonedTimestampInstantConverter;
import org.apache.flink.table.data.conversion.LocalZonedTimestampIntConverter;
import org.apache.flink.table.data.conversion.LocalZonedTimestampLongConverter;
import org.apache.flink.table.data.conversion.LocalZonedTimestampTimestampConverter;
import org.apache.flink.table.data.conversion.MapMapConverter;
import org.apache.flink.table.data.conversion.RawByteArrayConverter;
import org.apache.flink.table.data.conversion.RawObjectConverter;
import org.apache.flink.table.data.conversion.RowRowConverter;
import org.apache.flink.table.data.conversion.StringByteArrayConverter;
import org.apache.flink.table.data.conversion.StringStringConverter;
import org.apache.flink.table.data.conversion.StructuredObjectConverter;
import org.apache.flink.table.data.conversion.TimeLocalTimeConverter;
import org.apache.flink.table.data.conversion.TimeLongConverter;
import org.apache.flink.table.data.conversion.TimeTimeConverter;
import org.apache.flink.table.data.conversion.TimestampLocalDateTimeConverter;
import org.apache.flink.table.data.conversion.TimestampTimestampConverter;
import org.apache.flink.table.data.conversion.YearMonthIntervalPeriodConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.types.Row;

@Internal
public final class DataStructureConverters {
    private static final Map<ConverterIdentifier<?>, DataStructureConverterFactory> converters = new HashMap();

    public static DataStructureConverter<Object, Object> getConverter(DataType dataType2) {
        return DataStructureConverters.getConverterInternal(dataType2);
    }

    private static DataStructureConverter<?, ?> getConverterInternal(DataType dataType2) {
        LogicalType logicalType = dataType2.getLogicalType();
        DataStructureConverterFactory factory = converters.get(new ConverterIdentifier(logicalType.getTypeRoot(), dataType2.getConversionClass()));
        if (factory != null) {
            return factory.createConverter(dataType2);
        }
        switch (logicalType.getTypeRoot()) {
            case ARRAY: {
                if (List.class.isAssignableFrom(dataType2.getConversionClass())) {
                    return ArrayListConverter.create(dataType2);
                }
                return ArrayObjectArrayConverter.create(dataType2);
            }
            case MULTISET: {
                return MapMapConverter.createForMultisetType(dataType2);
            }
            case MAP: {
                return MapMapConverter.createForMapType(dataType2);
            }
            case DISTINCT_TYPE: {
                return DataStructureConverters.getConverterInternal(dataType2.getChildren().get(0));
            }
            case STRUCTURED_TYPE: {
                return StructuredObjectConverter.create(dataType2);
            }
            case RAW: {
                return RawObjectConverter.create(dataType2);
            }
        }
        throw new TableException("Could not find converter for data type: " + dataType2);
    }

    private static <E> void putConverter(LogicalTypeRoot root2, Class<E> conversionClass, DataStructureConverterFactory factory) {
        converters.put(new ConverterIdentifier<E>(root2, conversionClass), factory);
    }

    private static DataStructureConverterFactory identity() {
        return DataStructureConverters.constructor(IdentityConverter::new);
    }

    private static DataStructureConverterFactory constructor(Supplier<DataStructureConverter<?, ?>> supplier) {
        return dataType2 -> (DataStructureConverter)supplier.get();
    }

    private static DataStructureConverterFactory unsupported() {
        return dataType2 -> {
            throw new TableException("Unsupported data type: " + dataType2);
        };
    }

    static {
        DataStructureConverters.putConverter(LogicalTypeRoot.CHAR, String.class, DataStructureConverters.constructor(StringStringConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.CHAR, byte[].class, DataStructureConverters.constructor(StringByteArrayConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.CHAR, StringData.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.VARCHAR, String.class, DataStructureConverters.constructor(StringStringConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.VARCHAR, byte[].class, DataStructureConverters.constructor(StringByteArrayConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.VARCHAR, StringData.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.BOOLEAN, Boolean.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.BOOLEAN, Boolean.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.BINARY, byte[].class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.VARBINARY, byte[].class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.DECIMAL, BigDecimal.class, DecimalBigDecimalConverter::create);
        DataStructureConverters.putConverter(LogicalTypeRoot.DECIMAL, DecimalData.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.TINYINT, Byte.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.TINYINT, Byte.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.SMALLINT, Short.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.SMALLINT, Short.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.INTEGER, Integer.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.INTEGER, Integer.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.BIGINT, Long.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.BIGINT, Long.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.FLOAT, Float.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.FLOAT, Float.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.DOUBLE, Double.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.DOUBLE, Double.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.DATE, Date.class, DataStructureConverters.constructor(DateDateConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.DATE, LocalDate.class, DataStructureConverters.constructor(DateLocalDateConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.DATE, Integer.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.DATE, Integer.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, Time.class, DataStructureConverters.constructor(TimeTimeConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LocalTime.class, DataStructureConverters.constructor(TimeLocalTimeConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, Integer.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, Integer.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, Long.class, DataStructureConverters.constructor(TimeLongConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, Long.TYPE, DataStructureConverters.constructor(TimeLongConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, Timestamp.class, DataStructureConverters.constructor(TimestampTimestampConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LocalDateTime.class, DataStructureConverters.constructor(TimestampLocalDateTimeConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, TimestampData.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, ZonedDateTime.class, DataStructureConverters.unsupported());
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, OffsetDateTime.class, DataStructureConverters.unsupported());
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, Instant.class, DataStructureConverters.constructor(LocalZonedTimestampInstantConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, Integer.class, DataStructureConverters.constructor(LocalZonedTimestampIntConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, Integer.TYPE, DataStructureConverters.constructor(LocalZonedTimestampIntConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, Long.class, DataStructureConverters.constructor(LocalZonedTimestampLongConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, Long.TYPE, DataStructureConverters.constructor(LocalZonedTimestampLongConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, Timestamp.class, DataStructureConverters.constructor(LocalZonedTimestampTimestampConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, TimestampData.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.INTERVAL_YEAR_MONTH, Period.class, YearMonthIntervalPeriodConverter::create);
        DataStructureConverters.putConverter(LogicalTypeRoot.INTERVAL_YEAR_MONTH, Integer.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.INTERVAL_YEAR_MONTH, Integer.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.INTERVAL_DAY_TIME, Duration.class, DataStructureConverters.constructor(DayTimeIntervalDurationConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.INTERVAL_DAY_TIME, Long.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.INTERVAL_DAY_TIME, Long.TYPE, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.ARRAY, ArrayData.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.ARRAY, boolean[].class, DataStructureConverters.constructor(ArrayBooleanArrayConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.ARRAY, byte[].class, DataStructureConverters.constructor(ArrayByteArrayConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.ARRAY, short[].class, DataStructureConverters.constructor(ArrayShortArrayConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.ARRAY, int[].class, DataStructureConverters.constructor(ArrayIntArrayConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.ARRAY, long[].class, DataStructureConverters.constructor(ArrayLongArrayConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.ARRAY, float[].class, DataStructureConverters.constructor(ArrayFloatArrayConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.ARRAY, double[].class, DataStructureConverters.constructor(ArrayDoubleArrayConverter::new));
        DataStructureConverters.putConverter(LogicalTypeRoot.MULTISET, MapData.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.MAP, MapData.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.ROW, Row.class, RowRowConverter::create);
        DataStructureConverters.putConverter(LogicalTypeRoot.ROW, RowData.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.STRUCTURED_TYPE, Row.class, RowRowConverter::create);
        DataStructureConverters.putConverter(LogicalTypeRoot.STRUCTURED_TYPE, RowData.class, DataStructureConverters.identity());
        DataStructureConverters.putConverter(LogicalTypeRoot.RAW, byte[].class, RawByteArrayConverter::create);
        DataStructureConverters.putConverter(LogicalTypeRoot.RAW, RawValueData.class, DataStructureConverters.identity());
    }

    private static interface DataStructureConverterFactory {
        public DataStructureConverter<?, ?> createConverter(DataType var1);
    }

    private static class ConverterIdentifier<E> {
        final LogicalTypeRoot root;
        final Class<E> conversionClass;

        ConverterIdentifier(LogicalTypeRoot root2, Class<E> conversionClass) {
            this.root = root2;
            this.conversionClass = conversionClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConverterIdentifier that = (ConverterIdentifier)o;
            return this.root == that.root && this.conversionClass.equals(that.conversionClass);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.root, this.conversionClass});
        }
    }
}

