/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.binary;

import java.nio.ByteOrder;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinarySection;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.binary.NestedRowData;
import org.apache.flink.table.data.binary.NullAwareGetters;
import org.apache.flink.table.data.binary.TypedSetters;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

@Internal
public final class BinaryRowData
extends BinarySection
implements RowData,
TypedSetters,
NullAwareGetters {
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final long FIRST_BYTE_ZERO = LITTLE_ENDIAN ? -256L : 0xFFFFFFFFFFFFFFL;
    public static final int HEADER_SIZE_IN_BITS = 8;
    private final int arity;
    private final int nullBitsSizeInBytes;

    public static int calculateBitSetWidthInBytes(int arity) {
        return (arity + 63 + 8) / 64 * 8;
    }

    public static int calculateFixPartSizeInBytes(int arity) {
        return BinaryRowData.calculateBitSetWidthInBytes(arity) + 8 * arity;
    }

    public static boolean isInFixedLengthPart(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: 
            case BIGINT: 
            case INTERVAL_DAY_TIME: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
            case DECIMAL: {
                return DecimalData.isCompact(((DecimalType)type).getPrecision());
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TimestampData.isCompact(((TimestampType)type).getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return TimestampData.isCompact(((LocalZonedTimestampType)type).getPrecision());
            }
        }
        return false;
    }

    public static boolean isMutable(LogicalType type) {
        return BinaryRowData.isInFixedLengthPart(type) || type.getTypeRoot() == LogicalTypeRoot.DECIMAL;
    }

    public BinaryRowData(int arity) {
        Preconditions.checkArgument((arity >= 0 ? 1 : 0) != 0);
        this.arity = arity;
        this.nullBitsSizeInBytes = BinaryRowData.calculateBitSetWidthInBytes(arity);
    }

    private int getFieldOffset(int pos) {
        return this.offset + this.nullBitsSizeInBytes + pos * 8;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.arity) : "index (" + index + ") should < " + this.arity;
    }

    public int getFixedLengthPartSize() {
        return this.nullBitsSizeInBytes + 8 * this.arity;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public RowKind getRowKind() {
        byte kindValue = this.segments[0].get(this.offset);
        return RowKind.fromByteValue((byte)kindValue);
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.segments[0].put(this.offset, kind.toByteValue());
    }

    public void setTotalSize(int sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.bitGet(this.segments[0], this.offset, pos + 8);
    }

    private void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        BinarySegmentUtils.bitUnSet(this.segments[0], this.offset, i + 8);
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        BinarySegmentUtils.bitSet(this.segments[0], this.offset, i + 8);
        this.segments[0].putLong(this.getFieldOffset(i), 0L);
    }

    @Override
    public void setInt(int pos, int value2) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putInt(this.getFieldOffset(pos), value2);
    }

    @Override
    public void setLong(int pos, long value2) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putLong(this.getFieldOffset(pos), value2);
    }

    @Override
    public void setDouble(int pos, double value2) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putDouble(this.getFieldOffset(pos), value2);
    }

    @Override
    public void setDecimal(int pos, DecimalData value2, int precision) {
        this.assertIndexIsValid(pos);
        if (DecimalData.isCompact(precision)) {
            this.setLong(pos, value2.toUnscaledLong());
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(this.segments[0].getLong(fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            BinarySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
            BinarySegmentUtils.setLong(this.segments, this.offset + cursor + 8, 0L);
            if (value2 == null) {
                this.setNullAt(pos);
                this.segments[0].putLong(fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value2.toUnscaledBytes();
                assert (bytes.length <= 16);
                BinarySegmentUtils.copyFromBytes(this.segments, this.offset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public void setTimestamp(int pos, TimestampData value2, int precision) {
        this.assertIndexIsValid(pos);
        if (TimestampData.isCompact(precision)) {
            this.setLong(pos, value2.getMillisecond());
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(this.segments[0].getLong(fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            if (value2 == null) {
                this.setNullAt(pos);
                BinarySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
                this.segments[0].putLong(fieldOffset, (long)cursor << 32);
            } else {
                BinarySegmentUtils.setLong(this.segments, this.offset + cursor, value2.getMillisecond());
                this.setLong(pos, (long)cursor << 32 | (long)value2.getNanoOfMillisecond());
            }
        }
    }

    @Override
    public void setBoolean(int pos, boolean value2) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putBoolean(this.getFieldOffset(pos), value2);
    }

    @Override
    public void setShort(int pos, short value2) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putShort(this.getFieldOffset(pos), value2);
    }

    @Override
    public void setByte(int pos, byte value2) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].put(this.getFieldOffset(pos), value2);
    }

    @Override
    public void setFloat(int pos, float value2) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putFloat(this.getFieldOffset(pos), value2);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getBoolean(this.getFieldOffset(pos));
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].get(this.getFieldOffset(pos));
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getShort(this.getFieldOffset(pos));
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getInt(this.getFieldOffset(pos));
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getLong(this.getFieldOffset(pos));
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getFloat(this.getFieldOffset(pos));
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getDouble(this.getFieldOffset(pos));
    }

    @Override
    public StringData getString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = this.segments[0].getLong(fieldOffset);
        return BinarySegmentUtils.readStringData(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (DecimalData.isCompact(precision)) {
            return DecimalData.fromUnscaledLong(this.segments[0].getLong(this.getFieldOffset(pos)), precision, scale);
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = this.segments[0].getLong(fieldOffset);
        return BinarySegmentUtils.readDecimalData(this.segments, this.offset, offsetAndSize, precision, scale);
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        this.assertIndexIsValid(pos);
        if (TimestampData.isCompact(precision)) {
            return TimestampData.fromEpochMillis(this.segments[0].getLong(this.getFieldOffset(pos)));
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndNanoOfMilli = this.segments[0].getLong(fieldOffset);
        return BinarySegmentUtils.readTimestampData(this.segments, this.offset, offsetAndNanoOfMilli);
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readRawValueData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public byte[] getBinary(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = this.segments[0].getLong(fieldOffset);
        return BinarySegmentUtils.readBinary(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public ArrayData getArray(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readArrayData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public MapData getMap(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readMapData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readRowData(this.segments, numFields, this.offset, this.getLong(pos));
    }

    @Override
    public boolean anyNull() {
        if ((this.segments[0].getLong(0) & FIRST_BYTE_ZERO) != 0L) {
            return true;
        }
        for (int i = 8; i < this.nullBitsSizeInBytes; i += 8) {
            if (this.segments[0].getLong(i) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean anyNull(int[] fields2) {
        for (int field : fields2) {
            if (!this.isNullAt(field)) continue;
            return true;
        }
        return false;
    }

    public BinaryRowData copy() {
        return this.copy(new BinaryRowData(this.arity));
    }

    public BinaryRowData copy(BinaryRowData reuse) {
        return this.copyInternal(reuse);
    }

    private BinaryRowData copyInternal(BinaryRowData reuse) {
        byte[] bytes = BinarySegmentUtils.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, this.sizeInBytes);
        return reuse;
    }

    public void clear() {
        this.segments = null;
        this.offset = 0;
        this.sizeInBytes = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryRowData) && !(o instanceof NestedRowData)) {
            return false;
        }
        BinarySection that = (BinarySection)o;
        return this.sizeInBytes == that.sizeInBytes && BinarySegmentUtils.equals(this.segments, this.offset, that.segments, that.offset, this.sizeInBytes);
    }

    @Override
    public int hashCode() {
        return BinarySegmentUtils.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }
}

