/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.TypedSetters;
import org.apache.flink.types.RowKind;

public final class UpdatableRowData
implements RowData,
TypedSetters {
    private RowData row;
    private final Object[] fields;
    private final boolean[] updated;

    public UpdatableRowData(RowData row, int arity) {
        this.row = row;
        this.fields = new Object[arity];
        this.updated = new boolean[arity];
    }

    public RowData getRow() {
        return this.row;
    }

    @Override
    public int getArity() {
        return this.fields.length;
    }

    @Override
    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.updated[pos] ? this.fields[pos] == null : this.row.isNullAt(pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.updated[pos] ? ((Boolean)this.fields[pos]).booleanValue() : this.row.getBoolean(pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.updated[pos] ? ((Byte)this.fields[pos]).byteValue() : this.row.getByte(pos);
    }

    @Override
    public short getShort(int pos) {
        return this.updated[pos] ? ((Short)this.fields[pos]).shortValue() : this.row.getShort(pos);
    }

    @Override
    public int getInt(int pos) {
        return this.updated[pos] ? ((Integer)this.fields[pos]).intValue() : this.row.getInt(pos);
    }

    @Override
    public long getLong(int pos) {
        return this.updated[pos] ? ((Long)this.fields[pos]).longValue() : this.row.getLong(pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.updated[pos] ? ((Float)this.fields[pos]).floatValue() : this.row.getFloat(pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.updated[pos] ? ((Double)this.fields[pos]).doubleValue() : this.row.getDouble(pos);
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.updated[pos] ? (byte[])this.fields[pos] : this.row.getBinary(pos);
    }

    @Override
    public StringData getString(int pos) {
        return this.updated[pos] ? (StringData)this.fields[pos] : this.row.getString(pos);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        return this.updated[pos] ? (DecimalData)this.fields[pos] : this.row.getDecimal(pos, precision, scale);
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        return this.updated[pos] ? (TimestampData)this.fields[pos] : this.row.getTimestamp(pos, precision);
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        return this.updated[pos] ? (RawValueData)this.fields[pos] : this.row.getRawValue(pos);
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        return this.updated[pos] ? (RowData)this.fields[pos] : this.row.getRow(pos, numFields);
    }

    @Override
    public ArrayData getArray(int pos) {
        return this.updated[pos] ? (ArrayData)this.fields[pos] : this.row.getArray(pos);
    }

    @Override
    public MapData getMap(int pos) {
        return this.updated[pos] ? (MapData)this.fields[pos] : this.row.getMap(pos);
    }

    @Override
    public void setNullAt(int pos) {
        this.setField(pos, null);
    }

    @Override
    public void setBoolean(int pos, boolean value2) {
        this.setField(pos, value2);
    }

    @Override
    public void setByte(int pos, byte value2) {
        this.setField(pos, value2);
    }

    @Override
    public void setShort(int pos, short value2) {
        this.setField(pos, value2);
    }

    @Override
    public void setInt(int pos, int value2) {
        this.setField(pos, value2);
    }

    @Override
    public void setLong(int pos, long value2) {
        this.setField(pos, value2);
    }

    @Override
    public void setFloat(int pos, float value2) {
        this.setField(pos, Float.valueOf(value2));
    }

    @Override
    public void setDouble(int pos, double value2) {
        this.setField(pos, value2);
    }

    @Override
    public void setDecimal(int pos, DecimalData value2, int precision) {
        this.setField(pos, value2);
    }

    @Override
    public void setTimestamp(int pos, TimestampData value2, int precision) {
        this.setField(pos, value2);
    }

    public void setField(int pos, Object value2) {
        this.updated[pos] = true;
        this.fields[pos] = value2;
    }
}

