/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.util.Arrays;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.TypedSetters;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.ShortValue;
import org.apache.flink.util.StringUtils;

public class BoxedWrapperRowData
implements RowData,
TypedSetters {
    private RowKind rowKind = RowKind.INSERT;
    protected final Object[] fields;

    public BoxedWrapperRowData(int arity) {
        this.fields = new Object[arity];
    }

    @Override
    public int getArity() {
        return this.fields.length;
    }

    @Override
    public RowKind getRowKind() {
        return this.rowKind;
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.rowKind = kind;
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.fields[pos] == null;
    }

    @Override
    public boolean getBoolean(int pos) {
        return ((BooleanValue)this.fields[pos]).getValue();
    }

    @Override
    public byte getByte(int pos) {
        return ((ByteValue)this.fields[pos]).getValue();
    }

    @Override
    public short getShort(int pos) {
        return ((ShortValue)this.fields[pos]).getValue();
    }

    @Override
    public int getInt(int pos) {
        return ((IntValue)this.fields[pos]).getValue();
    }

    @Override
    public long getLong(int pos) {
        return ((LongValue)this.fields[pos]).getValue();
    }

    @Override
    public float getFloat(int pos) {
        return ((FloatValue)this.fields[pos]).getValue();
    }

    @Override
    public double getDouble(int pos) {
        return ((DoubleValue)this.fields[pos]).getValue();
    }

    @Override
    public StringData getString(int pos) {
        return (StringData)this.fields[pos];
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        return (DecimalData)this.fields[pos];
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        return (TimestampData)this.fields[pos];
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        return (RawValueData)this.fields[pos];
    }

    @Override
    public byte[] getBinary(int pos) {
        return (byte[])this.fields[pos];
    }

    @Override
    public ArrayData getArray(int pos) {
        return (ArrayData)this.fields[pos];
    }

    @Override
    public MapData getMap(int pos) {
        return (MapData)this.fields[pos];
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        return (RowData)this.fields[pos];
    }

    @Override
    public void setNullAt(int pos) {
        this.fields[pos] = null;
    }

    @Override
    public void setBoolean(int pos, boolean value2) {
        BooleanValue wrap = (BooleanValue)this.fields[pos];
        if (wrap == null) {
            wrap = new BooleanValue();
            this.fields[pos] = wrap;
        }
        wrap.setValue(value2);
    }

    @Override
    public void setByte(int pos, byte value2) {
        ByteValue wrap = (ByteValue)this.fields[pos];
        if (wrap == null) {
            wrap = new ByteValue();
            this.fields[pos] = wrap;
        }
        wrap.setValue(value2);
    }

    @Override
    public void setShort(int pos, short value2) {
        ShortValue wrap = (ShortValue)this.fields[pos];
        if (wrap == null) {
            wrap = new ShortValue();
            this.fields[pos] = wrap;
        }
        wrap.setValue(value2);
    }

    @Override
    public void setInt(int pos, int value2) {
        IntValue wrap = (IntValue)this.fields[pos];
        if (wrap == null) {
            wrap = new IntValue();
            this.fields[pos] = wrap;
        }
        wrap.setValue(value2);
    }

    @Override
    public void setLong(int pos, long value2) {
        LongValue wrap = (LongValue)this.fields[pos];
        if (wrap == null) {
            wrap = new LongValue();
            this.fields[pos] = wrap;
        }
        wrap.setValue(value2);
    }

    @Override
    public void setFloat(int pos, float value2) {
        FloatValue wrap = (FloatValue)this.fields[pos];
        if (wrap == null) {
            wrap = new FloatValue();
            this.fields[pos] = wrap;
        }
        wrap.setValue(value2);
    }

    @Override
    public void setDouble(int pos, double value2) {
        DoubleValue wrap = (DoubleValue)this.fields[pos];
        if (wrap == null) {
            wrap = new DoubleValue();
            this.fields[pos] = wrap;
        }
        wrap.setValue(value2);
    }

    @Override
    public void setDecimal(int pos, DecimalData value2, int precision) {
        this.fields[pos] = value2;
    }

    @Override
    public void setTimestamp(int pos, TimestampData value2, int precision) {
        this.fields[pos] = value2;
    }

    public void setNonPrimitiveValue(int pos, Object value2) {
        this.fields[pos] = value2;
    }

    public int hashCode() {
        return 31 * this.rowKind.hashCode() + Arrays.hashCode(this.fields);
    }

    public boolean equals(Object o) {
        if (o instanceof BoxedWrapperRowData) {
            BoxedWrapperRowData other = (BoxedWrapperRowData)o;
            return this.rowKind == other.rowKind && Arrays.equals(this.fields, other.fields);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rowKind.shortString()).append("(");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(StringUtils.arrayAwareToString((Object)this.fields[i]));
        }
        sb.append(")");
        return sb.toString();
    }
}

