/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSortedMap;

public abstract class ImmutableNullableMap<K, V>
extends AbstractMap<K, V> {
    private static final Map<Integer, Integer> SINGLETON_MAP = Collections.singletonMap(0, 0);

    private ImmutableNullableMap() {
    }

    public static <K, V> Map<K, V> copyOf(Map<? extends K, ? extends V> map2) {
        if (map2 instanceof ImmutableNullableMap || map2 instanceof ImmutableMap || map2 == Collections.emptyMap() || map2 == Collections.emptyNavigableMap() || map2.getClass() == SINGLETON_MAP.getClass()) {
            return map2;
        }
        if (map2 instanceof SortedMap) {
            SortedMap sortedMap = (SortedMap)map2;
            try {
                return ImmutableSortedMap.copyOf(sortedMap, sortedMap.comparator());
            }
            catch (NullPointerException e) {
                return Collections.unmodifiableNavigableMap(new TreeMap(sortedMap));
            }
        }
        try {
            return ImmutableMap.copyOf(map2);
        }
        catch (NullPointerException e) {
            return Collections.unmodifiableMap(new HashMap<K, V>(map2));
        }
    }

    public static <K, V> Map<K, V> copyOf(SortedMap<? extends K, ? extends V> map2) {
        if (map2 instanceof ImmutableNullableMap || map2 instanceof ImmutableMap || map2 == Collections.emptyMap() || map2 == Collections.emptyNavigableMap()) {
            return map2;
        }
        SortedMap<K, V> sortedMap = map2;
        try {
            return ImmutableSortedMap.copyOf(sortedMap, sortedMap.comparator());
        }
        catch (NullPointerException e) {
            return Collections.unmodifiableNavigableMap(new TreeMap<K, V>(sortedMap));
        }
    }
}

