/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class ReduceDecimalsRule
extends RelRule<Config>
implements TransformationRule {
    protected ReduceDecimalsRule(Config config) {
        super(config);
    }

    @Deprecated
    public ReduceDecimalsRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public Convention getOutConvention() {
        return Convention.NONE;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalCalc calc = (LogicalCalc)call.rel(0);
        RexProgram program = calc.getProgram();
        if (!RexUtil.requiresDecimalExpansion(program, true)) {
            return;
        }
        RexBuilder rexBuilder = calc.getCluster().getRexBuilder();
        DecimalShuttle shuttle = new DecimalShuttle(rexBuilder);
        RexProgramBuilder programBuilder = RexProgramBuilder.create(rexBuilder, calc.getInput().getRowType(), program.getExprList(), program.getProjectList(), program.getCondition(), program.getOutputRowType(), shuttle, true);
        RexProgram newProgram = programBuilder.getProgram();
        LogicalCalc newCalc = LogicalCalc.create(calc.getInput(), newProgram);
        call.transformTo(newCalc);
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.withOperandSupplier(b -> b.operand(LogicalCalc.class).anyInputs()).as(Config.class);

        @Override
        default public ReduceDecimalsRule toRule() {
            return new ReduceDecimalsRule(this);
        }
    }

    private static class ReinterpretExpander
    extends RexExpander {
        private ReinterpretExpander(RexBuilder builder) {
            super(builder);
        }

        @Override
        public boolean canExpand(RexCall call) {
            return call.isA(SqlKind.REINTERPRET) && ((RexNode)call.operands.get(0)).isA(SqlKind.REINTERPRET);
        }

        @Override
        public RexNode expand(RexCall call) {
            RexNode innerValue;
            ImmutableList<RexNode> operands = call.operands;
            RexCall subCall = (RexCall)operands.get(0);
            if (this.canSimplify(call, subCall, innerValue = (RexNode)subCall.operands.get(0))) {
                return innerValue;
            }
            return call;
        }

        private boolean canSimplify(RexCall outer, RexCall inner, RexNode value2) {
            RelDataType outerType = outer.getType();
            RelDataType innerType = inner.getType();
            RelDataType valueType = value2.getType();
            boolean outerCheck = RexUtil.canReinterpretOverflow(outer);
            boolean innerCheck = RexUtil.canReinterpretOverflow(inner);
            if (outerType.getSqlTypeName() != valueType.getSqlTypeName() || outerType.getPrecision() != valueType.getPrecision() || outerType.getScale() != valueType.getScale()) {
                return false;
            }
            if (!(!valueType.isNullable() || innerType.isNullable() && outerType.isNullable())) {
                return false;
            }
            if (innerType.isNullable() && !outerType.isNullable()) {
                return false;
            }
            if (valueType.isNullable() != outerType.isNullable()) {
                return false;
            }
            return !innerCheck && !outerCheck;
        }
    }

    private static abstract class CastArgAsTypeExpander
    extends RexExpander {
        private CastArgAsTypeExpander(RexBuilder builder) {
            super(builder);
        }

        public abstract RelDataType getArgType(RexCall var1, int var2);

        @Override
        public RexNode expand(RexCall call) {
            ImmutableList.Builder opBuilder = ImmutableList.builder();
            for (Ord<RexNode> operand : Ord.zip(call.operands)) {
                RelDataType targetType = this.getArgType(call, operand.i);
                if (SqlTypeUtil.isDecimal(((RexNode)operand.e).getType())) {
                    opBuilder.add(this.ensureType(targetType, (RexNode)operand.e, true));
                    continue;
                }
                opBuilder.add(operand.e);
            }
            RexNode ret = this.builder.makeCall(call.getType(), call.getOperator(), (List<RexNode>)((Object)opBuilder.build()));
            ret = this.ensureType(call.getType(), ret, true);
            return ret;
        }
    }

    private static class CastArgAsDoubleExpander
    extends CastArgAsTypeExpander {
        private CastArgAsDoubleExpander(RexBuilder builder) {
            super(builder);
        }

        @Override
        public RelDataType getArgType(RexCall call, int ordinal) {
            RelDataType type = this.real8;
            if (((RexNode)call.operands.get(ordinal)).getType().isNullable()) {
                type = this.builder.getTypeFactory().createTypeWithNullability(type, true);
            }
            return type;
        }
    }

    private static class PassThroughExpander
    extends RexExpander {
        private PassThroughExpander(RexBuilder builder) {
            super(builder);
        }

        @Override
        public boolean canExpand(RexCall call) {
            return RexUtil.requiresDecimalExpansion(call, false);
        }

        @Override
        public RexNode expand(RexCall call) {
            ImmutableList.Builder opBuilder = ImmutableList.builder();
            for (RexNode operand : call.operands) {
                if (SqlTypeUtil.isNumeric(operand.getType())) {
                    opBuilder.add(this.accessValue(operand));
                    continue;
                }
                opBuilder.add(operand);
            }
            RexNode newCall = this.builder.makeCall(call.getType(), call.getOperator(), (List<RexNode>)((Object)opBuilder.build()));
            if (SqlTypeUtil.isDecimal(call.getType())) {
                return this.encodeValue(newCall, call.getType());
            }
            return newCall;
        }
    }

    private static class CaseExpander
    extends RexExpander {
        private CaseExpander(RexBuilder rexBuilder) {
            super(rexBuilder);
        }

        @Override
        public RexNode expand(RexCall call) {
            RelDataType retType = call.getType();
            int argCount = call.operands.size();
            ImmutableList.Builder opBuilder = ImmutableList.builder();
            for (int i = 0; i < argCount; ++i) {
                if (i % 2 == 0 && i != argCount - 1) {
                    opBuilder.add(call.operands.get(i));
                    continue;
                }
                RexNode expr = this.ensureType(retType, (RexNode)call.operands.get(i), false);
                if (SqlTypeUtil.isDecimal(retType)) {
                    expr = this.decodeValue(expr);
                }
                opBuilder.add(expr);
            }
            RexNode newCall = this.builder.makeCall(retType, call.getOperator(), (List<RexNode>)((Object)opBuilder.build()));
            if (SqlTypeUtil.isDecimal(retType)) {
                newCall = this.encodeValue(newCall, retType);
            }
            return newCall;
        }
    }

    private static class CeilExpander
    extends RexExpander {
        private CeilExpander(RexBuilder rexBuilder) {
            super(rexBuilder);
        }

        @Override
        public RexNode expand(RexCall call) {
            RexNode rewrite2;
            assert (call.getOperator() == SqlStdOperatorTable.CEIL);
            RexNode decValue = (RexNode)call.operands.get(0);
            int scale = decValue.getType().getScale();
            RexNode value2 = this.decodeValue(decValue);
            RelDataTypeSystem typeSystem = this.builder.getTypeFactory().getTypeSystem();
            if (scale == 0) {
                rewrite2 = decValue;
            } else if (scale == typeSystem.getMaxNumericPrecision()) {
                rewrite2 = this.makeCase(this.makeIsPositive(value2), this.makeExactLiteral(1L), this.makeExactLiteral(0L));
            } else {
                RexNode round = this.makeExactLiteral(this.powerOfTen(scale) - 1L);
                RexNode scaleFactor = this.makeScaleFactor(scale);
                rewrite2 = this.makeCase(this.makeIsPositive(value2), this.makeDivide(this.makePlus(value2, round), scaleFactor), this.makeDivide(value2, scaleFactor));
            }
            return this.encodeValue(rewrite2, call.getType());
        }
    }

    private static class FloorExpander
    extends RexExpander {
        private FloorExpander(RexBuilder rexBuilder) {
            super(rexBuilder);
        }

        @Override
        public RexNode expand(RexCall call) {
            RexNode rewrite2;
            assert (call.getOperator() == SqlStdOperatorTable.FLOOR);
            RexNode decValue = (RexNode)call.operands.get(0);
            int scale = decValue.getType().getScale();
            RexNode value2 = this.decodeValue(decValue);
            RelDataTypeSystem typeSystem = this.builder.getTypeFactory().getTypeSystem();
            if (scale == 0) {
                rewrite2 = decValue;
            } else if (scale == typeSystem.getMaxNumericPrecision()) {
                rewrite2 = this.makeCase(this.makeIsNegative(value2), this.makeExactLiteral(-1L), this.makeExactLiteral(0L));
            } else {
                RexNode round = this.makeExactLiteral(1L - this.powerOfTen(scale));
                RexNode scaleFactor = this.makeScaleFactor(scale);
                rewrite2 = this.makeCase(this.makeIsNegative(value2), this.makeDivide(this.makePlus(value2, round), scaleFactor), this.makeDivide(value2, scaleFactor));
            }
            return this.encodeValue(rewrite2, call.getType());
        }
    }

    private static class BinaryArithmeticExpander
    extends RexExpander {
        RelDataType typeA;
        RelDataType typeB;
        int scaleA;
        int scaleB;

        private BinaryArithmeticExpander(RexBuilder builder) {
            super(builder);
        }

        @Override
        public RexNode expand(RexCall call) {
            ImmutableList<RexNode> operands = call.operands;
            assert (operands.size() == 2);
            RelDataType typeA = ((RexNode)operands.get(0)).getType();
            RelDataType typeB = ((RexNode)operands.get(1)).getType();
            assert (SqlTypeUtil.isNumeric(typeA) && SqlTypeUtil.isNumeric(typeB));
            if (SqlTypeUtil.isApproximateNumeric(typeA) || SqlTypeUtil.isApproximateNumeric(typeB)) {
                ImmutableList<RexNode> newOperands = SqlTypeUtil.isApproximateNumeric(typeA) ? ImmutableList.of(operands.get(0), this.ensureType(this.real8, (RexNode)operands.get(1))) : ImmutableList.of(this.ensureType(this.real8, (RexNode)operands.get(0)), operands.get(1));
                return this.builder.makeCall(call.getOperator(), newOperands);
            }
            this.analyzeOperands(operands);
            if (call.isA(SqlKind.PLUS)) {
                return this.expandPlusMinus(call, operands);
            }
            if (call.isA(SqlKind.MINUS)) {
                return this.expandPlusMinus(call, operands);
            }
            if (call.isA(SqlKind.DIVIDE)) {
                return this.expandDivide(call, operands);
            }
            if (call.isA(SqlKind.TIMES)) {
                return this.expandTimes(call, operands);
            }
            if (call.isA(SqlKind.COMPARISON)) {
                return this.expandComparison(call, operands);
            }
            if (call.getOperator() == SqlStdOperatorTable.MOD) {
                return this.expandMod(call, operands);
            }
            throw new AssertionError((Object)("ReduceDecimalsRule could not expand " + call.getOperator()));
        }

        private void analyzeOperands(List<RexNode> operands) {
            assert (operands.size() == 2);
            this.typeA = operands.get(0).getType();
            this.typeB = operands.get(1).getType();
            assert (SqlTypeUtil.isExactNumeric(this.typeA) && SqlTypeUtil.isExactNumeric(this.typeB));
            this.scaleA = this.typeA.getScale();
            this.scaleB = this.typeB.getScale();
        }

        private RexNode expandPlusMinus(RexCall call, List<RexNode> operands) {
            RelDataType outType = call.getType();
            int outScale = outType.getScale();
            return this.encodeValue(this.builder.makeCall(call.getOperator(), this.ensureScale(this.accessValue(operands.get(0)), this.scaleA, outScale), this.ensureScale(this.accessValue(operands.get(1)), this.scaleB, outScale)), outType);
        }

        private RexNode expandDivide(RexCall call, List<RexNode> operands) {
            RelDataType outType = call.getType();
            RexNode dividend = this.builder.makeCall(call.getOperator(), this.ensureType(this.real8, this.accessValue(operands.get(0))), this.ensureType(this.real8, this.accessValue(operands.get(1))));
            int scaleDifference = outType.getScale() - this.scaleA + this.scaleB;
            RexNode rescale = this.builder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, dividend, this.makeApproxScaleFactor(scaleDifference));
            return this.encodeValue(rescale, outType);
        }

        private RexNode expandTimes(RexCall call, List<RexNode> operands) {
            int divisor = this.scaleA + this.scaleB - call.getType().getScale();
            if (this.builder.getTypeFactory().getTypeSystem().shouldUseDoubleMultiplication(this.builder.getTypeFactory(), this.typeA, this.typeB)) {
                RexNode division = this.makeDivide(this.makeMultiply(this.ensureType(this.real8, this.accessValue(operands.get(0))), this.ensureType(this.real8, this.accessValue(operands.get(1)))), this.makeApproxLiteral(BigDecimal.TEN.pow(divisor)));
                return this.encodeValue(division, call.getType(), true);
            }
            return this.encodeValue(this.scaleDown(this.builder.makeCall(call.getOperator(), this.accessValue(operands.get(0)), this.accessValue(operands.get(1))), divisor), call.getType());
        }

        private RexNode expandComparison(RexCall call, List<RexNode> operands) {
            int commonScale = Math.max(this.scaleA, this.scaleB);
            return this.builder.makeCall(call.getOperator(), this.ensureScale(this.accessValue(operands.get(0)), this.scaleA, commonScale), this.ensureScale(this.accessValue(operands.get(1)), this.scaleB, commonScale));
        }

        private RexNode expandMod(RexCall call, List<RexNode> operands) {
            assert (SqlTypeUtil.isExactNumeric(this.typeA));
            assert (SqlTypeUtil.isExactNumeric(this.typeB));
            if (this.scaleA != 0 || this.scaleB != 0) {
                throw Static.RESOURCE.argumentMustHaveScaleZero(call.getOperator().getName()).ex();
            }
            RexNode result = this.builder.makeCall(call.getOperator(), this.accessValue(operands.get(0)), this.accessValue(operands.get(1)));
            RelDataType retType = call.getType();
            if (SqlTypeUtil.isDecimal(retType)) {
                return this.encodeValue(result, retType);
            }
            return this.ensureType(call.getType(), result);
        }
    }

    private static class CastExpander
    extends RexExpander {
        private CastExpander(RexBuilder builder) {
            super(builder);
        }

        @Override
        public RexNode expand(RexCall call) {
            boolean checkOverflow;
            ImmutableList<RexNode> operands = call.operands;
            assert (call.isA(SqlKind.CAST));
            assert (operands.size() == 1);
            assert (!RexLiteral.isNullLiteral((RexNode)operands.get(0)));
            RexNode operand = (RexNode)operands.get(0);
            RelDataType fromType = operand.getType();
            RelDataType toType = call.getType();
            assert (SqlTypeUtil.isDecimal(fromType) || SqlTypeUtil.isDecimal(toType));
            if (SqlTypeUtil.isIntType(toType)) {
                return this.ensureType(toType, this.scaleDown(this.decodeValue(operand), fromType.getScale()), false);
            }
            if (SqlTypeUtil.isApproximateNumeric(toType)) {
                return this.ensureType(toType, this.scaleDownDouble(this.decodeValue(operand), fromType.getScale()), false);
            }
            if (SqlTypeUtil.isApproximateNumeric(fromType)) {
                return this.encodeValue(this.ensureScale(operand, 0, toType.getScale()), toType, true);
            }
            if (!SqlTypeUtil.isExactNumeric(fromType) || !SqlTypeUtil.isExactNumeric(toType)) {
                throw Util.needToImplement("Cast from '" + fromType.toString() + "' to '" + toType.toString() + "'");
            }
            int fromScale = fromType.getScale();
            int toScale = toType.getScale();
            int fromDigits = fromType.getPrecision() - fromScale;
            int toDigits = toType.getPrecision() - toScale;
            boolean bl = checkOverflow = toType.getPrecision() < 19 && toDigits < fromDigits;
            if (SqlTypeUtil.isIntType(fromType)) {
                return this.encodeValue(this.ensureScale(operand, 0, toType.getScale()), toType, checkOverflow);
            }
            if (SqlTypeUtil.isDecimal(fromType) && SqlTypeUtil.isDecimal(toType)) {
                RexNode scaled;
                RexNode value2 = this.decodeValue(operand);
                if (fromScale <= toScale) {
                    scaled = this.ensureScale(value2, fromScale, toScale);
                } else {
                    if (toDigits == fromDigits) {
                        checkOverflow = true;
                    }
                    scaled = this.scaleDown(value2, fromScale - toScale);
                }
                return this.encodeValue(scaled, toType, checkOverflow);
            }
            throw Util.needToImplement("Reduce decimal cast from " + fromType + " to " + toType);
        }
    }

    public static abstract class RexExpander {
        final RexBuilder builder;
        final RelDataType int8;
        final RelDataType real8;

        RexExpander(RexBuilder builder) {
            this.builder = builder;
            this.int8 = builder.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            this.real8 = builder.getTypeFactory().createSqlType(SqlTypeName.DOUBLE);
        }

        public boolean canExpand(RexCall call) {
            return RexUtil.requiresDecimalExpansion(call, false);
        }

        public abstract RexNode expand(RexCall var1);

        protected RexNode makeScaleFactor(int scale) {
            assert (scale > 0);
            assert (scale < this.builder.getTypeFactory().getTypeSystem().getMaxNumericPrecision());
            return this.makeExactLiteral(this.powerOfTen(scale));
        }

        protected RexNode makeApproxScaleFactor(int scale) {
            assert (-100 < scale && scale < 100) : "could not make approximate scale factor";
            if (scale >= 0) {
                return this.makeApproxLiteral(BigDecimal.TEN.pow(scale));
            }
            BigDecimal tenth = BigDecimal.valueOf(1L, 1);
            return this.makeApproxLiteral(tenth.pow(-scale));
        }

        protected RexNode makeRoundFactor(int scale) {
            assert (scale > 0);
            assert (scale < this.builder.getTypeFactory().getTypeSystem().getMaxNumericPrecision());
            return this.makeExactLiteral(this.powerOfTen(scale) / 2L);
        }

        protected long powerOfTen(int scale) {
            assert (scale >= 0);
            assert (scale < this.builder.getTypeFactory().getTypeSystem().getMaxNumericPrecision());
            return BigInteger.TEN.pow(scale).longValue();
        }

        protected RexNode makeExactLiteral(long l) {
            BigDecimal bd = BigDecimal.valueOf(l);
            return this.builder.makeExactLiteral(bd, this.int8);
        }

        protected RexNode makeApproxLiteral(BigDecimal bd) {
            return this.builder.makeApproxLiteral(bd);
        }

        protected RexNode scaleUp(RexNode value2, int scale) {
            assert (scale >= 0);
            assert (scale < this.builder.getTypeFactory().getTypeSystem().getMaxNumericPrecision());
            if (scale == 0) {
                return value2;
            }
            return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, value2, this.makeScaleFactor(scale));
        }

        protected RexNode scaleDown(RexNode value2, int scale) {
            int maxPrecision = this.builder.getTypeFactory().getTypeSystem().getMaxNumericPrecision();
            assert (scale >= 0 && scale <= maxPrecision);
            if (scale == 0) {
                return value2;
            }
            if (scale == maxPrecision) {
                long half = BigInteger.TEN.pow(scale - 1).longValue() * 5L;
                return this.makeCase(this.builder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, value2, this.makeExactLiteral(half)), this.makeExactLiteral(1L), this.builder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, value2, this.makeExactLiteral(-half)), this.makeExactLiteral(-1L), this.makeExactLiteral(0L));
            }
            RexNode roundFactor = this.makeRoundFactor(scale);
            RexNode roundValue = this.makeCase(this.builder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, value2, this.makeExactLiteral(0L)), this.makePlus(value2, roundFactor), this.makeMinus(value2, roundFactor));
            return this.makeDivide(roundValue, this.makeScaleFactor(scale));
        }

        protected RexNode scaleDownDouble(RexNode value2, int scale) {
            assert (scale >= 0);
            assert (scale <= this.builder.getTypeFactory().getTypeSystem().getMaxNumericPrecision());
            RexNode cast = this.ensureType(this.real8, value2);
            if (scale == 0) {
                return cast;
            }
            return this.makeDivide(cast, this.makeApproxScaleFactor(scale));
        }

        protected RexNode ensureScale(RexNode value2, int scale, int required) {
            RelDataTypeSystem typeSystem = this.builder.getTypeFactory().getTypeSystem();
            int maxPrecision = typeSystem.getMaxNumericPrecision();
            assert (scale <= maxPrecision && required <= maxPrecision);
            assert (required >= scale);
            if (scale == required) {
                return value2;
            }
            int scaleDiff = required - scale;
            if (SqlTypeUtil.isApproximateNumeric(value2.getType())) {
                return this.makeMultiply(value2, this.makeApproxScaleFactor(scaleDiff));
            }
            if (scaleDiff >= maxPrecision) {
                throw Util.needToImplement("Source type with scale " + scale + " cannot be converted to target type with scale " + required + " because the smallest value of the source type is too large to be encoded by the target type");
            }
            return this.scaleUp(value2, scaleDiff);
        }

        protected RexNode decodeValue(RexNode decimalNode) {
            assert (SqlTypeUtil.isDecimal(decimalNode.getType()));
            return this.builder.decodeIntervalOrDecimal(decimalNode);
        }

        protected RexNode accessValue(RexNode node) {
            assert (SqlTypeUtil.isNumeric(node.getType()));
            if (SqlTypeUtil.isDecimal(node.getType())) {
                return this.decodeValue(node);
            }
            return node;
        }

        protected RexNode encodeValue(RexNode value2, RelDataType decimalType) {
            return this.encodeValue(value2, decimalType, false);
        }

        protected RexNode encodeValue(RexNode value2, RelDataType decimalType, boolean checkOverflow) {
            return this.builder.encodeIntervalOrDecimal(value2, decimalType, checkOverflow);
        }

        protected RexNode ensureType(RelDataType type, RexNode node) {
            return this.ensureType(type, node, true);
        }

        protected RexNode ensureType(RelDataType type, RexNode node, boolean matchNullability) {
            return this.builder.ensureType(type, node, matchNullability);
        }

        protected RexNode makeCase(RexNode condition, RexNode thenClause, RexNode elseClause) {
            return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, condition, thenClause, elseClause);
        }

        protected RexNode makeCase(RexNode whenA, RexNode thenA, RexNode whenB, RexNode thenB, RexNode elseClause) {
            return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, whenA, thenA, whenB, thenB, elseClause);
        }

        protected RexNode makePlus(RexNode a, RexNode b) {
            return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, a, b);
        }

        protected RexNode makeMinus(RexNode a, RexNode b) {
            return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, a, b);
        }

        protected RexNode makeDivide(RexNode a, RexNode b) {
            return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, a, b);
        }

        protected RexNode makeMultiply(RexNode a, RexNode b) {
            return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, a, b);
        }

        protected RexNode makeIsPositive(RexNode a) {
            return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, a, this.makeExactLiteral(0L));
        }

        protected RexNode makeIsNegative(RexNode a) {
            return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, a, this.makeExactLiteral(0L));
        }
    }

    private static class ExpanderMap {
        private final Map<SqlOperator, RexExpander> map = new HashMap<SqlOperator, RexExpander>();
        private RexExpander defaultExpander;

        private ExpanderMap(RexBuilder rexBuilder) {
            this.registerExpanders(rexBuilder);
        }

        private void registerExpanders(RexBuilder rexBuilder) {
            CastExpander cast = new CastExpander(rexBuilder);
            this.map.put(SqlStdOperatorTable.CAST, cast);
            PassThroughExpander passThrough = new PassThroughExpander(rexBuilder);
            this.map.put(SqlStdOperatorTable.UNARY_MINUS, passThrough);
            this.map.put(SqlStdOperatorTable.ABS, passThrough);
            this.map.put(SqlStdOperatorTable.IS_NULL, passThrough);
            this.map.put(SqlStdOperatorTable.IS_NOT_NULL, passThrough);
            BinaryArithmeticExpander arithmetic = new BinaryArithmeticExpander(rexBuilder);
            this.map.put(SqlStdOperatorTable.DIVIDE, arithmetic);
            this.map.put(SqlStdOperatorTable.MULTIPLY, arithmetic);
            this.map.put(SqlStdOperatorTable.PLUS, arithmetic);
            this.map.put(SqlStdOperatorTable.MINUS, arithmetic);
            this.map.put(SqlStdOperatorTable.MOD, arithmetic);
            this.map.put(SqlStdOperatorTable.EQUALS, arithmetic);
            this.map.put(SqlStdOperatorTable.GREATER_THAN, arithmetic);
            this.map.put(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, arithmetic);
            this.map.put(SqlStdOperatorTable.LESS_THAN, arithmetic);
            this.map.put(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, arithmetic);
            FloorExpander floor = new FloorExpander(rexBuilder);
            this.map.put(SqlStdOperatorTable.FLOOR, floor);
            CeilExpander ceil = new CeilExpander(rexBuilder);
            this.map.put(SqlStdOperatorTable.CEIL, ceil);
            ReinterpretExpander reinterpret = new ReinterpretExpander(rexBuilder);
            this.map.put(SqlStdOperatorTable.REINTERPRET, reinterpret);
            CaseExpander caseExpander = new CaseExpander(rexBuilder);
            this.map.put(SqlStdOperatorTable.CASE, caseExpander);
            this.defaultExpander = new CastArgAsDoubleExpander(rexBuilder);
        }

        RexExpander getExpander(RexCall call) {
            RexExpander expander = this.map.get(call.getOperator());
            return expander != null ? expander : this.defaultExpander;
        }
    }

    public static class DecimalShuttle
    extends RexShuttle {
        private final Map<Pair<RexNode, String>, RexNode> irreducible = new HashMap<Pair<RexNode, String>, RexNode>();
        private final Map<Pair<RexNode, String>, RexNode> results = new HashMap<Pair<RexNode, String>, RexNode>();
        private final ExpanderMap expanderMap;

        DecimalShuttle(RexBuilder rexBuilder) {
            this.expanderMap = new ExpanderMap(rexBuilder);
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode savedResult = this.lookup(call);
            if (savedResult != null) {
                return savedResult;
            }
            RexNode newCall = call;
            RexNode rewrite2 = this.rewriteCall(call);
            if (rewrite2 != call) {
                newCall = rewrite2.accept(this);
            }
            this.register(call, newCall);
            return newCall;
        }

        private void register(RexNode node, RexNode reducedNode) {
            Pair<RexNode, String> key = RexUtil.makeKey(node);
            if (node == reducedNode) {
                this.irreducible.put(key, reducedNode);
            } else {
                this.results.put(key, reducedNode);
            }
        }

        private RexNode lookup(RexNode node) {
            Pair<RexNode, String> key = RexUtil.makeKey(node);
            if (this.irreducible.get(key) != null) {
                return node;
            }
            return this.results.get(key);
        }

        private RexNode rewriteCall(RexCall call) {
            SqlOperator operator = call.getOperator();
            if (!operator.requiresDecimalExpansion()) {
                return call;
            }
            RexExpander expander = this.getExpander(call);
            if (expander.canExpand(call)) {
                return expander.expand(call);
            }
            return call;
        }

        private RexExpander getExpander(RexCall call) {
            return this.expanderMap.getExpander(call);
        }
    }
}

