/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.Visitor;

public class ConstantExpression
extends Expression {
    public final Object value;

    public ConstantExpression(Type type, Object value2) {
        super(ExpressionType.Constant, type);
        this.value = value2;
        if (value2 != null && type instanceof Class) {
            Class clazz = (Class)type;
            Primitive primitive = Primitive.of(clazz);
            if (primitive != null) {
                clazz = primitive.boxClass;
            }
            if (!clazz.isInstance(value2) && (clazz != Float.class && clazz != Double.class || !(value2 instanceof BigDecimal))) {
                throw new AssertionError((Object)("value " + value2 + " does not match type " + type));
            }
        }
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        return this.value;
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (this.value == null) {
            if (!writer.requireParentheses(this, lprec, rprec)) {
                writer.append("(").append(this.type).append(") null");
            }
            return;
        }
        ConstantExpression.write(writer, this.value, this.type);
    }

    private static ExpressionWriter write(ExpressionWriter writer, Object value2, Type type) {
        if (value2 == null) {
            return writer.append("null");
        }
        if (type == null && Primitive.isBox(type = value2.getClass())) {
            type = Primitive.ofBox(type).primitiveClass;
        }
        if (value2 instanceof String) {
            ConstantExpression.escapeString(writer.getBuf(), (String)value2);
            return writer;
        }
        Primitive primitive = Primitive.of(type);
        if (primitive != null) {
            switch (primitive) {
                case BYTE: {
                    return writer.append("(byte)").append(((Byte)value2).intValue());
                }
                case CHAR: {
                    return writer.append("(char)").append((Object)((Character)value2).charValue());
                }
                case SHORT: {
                    return writer.append("(short)").append(((Short)value2).intValue());
                }
                case LONG: {
                    return writer.append(value2).append("L");
                }
                case FLOAT: {
                    BigDecimal bigDecimal = value2 instanceof BigDecimal ? (BigDecimal)value2 : BigDecimal.valueOf(((Float)value2).floatValue());
                    if (bigDecimal.precision() > 6) {
                        return writer.append("Float.intBitsToFloat(").append(Float.floatToIntBits(bigDecimal.floatValue())).append(")");
                    }
                    return writer.append(value2).append("F");
                }
                case DOUBLE: {
                    BigDecimal bigDecimal = value2 instanceof BigDecimal ? (BigDecimal)value2 : BigDecimal.valueOf((Double)value2);
                    if (bigDecimal.precision() > 10) {
                        return writer.append("Double.longBitsToDouble(").append(Double.doubleToLongBits(bigDecimal.doubleValue())).append("L)");
                    }
                    return writer.append(value2).append("D");
                }
            }
            return writer.append(value2);
        }
        Primitive primitive2 = Primitive.ofBox(type);
        if (primitive2 != null) {
            writer.append(primitive2.boxName + ".valueOf(");
            ConstantExpression.write(writer, value2, primitive2.primitiveClass);
            return writer.append(")");
        }
        if (value2 instanceof Enum) {
            return writer.append(((Enum)value2).getDeclaringClass()).append('.').append(((Enum)value2).name());
        }
        if (value2 instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)value2).stripTrailingZeros();
            try {
                int scale = bigDecimal.scale();
                long exact = bigDecimal.scaleByPowerOfTen(scale).longValueExact();
                writer.append("java.math.BigDecimal.valueOf(").append(exact).append("L");
                if (scale != 0) {
                    writer.append(", ").append(scale);
                }
                return writer.append(")");
            }
            catch (ArithmeticException e) {
                return writer.append("new java.math.BigDecimal(\"").append(bigDecimal.toString()).append("\")");
            }
        }
        if (value2 instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value2;
            return writer.append("new java.math.BigInteger(\"").append(bigInteger.toString()).append("\")");
        }
        if (value2 instanceof Class) {
            Class clazz = (Class)value2;
            return writer.append(clazz.getCanonicalName()).append(".class");
        }
        if (value2 instanceof Types.RecordType) {
            Types.RecordType recordType = (Types.RecordType)value2;
            return writer.append(recordType.getName()).append(".class");
        }
        if (value2.getClass().isArray()) {
            writer.append("new ").append(value2.getClass().getComponentType());
            ConstantExpression.list(writer, Primitive.asList(value2), "[] {\n", ",\n", "}");
            return writer;
        }
        if (value2 instanceof List) {
            if (((List)value2).isEmpty()) {
                writer.append("java.util.Collections.EMPTY_LIST");
                return writer;
            }
            ConstantExpression.list(writer, (List)value2, "java.util.Arrays.asList(", ",\n", ")");
            return writer;
        }
        if (value2 instanceof Map) {
            return ConstantExpression.writeMap(writer, (Map)value2);
        }
        if (value2 instanceof Set) {
            return ConstantExpression.writeSet(writer, (Set)value2);
        }
        Constructor constructor = ConstantExpression.matchingConstructor(value2);
        if (constructor != null) {
            writer.append("new ").append(value2.getClass());
            ConstantExpression.list(writer, Arrays.stream(value2.getClass().getFields()).map(field -> {
                try {
                    return field.get(value2);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList()), "(\n", ",\n", ")");
            return writer;
        }
        return writer.append(value2);
    }

    private static void list(ExpressionWriter writer, List list, String begin, String sep, String end) {
        writer.begin(begin);
        for (int i = 0; i < list.size(); ++i) {
            Object value2 = list.get(i);
            if (i > 0) {
                writer.append(sep).indent();
            }
            ConstantExpression.write(writer, value2, null);
        }
        writer.end(end);
    }

    private static ExpressionWriter writeMap(ExpressionWriter writer, Map map2) {
        writer.append("org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap.");
        if (map2.isEmpty()) {
            return writer.append("of()");
        }
        if (map2.size() < 5) {
            return ConstantExpression.map(writer, map2, "of(", ",\n", ")");
        }
        return ConstantExpression.map(writer, map2, "builder().put(", ")\n.put(", ").build()");
    }

    private static ExpressionWriter map(ExpressionWriter writer, Map map2, String begin, String entrySep, String end) {
        writer.append(begin);
        boolean comma = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            if (comma) {
                writer.append(entrySep).indent();
            }
            ConstantExpression.write(writer, entry.getKey(), null);
            writer.append(", ");
            ConstantExpression.write(writer, entry.getValue(), null);
            comma = true;
        }
        return writer.append(end);
    }

    private static ExpressionWriter writeSet(ExpressionWriter writer, Set set) {
        writer.append("org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet.");
        if (set.isEmpty()) {
            return writer.append("of()");
        }
        if (set.size() < 5) {
            return ConstantExpression.set(writer, set, "of(", ",", ")");
        }
        return ConstantExpression.set(writer, set, "builder().add(", ")\n.add(", ").build()");
    }

    private static ExpressionWriter set(ExpressionWriter writer, Set set, String begin, String entrySep, String end) {
        writer.append(begin);
        boolean comma = false;
        for (Object o : set.toArray()) {
            if (comma) {
                writer.append(entrySep).indent();
            }
            ConstantExpression.write(writer, o, null);
            comma = true;
        }
        return writer.append(end);
    }

    private static Constructor matchingConstructor(Object value2) {
        Field[] fields2 = value2.getClass().getFields();
        for (Constructor<?> constructor : value2.getClass().getConstructors()) {
            if (!ConstantExpression.argsMatchFields(fields2, constructor.getParameterTypes())) continue;
            return constructor;
        }
        return null;
    }

    private static boolean argsMatchFields(Field[] fields2, Class<?>[] parameterTypes) {
        if (parameterTypes.length != fields2.length) {
            return false;
        }
        for (int i = 0; i < fields2.length; ++i) {
            if (fields2[i].getType() == parameterTypes[i]) continue;
            return false;
        }
        return true;
    }

    private static void escapeString(StringBuilder buf, String s) {
        buf.append('\"');
        int n = s.length();
        int lastChar = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    if (lastChar == 10) break;
                    buf.append("\\r");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            lastChar = c;
        }
        buf.append('\"');
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConstantExpression that = (ConstantExpression)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.value});
    }
}

