/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.Serializable;

public class Point
extends Geometry
implements Serializable {
    double[] m_attributes;

    public Point() {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
    }

    public Point(VertexDescription vd) {
        if (vd == null) {
            throw new IllegalArgumentException();
        }
        this.m_description = vd;
    }

    public Point(double x, double y) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.setXY(x, y);
    }

    public Point(Point2D pt) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.setXY(pt);
    }

    public Point(double x, double y, double z) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        Point3D pt = new Point3D();
        pt.setCoords(x, y, z);
        this.setXYZ(pt);
    }

    public final Point2D getXY() {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation should not be performed on an empty geometry.");
        }
        Point2D pt = new Point2D();
        pt.setCoords(this.m_attributes[0], this.m_attributes[1]);
        return pt;
    }

    public final void getXY(Point2D pt) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation should not be performed on an empty geometry.");
        }
        pt.setCoords(this.m_attributes[0], this.m_attributes[1]);
    }

    public final void setXY(Point2D pt) {
        this._touch();
        this.setXY(pt.x, pt.y);
    }

    public Point3D getXYZ() {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation should not be performed on an empty geometry.");
        }
        Point3D pt = new Point3D();
        pt.x = this.m_attributes[0];
        pt.y = this.m_attributes[1];
        pt.z = this.m_description.hasZ() ? this.m_attributes[2] : VertexDescription.getDefaultValue(1);
        return pt;
    }

    public void setXYZ(Point3D pt) {
        this._touch();
        boolean bHasZ = this.hasAttribute(1);
        if (!bHasZ && !VertexDescription.isDefaultValue(1, pt.z)) {
            this.addAttribute(1);
            bHasZ = true;
        }
        if (this.m_attributes == null) {
            this._setToDefault();
        }
        this.m_attributes[0] = pt.x;
        this.m_attributes[1] = pt.y;
        if (bHasZ) {
            this.m_attributes[2] = pt.z;
        }
    }

    public final double getX() {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation should not be performed on an empty geometry.");
        }
        return this.m_attributes[0];
    }

    public void setX(double x) {
        this.setAttribute(0, 0, x);
    }

    public final double getY() {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation should not be performed on an empty geometry.");
        }
        return this.m_attributes[1];
    }

    public void setY(double y) {
        this.setAttribute(0, 1, y);
    }

    public double getZ() {
        return this.getAttributeAsDbl(1, 0);
    }

    public void setZ(double z) {
        this.setAttribute(1, 0, z);
    }

    public double getM() {
        return this.getAttributeAsDbl(2, 0);
    }

    public void setM(double m) {
        this.setAttribute(2, 0, m);
    }

    public int getID() {
        return this.getAttributeAsInt(3, 0);
    }

    public void setID(int id) {
        this.setAttribute(3, 0, id);
    }

    public double getAttributeAsDbl(int semantics, int ordinate) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation was performed on an Empty Geometry.");
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            return this.m_attributes[this.m_description._getPointAttributeOffset(attributeIndex) + ordinate];
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    public int getAttributeAsInt(int semantics, int ordinate) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation was performed on an Empty Geometry.");
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            return (int)this.m_attributes[this.m_description._getPointAttributeOffset(attributeIndex) + ordinate];
        }
        return (int)VertexDescription.getDefaultValue(semantics);
    }

    public void setAttribute(int semantics, int ordinate, double value2) {
        this._touch();
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ncomps < ordinate) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex < 0) {
            this.addAttribute(semantics);
            attributeIndex = this.m_description.getAttributeIndex(semantics);
        }
        if (this.m_attributes == null) {
            this._setToDefault();
        }
        this.m_attributes[this.m_description._getPointAttributeOffset((int)attributeIndex) + ordinate] = value2;
    }

    public void setAttribute(int semantics, int ordinate, int value2) {
        this.setAttribute(semantics, ordinate, (double)value2);
    }

    @Override
    public Geometry.Type getType() {
        return Geometry.Type.Point;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public long estimateMemorySize() {
        return 24L + Point.estimateMemorySize(this.m_attributes);
    }

    @Override
    public void setEmpty() {
        this._touch();
        if (this.m_attributes != null) {
            this.m_attributes[0] = NumberUtils.NaN();
            this.m_attributes[1] = NumberUtils.NaN();
        }
    }

    @Override
    protected void _assignVertexDescriptionImpl(VertexDescription newDescription) {
        if (this.m_attributes == null) {
            this.m_description = newDescription;
            return;
        }
        int[] mapping = VertexDescriptionDesignerImpl.mapAttributes(newDescription, this.m_description);
        double[] newAttributes = new double[newDescription.getTotalComponentCount()];
        int j2 = 0;
        int n = newDescription.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            int ord;
            int semantics = newDescription.getSemantics(i);
            int nords = VertexDescription.getComponentCount(semantics);
            if (mapping[i] == -1) {
                double d = VertexDescription.getDefaultValue(semantics);
                for (ord = 0; ord < nords; ++ord) {
                    newAttributes[j2] = d;
                    ++j2;
                }
                continue;
            }
            int m = mapping[i];
            int offset = this.m_description._getPointAttributeOffset(m);
            for (ord = 0; ord < nords; ++ord) {
                newAttributes[j2] = this.m_attributes[offset];
                ++j2;
                ++offset;
            }
        }
        this.m_attributes = newAttributes;
        this.m_description = newDescription;
    }

    void _setToDefault() {
        this.resizeAttributes(this.m_description.getTotalComponentCount());
        Point.attributeCopy(this.m_description._getDefaultPointAttributes(), this.m_attributes, this.m_description.getTotalComponentCount());
        this.m_attributes[0] = NumberUtils.NaN();
        this.m_attributes[1] = NumberUtils.NaN();
    }

    @Override
    public void applyTransformation(Transformation2D transform2) {
        if (this.isEmptyImpl()) {
            return;
        }
        Point2D pt = this.getXY();
        transform2.transform(pt, pt);
        this.setXY(pt);
    }

    @Override
    void applyTransformation(Transformation3D transform2) {
        if (this.isEmptyImpl()) {
            return;
        }
        this.addAttribute(1);
        Point3D pt = this.getXYZ();
        this.setXYZ(transform2.transform(pt));
    }

    @Override
    public void copyTo(Geometry dst) {
        if (dst.getType() != Geometry.Type.Point) {
            throw new IllegalArgumentException();
        }
        Point pointDst = (Point)dst;
        dst._touch();
        if (this.m_attributes == null) {
            pointDst.setEmpty();
            pointDst.m_attributes = null;
            pointDst.assignVertexDescription(this.m_description);
        } else {
            pointDst.assignVertexDescription(this.m_description);
            pointDst.resizeAttributes(this.m_description.getTotalComponentCount());
            Point.attributeCopy(this.m_attributes, pointDst.m_attributes, this.m_description.getTotalComponentCount());
        }
    }

    @Override
    public Geometry createInstance() {
        Point point = new Point(this.m_description);
        return point;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmptyImpl();
    }

    final boolean isEmptyImpl() {
        return this.m_attributes == null || NumberUtils.isNaN(this.m_attributes[0]) || NumberUtils.isNaN(this.m_attributes[1]);
    }

    @Override
    public void queryEnvelope(Envelope env) {
        env.setEmpty();
        if (this.m_description != env.m_description) {
            env.assignVertexDescription(this.m_description);
        }
        env.merge(this);
    }

    @Override
    public void queryEnvelope2D(Envelope2D env) {
        if (this.isEmptyImpl()) {
            env.setEmpty();
            return;
        }
        env.xmin = this.m_attributes[0];
        env.ymin = this.m_attributes[1];
        env.xmax = this.m_attributes[0];
        env.ymax = this.m_attributes[1];
    }

    @Override
    void queryEnvelope3D(Envelope3D env) {
        if (this.isEmptyImpl()) {
            env.setEmpty();
            return;
        }
        Point3D pt = this.getXYZ();
        env.xmin = pt.x;
        env.ymin = pt.y;
        env.zmin = pt.z;
        env.xmax = pt.x;
        env.ymax = pt.y;
        env.zmax = pt.z;
    }

    @Override
    public Envelope1D queryInterval(int semantics, int ordinate) {
        double s;
        Envelope1D env = new Envelope1D();
        if (this.isEmptyImpl()) {
            env.setEmpty();
            return env;
        }
        env.vmin = s = this.getAttributeAsDbl(semantics, ordinate);
        env.vmax = s;
        return env;
    }

    private void resizeAttributes(int newSize) {
        if (this.m_attributes == null) {
            this.m_attributes = new double[newSize];
        } else if (this.m_attributes.length < newSize) {
            double[] newbuffer = new double[newSize];
            System.arraycopy(this.m_attributes, 0, newbuffer, 0, this.m_attributes.length);
            this.m_attributes = newbuffer;
        }
    }

    static void attributeCopy(double[] src, double[] dst, int count) {
        if (count > 0) {
            System.arraycopy(src, 0, dst, 0, count);
        }
    }

    public void setXY(double x, double y) {
        this._touch();
        if (this.m_attributes == null) {
            this._setToDefault();
        }
        this.m_attributes[0] = x;
        this.m_attributes[1] = y;
    }

    public boolean equals(Object _other) {
        if (_other == this) {
            return true;
        }
        if (!(_other instanceof Point)) {
            return false;
        }
        Point otherPt = (Point)_other;
        if (this.m_description != otherPt.m_description) {
            return false;
        }
        if (this.isEmptyImpl()) {
            return otherPt.isEmptyImpl();
        }
        int n = this.m_description.getTotalComponentCount();
        for (int i = 0; i < n; ++i) {
            if (this.m_attributes[i] == otherPt.m_attributes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode2 = this.m_description.hashCode();
        if (!this.isEmptyImpl()) {
            int n = this.m_description.getTotalComponentCount();
            for (int i = 0; i < n; ++i) {
                long bits = Double.doubleToLongBits(this.m_attributes[i]);
                int hc = (int)(bits ^ bits >>> 32);
                hashCode2 = NumberUtils.hash(hashCode2, hc);
            }
        }
        return hashCode2;
    }

    @Override
    public Geometry getBoundary() {
        return null;
    }

    @Override
    public void replaceNaNs(int semantics, double value2) {
        this.addAttribute(semantics);
        if (this.isEmpty()) {
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        for (int i = 0; i < ncomps; ++i) {
            double v = this.getAttributeAsDbl(semantics, i);
            if (!Double.isNaN(v)) continue;
            this.setAttribute(semantics, i, value2);
        }
    }
}

