/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.io.PrintWriter;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.client.cli.CliUtils;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.utils.PrintUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.jline.terminal.Terminal;

public class CliTableauResultView
implements AutoCloseable {
    private final Terminal terminal;
    private final Executor sqlExecutor;
    private final String sessionId;
    private final ZoneId sessionTimeZone;
    private final ResultDescriptor resultDescriptor;
    private final ExecutorService displayResultExecutorService;

    public CliTableauResultView(Terminal terminal, Executor sqlExecutor, String sessionId, ResultDescriptor resultDescriptor) {
        this.terminal = terminal;
        this.sqlExecutor = sqlExecutor;
        this.sessionId = sessionId;
        this.resultDescriptor = resultDescriptor;
        this.displayResultExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new ExecutorThreadFactory("CliTableauResultView"));
        this.sessionTimeZone = CliUtils.getSessionTimeZone(sqlExecutor.getSessionConfig(sessionId));
    }

    public void displayResults() throws SqlExecutionException {
        AtomicInteger receivedRowCount = new AtomicInteger(0);
        Future<?> resultFuture = this.displayResultExecutorService.submit(() -> {
            if (this.resultDescriptor.isStreamingMode()) {
                this.printStreamingResults(receivedRowCount);
            } else {
                this.printBatchResults(receivedRowCount);
            }
        });
        this.terminal.handle(Terminal.Signal.INT, signal -> resultFuture.cancel(true));
        boolean cleanUpQuery = true;
        try {
            resultFuture.get();
            cleanUpQuery = false;
        }
        catch (CancellationException e) {
            this.terminal.writer().println("Query terminated, received a total of " + receivedRowCount.get() + " " + this.getRowTerm(receivedRowCount));
            this.terminal.flush();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SqlExecutionException) {
                throw (SqlExecutionException)e.getCause();
            }
            throw new SqlExecutionException("unknown exception", e.getCause());
        }
        catch (InterruptedException e) {
            throw new SqlExecutionException("Query interrupted", e);
        }
        finally {
            this.checkAndCleanUpQuery(cleanUpQuery);
        }
    }

    @Override
    public void close() {
        this.displayResultExecutorService.shutdown();
    }

    private void checkAndCleanUpQuery(boolean cleanUpQuery) {
        if (cleanUpQuery) {
            try {
                this.sqlExecutor.cancelQuery(this.sessionId, this.resultDescriptor.getResultId());
            }
            catch (SqlExecutionException sqlExecutionException) {
                // empty catch block
            }
        }
    }

    private void printBatchResults(AtomicInteger receivedRowCount) {
        List<Row> resultRows = this.waitBatchResults();
        receivedRowCount.addAndGet(resultRows.size());
        PrintUtils.printAsTableauForm((ResolvedSchema)this.resultDescriptor.getResultSchema(), resultRows.iterator(), (PrintWriter)this.terminal.writer(), (ZoneId)this.sessionTimeZone);
    }

    private void printStreamingResults(AtomicInteger receivedRowCount) {
        List columns = this.resultDescriptor.getResultSchema().getColumns();
        String[] fieldNames = (String[])Stream.concat(Stream.of("op"), columns.stream().map(Column::getName)).toArray(String[]::new);
        int[] colWidths = PrintUtils.columnWidthsByType((List)columns, (int)this.resultDescriptor.maxColumnWidth(), (String)"(NULL)", (String)"op");
        String borderline = PrintUtils.genBorderLine((int[])colWidths);
        this.terminal.writer().println(borderline);
        PrintUtils.printSingleRow((int[])colWidths, (String[])fieldNames, (PrintWriter)this.terminal.writer());
        this.terminal.writer().println(borderline);
        this.terminal.flush();
        block7: while (true) {
            TypedResult<List<Row>> result = this.sqlExecutor.retrieveResultChanges(this.sessionId, this.resultDescriptor.getResultId());
            switch (result.getType()) {
                case EMPTY: {
                    try {
                        Thread.sleep(1L);
                        break;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                case EOS: {
                    if (receivedRowCount.get() > 0) {
                        this.terminal.writer().println(borderline);
                    }
                    String rowTerm = this.getRowTerm(receivedRowCount);
                    this.terminal.writer().println("Received a total of " + receivedRowCount.get() + " " + rowTerm);
                    this.terminal.flush();
                    return;
                }
                case PAYLOAD: {
                    List<Row> changes = result.getPayload();
                    Iterator<Row> iterator = changes.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block7;
                        Row change = iterator.next();
                        String[] row = PrintUtils.rowToString((Row)change, (String)"(NULL)", (boolean)true, (ResolvedSchema)this.resultDescriptor.getResultSchema(), (ZoneId)this.sessionTimeZone);
                        PrintUtils.printSingleRow((int[])colWidths, (String[])row, (PrintWriter)this.terminal.writer());
                        receivedRowCount.incrementAndGet();
                    }
                }
                default: {
                    throw new SqlExecutionException("Unknown result type: " + (Object)((Object)result.getType()));
                }
            }
        }
    }

    private List<Row> waitBatchResults() {
        ArrayList<Row> resultRows = new ArrayList<Row>();
        while (true) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            TypedResult<List<Row>> result = this.sqlExecutor.retrieveResultChanges(this.sessionId, this.resultDescriptor.getResultId());
            if (result.getType() == TypedResult.ResultType.EOS) break;
            if (result.getType() != TypedResult.ResultType.PAYLOAD) continue;
            resultRows.addAll((Collection<Row>)result.getPayload());
        }
        return resultRows;
    }

    private String getRowTerm(AtomicInteger receivedRowCount) {
        return receivedRowCount.get() > 1 ? "rows" : "row";
    }
}

