/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CliStatementSplitter {
    private static final String MASK = "--.*$";
    private static final String BEGINNING_MASK = "^(\\s)*--.*$";

    public static boolean isStatementComplete(String statement) {
        String[] lines = statement.split("\n");
        if (lines.length == 0) {
            return false;
        }
        return CliStatementSplitter.isEndOfStatement(lines[lines.length - 1]);
    }

    public static List<String> splitContent(String content) {
        ArrayList<String> statements = new ArrayList<String>();
        ArrayList<String> buffer = new ArrayList<String>();
        for (String line : content.split("\n")) {
            if (CliStatementSplitter.isEndOfStatement(line)) {
                buffer.add(line);
                statements.add(CliStatementSplitter.normalize(buffer));
                buffer.clear();
                continue;
            }
            buffer.add(line);
        }
        if (!buffer.isEmpty()) {
            statements.add(CliStatementSplitter.normalize(buffer));
        }
        return statements;
    }

    private static String normalize(List<String> buffer) {
        return buffer.stream().map(statementLine -> statementLine.replaceAll(BEGINNING_MASK, "")).collect(Collectors.joining("\n"));
    }

    private static boolean isEndOfStatement(String line) {
        return line.replaceAll(MASK, "").trim().endsWith(";");
    }
}

